/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.controller;

import java.util.EventObject;
import javax.swing.JMenu;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.LabelUpdater;

public abstract class MenuAwareLabelUpdater
implements LabelUpdater {
    private String _menuLabel;

    public MenuAwareLabelUpdater(String menuLabel) {
        this._menuLabel = menuLabel;
    }

    public final String labelWhenDisabled(Context context, IdeAction action, String originalLabel) {
        return this.disabledLabelImpl(context, action, originalLabel);
    }

    public final String labelWhenEnabled(Context context, IdeAction action, String originalLabel) {
        return this.enabledLabelImpl(context, action, originalLabel);
    }

    protected abstract String disabledMenuSpecificLabel(IdeAction var1, String var2);

    protected abstract String enabledMenuSpecificLabel(IdeAction var1, String var2);

    public final void setDisabledFormat(String format) {
    }

    public final void setEnabledFormat(String format) {
    }

    private String disabledLabelImpl(Context context, IdeAction action, String originalLabel) {
        if (this.matchMenu(context.getEvent())) {
            return this.disabledMenuSpecificLabel(action, originalLabel);
        }
        return originalLabel;
    }

    private String enabledLabelImpl(Context context, IdeAction action, String originalLabel) {
        if (this.matchMenu(context.getEvent())) {
            return this.enabledMenuSpecificLabel(action, originalLabel);
        }
        return originalLabel;
    }

    protected boolean matchMenu(EventObject event) {
        Object source;
        if (event != null && this._menuLabel != null && (source = event.getSource()) instanceof JMenu) {
            JMenu jMenu = (JMenu)source;
            return this._menuLabel.equals(jMenu.getText()) || StringUtils.stripMnemonic((String)this._menuLabel).equals(jMenu.getText());
        }
        return false;
    }
}

