/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.compiler.BuildSystemVetoException;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.EditorUtil;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.index.QueryCriteria;
import oracle.ide.model.Attributes;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Folder;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.util.IntersectedFilters;
import oracle.ide.util.PatternFilters;
import oracle.ide.vcs.VCSManager;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Log;
import oracle.jdeveloper.cm.dt.CmJavaUtil;
import oracle.jdeveloper.compiler.BuildGraph;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.CompilerContext;
import oracle.jdeveloper.compiler.Helpers;
import oracle.jdeveloper.compiler.IdeLog;
import oracle.jdeveloper.compiler.IdeStorage;
import oracle.jdeveloper.compiler.JCompiler;
import oracle.jdeveloper.compiler.JCompilerMenuItems;
import oracle.jdeveloper.compiler.Ojc;
import oracle.jdeveloper.compiler.Translator;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.common.Interdependency;
import oracle.jdeveloper.deploy.common.ProfileDependable;
import oracle.jdeveloper.deploy.dt.Deployment;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdeveloper.model.J2eeSettings;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdevimpl.deploy.BuildSystemFacade;
import oracle.ojc.interfaces.Storage;

public class UnifiedBuildSystem {
    public static IdeLog ideLog = new IdeLog();
    public static boolean showCompileProgress = false;
    private static final String PREPROCESSOR_GENERATED_PROPERTY = "preprocessor_generated_file";
    private static final int CLEANED = 1;
    private static final int NOT_CLEANED = 2;
    private static final int CANCELLED = 3;
    private static final String ELEMENTS_TO_CLEAN_PROPERTY = "buildsystem.elements.to.clean";
    private static final String ELEMENTS_TO_BUILD_PROPERTY = "buildsystem.elements.to.build";
    HashMap registeredTranslators = new HashMap(19);
    ArrayList registeredTranslatorsList = new ArrayList(19);
    BuildGraph buildGraph = new BuildGraph();
    CompileThread compileThread = null;
    boolean locked = false;
    boolean buildingOnUIThread = false;
    private static UnifiedBuildSystem instance;
    private final Map<Workspace, Map<Project, Set<Storage>>> translatedWorkspaces = new HashMap<Workspace, Map<Project, Set<Storage>>>();
    private final Map<Workspace, Map<Project, Set<Storage>>> suppressedWorkspaces = new HashMap<Workspace, Map<Project, Set<Storage>>>();
    private Set<Storage> translatedSources;
    private Set<Storage> suppressedSources;
    private HashMap<Integer, Boolean> marking = new HashMap();
    private HashMap<Integer, Set<Storage>> translateableSources = new HashMap();
    private static final Log LOG;
    private long translatorStartingTime;
    private final Map<Workspace, Map<Project, List<String>>> compiledWorkspaces = new HashMap<Workspace, Map<Project, List<String>>>();
    private List<String> compiledClasses;
    private IOException failedDeleteException;

    private synchronized void initThread(Context context, boolean rebuild, boolean cleanAll, boolean autoClean, boolean stopOnFailedDelete) {
        this.compileThread = new CompileThread(rebuild, context, this.buildGraph, cleanAll, autoClean, stopOnFailedDelete);
        if (this.compileThread.getPriority() > 1) {
            this.compileThread.setPriority(this.compileThread.getPriority() - 1);
        }
        this.compileThread.start();
    }

    public synchronized boolean init(Context context, boolean rebuild) {
        if (!this.isAlive()) {
            this.initThread(context, rebuild, false, false, false);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean buildOnUIThread(Context context, boolean rebuild) {
        if (!this.isAlive()) {
            try {
                this.compileThread = new CompileThread(rebuild, context, this.buildGraph, false, false, false);
                this.buildingOnUIThread = true;
                this.compileThread.run();
                boolean bl = true;
                return bl;
            }
            finally {
                this.compileThread = null;
                this.buildingOnUIThread = false;
            }
        }
        return false;
    }

    public synchronized void initCleanAll(Context context) {
        if (!this.isAlive()) {
            this.initThread(context, false, true, false, false);
        }
    }

    synchronized boolean initCleanAll(Context context, boolean autoClean, boolean stopOnFailedDelete) {
        if (this.isAlive()) {
            return false;
        }
        this.initThread(context, false, true, autoClean, stopOnFailedDelete);
        return true;
    }

    public synchronized boolean isAlive() {
        return this.compileThread != null && this.compileThread.isAlive();
    }

    public void join(long millis) throws InterruptedException {
        if (this.compileThread != null) {
            this.compileThread.join(0L);
        }
    }

    public synchronized void stopBuildSystem() {
        if (this.compileThread != null) {
            this.compileThread.interrupt();
        }
    }

    public synchronized boolean isLocked(Context context) {
        return this.locked;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean lock(Context context) {
        if (this.isAlive()) return false;
        this.locked = true;
        if (!true) return false;
        return true;
    }

    public synchronized boolean unlock() {
        if (this.locked) {
            this.locked = false;
            return !false;
        }
        return false;
    }

    public synchronized int compileInThread(Thread thread, Project prj, ArrayList files, boolean rebuild) throws IllegalArgumentException {
        if (!(thread instanceof CompileThread || this.buildingOnUIThread && SwingUtilities.isEventDispatchThread())) {
            throw new IllegalArgumentException("thread");
        }
        int fileCnt = files.size();
        if (files == null) {
            throw new IllegalArgumentException("files");
        }
        for (int i = 0; i < fileCnt; ++i) {
            if (files.get(i) instanceof Storage) continue;
            throw new IllegalArgumentException("files[" + i + "]");
        }
        return this.compileThread.buildFilesInThread(prj, files, rebuild);
    }

    public synchronized int getLastErrorCount() {
        return ideLog != null ? ideLog.nerrors() : 0;
    }

    private boolean isTranslatorCompatible(ArrayList al, Translator translator, String ext) {
        int cnt = BuildGraph.isPreprocessor(translator) ? 0 : 1;
        for (int i = 0; i < al.size(); ++i) {
            if (BuildGraph.isPreprocessor((Translator)al.get(i))) continue;
            ++cnt;
        }
        return cnt <= 1;
    }

    public void registerTranslator(Translator translator) {
        ArrayList extensions = translator.getInputTypes();
        for (int i = 0; i < extensions.size(); ++i) {
            String ext = (String)extensions.get(i);
            ArrayList<Translator> al = (ArrayList<Translator>)this.registeredTranslators.get(ext);
            if (al == null) {
                al = new ArrayList<Translator>(1);
                al.add(translator);
                this.registeredTranslators.put(ext, al);
                continue;
            }
            if (al.contains(translator)) continue;
            if (this.isTranslatorCompatible(al, translator, ext)) {
                al.add(translator);
                this.registeredTranslators.put(ext, al);
                continue;
            }
            System.out.println("Addin: Translator " + translator.getName() + " is trying to register a input type (" + ext + ")" + " which conflicts with translator " + translator.getName() + " who already using this input type");
        }
        if (!this.buildGraph.rebuild(this.registeredTranslators)) {
            System.out.println("Addin error: unable to register translator " + translator.getName());
            this.unregisterTranslator(translator);
        } else if (!this.registeredTranslatorsList.contains(translator)) {
            this.registeredTranslatorsList.add(translator);
        }
    }

    public void unregisterTranslator(Translator translator) {
        ArrayList extensions = translator.getInputTypes();
        for (int i = 0; i < extensions.size(); ++i) {
            String ext = (String)extensions.get(i);
            ArrayList al = (ArrayList)this.registeredTranslators.get(ext);
            if (al != null) {
                al.remove(translator);
            }
            if (al != null && al.size() != 0) continue;
            this.registeredTranslators.remove(ext);
        }
        this.registeredTranslatorsList.remove(translator);
    }

    Translator getJavaTranslator() {
        for (Translator t : this.registeredTranslatorsList) {
            if ("Ojc".equals(t.getName())) {
                return t;
            }
            if (!t.getInputTypes().contains(".java") || !t.getOutputTypes().contains(".class")) continue;
            return t;
        }
        return null;
    }

    public static UnifiedBuildSystem getInstance() {
        if (instance == null) {
            instance = new UnifiedBuildSystem();
        }
        return instance;
    }

    private synchronized void beginTranslator(Translator translator) {
        assert (LOG.trace("begin translator {0}", (Object)translator));
        this.translatorStartingTime = System.currentTimeMillis();
        int uniqueID = System.identityHashCode(translator);
        this.marking.put(uniqueID, Boolean.FALSE);
        this.translateableSources.put(uniqueID, new HashSet());
    }

    private synchronized void markTranslateable(Translator translator, Storage source) {
        if (this.suppressedSources.contains(source)) {
            return;
        }
        if (Boolean.TRUE.equals(source.getProperty(PREPROCESSOR_GENERATED_PROPERTY))) {
            return;
        }
        Set<Storage> translateableSet = this.translateableSources.get(System.identityHashCode(translator));
        if (translateableSet != null) {
            translateableSet.add(source);
        }
    }

    public synchronized void beginMarking(Translator translator) {
        assert (LOG.trace("begin marking {0}", (Object)translator));
        int uniqueID = System.identityHashCode(translator);
        this.marking.put(uniqueID, Boolean.TRUE);
    }

    public synchronized void markTranslated(Translator translator, Storage source) {
        Set<Storage> set;
        boolean suppressed;
        boolean bl = suppressed = this.suppressedSources.contains(source) || Boolean.TRUE.equals(source.getProperty(PREPROCESSOR_GENERATED_PROPERTY));
        assert (LOG.trace("mark {1} translated, suppressed {0}, {2}", (Object)suppressed, (Object)source, (Object)translator));
        if (!suppressed) {
            this.translatedSources.add(source);
        }
        if ((set = this.translateableSources.get(System.identityHashCode(translator))) != null) {
            set.remove(source);
        }
    }

    private synchronized void endTranslator(Translator translator) {
        int uniqueID = System.identityHashCode(translator);
        Boolean mark = this.marking.remove(uniqueID);
        Set<Storage> translateable = this.translateableSources.remove(uniqueID);
        if (mark != null && mark.booleanValue()) {
            assert (LOG.trace("end translator, suppressed {0}, {1}", translateable, (Object)translator));
            if (translateable != null) {
                this.suppressedSources.addAll(translateable);
                this.translatedSources.removeAll(translateable);
                translateable.clear();
            }
        } else {
            assert (LOG.trace("end translator, translated {0}", translateable));
            if (translateable != null) {
                this.translatedSources.addAll(translateable);
                translateable.clear();
            }
        }
        assert (LOG.trace("Translation time in msec: " + (System.currentTimeMillis() - this.translatorStartingTime)));
    }

    public synchronized Map<Workspace, Map<Project, Set<Storage>>> getTranslatedSources() {
        return this.translatedWorkspaces;
    }

    public synchronized void markCompiled(String path) {
        this.compiledClasses.add(path);
    }

    public synchronized Map<Workspace, Map<Project, List<String>>> getCompiledClasses() {
        return this.compiledWorkspaces;
    }

    IOException getFailedDeleteException() {
        return this.failedDeleteException;
    }

    static File getCdiFile(Project prj, boolean javac_depinfo) {
        String ext = javac_depinfo ? ".cdi_javac" : ".cdi";
        URL prjURL = prj.getURL();
        URL cdiDir = JavaProject.getInstance((Project)prj).getOutputDirectory();
        if (javac_depinfo && cdiDir != null) {
            cdiDir = URLFactory.newDirURL((URL)cdiDir, (String)".data");
        }
        if (cdiDir != null) {
            String outPathName = new File(cdiDir.getPath()).getPath();
            String prjPathName = URLFileSystem.getFileName((URL)prjURL);
            return new File(outPathName, UnifiedBuildSystem.replaceExt(prjPathName, ext));
        }
        String prjPathName = URLFileSystem.getPlatformPathName((URL)prjURL);
        return new File(UnifiedBuildSystem.replaceExt(prjPathName, ext));
    }

    private static String replaceExt(String name, String newExt) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot < 0) {
            lastDot = name.length();
        }
        if (name.indexOf(File.separatorChar, lastDot) < 0) {
            name = name.substring(0, lastDot);
        }
        return name + newExt;
    }

    static {
        LOG = new Log("translator");
    }

    private class CompileThread
    extends Thread {
        boolean rebuild;
        boolean cleanAll;
        BuildGraph buildGraph;
        Context context;
        long startTime;
        String[] copyResSpec;
        boolean reverseCopy;
        HashMap deploymentProfileBuilt;
        HashSet projectsBuilt;
        int filesBuilt;
        boolean warnOnSourceNotInProject;
        boolean saveBeforeCompile;
        private boolean cleanProjectBeforeRebuild;
        private PrintWriter bsfPrintWriter;
        private boolean autoClean;
        private boolean stopOnFailedDelete;
        public static final String THREAD_NAME = "CompileThread";

        private CompileThread(boolean rebuild, Context context, BuildGraph buildGraph, boolean cleanAll, boolean autoClean, boolean stopOnFailedDelete) {
            super(THREAD_NAME);
            this.rebuild = rebuild;
            this.cleanAll = cleanAll;
            this.autoClean = autoClean;
            this.stopOnFailedDelete = stopOnFailedDelete;
            this.context = context;
            this.buildGraph = buildGraph;
            this.deploymentProfileBuilt = new HashMap();
            this.copyResSpec = null;
            this.reverseCopy = false;
            this.filesBuilt = 0;
            this.warnOnSourceNotInProject = false;
            EnvironOptions opt = Ide.getEnvironOptions();
            showCompileProgress = opt.getShowCompileProgress();
            this.saveBeforeCompile = opt.getSaveBeforeCompile();
            this.cleanProjectBeforeRebuild = opt.getCleanProjectBeforeRebuild();
            this.projectsBuilt = new HashSet();
            this.startTime = System.currentTimeMillis();
            UnifiedBuildSystem.this.failedDeleteException = null;
        }

        private Storage getStorageForNode(URL url) {
            Storage stor;
            Node node;
            if (url == null) {
                return null;
            }
            if (url.getRef() != null) {
                return null;
            }
            Node node2 = node = this.saveBeforeCompile ? null : NodeFactory.find((URL)url);
            if (node != null && node.isDirty() || !"file".equals(url.getProtocol())) {
                if (node == null) {
                    try {
                        node = NodeFactory.findOrCreate((URL)url);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                stor = new IdeStorage(node);
            } else {
                stor = Helpers.createFileStorage(url.getPath());
            }
            if (node != null) {
                stor.setProperty("nodeClassObject", node.getClass());
            }
            return stor;
        }

        private void processElement(URL url, ArrayList result, HashMap dupCache) {
            String path;
            Storage store = this.getStorageForNode(url);
            if (store != null && dupCache.get(path = store.getPath()) == null) {
                result.add(store);
                dupCache.put(path, store);
            }
        }

        private void getProjectFileList(Project prj, String relPath, IntersectedFilters filters, ArrayList result, HashMap dupCache) {
            Iterator iter = ProjectContent.getInstance((PropertyStorage)prj).getAllContents().urlIterator(relPath, filters);
            int i = 0;
            while (iter.hasNext()) {
                if ((++i & 0x1FF) == 511 && Thread.currentThread().isInterrupted()) {
                    throw new RuntimeException(CompArb.getString(76));
                }
                this.processElement((URL)iter.next(), result, dupCache);
            }
        }

        private void getProjectFileList(Project prj, ArrayList result, HashMap dupCache) {
            URL[] urls;
            QueryCriteria criteria = new QueryCriteria();
            criteria.put((Object)"file.all", (Object)"");
            for (URL url : urls = Helpers.getUrlsThroughIndexer(prj, criteria)) {
                this.processElement(url, result, dupCache);
            }
        }

        private void getFolderFileList(Folder folder, ArrayList result, HashMap dupCache) {
            Iterator iter = folder.getChildren();
            int i = 0;
            while (iter.hasNext()) {
                Element elem = (Element)iter.next();
                if ((++i & 0x1FF) == 511 && Thread.currentThread().isInterrupted()) {
                    throw new RuntimeException(CompArb.getString(76));
                }
                if (elem instanceof Locatable) {
                    this.processElement(((Locatable)elem).getURL(), result, dupCache);
                }
                if (!(elem instanceof Folder)) continue;
                this.getFolderFileList((Folder)elem, result, dupCache);
            }
        }

        private boolean makeSureResultsAreStorageInstances(ArrayList al) {
            if (al == null) {
                return true;
            }
            for (int i = 0; i < al.size(); ++i) {
                if (al.get(i) instanceof Storage) continue;
                return false;
            }
            return true;
        }

        private void delete(URL url) {
            try {
                if (URLFileSystem.exists((URL)url)) {
                    VCSManager.getVCSManager().deleteRecursively(url, null, !this.stopOnFailedDelete);
                }
            }
            catch (IOException ioe) {
                if (this.stopOnFailedDelete) {
                    UnifiedBuildSystem.this.failedDeleteException = ioe;
                    throw new FailedDeleteException();
                }
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(CompArb.getString(76));
            }
        }

        private void recursivelyDeleteDir(URL dir) {
            URLFilter filter = new URLFilter(){

                public final boolean accept(URL url) {
                    return !GlobalIgnoreList.isGloballyIgnored((URL)url) || ".cdi".equals(URLFileSystem.getSuffix((URL)url));
                }
            };
            try {
                VCSManager.getVCSManager().deleteRecursively(dir, filter, !this.stopOnFailedDelete);
            }
            catch (IOException ioe) {
                if (this.stopOnFailedDelete) {
                    UnifiedBuildSystem.this.failedDeleteException = ioe;
                    throw new FailedDeleteException();
                }
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(CompArb.getString(76));
            }
        }

        private int cleanProject(Project prj, boolean projectAutoClean, boolean addCancelOption) {
            File cdiFile;
            String title = CompArb.format(70, prj.getShortLabel());
            URL outputDir = JavaProject.getInstance((Project)prj).getOutputDirectory();
            if (outputDir == null) {
                String message = CompArb.getString(71);
                if (!projectAutoClean) {
                    MessageDialog.error(null, (Object)message, (String)title, (String)"f1_com_dcleantarget_html");
                } else {
                    JCompiler.getInstance().logOutMsg(message + "\n");
                }
                return 2;
            }
            if (URLFileSystem.exists((URL)outputDir)) {
                if (!URLFileSystem.isDirectory((URL)outputDir)) {
                    String message = CompArb.getString(74);
                    if (!projectAutoClean) {
                        MessageDialog.error(null, (Object)message, (String)title, (String)"f1_com_dcleantarget_html");
                    } else {
                        JCompiler.getInstance().logOutMsg(message + "\n");
                    }
                    return 2;
                }
                if (URLFileSystem.isBaseURLFor((URL)outputDir, (URL)prj.getURL())) {
                    return 2;
                }
                if (URLFileSystem.getParent((URL)outputDir) == null) {
                    if (projectAutoClean) {
                        return 2;
                    }
                    String cleanProjectOutputID = "cleanProject-outputToRootDir";
                    if (addCancelOption) {
                        int result = MessageDialog.optionalConfirmOrCancel((String)"cleanProject-outputToRootDir", (Component)Ide.getMainWindow(), (String)CompArb.getString(72), (String)title, (String)"f1_com_dcleantarget_html");
                        if (result != 1) {
                            MessageDialog.getPersistence().setConfirmed("cleanProject-outputToRootDir", null);
                            return result == -1 ? 3 : 2;
                        }
                    } else if (!MessageDialog.optionalConfirm((String)"cleanProject-outputToRootDir", (Component)Ide.getMainWindow(), (String)CompArb.getString(72), (String)title, (String)"f1_com_dcleantarget_html")) {
                        MessageDialog.getPersistence().setConfirmed("cleanProject-outputToRootDir", null);
                        return 2;
                    }
                }
            } else {
                outputDir = null;
            }
            URL projectDir = URLFileSystem.getParent((URL)prj.getURL());
            URL deployDir = null;
            if (projectDir != null && (deployDir = URLFactory.newDirURL((URL)projectDir, (String)"deploy")) != null && !URLFileSystem.isDirectory((URL)deployDir)) {
                deployDir = null;
            }
            if (outputDir == null && deployDir == null) {
                return 1;
            }
            if (!projectAutoClean) {
                StringBuilder buf = new StringBuilder();
                if (outputDir != null) {
                    buf.append(URLFileSystem.getPlatformPathName((URL)outputDir));
                }
                if (deployDir != null) {
                    if (outputDir != null) {
                        buf.append(", ");
                    }
                    buf.append(URLFileSystem.getPlatformPathName((URL)deployDir));
                }
                String cleanProjectNormalID = "cleanProject-normal";
                if (addCancelOption) {
                    int result = MessageDialog.optionalConfirmOrCancel((String)"cleanProject-normal", (Component)Ide.getMainWindow(), (String)CompArb.format(73, buf.toString()), (String)title, (String)"f1_com_dcleantarget_html");
                    if (result != 1) {
                        MessageDialog.getPersistence().setConfirmed("cleanProject-normal", null);
                        return result == -1 ? 3 : 2;
                    }
                } else if (!MessageDialog.optionalConfirm((String)"cleanProject-normal", (Component)Ide.getMainWindow(), (String)CompArb.format(73, buf.toString()), (String)title, (String)"f1_com_dcleantarget_html")) {
                    MessageDialog.getPersistence().setConfirmed("cleanProject-normal", null);
                    return 2;
                }
            }
            if ((cdiFile = UnifiedBuildSystem.getCdiFile(prj, true)) != null) {
                URL javacCdiUrl = URLFactory.newFileURL((File)cdiFile);
                this.delete(javacCdiUrl);
            }
            if (outputDir != null) {
                this.recursivelyDeleteDir(outputDir);
            }
            if (deployDir != null) {
                this.recursivelyDeleteDir(deployDir);
            }
            return 1;
        }

        private boolean cleanWorkspace(Workspace workSpace) {
            if (workSpace == null || workSpace.getBaseDirectory() == null) {
                return false;
            }
            if (!this.autoClean) {
                String cleanApplicationID = "cleanApplication";
                String title = CompArb.format(70, workSpace.getShortLabel());
                if (!MessageDialog.optionalConfirm((String)"cleanApplication", (Component)Ide.getMainWindow(), (String)CompArb.format(95, workSpace.getLongLabel()), (String)title, (String)"f1_com_dcleantarget_html")) {
                    MessageDialog.getPersistence().setConfirmed("cleanApplication", null);
                    return false;
                }
            }
            Iterator childIter = workSpace.getChildren();
            while (childIter.hasNext()) {
                this.cleanProject((Project)childIter.next(), true, false);
            }
            URL deployDir = URLFactory.newDirURL((URL)workSpace.getURL(), (String)"deploy");
            if (URLFileSystem.isDirectory((URL)deployDir)) {
                this.recursivelyDeleteDir(deployDir);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void buildGraph(ArrayList files, Project prj, boolean rebuild) {
            if (files == null || files.size() <= 0 || prj == null) {
                return;
            }
            ArrayList translators = this.buildGraph.getOrderedTranslatorList();
            for (int i = 0; i < UnifiedBuildSystem.this.registeredTranslatorsList.size(); ++i) {
                Translator t = (Translator)UnifiedBuildSystem.this.registeredTranslatorsList.get(i);
                if (translators.indexOf(t) != -1) continue;
                translators.add(t);
            }
            HashMap<Storage, Storage> generatedFiles = new HashMap<Storage, Storage>();
            try {
                Workspace workspace = ideLog.getWorkspace();
                Project project = ideLog.getProject();
                HashMap<Project, Set> translatedProjects = (HashMap<Project, Set>)UnifiedBuildSystem.this.translatedWorkspaces.get(workspace);
                HashMap<Project, Set> suppressedProjects = (HashMap<Project, Set>)UnifiedBuildSystem.this.suppressedWorkspaces.get(workspace);
                HashMap<Project, List> compiledProjects = (HashMap<Project, List>)UnifiedBuildSystem.this.compiledWorkspaces.get(workspace);
                if (translatedProjects == null) {
                    translatedProjects = new HashMap<Project, Set>();
                    UnifiedBuildSystem.this.translatedWorkspaces.put(workspace, translatedProjects);
                    suppressedProjects = new HashMap<Project, Set>();
                    UnifiedBuildSystem.this.suppressedWorkspaces.put(workspace, suppressedProjects);
                    compiledProjects = new HashMap<Project, List>();
                    UnifiedBuildSystem.this.compiledWorkspaces.put(workspace, compiledProjects);
                }
                UnifiedBuildSystem.this.translatedSources = (Set)translatedProjects.get(project);
                UnifiedBuildSystem.this.suppressedSources = (Set)suppressedProjects.get(project);
                UnifiedBuildSystem.this.compiledClasses = (List)compiledProjects.get(project);
                if (UnifiedBuildSystem.this.translatedSources == null) {
                    UnifiedBuildSystem.this.translatedSources = new HashSet();
                    translatedProjects.put(project, UnifiedBuildSystem.this.translatedSources);
                    UnifiedBuildSystem.this.suppressedSources = new HashSet();
                    suppressedProjects.put(project, UnifiedBuildSystem.this.suppressedSources);
                    UnifiedBuildSystem.this.compiledClasses = new ArrayList();
                    compiledProjects.put(project, UnifiedBuildSystem.this.compiledClasses);
                }
                for (int i = 0; i < translators.size(); ++i) {
                    if (this.isInterrupted()) {
                        throw new RuntimeException(CompArb.getString(76));
                    }
                    Translator translator = (Translator)translators.get(i);
                    try {
                        URL url;
                        Storage s;
                        int j;
                        UnifiedBuildSystem.this.beginTranslator(translator);
                        translator.setProject(prj);
                        translator.setLog(ideLog);
                        ArrayList<Storage> inputFiles = new ArrayList<Storage>();
                        for (int j2 = 0; j2 < files.size(); ++j2) {
                            Storage s2 = (Storage)files.get(j2);
                            if (translator.canBuild(s2)) {
                                inputFiles.add(s2);
                                UnifiedBuildSystem.this.markTranslateable(translator, s2);
                                continue;
                            }
                            if (!translator.needToBuild(s2)) continue;
                            inputFiles.add(s2);
                        }
                        if (inputFiles.size() <= 0) continue;
                        int errCnt = ideLog.nerrors();
                        ArrayList results = new ArrayList();
                        translator.translate(prj, rebuild, inputFiles, results);
                        int nerrors = ideLog.nerrors() - errCnt;
                        if (nerrors <= 0 && results.size() > 0) {
                            if (BuildGraph.isPreprocessor(translator)) {
                                for (j = 0; j < inputFiles.size(); ++j) {
                                    Storage inputFile = (Storage)inputFiles.get(j);
                                    if (!translator.canBuild(inputFile)) continue;
                                    if (results.contains(inputFile)) {
                                        results.remove(inputFile);
                                        continue;
                                    }
                                    files.remove(inputFile);
                                }
                            }
                            for (j = 0; j < results.size(); ++j) {
                                s = (Storage)results.get(j);
                                assert (LOG.trace("preprocess created {0}", (Object)s));
                                s.setProperty(UnifiedBuildSystem.PREPROCESSOR_GENERATED_PROPERTY, (Object)Boolean.TRUE);
                                files.add(s);
                                generatedFiles.put(s, s);
                            }
                        }
                        if (nerrors <= 0) continue;
                        for (j = 0; j < inputFiles.size(); ++j) {
                            s = (Storage)inputFiles.get(j);
                            if (generatedFiles.get(s) != s) continue;
                            url = URLFactory.newFileURL((String)s.getPath());
                            URLFileSystem.delete((URL)url);
                            generatedFiles.remove(s);
                        }
                        for (j = 0; j < results.size(); ++j) {
                            s = (Storage)results.get(j);
                            url = URLFactory.newFileURL((String)s.getPath());
                            URLFileSystem.delete((URL)url);
                        }
                        continue;
                    }
                    finally {
                        translator.setProject(null);
                        translator.setLog(null);
                        UnifiedBuildSystem.this.endTranslator(translator);
                    }
                }
            }
            finally {
                UnifiedBuildSystem.this.translatedSources = null;
                UnifiedBuildSystem.this.suppressedSources = null;
                UnifiedBuildSystem.this.compiledClasses = null;
                UnifiedBuildSystem.this.translateableSources.clear();
                UnifiedBuildSystem.this.marking.clear();
            }
        }

        int buildFilesInThread(Project prj, ArrayList files, boolean rebuild) {
            int errCnt = ideLog.nerrors();
            this.buildGraph(files, prj, rebuild);
            return ideLog.nerrors() - errCnt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void buildProjectFiles(Workspace wsp, Project prj, Element[] elements) {
            if (this.projectsBuilt.contains(prj)) {
                return;
            }
            if (elements == null) {
                this.projectsBuilt.add(prj);
            }
            prj.getTransientProperties().put("rebuild", this.rebuild && elements == null);
            boolean rebuild = this.rebuild | JCompiler.getInstance().forceRebuildOnProject(prj);
            if (rebuild && elements == null && this.cleanProjectBeforeRebuild && !this.autoClean) {
                if (showCompileProgress) {
                    String cleanStr = CompArb.format(70, prj.getShortLabel());
                    JCompiler.getInstance().logOutMsg(cleanStr + "\n");
                }
                this.cleanProject(prj, true, false);
            }
            Workspace prevWsp = ideLog.getWorkspace();
            Project prevPrj = ideLog.getProject();
            try {
                Object p;
                ideLog.setWorkspace(wsp);
                ideLog.setProject(prj);
                this.copyResSpec = JCompiler.getCopyRes(prj);
                this.reverseCopy = JCompiler.getReverseCopyRes(prj);
                ArrayList files = new ArrayList(64);
                try {
                    PerformanceLogger.get().startTiming(this.getClass().getName());
                    HashMap dupCache = new HashMap();
                    if (elements != null) {
                        for (int i = 0; i < elements.length; ++i) {
                            Element element = elements[i];
                            if (element instanceof WorkingSetNode) {
                                WorkingSetNode n = (WorkingSetNode)element;
                                this.getProjectFileList(prj, null, n.getFilters(prj), files, dupCache);
                                continue;
                            }
                            if (element instanceof RelativeDirectoryContextFolder) {
                                RelativeDirectoryContextFolder rd = (RelativeDirectoryContextFolder)element;
                                this.getProjectFileList(prj, rd.getRelativePath(), null, files, dupCache);
                                continue;
                            }
                            if (element instanceof Locatable) {
                                this.processElement(((Locatable)element).getURL(), files, dupCache);
                            }
                            if (!(element instanceof Folder)) continue;
                            this.getFolderFileList((Folder)element, files, dupCache);
                        }
                    } else {
                        this.getProjectFileList(prj, files, dupCache);
                    }
                    dupCache.clear();
                    this.filesBuilt += files.size();
                    if (files.size() <= 0) {
                        return;
                    }
                }
                finally {
                    PerformanceLogger.get().stopTiming(this.getClass().getName(), "Build System --> " + files.size() + " files to process");
                }
                if (elements == null) {
                    ideLog.clear(null);
                } else {
                    for (int i = 0; i < this.filesBuilt; ++i) {
                        Storage stor = (Storage)files.get(i);
                        if (stor.getPath().endsWith(".java")) continue;
                        ideLog.clear((Storage)files.get(i));
                    }
                }
                if (JavaProject.getInstance((Project)prj).getOutputDirectory() == null) {
                    ideLog.error(null, 0, 0, 0, CompArb.getString(61));
                    return;
                }
                if (this.warnOnSourceNotInProject && files.size() == 1 && ((p = this.context.getProperty("disableFileNotInProjectWarning")) == null || p == Boolean.FALSE)) {
                    ideLog.warning(null, 0, 0, 0, CompArb.format(79, ((Storage)files.get(0)).getPath(), prj.getShortLabel()));
                }
                if (this.buildGraph == null || this.buildGraph.buildRoots == null || this.buildGraph.buildRoots.size() == 0) {
                    throw new Error("no compiler addins installed");
                }
                ArrayList<Storage> jspFiles = new ArrayList<Storage>(64);
                ArrayList<Storage> uixFiles = new ArrayList<Storage>(64);
                for (int i = files.size() - 1; i >= 0; --i) {
                    Storage f = (Storage)files.get(i);
                    String n = f.getName();
                    if (J2eeSettings.isCompilableJsp(n)) {
                        jspFiles.add(f);
                        files.remove(i);
                        continue;
                    }
                    if (!n.endsWith(".uix") && !n.endsWith(".uit")) continue;
                    uixFiles.add(f);
                    files.remove(i);
                }
                this.buildGraph(files, prj, rebuild);
                this.buildGraph(jspFiles, prj, rebuild);
                this.buildGraph(uixFiles, prj, rebuild);
            }
            finally {
                ideLog.setWorkspace(prevWsp);
                ideLog.setProject(prevPrj);
            }
        }

        private PrintWriter getBsfPrintWriter() {
            if (this.bsfPrintWriter == null) {
                this.bsfPrintWriter = Deployment.getLogPrintWriter();
            }
            return this.bsfPrintWriter;
        }

        private void buildDepProfile(Profile prf) {
            ProfileDependable[] dependables;
            DataContainer prj = prf.getDataContainer();
            if (this.deploymentProfileBuilt.get(prf) == prj) {
                return;
            }
            this.deploymentProfileBuilt.put(prf, prj);
            BuildSystemFacade bsf = new BuildSystemFacade();
            int errCnt = ideLog.nerrors();
            for (ProfileDependable profileDep : dependables = (ProfileDependable[])DeployUtil.getDependables((Interdependency)prf, ProfileDependable.class)) {
                Profile profile = profileDep.getProfile();
                if (profile == null) continue;
                this.buildDepProfile(profile);
            }
            if (prj instanceof Project) {
                this.buildProjectFiles(null, (Project)prj, null);
            }
            if (ideLog.nerrors() <= errCnt) {
                long startingTime = System.currentTimeMillis();
                boolean isAssembly = Boolean.TRUE.equals(this.context.getProperty("is-j2ee-application-assembly"));
                PrintWriter deployContextLog = (PrintWriter)this.context.getProperty("deploy-context-log");
                DeployUtil.setProfile(this.context, prf);
                bsf.deploy(isAssembly, deployContextLog != null ? deployContextLog : this.getBsfPrintWriter(), this.context);
                assert (LOG.trace("Deploy time in msec: " + (System.currentTimeMillis() - startingTime)));
            }
        }

        private void buildProject(Workspace wsp, Project prj) {
            boolean onlyThisProject = this.context.containsProperty("buildsystem.dont.compile.dependent.projects");
            if (!onlyThisProject) {
                for (Dependable dependable : DependencyConfiguration.getInstance((Project)prj).getAllDependenciesList()) {
                    Element source = dependable.getSource();
                    Folder owner = dependable.getSourceOwner();
                    if (source instanceof Project) {
                        Workspace w = owner instanceof Workspace ? (Workspace)owner : null;
                        this.buildProjectFiles(w, (Project)source, null);
                        continue;
                    }
                    if (!(source instanceof Profile) || !(owner instanceof Project)) continue;
                    this.buildDepProfile((Profile)source);
                }
            }
            this.buildProjectFiles(wsp, prj, null);
        }

        private void buildWorkspace(Workspace wsp) {
            ideLog.setWorkspace(wsp);
            Iterator childIter = wsp.getChildren();
            while (childIter.hasNext()) {
                Project prj = (Project)childIter.next();
                this.buildProject(wsp, prj);
            }
        }

        private void buildAll(Element[] elements) {
            if (elements[0] instanceof Workspaces) {
                Iterator childIter = elements[0].getChildren();
                while (childIter.hasNext()) {
                    Workspace wsp = (Workspace)childIter.next();
                    this.buildWorkspace(wsp);
                }
            } else if (elements[0] instanceof Workspace) {
                for (int i = 0; i < elements.length; ++i) {
                    Element element = elements[i];
                    this.buildWorkspace((Workspace)element);
                }
            } else if (elements[0] instanceof Project) {
                for (int i = 0; i < elements.length; ++i) {
                    Element element = elements[i];
                    this.buildProject(this.context.getWorkspace(), (Project)element);
                }
            } else if (elements[0] instanceof WorkingSetNode) {
                Project prj = this.context.getProject();
                Workspace wsp = this.context.getWorkspace();
                if (prj == null) {
                    prj = Ide.getActiveProject();
                    wsp = Ide.getActiveWorkspace();
                }
                if (prj == null) {
                    prj = Ide.getDefaultProject();
                    wsp = Ide.getDefaultWorkspace();
                }
                this.buildProjectFiles(wsp, prj, elements);
            } else {
                Context c;
                if (elements.length == 1 && elements[0] instanceof Locatable && !elements[0].mayHaveChildren() && !CmJavaUtil.isCMUrl(((Locatable)elements[0]).getURL()) && !(this.warnOnSourceNotInProject = (c = EditorUtil.findNodeInContext((Element)elements[0], (Context)this.context)) == null)) {
                    this.context = c;
                }
                Project prj = this.context.getProject();
                Workspace wsp = this.context.getWorkspace();
                if (prj == null) {
                    prj = Ide.getActiveProject();
                    wsp = Ide.getActiveWorkspace();
                }
                if (prj == null) {
                    prj = Ide.getDefaultProject();
                    wsp = Ide.getDefaultWorkspace();
                }
                this.buildProjectFiles(wsp, prj, elements);
                this.warnOnSourceNotInProject = false;
            }
        }

        private boolean cleanAll(Element[] elements) {
            boolean res = true;
            if (elements[0] instanceof Workspaces) {
                Iterator childIter = elements[0].getChildren();
                while (childIter.hasNext()) {
                    res &= this.cleanAll(new Element[]{(Element)childIter.next()});
                }
            } else if (elements[0] instanceof Workspace) {
                for (int i = 0; i < elements.length; ++i) {
                    res &= this.cleanWorkspace((Workspace)elements[i]);
                }
            } else if (elements[0] instanceof Project) {
                for (int i = 0; i < elements.length; ++i) {
                    Element element = elements[i];
                    int result = this.cleanProject((Project)element, this.autoClean, elements.length > 1);
                    res &= result == 1;
                    if (result != 3) continue;
                    return res;
                }
            } else {
                Project prj = this.context.getProject();
                if (prj == null) {
                    prj = Ide.getActiveProject();
                }
                if (prj != null) {
                    int result = this.cleanProject(prj, this.autoClean, false);
                    res &= result == 1;
                }
            }
            return res;
        }

        private Element[] getElementsToBuild() {
            IdeAction compileAction;
            Element[] elements = this.context.getSelection();
            boolean nonBuildableElements = elements == null || elements.length == 0;
            for (int i = 0; !nonBuildableElements && i < elements.length; ++i) {
                Element element = elements[i];
                if (element == null) {
                    nonBuildableElements = true;
                    continue;
                }
                Attributes attributes = element.getAttributes();
                if (attributes.isSet(ElementAttributes.BUILDABLE)) continue;
                nonBuildableElements = true;
            }
            if (nonBuildableElements && this.context.getNode() != null) {
                elements = new Element[]{this.context.getNode()};
            }
            if ((compileAction = CompilerContext.getCompileAction(this.context)) != null) {
                int cmdId = compileAction.getCommandId();
                Workspace wsp = Ide.getActiveWorkspace();
                Project prj = Ide.getActiveProject();
                if (wsp != null && (cmdId == JCompiler.MAKE_WORKSPACE_CMD_ID || cmdId == JCompiler.BUILD_WORKSPACE_CMD_ID || cmdId == JCompiler.CLEAN_WORKSPACE_CMD_ID)) {
                    elements = new Element[]{wsp};
                } else if (prj != null && (cmdId == JCompiler.MAKE_PROJECT_CMD_ID || cmdId == JCompiler.MAKE_PROJECT_AND_DEPENDENCIES_CMD_ID || cmdId == JCompiler.BUILD_PROJECT_CMD_ID || cmdId == JCompiler.BUILD_PROJECT_AND_DEPENDENCIES_CMD_ID || cmdId == JCompiler.CLEAN_PROJECT_CMD_ID)) {
                    elements = new Element[]{prj};
                } else if (prj != null && (cmdId == JCompiler.MAKE_WORKINGSET_CMD_ID || cmdId == JCompiler.BUILD_WORKINGSET_CMD_ID)) {
                    elements = new Element[]{new WorkingSetNode()};
                }
            }
            return elements;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block28: {
                JCompiler ci = JCompiler.getInstance();
                boolean cleanAllResult = false;
                try {
                    boolean buildVetoThrown;
                    block29: {
                        Ojc.currentContext = this.context;
                        UnifiedBuildSystem.this.translatedWorkspaces.clear();
                        UnifiedBuildSystem.this.suppressedWorkspaces.clear();
                        UnifiedBuildSystem.this.compiledWorkspaces.clear();
                        Element[] elements = this.getElementsToBuild();
                        if (elements == null) break block28;
                        if (elements.length == 0) {
                            break block28;
                        }
                        ideLog.reinit();
                        if (Ide.getIdeArgs().getCreateUI()) {
                            JCompilerMenuItems.getInstance().enableCancelBuild(true);
                        }
                        if (!this.cleanAll) {
                            ci.logOutStartBuild();
                        }
                        buildVetoThrown = false;
                        try {
                            if (this.cleanAll) {
                                if (this.context != null) {
                                    this.context.setProperty(UnifiedBuildSystem.ELEMENTS_TO_CLEAN_PROPERTY, elements.clone());
                                }
                                ci.invokeListenersCleanBegin(this.context, ideLog);
                                try {
                                    cleanAllResult = this.cleanAll(elements);
                                }
                                catch (FailedDeleteException e) {
                                    String message = UnifiedBuildSystem.this.failedDeleteException.getMessage();
                                    ci.logOutMsg(message + "\n");
                                    message = CompArb.getString(37);
                                    ci.logOutMsg(message + "\n");
                                }
                            } else {
                                if (this.context != null) {
                                    this.context.setProperty(UnifiedBuildSystem.ELEMENTS_TO_BUILD_PROPERTY, elements.clone());
                                }
                                ci.invokeListenersBuildBegin(this.context, ideLog);
                                this.buildAll(elements);
                            }
                        }
                        catch (BuildSystemVetoException e) {
                            buildVetoThrown = true;
                        }
                        catch (RuntimeException e) {
                            if (CompArb.getString(76).equals(e.getMessage())) {
                                ideLog.error(null, 0, 0, 0, e.getMessage());
                                break block29;
                            }
                            throw e;
                        }
                        finally {
                            this.deploymentProfileBuilt.clear();
                            this.projectsBuilt.clear();
                        }
                    }
                    assert (LOG.trace("Build time in msec: " + (System.currentTimeMillis() - this.startTime)));
                    if (!buildVetoThrown) {
                        if (this.cleanAll) {
                            ci.invokeListenersCleanFinish(this.context, ideLog);
                        } else {
                            ci.invokeListenersBuildFinish(ideLog);
                        }
                    }
                    ideLog.completed();
                    ci.logOutEndBuild(this.filesBuilt, this.cleanAll ? (cleanAllResult ? 1 : 2) : 0);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    ci.logOutMsg(CompArb.getString(46) + "\n");
                    ideLog.error(null, 0, 0, 0, CompArb.getString(46));
                    ideLog.completed();
                    ci.logOutEndBuild(this.filesBuilt, this.cleanAll ? (cleanAllResult ? 1 : 2) : 0);
                    String message = "Fatal exception during " + (this.cleanAll ? "cleaning" : "compiling") + " of project files";
                    FeedbackManager.reportException((String)message, (Throwable)t);
                }
                finally {
                    UnifiedBuildSystem.this.translatedWorkspaces.clear();
                    UnifiedBuildSystem.this.suppressedWorkspaces.clear();
                    UnifiedBuildSystem.this.compiledWorkspaces.clear();
                    UnifiedBuildSystem.this.translatedSources = null;
                    UnifiedBuildSystem.this.suppressedSources = null;
                    UnifiedBuildSystem.this.compiledClasses = null;
                    if (this.context != null) {
                        this.context.removeProperty(UnifiedBuildSystem.ELEMENTS_TO_BUILD_PROPERTY);
                        this.context.removeProperty(UnifiedBuildSystem.ELEMENTS_TO_CLEAN_PROPERTY);
                    }
                }
            }
            if (Ide.getIdeArgs().getCreateUI()) {
                JCompilerMenuItems.getInstance().enableCancelBuild(false);
            }
            this.context = null;
            this.copyResSpec = null;
            this.reverseCopy = false;
        }

        private class FailedDeleteException
        extends RuntimeException {
            private FailedDeleteException() {
            }
        }

        private final class WorkingSetNode
        extends Node {
            WorkingSetNode() {
            }

            IntersectedFilters getFilters(Project prj) {
                WorkingSets workingSets = WorkingSets.getInstance((Workspace)Ide.getActiveWorkspace());
                WorkingSet curWorkingSet = workingSets.getCurrentWorkingSet();
                if (curWorkingSet == null) {
                    curWorkingSet = workingSets.getWorkingSet(WorkingSets.ALL_FILES_WORKING_SET_LABEL);
                }
                if (curWorkingSet == null) {
                    return null;
                }
                PatternFilters filters = curWorkingSet.getPatternFilters(prj);
                if (filters == null) {
                    return null;
                }
                return new IntersectedFilters(filters);
            }
        }
    }
}

