/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.model.Project;
import oracle.ide.runner.Debugger;
import oracle.jdeveloper.compiler.Translator;
import oracle.jdeveloper.compiler.UnifiedBuildSystem;
import oracle.ojc.interfaces.Storage;

class RedefineMap {
    final HashMap<String, RedefineDetails> redefineMap = new HashMap();
    final byte[] empty = new byte[0];

    RedefineMap() {
    }

    private byte[] fileToBuffer(String file, Translator.Log log) {
        try {
            File f = new File(file);
            FileInputStream fis = new FileInputStream(f);
            int len = fis.available();
            if (len <= 0) {
                return null;
            }
            byte[] classBuffer = new byte[len];
            fis.read(classBuffer);
            fis.close();
            return classBuffer;
        }
        catch (IOException e) {
            log.error(null, 0, 0, 0, "can't redefine " + file);
            return null;
        }
    }

    void redefineClass(Storage storage, String qualifiedClassName, byte[] buffer, int len, Translator.Log log) {
        String path = storage.getPath();
        UnifiedBuildSystem.getInstance().markCompiled(path);
        Debugger debugger = Debugger.getDebugger();
        if (debugger != null && debugger.isDebugging()) {
            byte[] classBuffer;
            if (buffer == null) {
                classBuffer = this.empty;
            } else {
                classBuffer = new byte[len];
                System.arraycopy(buffer, 0, classBuffer, 0, len);
            }
            RedefineDetails details = new RedefineDetails(qualifiedClassName, classBuffer);
            this.redefineMap.put(path, details);
        }
    }

    void redefineClass(String fileName, String outDir, Translator.Log log) {
        UnifiedBuildSystem.getInstance().markCompiled(fileName);
        Debugger debugger = Debugger.getDebugger();
        if (debugger != null && debugger.isDebugging()) {
            String c = fileName;
            if (c.startsWith(outDir)) {
                c = c.substring(outDir.length());
            }
            if (c.length() > 0 && c.charAt(0) == File.separatorChar) {
                c = c.substring(1);
            }
            if (c.endsWith(".class")) {
                c = c.substring(0, c.length() - 6);
            }
            c = c.replace(File.separatorChar, '.');
            RedefineDetails details = new RedefineDetails(c, this.empty);
            this.redefineMap.put(fileName, details);
        }
    }

    void redefineClassMap(Project prj, Translator.Log log) {
        if (this.redefineMap != null && this.redefineMap.size() > 0) {
            HashMap<String, byte[]> newRedefineMap = new HashMap<String, byte[]>();
            for (Map.Entry<String, RedefineDetails> entry : this.redefineMap.entrySet()) {
                if (entry.getValue().fileContents == this.empty) {
                    byte[] classBuffer = this.fileToBuffer(entry.getKey(), log);
                    if (classBuffer == null) continue;
                    newRedefineMap.put(entry.getValue().className, classBuffer);
                    continue;
                }
                newRedefineMap.put(entry.getValue().className, entry.getValue().fileContents);
            }
            this.redefineMap.clear();
            Debugger.getDebugger().redefineClasses(prj, newRedefineMap);
            newRedefineMap.clear();
        }
    }

    class RedefineDetails {
        String className;
        byte[] fileContents;

        RedefineDetails(String className, byte[] fileContents) {
            this.className = className;
            this.fileContents = fileContents;
        }
    }
}

