/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.awt.Component;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.JavaFileManager;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.index.QueryCriteria;
import oracle.ide.layout.ViewId;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.LogPage;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.runner.SimpleProcess;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.PlatformUtils;
import oracle.jdeveloper.compiler.BuildSystemConfiguration;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.Helpers;
import oracle.jdeveloper.compiler.IdeLog;
import oracle.jdeveloper.compiler.IdeStorageMap;
import oracle.jdeveloper.compiler.IdeStorageWrapper;
import oracle.jdeveloper.compiler.JCompiler;
import oracle.jdeveloper.compiler.PatchClassFile;
import oracle.jdeveloper.compiler.RedefineMap;
import oracle.jdeveloper.compiler.SourceMap;
import oracle.jdeveloper.compiler.Translator;
import oracle.jdeveloper.compiler.UnifiedBuildSystem;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.model.J2eeSettings;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.compiler.CompilerOptionManager;
import oracle.jdevimpl.javacompiler.FileOutputListener;
import oracle.jdevimpl.javacompiler.JDevJavaCompiler;
import oracle.jdevimpl.javacompiler.JDevJavaFileManager;
import oracle.jdevimpl.javacompiler.JavaCompilerLog;
import oracle.jdevimpl.javacompiler.JavaDependencyProvider;
import oracle.jdevimpl.javacompiler.StorageJavaFileObject;
import oracle.ojc.compiler.Compiler;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Options;
import oracle.ojc.compiler.Scanner;
import oracle.ojc.compiler.Warning;
import oracle.ojc.interfaces.ErrorInfo;
import oracle.ojc.interfaces.IdeEnv;
import oracle.ojc.interfaces.Log;
import oracle.ojc.interfaces.Log2;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.FileStorage;

public class Ojc
implements Translator,
Addin {
    private final Pattern javacOutFilePattern = Pattern.compile("^\\[wrote (.*\\.class)\\]$");
    private final Pattern javacParsingFilePattern = Pattern.compile("^\\[parsing started (.*\\.java)\\]$");
    private Translator.Log _log = null;
    private static File tmpJavacFile = null;
    private static File tmpOjcFile = null;
    static Context currentContext = null;

    @Override
    public String getName() {
        return "Ojc";
    }

    @Override
    public ArrayList getInputTypes() {
        ArrayList<String> v = new ArrayList<String>(1);
        v.add(".java");
        return v;
    }

    @Override
    public ArrayList getOutputTypes() {
        ArrayList<String> v = new ArrayList<String>(1);
        v.add(".class");
        return v;
    }

    @Override
    public boolean canBuild(Storage store) {
        return store.getName().endsWith(".java");
    }

    @Override
    public boolean needToBuild(Storage store) {
        return false;
    }

    @Override
    public void setLog(Translator.Log log) {
        this._log = log;
    }

    @Override
    public void setParameter(String name, String value) {
        throw new Error();
    }

    @Override
    public void setProject(Project project) {
    }

    @Override
    public void updateProject(Project project) {
    }

    private static File processOutputDirectory(Project prj, List cmd) {
        File outFile;
        URL outUrl = JavaProject.getInstance((Project)prj).getOutputDirectory();
        File file = outFile = outUrl != null ? new File(outUrl.getPath()) : new File(prj.getURL().getPath()).getParentFile();
        if (cmd != null) {
            cmd.add("-d");
            cmd.add(Ojc.stringize(outFile.getPath()));
        }
        if (!outFile.exists()) {
            outFile.mkdirs();
        }
        return outFile;
    }

    private static String stringize(String str) {
        if (!(str.startsWith("\"") || str.indexOf(32) < 0 && str.indexOf(9) < 0)) {
            return "\"" + str + "\"";
        }
        return str;
    }

    private String buildString(String opt, Storage[] path, ArrayList sources) {
        StringBuffer pathstr = new StringBuffer();
        if (path != null) {
            for (int i = 0; i < path.length; ++i) {
                if (path[i].getProperty("isFromManifestFile") == Boolean.TRUE) continue;
                pathstr.append(opt == null ? Ojc.stringize(path[i].getPath()) : path[i].getPath());
                pathstr.append(opt == null ? " " : File.pathSeparator);
            }
        }
        if (sources != null) {
            ArrayList srcList = new ArrayList();
            for (int i = 0; i < sources.size(); ++i) {
                srcList.add(sources.get(i));
            }
            ArrayList cpElements = Helpers.listOfUniqueClassPathElement(srcList);
            if (cpElements != null) {
                for (int i = 0; i < cpElements.size(); ++i) {
                    URL url = (URL)cpElements.get(i);
                    String p = new File(url.getPath()).getPath();
                    pathstr.append(opt == null ? Ojc.stringize(p) : p);
                    pathstr.append(opt == null ? " " : File.pathSeparator);
                }
            }
        }
        if (pathstr != null && pathstr.length() > 0) {
            if (opt != null) {
                pathstr.setLength(pathstr.length() - 1);
                return opt + " " + Ojc.stringize(pathstr.toString()) + " ";
            }
            pathstr.setCharAt(pathstr.length() - 1, ' ');
            return pathstr.toString();
        }
        return "";
    }

    private void addSMAPs(ArrayList sources, String outPath) {
        HashMap<String, File[]> classDirectoryMap = new HashMap<String, File[]>();
        for (int i = 0; i < sources.size(); ++i) {
            Storage stor = (Storage)sources.get(i);
            SourceMap sourceMap = (SourceMap)stor.getProperty("sourceMap");
            if (sourceMap == null) continue;
            try {
                String qualifiedClassName = sourceMap.getQualifiedClassName().replace('.', File.separatorChar) + ".class";
                File qualifiedClassFile = new File(outPath + File.separatorChar + qualifiedClassName);
                if (!qualifiedClassFile.exists()) continue;
                this.patchAndMoveClassFiles(qualifiedClassFile, qualifiedClassName, sourceMap, stor, outPath, classDirectoryMap);
                continue;
            }
            catch (IOException e) {
                continue;
            }
            catch (ClassFormatError e) {
                // empty catch block
            }
        }
    }

    private void patchAndMoveClassFiles(File qualifiedClassFile, String qualifiedClassName, SourceMap sourceMap, Storage stor, String outPath, HashMap<String, File[]> classDirectoryMap) throws IOException, ClassFormatError {
        String destOutPath = (String)stor.getProperty("outputDirectory");
        boolean moveClassFiles = destOutPath != null && !destOutPath.equals(outPath);
        ArrayList<File> classFileList = new ArrayList<File>();
        classFileList.add(qualifiedClassFile);
        int separatorIndex = qualifiedClassName.lastIndexOf(File.separatorChar);
        String qualifiedPackageName = separatorIndex > 0 ? qualifiedClassName.substring(0, separatorIndex + 1) : "";
        File classDirectory = qualifiedClassFile.getParentFile();
        String classNamePrefix = qualifiedClassFile.getName();
        int dotIndex = classNamePrefix.lastIndexOf(46);
        classNamePrefix = dotIndex > 0 ? classNamePrefix.substring(0, dotIndex) + "$" : null;
        if (classDirectory != null && classNamePrefix != null) {
            File[] children = classDirectoryMap.get(classDirectory.getPath());
            if (children == null) {
                children = classDirectory.listFiles();
                classDirectoryMap.put(classDirectory.getPath(), children);
            }
            for (int x = 0; x < children.length; ++x) {
                String childName = children[x].getName();
                if (!childName.endsWith(".class") || !childName.startsWith(classNamePrefix)) continue;
                classFileList.add(children[x]);
            }
        }
        for (int x = 0; x < classFileList.size(); ++x) {
            File classFile = (File)classFileList.get(x);
            PatchClassFile.addSMAP(classFile, sourceMap.getSMAP());
            if (!moveClassFiles) continue;
            String className = classFile.getName();
            File dest = new File(destOutPath + File.separatorChar + qualifiedPackageName + className);
            if (dest.exists()) {
                dest.delete();
            }
            classFile.renameTo(dest);
        }
    }

    private void logMessage(Translator.Log log, Storage source, int pos, int errCode, String errMsg, boolean error) {
        SourceMap sourceMap;
        int line = Scanner.positionToLine((int)pos);
        int col = Scanner.positionToColumn((int)pos);
        if (source != null && (sourceMap = (SourceMap)source.getProperty("sourceMap")) != null) {
            int[] data = new int[]{line, col};
            Storage[] stor = new Storage[]{null};
            boolean translated = sourceMap.translateLocation(data, stor);
            line = data[0];
            col = data[1];
            source = stor[0];
            if (source != null && J2eeSettings.isCompilableJsp(source.getName()) && log instanceof IdeLog) {
                String path;
                URL htmlRootDirURL;
                URL newPathURL;
                String newPath;
                File f;
                if (!translated && !error) {
                    return;
                }
                Project project = ((IdeLog)log).getProject();
                if (project != null && (f = new File(newPath = URLFileSystem.getPlatformPathName((URL)(newPathURL = URLFactory.newURL((URL)(htmlRootDirURL = J2eeSettings.getInstance(project).getHtmlRootDirectory()), (String)(path = source.getPath())))))).exists()) {
                    source = Helpers.createFileStorage(f);
                }
            }
        }
        if (error) {
            log.error(source, line, col, errCode, errMsg);
        } else {
            log.warning(source, line, col, errCode, errMsg);
        }
    }

    private String buildOjcCmdLine(Project jprj, Options opt, ArrayList toBuild, boolean rebuild) {
        StringBuffer ojcCmd = new StringBuffer();
        String str = new File(JProjectLibraries.getInstance((PropertyStorage)jprj).getJDK().getJavaExecutable().getPath()).getPath();
        if (str == null) {
            str = "<path to java executable>";
        }
        ojcCmd.append(str);
        ojcCmd.append(" -jar ");
        File file = new File(Ide.getLibDirectory(), "ojc.jar");
        if (file.exists()) {
            ojcCmd.append(file.getPath());
        } else {
            file = new File(Ide.getBinDirectory() + "/../lib/ojc.jar");
            if (file.exists()) {
                ojcCmd.append(file.getPath());
            } else {
                ojcCmd.append("<ojc.jar location>");
            }
        }
        ojcCmd.append(" ");
        CompilerOptionManager optionManager = CompilerOptionManager.getInstance((PropertyStorage)jprj);
        ojcCmd.append(optionManager.getCompilerOptionsAsString("Ojc"));
        switch (opt.sourceJDKVersion) {
            case 110: {
                ojcCmd.append("-source 1.1 ");
                break;
            }
            case 120: {
                ojcCmd.append("-source 1.2 ");
                break;
            }
            case 130: {
                ojcCmd.append("-source 1.3 ");
                break;
            }
            case 140: {
                ojcCmd.append("-source 1.4 ");
                break;
            }
            case 150: {
                ojcCmd.append("-source 1.5 ");
                break;
            }
            case 160: {
                ojcCmd.append("-source 1.6 ");
                break;
            }
            case 170: {
                ojcCmd.append("-source 1.7 ");
            }
        }
        switch (opt.targetJDKVersion) {
            case 110: {
                ojcCmd.append("-target 1.1 ");
                break;
            }
            case 120: {
                ojcCmd.append("-target 1.2 ");
                break;
            }
            case 130: {
                ojcCmd.append("-target 1.3 ");
                break;
            }
            case 140: {
                ojcCmd.append("-target 1.4 ");
                break;
            }
            case 150: {
                ojcCmd.append("-target 1.5 ");
                break;
            }
            case 160: {
                ojcCmd.append("-target 1.6 ");
                break;
            }
            case 170: {
                ojcCmd.append("-target 1.7 ");
            }
        }
        ojcCmd.append(opt.noquiet ? "-noquiet " : "");
        ojcCmd.append("-encoding ");
        ojcCmd.append(opt.encoding == null ? "null" : opt.encoding);
        ojcCmd.append(" ");
        if (opt.destinationDir != null) {
            ojcCmd.append("-d ");
            ojcCmd.append(Ojc.stringize(opt.destinationDir));
            ojcCmd.append(" ");
        }
        if (opt.makeFile != null) {
            ojcCmd.append("-make ");
            ojcCmd.append(Ojc.stringize(opt.makeFile.getPath()));
            ojcCmd.append(" ");
        }
        if (rebuild && ojcCmd.indexOf("-rebuild") < 0) {
            ojcCmd.append("-rebuild ");
        }
        ojcCmd.append(this.buildString("-classpath ", opt.classpathStorage, toBuild));
        ojcCmd.append(this.buildString("-sourcepath ", opt.sourcepathStorage, null));
        Storage[] tmp = new Storage[toBuild.size()];
        toBuild.toArray(tmp);
        ojcCmd.append(this.buildString(null, tmp, null));
        return ojcCmd.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runJavacInProcess(Project jprj, CompilerOptionManager optionManager, ArrayList sources, final Translator.Log log) {
        int result;
        String target;
        String source;
        String[] optionCommands;
        final Pattern javacErrorPattern = Pattern.compile("^(.*):([0-9]+):(.*)$");
        final Pattern javacWarningPattern = Pattern.compile("^(.*):([0-9]+):[ ]*([\\p{javaLowerCase}\\p{javaUpperCase}]+:[ ]*\\[[\\p{javaLowerCase}\\p{javaUpperCase}]+\\])(.*)$");
        final RedefineMap rm = new RedefineMap();
        final HashMap<String, Storage> sourceMapFiles = new HashMap<String, Storage>();
        final boolean[] foundParsingLines = new boolean[]{false};
        boolean reallyVerboseOutput = false;
        ArrayList<String> options = new ArrayList<String>();
        for (String optionCommand : optionCommands = optionManager.getCompilerOptionsAsArray("Javac")) {
            if (optionCommand.equals("-verbose")) {
                reallyVerboseOutput = true;
            }
            options.add(optionCommand);
        }
        BuildSystemConfiguration buildSysConfig = BuildSystemConfiguration.getInstance((PropertyStorage)jprj);
        if (buildSysConfig.isJDK14OrHigher() && !(source = buildSysConfig.getSource()).equals("Default")) {
            options.add("-source");
            options.add(source);
        }
        if (!(target = buildSysConfig.getTarget()).equals("Default")) {
            options.add("-target");
            options.add(target);
        }
        if (UnifiedBuildSystem.showCompileProgress && !reallyVerboseOutput) {
            options.add("-verbose");
        }
        options.add("-encoding");
        options.add(buildSysConfig.getCurrentEncoding());
        options.add("-classpath");
        options.add(Helpers.urlPathAndDependantPathToString(PathsConfiguration.getInstance((Project)jprj).getClassPath(), sources, File.pathSeparator));
        options.add("-sourcepath");
        options.add(Helpers.urlPathToString(PathsConfiguration.getInstance((Project)jprj).getProjectSourcePath(), File.pathSeparator));
        final String outPath = Ojc.processOutputDirectory(jprj, null).getPath();
        options.add("-d");
        options.add(outPath);
        JDevJavaCompiler jdevJavaCompiler = new JDevJavaCompiler();
        ArrayList<StorageJavaFileObject> fileObjects = new ArrayList<StorageJavaFileObject>(sources.size());
        HashSet<String> sourcesSeen = new HashSet<String>(sources.size());
        for (int x = 0; x < sources.size(); ++x) {
            Storage storage = (Storage)sources.get(x);
            String storagePath = storage.getPath().replace('\\', '/');
            if (!sourcesSeen.add(storagePath)) continue;
            if (storage.getProperty("sourceMap") != null) {
                sourceMapFiles.put(storagePath, storage);
            }
            fileObjects.add(jdevJavaCompiler.getJavaFileObject(null, storage, buildSysConfig.getCurrentEncoding()));
            if (foundParsingLines[0]) continue;
            UnifiedBuildSystem.getInstance().markTranslated(this, storage);
        }
        sourcesSeen.clear();
        sourcesSeen = null;
        if (Thread.currentThread().isInterrupted()) {
            return 0;
        }
        if (UnifiedBuildSystem.showCompileProgress) {
            this.showJavacInProcessCmdLine(jprj, options, sources);
        }
        class JavacCompilerLog
        implements JavaCompilerLog<StorageJavaFileObject> {
            private String outputDirectory;
            private boolean reallyVerboseOutput;

            JavacCompilerLog(String outputDirectory, boolean reallyVerboseOutput) {
                this.outputDirectory = outputDirectory;
                this.reallyVerboseOutput = reallyVerboseOutput;
            }

            public void println(String line) {
                String fname;
                String classFile;
                Matcher matcher = Ojc.this.javacOutFilePattern.matcher(line);
                if (matcher.matches() && (classFile = matcher.group(1)).endsWith(".class")) {
                    if (UnifiedBuildSystem.showCompileProgress) {
                        String msg = "  " + CompArb.format(111, classFile) + "\n";
                        JCompiler.getInstance().getOutputLog().log((Object)msg);
                    }
                    return;
                }
                matcher = Ojc.this.javacParsingFilePattern.matcher(line);
                if (matcher.matches() && (fname = matcher.group(1)).endsWith(".java")) {
                    foundParsingLines[0] = true;
                    Storage source = Ojc.getSourceFile(sourceMapFiles, fname);
                    UnifiedBuildSystem.getInstance().markTranslated(Ojc.this, source);
                    if (log.nerrors() <= 0) {
                        log.clear(source);
                    }
                    if (UnifiedBuildSystem.showCompileProgress) {
                        if (fname != null) {
                            fname = fname.replace('/', File.separatorChar);
                        }
                        String msg = "  " + CompArb.format(112, fname) + "\n";
                        JCompiler.getInstance().getOutputLog().log((Object)msg);
                    }
                    return;
                }
                if (line.startsWith("[")) {
                    if (this.reallyVerboseOutput) {
                        JCompiler.getInstance().getOutputLog().log((Object)(line + "\n"));
                    }
                    return;
                }
                JCompiler.getInstance().getOutputLog().log((Object)(line + "\n"));
            }

            public void error(StorageJavaFileObject source, long line, long col, int errNumber, String errMsg) {
                String finalMessage = errMsg;
                if (Locale.getDefault().getLanguage().equals("en")) {
                    Matcher matcher;
                    int eolIndex = errMsg.indexOf(10);
                    StringBuilder buf = new StringBuilder();
                    if (eolIndex > 0) {
                        buf.append(errMsg.substring(0, eolIndex));
                        if (errMsg.substring(0, eolIndex).endsWith(" cannot find symbol") && errMsg.length() > eolIndex && errMsg.substring(eolIndex + 1).startsWith("symbol  : ")) {
                            buf.setLength(buf.length() - 6);
                            int nextEolIndex = errMsg.indexOf(10, eolIndex + 1);
                            if (nextEolIndex > 0) {
                                buf.append(errMsg.substring(eolIndex + 11, nextEolIndex));
                            } else {
                                buf.append(errMsg.substring(eolIndex + 11));
                            }
                        }
                    } else {
                        buf.append(errMsg);
                    }
                    finalMessage = (matcher = javacErrorPattern.matcher(buf.toString())).matches() && matcher.groupCount() == 3 ? matcher.group(3) : buf.toString();
                }
                int pos = Scanner.lineColumnToPosition((int)((int)line), (int)((int)col));
                Ojc.this.logMessage(log, source == null ? null : source.getStorage(), pos, errNumber, finalMessage, true);
            }

            public void warning(StorageJavaFileObject source, long line, long col, int warnNumber, String warnMsg) {
                String finalMessage = warnMsg;
                if (Locale.getDefault().getLanguage().equals("en")) {
                    Matcher matcher = javacWarningPattern.matcher(warnMsg);
                    finalMessage = matcher.matches() ? matcher.group(4) : warnMsg;
                }
                int pos = Scanner.lineColumnToPosition((int)((int)line), (int)((int)col));
                Ojc.this.logMessage(log, source == null ? null : source.getStorage(), pos, warnNumber, finalMessage, false);
            }

            public void clear(StorageJavaFileObject source) {
            }

            public int nerrors() {
                return log.nerrors();
            }

            public int nwarnings() {
                return log.nwarnings();
            }
        }
        JavacCompilerLog javacCompilerLog = new JavacCompilerLog(outPath, reallyVerboseOutput);
        JDevJavaFileManager fileManager = new JDevJavaFileManager();
        fileManager.setLog((JavaCompilerLog)javacCompilerLog);
        fileManager.setVerbosePath(reallyVerboseOutput);
        fileManager.setClassPath(Helpers.urlPathAndDependantPathToStorageArray(PathsConfiguration.getInstance((Project)jprj).getClassPath(), sources));
        fileManager.registerFileOutputListener(new FileOutputListener(){

            public void outputFile(String outputPath) {
                rm.redefineClass(outputPath, outPath, log);
            }
        });
        File toolsJar = this.getToolsJarFromJdk(jprj, log);
        try {
            result = jdevJavaCompiler.compile(toolsJar, (JavaFileManager)fileManager, fileObjects, options, (JavaCompilerLog)javacCompilerLog);
        }
        finally {
            try {
                if (fileManager != null) {
                    fileManager.close();
                }
            }
            catch (IOException ioe) {
                FeedbackManager.reportException((Throwable)ioe);
            }
        }
        rm.redefineClassMap(jprj, log);
        this.addSMAPs(sources, outPath);
        return result == 0 ? result : (log.nerrors() > 0 ? log.nerrors() : 1);
    }

    private File getToolsJarFromJdk(Project jprj, Translator.Log log) {
        JDK jdk = JProjectLibraries.getInstance((PropertyStorage)jprj).getJDK();
        if (jdk == JLibraryManager.getDefaultJDK()) {
            return null;
        }
        URL url = jdk.getSDKBinDir();
        if (url != null) {
            String path = URLFileSystem.getPath((URL)url);
            return new File(path, "../lib/tools.jar");
        }
        log.warning(null, 0, 0, 0, CompArb.getString(110));
        return null;
    }

    private void showJavacInProcessCmdLine(Project jprj, List<String> options, List sources) {
        StringBuilder cmdBuf = new StringBuilder();
        String javacExe = null;
        URL javacURL = JProjectLibraries.getInstance((PropertyStorage)jprj).getJDK().getSDKBinDir();
        if (javacURL != null) {
            javacURL = URLFactory.newURL((URL)javacURL, (String)"javac");
            javacExe = URLFileSystem.getPlatformPathName((URL)javacURL);
        }
        if (javacExe == null) {
            javacExe = "<path to java executable>";
        }
        cmdBuf.append(javacExe);
        cmdBuf.append(' ');
        boolean skipOption = false;
        for (String option : options) {
            if (skipOption) {
                skipOption = false;
                continue;
            }
            if (option.equals("-version") || option.equals("-et") || option.equals("-rebuild")) continue;
            if (option.equals("-exclude")) {
                skipOption = true;
                continue;
            }
            if (option.indexOf(47) >= 0 || option.indexOf(92) >= 0) {
                cmdBuf.append(Ojc.stringize(option));
            } else {
                cmdBuf.append(option);
            }
            cmdBuf.append(' ');
        }
        for (int i = 0; i < sources.size(); ++i) {
            Storage storage = (Storage)sources.get(i);
            cmdBuf.append(Ojc.stringize(storage.getPath()));
            cmdBuf.append(' ');
        }
        String cmdLine = cmdBuf.toString();
        if (System.getProperty("COMPILER.COMPILE.PRETTIFY_CMDLINE") != null) {
            cmdLine = this.prettifyCommandLine(cmdLine);
        }
        JCompiler.getInstance().getOutputLog().log((Object)(cmdLine + "\n"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runJavacOutOfProcess(Project jprj, CompilerOptionManager optionManager, boolean rebuild, ArrayList sources, ArrayList results, final Translator.Log log) {
        String target;
        String source;
        final RedefineMap rm = new RedefineMap();
        final HashMap<String, Storage> sourceMapFiles = new HashMap<String, Storage>();
        final HashSet<String> sourcesBeingCompiled = new HashSet<String>();
        ArrayList<String> cmd = new ArrayList<String>(15 + sources.size());
        BuildSystemConfiguration buildSysConfig = BuildSystemConfiguration.getInstance((PropertyStorage)jprj);
        try {
            String javacString = JProjectLibraries.getInstance((PropertyStorage)jprj).getJDK().getJavaExecutable().getPath();
            if (javacString.endsWith("jre/bin/java.exe")) {
                javacString = javacString.substring(0, javacString.length() - 16) + (File.separatorChar == '/' ? "bin/javac" : "bin/javac.exe");
            } else if (javacString.endsWith("java.exe")) {
                javacString = javacString.substring(0, javacString.length() - 4) + (File.separatorChar == '/' ? "c" : "c.exe");
            } else if (javacString.endsWith("jre/bin/java")) {
                javacString = javacString.substring(0, javacString.length() - 12) + (File.separatorChar == '/' ? "bin/javac" : "bin/javac.exe");
            } else if (javacString.endsWith("java")) {
                javacString = javacString + (File.separatorChar == '/' ? "c" : "c.exe");
            } else {
                throw new Throwable();
            }
            File javacFile = new File(javacString);
            if (!javacFile.exists()) {
                throw new Throwable();
            }
            javacString = javacFile.getPath();
            cmd.add(Ojc.stringize(javacString));
        }
        catch (Throwable t) {
            System.out.println("error: unable to determine javac path");
            return 1;
        }
        StringTokenizer vmArgs = new StringTokenizer(buildSysConfig.getOutOfProcessJavaOptions());
        while (vmArgs.hasMoreTokens()) {
            cmd.add("-J" + vmArgs.nextToken());
        }
        boolean reallyVerboseOutput = false;
        String[] optionCommands = optionManager.getCompilerOptionsAsArray("Javac");
        for (int x = 0; x < optionCommands.length; ++x) {
            String optionCommand = optionCommands[x];
            if (optionCommand.equals("-verbose")) {
                reallyVerboseOutput = true;
            } else if (optionCommand.equals("-exclude")) {
                if (x >= optionCommand.length() - 1 || optionCommands[x + 1].startsWith("-")) continue;
                ++x;
                continue;
            }
            cmd.add(optionCommand);
        }
        if (buildSysConfig.isJDK14OrHigher() && !(source = buildSysConfig.getSource()).equals("Default")) {
            cmd.add("-source");
            cmd.add(source);
        }
        if (!(target = buildSysConfig.getTarget()).equals("Default")) {
            cmd.add("-target");
            cmd.add(target);
        }
        if (UnifiedBuildSystem.showCompileProgress && !reallyVerboseOutput) {
            cmd.add("-verbose");
        }
        cmd.add("-encoding");
        cmd.add(buildSysConfig.getCurrentEncoding());
        cmd.add("-classpath");
        cmd.add(Ojc.stringize(Helpers.urlPathAndDependantPathToString(PathsConfiguration.getInstance((Project)jprj).getClassPath(), sources, File.pathSeparator)));
        cmd.add("-sourcepath");
        cmd.add(Ojc.stringize(Helpers.urlPathToString(PathsConfiguration.getInstance((Project)jprj).getProjectSourcePath(), File.pathSeparator)));
        String outPath = Ojc.processOutputDirectory(jprj, cmd).getPath();
        try {
            if (tmpJavacFile == null) {
                tmpJavacFile = File.createTempFile("javac", null, null);
                tmpJavacFile.deleteOnExit();
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(tmpJavacFile), 16384);
            boolean isBuggedJavac = PlatformUtils.isWindows() && buildSysConfig.isJDK15();
            for (int i = 0; i < sources.size(); ++i) {
                Storage stor = (Storage)sources.get(i);
                String forwardStorPath = stor.getPath().replace('\\', '/');
                if (isBuggedJavac && stor.getName().equals("package-info.java")) {
                    bw.write(Ojc.stringize(stor.getPath().replace('/', '\\')));
                } else {
                    bw.write(Ojc.stringize(forwardStorPath));
                }
                bw.write("\n");
                if (stor.getProperty("sourceMap") != null) {
                    sourceMapFiles.put(forwardStorPath, stor);
                }
                sourcesBeingCompiled.add(forwardStorPath);
            }
            bw.close();
            cmd.add(Ojc.stringize("@" + tmpJavacFile.getPath()));
        }
        catch (Throwable t) {
            System.out.println("error: unable to run javac as an external process: " + t);
            return 1;
        }
        SimpleProcess javacProcess = new SimpleProcess(cmd.toArray(new String[cmd.size()]));
        javacProcess.setAddToProcessesFolder(false);
        javacProcess.setAddToTerminateMenu(false);
        class JavacLogInfo
        extends AbstractLogPage {
            final StringBuffer sb;
            final String outPath;
            final SimpleProcess javacProcess;
            int logLine;
            boolean reallyVerboseOutput;
            boolean startedParsing;
            boolean errorsAtStartup;
            private final Pattern javacErrorPattern;
            private final Pattern javacWarningPatternExactLine;
            private final Pattern javacWarningPatternExactLineJpCn;
            private final Pattern javacWarningPatternNoLine;
            private final Pattern javacWarningPatternNoLineJpCn;
            private final Pattern javacOutFilePattern;
            private final Pattern javacParsingFilePattern;

            JavacLogInfo(String outp, SimpleProcess prc, boolean reallyVerboseOutput) {
                super(new ViewId("BuildSystemJavacBufferPage", "BuildSystemJavacBufferPage"), null, false);
                this.javacErrorPattern = Pattern.compile("^(.*):([0-9]+):(.*)$");
                this.javacWarningPatternExactLine = Pattern.compile("^(.*):([0-9]+):([\\s\\p{L}\\d]+:[\\s]*)(\\[.+\\].*)$");
                this.javacWarningPatternExactLineJpCn = Pattern.compile("^(.*):([0-9]+):(.*\u8b66\u544a.*)(\\[.+\\].*)$");
                this.javacWarningPatternNoLine = Pattern.compile("^(.+:[\\s]*)(\\[[\\p{L}]+\\].+$)");
                this.javacWarningPatternNoLineJpCn = Pattern.compile("^(.*\u8b66\u544a.*)(\\[[\\p{L}]+\\].*$)");
                this.javacOutFilePattern = Pattern.compile("^\\[wrote (.*\\.class)\\]$");
                this.javacParsingFilePattern = Pattern.compile("^\\[parsing started (.*\\.java)\\]$");
                this.sb = new StringBuffer(1024);
                this.logLine = 0;
                this.outPath = outp;
                this.javacProcess = prc;
                this.reallyVerboseOutput = reallyVerboseOutput;
                this.startedParsing = false;
                this.errorsAtStartup = false;
            }

            private Storage getSourceMapFile(String sourceFile) {
                Storage source = (Storage)sourceMapFiles.get(sourceFile.replace('\\', '/'));
                if (source == null) {
                    source = new FileStorage(new File(sourceFile));
                }
                return source;
            }

            public void log(Object msg) {
                String line;
                this.sb.append(msg.toString());
                while ((line = this.getLine(this.sb)) != null) {
                    String newLine;
                    this.checkForTermination();
                    if (++this.logLine == 1) {
                        if (!Ide.getEnvironOptions().getSaveBeforeCompile()) {
                            log.error(null, 0, 0, 0, CompArb.getString(75));
                        }
                        if (!UnifiedBuildSystem.showCompileProgress) continue;
                        JCompiler.getInstance().getOutputLog().log((Object)(CompArb.getString(94) + "\n"));
                        if (System.getProperty("COMPILER.COMPILE.PRETTIFY_CMDLINE") != null) {
                            line = Ojc.this.prettifyCommandLine(line);
                        }
                        JCompiler.getInstance().getOutputLog().log((Object)(line + "\n"));
                        continue;
                    }
                    if (line.endsWith(" cannot find symbol") && (newLine = this.getLine(this.sb)) != null && newLine.startsWith("symbol  : ")) {
                        line = line.substring(0, line.lastIndexOf("symbol")) + newLine.substring(10);
                    }
                    boolean warningAtPreciseLine = false;
                    Matcher matcher = this.javacWarningPatternExactLineJpCn.matcher(line);
                    if (matcher.matches()) {
                        warningAtPreciseLine = true;
                    } else {
                        matcher = this.javacWarningPatternExactLine.matcher(line);
                        if (matcher.matches()) {
                            warningAtPreciseLine = true;
                        }
                    }
                    if (warningAtPreciseLine) {
                        int lineno;
                        try {
                            lineno = Integer.parseInt(matcher.group(2));
                        }
                        catch (NumberFormatException e) {
                            lineno = 0;
                        }
                        String warnMsg = matcher.group(4);
                        Ojc.this.logMessage(log, this.getSourceMapFile(matcher.group(1)), Scanner.lineColumnToPosition((int)lineno, (int)0), 0, warnMsg, false);
                        continue;
                    }
                    matcher = this.javacErrorPattern.matcher(line);
                    if (matcher.matches()) {
                        int lineno;
                        try {
                            lineno = Integer.parseInt(matcher.group(2));
                        }
                        catch (NumberFormatException e) {
                            lineno = 0;
                        }
                        String errmsg = matcher.group(3);
                        boolean isError = !errmsg.startsWith(" warning:");
                        Ojc.this.logMessage(log, this.getSourceMapFile(matcher.group(1)), Scanner.lineColumnToPosition((int)lineno, (int)0), 0, isError ? errmsg : errmsg.substring(9), isError);
                        continue;
                    }
                    matcher = this.javacOutFilePattern.matcher(line);
                    String classFileName = null;
                    if (matcher.matches() && matcher.group(1).endsWith(".class")) {
                        classFileName = matcher.group(1);
                    }
                    String sourceFileName = null;
                    matcher = this.javacParsingFilePattern.matcher(line);
                    if (matcher.matches() && matcher.group(1).endsWith(".java")) {
                        sourceFileName = matcher.group(1);
                    }
                    if (sourceFileName == null && classFileName == null && line.startsWith("[") && line.endsWith("]")) {
                        String fileName;
                        int index = line.indexOf(".class ");
                        if (index > 0 && (fileName = line.substring(1, index + 6)).replace('\\', '/').startsWith(this.outPath + '/')) {
                            classFileName = fileName;
                        }
                        if ((index = line.indexOf(".java ")) > 0) {
                            fileName = line.substring(1, index + 5);
                            if (sourcesBeingCompiled.contains(fileName.replace('\\', '/'))) {
                                sourceFileName = fileName;
                            } else if (this.startedParsing && new File(fileName).exists()) {
                                sourceFileName = fileName;
                            }
                        }
                    }
                    if (sourceFileName == null && classFileName == null && line.startsWith("[") && line.endsWith("]")) {
                        String fileName;
                        int firstIndex;
                        String forwardLine = line.replace('\\', '/');
                        for (firstIndex = forwardLine.indexOf(47); firstIndex > 0 && !Character.isWhitespace(forwardLine.charAt(firstIndex)); --firstIndex) {
                        }
                        int lastIndex = 0;
                        if (firstIndex > 0) {
                            lastIndex = forwardLine.indexOf(".class]", firstIndex);
                        }
                        if (lastIndex > 0 && (fileName = forwardLine.substring(firstIndex, lastIndex + 6).trim()).startsWith(this.outPath + '/')) {
                            classFileName = fileName;
                        }
                        lastIndex = 0;
                        if (firstIndex > 0) {
                            lastIndex = forwardLine.indexOf(".java]");
                        }
                        if (lastIndex > 0) {
                            fileName = forwardLine.substring(firstIndex, lastIndex + 5).trim();
                            if (sourcesBeingCompiled.contains(fileName)) {
                                sourceFileName = fileName;
                            } else if (this.startedParsing && new File(fileName).exists()) {
                                sourceFileName = fileName;
                            }
                        }
                    }
                    if (classFileName != null) {
                        rm.redefineClass(classFileName, this.outPath, log);
                        if (!UnifiedBuildSystem.showCompileProgress) continue;
                        JCompiler.getInstance().getOutputLog().log((Object)("  writing " + classFileName + "\n"));
                        continue;
                    }
                    if (sourceFileName != null) {
                        this.startedParsing = true;
                        Storage source = this.getSourceMapFile(sourceFileName);
                        UnifiedBuildSystem.getInstance().markTranslated(Ojc.this, source);
                        if (log.nerrors() <= 0) {
                            log.clear(source);
                        }
                        if (!UnifiedBuildSystem.showCompileProgress) continue;
                        JCompiler.getInstance().getOutputLog().log((Object)("  compiling " + sourceFileName + "\n"));
                        continue;
                    }
                    boolean warningNoLine = false;
                    matcher = this.javacWarningPatternNoLineJpCn.matcher(line);
                    if (matcher.matches()) {
                        warningNoLine = true;
                    } else {
                        matcher = this.javacWarningPatternNoLine.matcher(line);
                        if (matcher.matches()) {
                            warningNoLine = true;
                        }
                    }
                    if (warningNoLine) {
                        log.warning(null, 0, 0, 0, matcher.group(2));
                        continue;
                    }
                    if (line.startsWith("javac:")) {
                        log.error(null, 0, 0, 0, line);
                        JCompiler.getInstance().getOutputLog().log((Object)(line + "\n"));
                        continue;
                    }
                    if (line.startsWith("javac ")) {
                        JCompiler.getInstance().getOutputLog().log((Object)(line + "\n"));
                        continue;
                    }
                    if (line.startsWith("[")) {
                        if (!this.reallyVerboseOutput) continue;
                        JCompiler.getInstance().getOutputLog().log((Object)(line + "\n"));
                        continue;
                    }
                    if (!this.startedParsing && line.startsWith("Could ") || line.startsWith("Error") || line.startsWith("Unrecognized") || line.startsWith("Invalid")) {
                        if (!this.errorsAtStartup) {
                            log.error(null, 0, 0, 0, line);
                        }
                        this.errorsAtStartup = true;
                        JCompiler.getInstance().getOutputLog().log((Object)(line + "\n"));
                        continue;
                    }
                    if (this.startedParsing) continue;
                    JCompiler.getInstance().getOutputLog().log((Object)(line + "\n"));
                }
                this.checkForTermination();
            }

            private String getLine(StringBuffer sb) {
                int i = sb.indexOf("\n");
                if (i >= 0) {
                    int j = i;
                    char c = sb.charAt(j);
                    while (j >= 0 && (c == '\r' || c == '\n')) {
                        if (--j < 0) continue;
                        c = sb.charAt(j);
                    }
                    String result = sb.substring(0, j + 1);
                    sb.delete(0, i + 1);
                    return result;
                }
                return null;
            }

            private void checkForTermination() {
                if (Thread.currentThread().isInterrupted()) {
                    new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            SimpleProcess simpleProcess = javacProcess;
                            synchronized (simpleProcess) {
                                if (javacProcess != null) {
                                    javacProcess.getRunProcess().terminate();
                                }
                            }
                        }
                    }.start();
                }
            }

            public Component getGUI() {
                return null;
            }

            protected void requestShow() {
            }

            public void show() {
            }

            public boolean isVisible() {
                return true;
            }
        }
        JavacLogInfo javacLogInfo = new JavacLogInfo(outPath, javacProcess, reallyVerboseOutput);
        javacProcess.setLogPage((LogPage)javacLogInfo);
        int resCode = javacProcess.execAndWait();
        SimpleProcess jProcess = javacProcess;
        SimpleProcess simpleProcess = javacProcess;
        synchronized (simpleProcess) {
            jProcess = null;
        }
        if (resCode < 0) {
            log.error(null, 0, 0, 0, CompArb.getString(76));
        }
        rm.redefineClassMap(jprj, log);
        this.addSMAPs(sources, outPath);
        sourceMapFiles.clear();
        sourcesBeingCompiled.clear();
        return resCode == 0 ? resCode : (log.nerrors() > 0 ? log.nerrors() : 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runOjcOutOfProcess(Project jprj, CompilerOptionManager optionManager, boolean rebuild, ArrayList sources, ArrayList results, final Translator.Log log) {
        Boolean val;
        String target;
        String[] compilerOptionArray;
        final RedefineMap rm = new RedefineMap();
        final HashMap<String, Storage> sourceMapFiles = new HashMap<String, Storage>();
        BuildSystemConfiguration buildSysConfig = BuildSystemConfiguration.getInstance((PropertyStorage)jprj);
        ArrayList<String> cmd = new ArrayList<String>(15 + sources.size());
        try {
            String javaString = JProjectLibraries.getInstance((PropertyStorage)jprj).getJDK().getJavaExecutable().getPath();
            javaString = new File(javaString).getPath();
            cmd.add(Ojc.stringize(javaString.replace('/', File.separatorChar)));
            StringTokenizer vmArgs = new StringTokenizer(buildSysConfig.getOutOfProcessJavaOptions());
            while (vmArgs.hasMoreTokens()) {
                cmd.add(vmArgs.nextToken());
            }
            cmd.add("-classpath");
            cmd.add(Ide.getLibDirectory() + "ojc.jar");
            cmd.add("oracle.ojc.compiler.OutOfProcessMain");
        }
        catch (Throwable t) {
            System.out.println("Error: unable to run ojc compiler out of process");
            return 1;
        }
        boolean rebuildOption = false;
        for (String compilerOption : compilerOptionArray = optionManager.getCompilerOptionsAsArray("Ojc")) {
            if (compilerOption.equals("-rebuild")) {
                rebuildOption = true;
            }
            cmd.add(compilerOption);
        }
        String source = buildSysConfig.getSource();
        if (!source.equals("Default")) {
            cmd.add("-source");
            cmd.add(source);
        }
        if (!(target = buildSysConfig.getTarget()).equals("Default")) {
            cmd.add("-target");
            cmd.add(target);
        }
        cmd.add("-encoding");
        cmd.add(buildSysConfig.getCurrentEncoding());
        cmd.add("-classpath");
        cmd.add(Ojc.stringize(Helpers.urlPathAndDependantPathToString(PathsConfiguration.getInstance((Project)jprj).getClassPath(), sources, File.pathSeparator)));
        cmd.add("-sourcepath");
        cmd.add(Ojc.stringize(Helpers.urlPathToString(PathsConfiguration.getInstance((Project)jprj).getProjectSourcePath(), File.pathSeparator)));
        String outPath = Ojc.processOutputDirectory(jprj, cmd).getPath();
        File mdfFile = UnifiedBuildSystem.getCdiFile(jprj, false);
        cmd.add("-make");
        cmd.add(mdfFile.getPath());
        if (rebuild && !rebuildOption) {
            cmd.add("-rebuild");
        }
        if ((rebuild || rebuildOption) && (val = (Boolean)jprj.getTransientProperties().get("rebuild")) != null && val.booleanValue() && mdfFile.exists()) {
            mdfFile.delete();
        }
        if (UnifiedBuildSystem.showCompileProgress) {
            cmd.add("-noquiet");
        }
        try {
            if (tmpOjcFile == null) {
                tmpOjcFile = File.createTempFile("ojc", null, null);
                tmpOjcFile.deleteOnExit();
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(tmpOjcFile), 16384);
            for (int i = 0; i < sources.size(); ++i) {
                Storage stor = (Storage)sources.get(i);
                String storPath = stor.getPath().replace('\\', '/');
                bw.write(Ojc.stringize(storPath));
                bw.write("\n");
                if (stor.getProperty("sourceMap") == null) continue;
                sourceMapFiles.put(storPath, stor);
            }
            bw.close();
            cmd.add(Ojc.stringize("@" + tmpOjcFile.getPath()));
        }
        catch (Throwable t) {
            System.out.println("error: unable to run ojc as an external process: " + t);
            return 1;
        }
        SimpleProcess ojcProcess = new SimpleProcess(cmd.toArray(new String[cmd.size()]));
        ojcProcess.setAddToProcessesFolder(false);
        ojcProcess.setAddToTerminateMenu(false);
        class OjcLogInfo
        extends AbstractLogPage {
            final SimpleProcess ojcProcess;
            final String outPath;
            final StringBuffer sb;
            int logLine;
            boolean ojcStarted;
            boolean errorsAtStartup;

            OjcLogInfo(String outp, SimpleProcess prc) {
                super(new ViewId("BuildSystemOjcBufferPage", "BuildSystemOjcBufferPage"), null, false);
                this.sb = new StringBuffer(1024);
                this.logLine = 0;
                this.outPath = outp;
                this.ojcProcess = prc;
                this.ojcStarted = false;
                this.errorsAtStartup = false;
            }

            public void log(Object msg) {
                String line;
                this.sb.append(msg.toString());
                while ((line = this.getLine(this.sb)) != null) {
                    this.checkForTermination();
                    if (++this.logLine == 1) {
                        if (!Ide.getEnvironOptions().getSaveBeforeCompile()) {
                            log.warning(null, 0, 0, 0, CompArb.getString(90));
                        }
                        if (!UnifiedBuildSystem.showCompileProgress) continue;
                        JCompiler.getInstance().getOutputLog().log((Object)(CompArb.getString(94) + "\n"));
                        if (System.getProperty("COMPILER.COMPILE.PRETTIFY_CMDLINE") != null) {
                            line = Ojc.this.prettifyCommandLine(line);
                        }
                        JCompiler.getInstance().getOutputLog().log((Object)(line + "\n"));
                        continue;
                    }
                    this.logLine(line);
                }
                this.checkForTermination();
            }

            private void logLine(String line) {
                Storage source = null;
                if (line.startsWith("OutOfProcessAuthorizeParse:")) {
                    int len = "OutOfProcessAuthorizeParse:".length();
                    source = Ojc.getSourceFile(sourceMapFiles, line.substring(len));
                    log.clear(source);
                    UnifiedBuildSystem.getInstance().markTranslated(Ojc.this, source);
                    return;
                }
                if (line.startsWith("OutOfProcessAuthorizeWrite:")) {
                    int len = "OutOfProcessAuthorizeWrite:".length();
                    rm.redefineClass(line.substring(len), this.outPath, log);
                    return;
                }
                if (line.equals("OutOfProcessOjcStarted")) {
                    this.ojcStarted = true;
                    return;
                }
                if (line.startsWith("OutOfProcessWord:")) {
                    int len = "OutOfProcessWord:".length();
                    if (UnifiedBuildSystem.showCompileProgress) {
                        JCompiler.getInstance().getOutputLog().log((Object)line.substring(len));
                    }
                    return;
                }
                if (line.startsWith("OutOfProcessLine:")) {
                    int len = "OutOfProcessLine:".length();
                    if (UnifiedBuildSystem.showCompileProgress) {
                        line = line.substring(len);
                        String translatedCompilingString = "[" + CompArb.getString(93) + " ";
                        String originalCompilingString = "[compiling ";
                        if ((line.startsWith(translatedCompilingString) || line.startsWith(originalCompilingString)) && line.endsWith("]")) {
                            line = "  " + line.substring(1, line.length() - 1);
                        }
                        JCompiler.getInstance().getOutputLog().log((Object)(line + "\n"));
                    }
                    return;
                }
                if (line.startsWith("[")) {
                    JCompiler.getInstance().getOutputLog().log((Object)(line + "\n"));
                    return;
                }
                String prefixToken = null;
                int lineNumber = 0;
                int column = 0;
                int diagnosticNumber = 0;
                int state = 0;
                StringTokenizer tokenizer = new StringTokenizer(line, ",", true);
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    switch (state) {
                        case 0: {
                            if (token.equals("OutOfProcessError") || token.equals("OutOfProcessWarning")) {
                                prefixToken = token;
                                ++state;
                                break;
                            }
                            if (!this.ojcStarted && !this.errorsAtStartup) {
                                log.error(null, 0, 0, 0, line);
                                this.errorsAtStartup = true;
                            }
                            JCompiler.getInstance().getOutputLog().log((Object)(line + "\n"));
                            return;
                        }
                        case 1: 
                        case 3: 
                        case 5: 
                        case 7: 
                        case 9: {
                            if (token.equals(",")) {
                                ++state;
                                break;
                            }
                            JCompiler.getInstance().getOutputLog().log((Object)(line + "\n"));
                            return;
                        }
                        case 2: {
                            if (token.trim().length() > 0) {
                                source = Ojc.getSourceFile(sourceMapFiles, token);
                            }
                            ++state;
                            break;
                        }
                        case 4: {
                            lineNumber = this.getInt(token, line);
                            if (lineNumber < 0) {
                                return;
                            }
                            ++state;
                            break;
                        }
                        case 6: {
                            column = this.getInt(token, line);
                            if (column < 0) {
                                return;
                            }
                            ++column;
                            ++state;
                            break;
                        }
                        case 8: {
                            diagnosticNumber = this.getInt(token, line);
                            if (diagnosticNumber < 0) {
                                return;
                            }
                            ++state;
                            break;
                        }
                        case 10: {
                            StringBuilder buf = new StringBuilder(token);
                            while (tokenizer.hasMoreTokens()) {
                                buf.append(tokenizer.nextToken());
                            }
                            Ojc.this.logMessage(log, source, Scanner.lineColumnToPosition((int)lineNumber, (int)column), diagnosticNumber, buf.toString(), prefixToken.equals("OutOfProcessError"));
                            return;
                        }
                    }
                }
                JCompiler.getInstance().getOutputLog().log((Object)(line + "\n"));
            }

            private int getInt(String token, String line) {
                try {
                    if (token.trim().length() > 0) {
                        return Integer.parseInt(token);
                    }
                    return 0;
                }
                catch (NumberFormatException e) {
                    JCompiler.getInstance().getOutputLog().log((Object)(line + "\n"));
                    return -1;
                }
            }

            private String getLine(StringBuffer sb) {
                int i = sb.indexOf("\n");
                if (i >= 0) {
                    int j = i;
                    char c = sb.charAt(j);
                    while (j >= 0 && (c == '\r' || c == '\n')) {
                        if (--j < 0) continue;
                        c = sb.charAt(j);
                    }
                    String result = sb.substring(0, j + 1);
                    sb.delete(0, i + 1);
                    return result;
                }
                return null;
            }

            private void checkForTermination() {
                if (Thread.currentThread().isInterrupted()) {
                    new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            SimpleProcess simpleProcess = ojcProcess;
                            synchronized (simpleProcess) {
                                if (ojcProcess != null) {
                                    ojcProcess.getRunProcess().terminate();
                                }
                            }
                        }
                    }.start();
                }
            }

            public Component getGUI() {
                return null;
            }

            protected void requestShow() {
            }

            public void show() {
            }

            public boolean isVisible() {
                return true;
            }
        }
        ojcProcess.setLogPage((LogPage)new OjcLogInfo(outPath, ojcProcess));
        int resCode = ojcProcess.execAndWait();
        SimpleProcess jProcess = ojcProcess;
        SimpleProcess simpleProcess = ojcProcess;
        synchronized (simpleProcess) {
            jProcess = null;
        }
        if (resCode < 0) {
            log.error(null, 0, 0, 0, CompArb.getString(76));
        }
        rm.redefineClassMap(jprj, log);
        this.addSMAPs(sources, outPath);
        return resCode == 0 ? resCode : (log.nerrors() > 0 ? log.nerrors() : 1);
    }

    private ArrayList checkDependencies(JavaDependencyProvider dp, File depFile, Project jprj, ArrayList sources, boolean rebuild) {
        File file;
        if (depFile.exists()) {
            try {
                dp.load(depFile, false);
            }
            catch (IOException e) {
                dp.reinit();
            }
        }
        ArrayList fileList = new ArrayList();
        HashMap<File, Storage> sourceMap = new HashMap<File, Storage>(sources.size());
        for (int i = 0; i < sources.size(); ++i) {
            Storage s = (Storage)sources.get(i);
            String p = s.getPath();
            file = new File(p);
            sourceMap.put(file, s);
            fileList.add(file);
        }
        try {
            fileList = dp.updateData(fileList, rebuild, true);
        }
        catch (IOException e) {
            new Exception("dependency provider error").printStackTrace();
        }
        sources.clear();
        ArrayList c = rebuild ? fileList : dp.getDependants(fileList, true);
        for (Object ofile : c) {
            file = (File)ofile;
            Storage stor = (Storage)sourceMap.get(file);
            if (stor != null) {
                sources.add(stor);
                continue;
            }
            sources.add(new FileStorage(file));
        }
        return sources;
    }

    private void getJavaSourceFiles(Project prj, ArrayList result) {
        URL[] urls;
        QueryCriteria criteria = new QueryCriteria();
        criteria.put((Object)"file.extension", (Object)".java");
        for (URL url : urls = Helpers.getUrlsThroughIndexer(prj, criteria)) {
            result.add(url);
        }
    }

    @Override
    public int translate(Project prj, boolean rebuild, ArrayList sources, ArrayList results) {
        int batchSize;
        Boolean val;
        int result;
        UnifiedBuildSystem.getInstance().beginMarking(this);
        final Translator.Log log = this._log;
        Project jprj = prj;
        CompilerOptionManager optionManager = CompilerOptionManager.getInstance((PropertyStorage)jprj);
        final RedefineMap rm = new RedefineMap();
        BuildSystemConfiguration buildSystemConfiguration = BuildSystemConfiguration.getInstance((PropertyStorage)jprj);
        final Options options = new Options(null);
        options.noquiet = UnifiedBuildSystem.showCompileProgress;
        if (optionManager.getCurrentCompiler().equalsIgnoreCase("javac")) {
            File depFile = UnifiedBuildSystem.getCdiFile(prj, true);
            String encoding = buildSystemConfiguration.getCurrentEncoding();
            JavaDependencyProvider dp = new JavaDependencyProvider(encoding);
            String source = buildSystemConfiguration.getSource();
            if (!source.equals("Default")) {
                dp.setSourceJdk(source);
            }
            if ((sources = this.checkDependencies(dp, depFile, jprj, sources, rebuild)).size() <= 0) {
                JCompiler.getInstance().getOutputLog().log((Object)(CompArb.getString(45) + "\n"));
                return 0;
            }
            int errCnt = log.nerrors();
            int compileResult = buildSystemConfiguration.getOutOfProcess() ? this.runJavacOutOfProcess(jprj, optionManager, rebuild, sources, results, log) : this.runJavacInProcess(jprj, optionManager, sources, log);
            if (compileResult == 0) {
                if (errCnt == log.nerrors()) {
                    try {
                        File dir = depFile.getParentFile();
                        if (!dir.exists()) {
                            dir.mkdirs();
                        }
                        dp.save(depFile);
                    }
                    catch (IOException e) {
                        new Exception("Dependency provider error, " + depFile.getPath() + " may be readonly").printStackTrace();
                    }
                }
                return 0;
            }
            return 1;
        }
        if (buildSystemConfiguration.getOutOfProcess()) {
            return this.runOjcOutOfProcess(jprj, optionManager, rebuild, sources, results, log);
        }
        options.ideEnv = new IdeEnv(){

            public boolean authorizeParsing(Storage source, String reason) {
                log.clear(source);
                if (Thread.currentThread().isInterrupted()) {
                    return false;
                }
                UnifiedBuildSystem.getInstance().markTranslated(Ojc.this, source);
                return true;
            }

            public boolean authorizeChecking(Storage source, String reason) {
                return !Thread.currentThread().isInterrupted();
            }

            public boolean authorizeWriting(Storage source, String qualifiedClassName, byte[] buffer, int offset, int len) {
                if (Thread.currentThread().isInterrupted()) {
                    return false;
                }
                rm.redefineClass(source, qualifiedClassName, buffer, len, Ojc.this._log);
                return true;
            }
        };
        Log2 ojcLog = new Log2(){

            public void redirect(String filename) {
                assert (false);
            }

            public void print(String word) {
                if (options.noquiet) {
                    oracle.ide.compiler.Compiler.getCompiler().logOutMsg(word);
                }
            }

            public void println(String line) {
                if (options.noquiet) {
                    String translatedCompilingString = "[" + CompArb.getString(93) + " ";
                    String originalCompilingString = "[compiling ";
                    if (UnifiedBuildSystem.showCompileProgress && (line.startsWith(translatedCompilingString) || line.startsWith(originalCompilingString)) && line.endsWith("]")) {
                        line = "  " + line.substring(1, line.length() - 1);
                    }
                    oracle.ide.compiler.Compiler.getCompiler().logOutMsg(line + "\n");
                }
            }

            public void printError(Storage source, int pos, ErrorInfo info) {
                Ojc.this.logMessage(log, source, pos + 1, info.getNumber(), info.getMessage(), true);
            }

            public void printError(String errorMessage) {
                log.error(null, 0, 0, 0, errorMessage);
            }

            public void printWarning(Storage source, int pos, ErrorInfo info) {
                Ojc.this.logMessage(log, source, pos + 1, info.getNumber(), info.getMessage(), false);
            }

            public void printWarning(String warningMessage) {
                log.warning(null, 0, 0, 0, warningMessage);
            }

            public int nerrors() {
                return log.nerrors();
            }

            public int nwarnings() {
                return log.nwarnings();
            }
        };
        options.setLog((Log)ojcLog);
        Message.initializeMessages((Log)options.getLog());
        if (Thread.currentThread().isInterrupted()) {
            return 0;
        }
        Warning.disableAllWarnings();
        String[] optionArgs = optionManager.getCompilerOptionsAsArray("Ojc");
        for (int optionArgCount = 0; optionArgCount < optionArgs.length; optionArgCount += result) {
            result = options.parseOption(optionArgs, optionArgCount);
            if (result != 0) continue;
            return 1;
        }
        String target = buildSystemConfiguration.getTarget();
        options.targetJDKVersion = target.equals("1.1") ? 110 : (target.equals("1.2") ? 120 : (target.equals("1.3") ? 130 : (target.equals("1.4") ? 140 : (target.equals("1.5") ? 150 : (target.equals("1.6") ? 160 : (target.equals("1.7") ? 170 : this.getDefaultJDKVersion(buildSystemConfiguration)))))));
        String source = buildSystemConfiguration.getSource();
        options.sourceJDKVersion = source.equals("1.1") ? 110 : (source.equals("1.2") ? 120 : (source.equals("1.3") ? 130 : (source.equals("1.4") ? 140 : (source.equals("1.5") ? 150 : (source.equals("1.6") ? 160 : (source.equals("1.7") ? 170 : this.getDefaultJDKVersion(buildSystemConfiguration)))))));
        if (currentContext != null && currentContext.getProperty("CompilerGenerateClassesDespiteErrors") == Boolean.TRUE) {
            options.generateClassesDespiteErrors = true;
        }
        options.encoding = buildSystemConfiguration.getCurrentEncoding();
        options.classpathStorage = Helpers.urlPathAndDependantPathToStorageArray(PathsConfiguration.getInstance((Project)jprj).getClassPath(), sources);
        URLPath urlSrcPath = PathsConfiguration.getInstance((Project)jprj).getProjectSourcePath();
        Storage[] srcPath = Helpers.urlPathToStorageArray(urlSrcPath);
        IdeStorageMap storageMap = IdeStorageMap.create(urlSrcPath);
        for (int i = 0; i < srcPath.length; ++i) {
            if (!(srcPath[i] instanceof FileStorage)) continue;
            srcPath[i] = new IdeStorageWrapper(srcPath[i], storageMap);
        }
        options.sourcepathStorage = srcPath;
        options.bootClasspathStr = "";
        File outputDirectory = Ojc.processOutputDirectory(jprj, null);
        options.destinationDir = outputDirectory.getPath();
        File mdf = UnifiedBuildSystem.getCdiFile(prj, false);
        options.rebuild |= rebuild;
        if (options.rebuild && (val = (Boolean)prj.getTransientProperties().get("rebuild")) != null && val.booleanValue() && mdf.exists()) {
            mdf.delete();
        }
        options.makeFile = new FileStorage(mdf);
        int fileCount = sources.size();
        try {
            String fileCountStr = Integer.toString(fileCount);
            String splitProperty = Ide.getProperty((String)"OJC.BuildFragmentSize", (String)fileCountStr);
            batchSize = Integer.parseInt(splitProperty);
            if (batchSize <= 0 || batchSize > fileCount) {
                batchSize = fileCount;
            }
        }
        catch (Throwable t) {
            batchSize = fileCount;
        }
        int fileIndex = 0;
        int retry = 0;
        if (batchSize != fileCount) {
            // empty if block
        }
        while (fileCount > 0) {
            int res;
            int fileToBuild;
            block29: {
                fileToBuild = fileCount < batchSize ? fileCount : batchSize;
                ArrayList<Storage> toBuild = new ArrayList<Storage>(fileToBuild);
                for (int i = 0; i < fileToBuild; ++i) {
                    toBuild.add((Storage)sources.get(fileIndex + i));
                }
                fileIndex += fileToBuild;
                fileCount -= fileToBuild;
                if (options.noquiet) {
                    String cmdLine = this.buildOjcCmdLine(jprj, options, toBuild, rebuild);
                    if (System.getProperty("COMPILER.COMPILE.PRETTIFY_CMDLINE") != null) {
                        cmdLine = this.prettifyCommandLine(cmdLine);
                    }
                    oracle.ide.compiler.Compiler.getCompiler().logOutMsg(cmdLine + "\n");
                }
                try {
                    try {
                        res = Compiler.main_throws_exceptions(toBuild, (Options)options);
                    }
                    catch (NoSuchMethodError e) {
                        res = Compiler.main(toBuild, (Options)options);
                    }
                }
                catch (Exception e) {
                    res = 2;
                    Throwable t = e.getCause();
                    if (t == null) break block29;
                    FeedbackManager.reportException((String)e.getMessage(), (Throwable)t);
                }
            }
            if (res == 4) {
                if (retry > 3 || batchSize < 2) {
                    log.error(null, 0, 0, 0, CompArb.getString(82));
                    continue;
                }
                fileIndex -= fileToBuild;
                fileCount += fileToBuild;
                prj.setProperty("OJC.BuildFragmentSize", Integer.toString(batchSize /= 2));
                ++retry;
                continue;
            }
            if (res < 2) continue;
            log.error(null, 0, 0, 0, res == 3 ? CompArb.getString(76) : CompArb.getString(46));
        }
        if (storageMap != null) {
            storageMap.destroy();
        }
        rm.redefineClassMap(prj, log);
        this.addSMAPs(sources, outputDirectory.getPath());
        return log.nerrors();
    }

    public void initialize() {
        JCompiler.getInstance().registerTranslator(this);
    }

    private int getDefaultJDKVersion(BuildSystemConfiguration buildConfig) {
        if (buildConfig.isJDK17OrHigher()) {
            return 170;
        }
        if (buildConfig.isJDK16()) {
            return 160;
        }
        if (buildConfig.isJDK15()) {
            return 150;
        }
        if (buildConfig.isJDK14OrHigher()) {
            return 140;
        }
        if (buildConfig.isJDK13OrHigher()) {
            return 130;
        }
        if (buildConfig.isJDK12OrHigher()) {
            return 120;
        }
        return 110;
    }

    private String prettifyCommandLine(String cmdLine) {
        String[] tokens = this.tokenizeCommandLine(cmdLine);
        boolean inPath = false;
        boolean inOption = false;
        StringBuilder buf = new StringBuilder();
        for (String token : tokens) {
            if (token.startsWith("-")) {
                buf.append('\n');
                buf.append(token);
                buf.append(' ');
                if (token.equals("-sourcepath") || token.equals("-classpath") || token.equals("-cp") || token.startsWith("-bootclasspath") || token.startsWith("-sysclasspath") || token.startsWith("-Xboot") || token.equals("-d")) {
                    inPath = true;
                    continue;
                }
                inOption = true;
                continue;
            }
            if (inPath) {
                buf.append('\n');
                StringBuilder tokenBuf = new StringBuilder(token);
                int index = tokenBuf.indexOf(File.pathSeparator);
                while (index >= 0) {
                    tokenBuf.insert(index + 1, '\n');
                    index = tokenBuf.indexOf(File.pathSeparator, index + 1);
                }
                buf.append((CharSequence)tokenBuf);
                continue;
            }
            if (inOption) {
                buf.append(token);
                buf.append(' ');
                inOption = false;
                continue;
            }
            buf.append('\n');
            buf.append(token);
        }
        buf.append('\n');
        return buf.toString();
    }

    private String[] tokenizeCommandLine(String cmdLine) {
        StringBuilder buf = new StringBuilder();
        ArrayList<String> tokens = new ArrayList<String>();
        int len = cmdLine.length();
        boolean inString = false;
        for (int pointer = 0; pointer < len; ++pointer) {
            char c = cmdLine.charAt(pointer);
            if (c == '\"') {
                if (!inString) {
                    if (buf.length() > 0) {
                        tokens.add(buf.toString());
                        buf.setLength(0);
                    }
                    buf.append(c);
                    inString = true;
                    continue;
                }
                buf.append(c);
                tokens.add(buf.toString());
                buf.setLength(0);
                inString = false;
                continue;
            }
            if (inString) {
                if (c == '\\' && pointer < len - 1) {
                    buf.append(c);
                    c = cmdLine.charAt(++pointer);
                }
                buf.append(c);
                continue;
            }
            if (!Character.isWhitespace(c)) {
                buf.append(c);
                continue;
            }
            if (buf.length() <= 0) continue;
            tokens.add(buf.toString());
            buf.setLength(0);
        }
        if (buf.length() > 0) {
            tokens.add(buf.toString());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private static Storage getSourceFile(HashMap<String, Storage> map, String sourceFile) {
        Storage source = map.get(sourceFile.replace('\\', '/'));
        if (source == null) {
            source = new FileStorage(new File(sourceFile));
        }
        return source;
    }
}

