/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.HashMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.compiler.CompileArguments;
import oracle.ide.compiler.Compiler;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorManager;
import oracle.ide.log.LogManager;
import oracle.ide.log.MessagePage;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.javatools.util.Log;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.cm.dt.CmJavaUtil;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.CompilerContext;
import oracle.jdeveloper.compiler.JCompiler;
import oracle.jdeveloper.compiler.UnifiedBuildSystem;
import oracle.jdevimpl.ant.AntNodeHook;

final class JCompilerMenuItems
implements Addin,
Controller,
ContextMenuListener {
    private static final Log LOG = new Log("JCompilerMenuItems");
    private JCompiler jcompiler;
    private JMenuItem compileSelected;
    private JMenuItem rebuildSelected;
    private JMenuItem makeWorkingSet;
    private JMenuItem buildWorkingSet;
    private JMenuItem makeProjectAndDependencies;
    private JMenuItem makeProject;
    private JMenuItem buildProjectAndDependencies;
    private JMenuItem buildProject;
    private JMenuItem cancelBuild;
    private JMenuItem cleanProject;
    private JMenuItem cleanWorkspace;
    private JMenuItem makeWorkspace;
    private JMenuItem cleanAll;
    private static final String CompileS = CompArb.getString(5);
    private static final String RebuildS = CompArb.getString(9);
    private static final String SelectedS = CompArb.getString(2);
    private static final String CleanS = CompArb.getString(33);
    private static final String CompileDB = CompArb.getString(83);
    private static JCompilerMenuItems instance;
    private HashMap popupCachedMenuItems;

    JCompilerMenuItems() {
        instance = this;
    }

    static JCompilerMenuItems getInstance() {
        return instance;
    }

    public void initialize() {
        this.jcompiler = JCompiler.getInstance();
        if (this.jcompiler != null && this.jcompiler == Compiler.getCompiler()) {
            this.createBuildMenu();
            this.initializeMenuItems();
            NavigatorManager.getWorkspaceNavigatorManager().addContextMenuListener((ContextMenuListener)this, null);
            ContextMenu menu = EditorManager.getEditorManager().getContextMenu();
            if (menu != null) {
                menu.addContextMenuListener((ContextMenuListener)this);
            }
            if ((menu = LogManager.getLogManager().getContextMenu()) != null) {
                menu.addContextMenuListener((ContextMenuListener)this);
            }
        }
    }

    public boolean handleEvent(IdeAction action, Context context) {
        if (context == null) {
            return false;
        }
        int cmdId = action.getCommandId();
        if (this.jcompiler.isBusy(null) && cmdId == JCompiler.CANCEL_BUILD_CMD_ID) {
            this.jcompiler.stopBuild(context);
            return true;
        }
        CompilerContext.setCompileAction(context, action);
        if (cmdId == JCompiler.MAKE_SELECTED_CMD_ID || cmdId == JCompiler.MAKE_FOLDER_CMD_ID || cmdId == JCompiler.MAKE_PROJECT_CMD_ID || cmdId == JCompiler.MAKE_PROJECT_AND_DEPENDENCIES_CMD_ID || cmdId == JCompiler.MAKE_WORKINGSET_CMD_ID || cmdId == JCompiler.MAKE_WORKSPACE_CMD_ID) {
            CompileArguments compileArguments = new CompileArguments(context);
            compileArguments.setRebuildAllSources(false);
            compileArguments.setWaitForTermination(false);
            compileArguments.setSaveBeforeCompiling(true);
            if (cmdId == JCompiler.MAKE_PROJECT_CMD_ID) {
                compileArguments.setCompileDepdendentProjects(false);
            }
            this.jcompiler.compile(compileArguments);
            return true;
        }
        if (cmdId == JCompiler.BUILD_SELECTED_CMD_ID || cmdId == JCompiler.BUILD_WORKINGSET_CMD_ID || cmdId == JCompiler.BUILD_PROJECT_CMD_ID || cmdId == JCompiler.BUILD_PROJECT_AND_DEPENDENCIES_CMD_ID || cmdId == JCompiler.BUILD_WORKSPACE_CMD_ID) {
            CompileArguments compileArguments = new CompileArguments(context);
            compileArguments.setRebuildAllSources(true);
            compileArguments.setWaitForTermination(false);
            compileArguments.setSaveBeforeCompiling(true);
            if (cmdId == JCompiler.BUILD_PROJECT_CMD_ID) {
                compileArguments.setCompileDepdendentProjects(false);
            }
            this.jcompiler.compile(compileArguments);
            return true;
        }
        if (cmdId == JCompiler.CANCEL_BUILD_CMD_ID) {
            return true;
        }
        if (cmdId == JCompiler.CLEANALL_CMD_ID || cmdId == JCompiler.CLEAN_PROJECT_CMD_ID || cmdId == JCompiler.CLEAN_WORKSPACE_CMD_ID) {
            this.jcompiler.cleanAll(context);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        if (context == null || action == null) {
            return false;
        }
        int cmdId = action.getCommandId();
        if (cmdId == JCompiler.MAKE_PROJECT_CMD_ID) {
            return this.setWPActionAndMenuItem(context, (Element)Ide.getActiveProject(), this.makeProject, action, false, false);
        }
        if (cmdId == JCompiler.MAKE_PROJECT_AND_DEPENDENCIES_CMD_ID) {
            return this.setWPActionAndMenuItem(context, (Element)Ide.getActiveProject(), this.makeProjectAndDependencies, action, false, false);
        }
        if (cmdId == JCompiler.MAKE_SELECTED_CMD_ID) {
            return this.setMenuItem(context, this.compileSelected, action, false, false);
        }
        if (cmdId == JCompiler.MAKE_FOLDER_CMD_ID) {
            return this.setMenuItem(context, null, action, false, false);
        }
        if (cmdId == JCompiler.BUILD_PROJECT_CMD_ID) {
            return this.setWPActionAndMenuItem(context, (Element)Ide.getActiveProject(), this.buildProject, action, true, false);
        }
        if (cmdId == JCompiler.BUILD_PROJECT_AND_DEPENDENCIES_CMD_ID) {
            return this.setWPActionAndMenuItem(context, (Element)Ide.getActiveProject(), this.buildProjectAndDependencies, action, true, false);
        }
        if (cmdId == JCompiler.BUILD_SELECTED_CMD_ID) {
            return this.setMenuItem(context, this.rebuildSelected, action, true, false);
        }
        if (cmdId == JCompiler.MAKE_WORKINGSET_CMD_ID) {
            return this.setWSMenuItem(action, !this.jcompiler.isBusy(context), this.makeWorkingSet, this.getWorkingSet(Ide.getActiveWorkspace()));
        }
        if (cmdId == JCompiler.BUILD_WORKINGSET_CMD_ID) {
            return this.setWSMenuItem(action, !this.jcompiler.isBusy(context), this.buildWorkingSet, this.getWorkingSet(Ide.getActiveWorkspace()));
        }
        if (cmdId == JCompiler.MAKE_WORKSPACE_CMD_ID) {
            return this.setWPActionAndMenuItem(context, (Element)Ide.getActiveWorkspace(), this.makeWorkspace, action, false, false);
        }
        if (cmdId == JCompiler.BUILD_WORKSPACE_CMD_ID) {
            return this.setWPActionAndMenuItem(context, (Element)Ide.getActiveWorkspace(), null, action, true, false);
        }
        if (cmdId == JCompiler.CANCEL_BUILD_CMD_ID) {
            boolean isCancellable = UnifiedBuildSystem.getInstance().isAlive();
            return this.setMenuItem(action, isCancellable, this.cancelBuild);
        }
        if (cmdId == JCompiler.CLEAN_PROJECT_CMD_ID) {
            return this.setWPActionAndMenuItem(context, (Element)Ide.getActiveProject(), this.cleanProject, action, false, true);
        }
        if (cmdId == JCompiler.CLEAN_WORKSPACE_CMD_ID) {
            return this.setWPActionAndMenuItem(context, (Element)Ide.getActiveWorkspace(), this.cleanWorkspace, action, false, true);
        }
        if (cmdId == JCompiler.CLEANALL_CMD_ID) {
            return this.setMenuItem(context, this.cleanAll, action, false, true);
        }
        return false;
    }

    public void menuWillShow(ContextMenu popup) {
        IdeAction action;
        boolean isElementAWorkspace;
        assert (LOG.trace("Start of JCompilerMenuItems.menuWillShow"));
        Context context = popup.getContext();
        View view = context.getView();
        if (view instanceof MessagePage && this.jcompiler.isBusy(context)) {
            IdeAction action2 = IdeAction.find((int)JCompiler.CANCEL_BUILD_CMD_ID);
            action2.setEnabled(true);
            popup.add((Component)this.getMenuItem(popup, action2), JDeveloperMenuConstants.SECTION_DYNAMIC_CTXT_MENU);
        }
        boolean leaveEarly = false;
        Element[] elements = this.getElementsFromContext(context, false);
        if (elements == null || elements.length == 0) {
            leaveEarly = true;
        } else {
            for (int x = 0; x < elements.length; ++x) {
                if (elements[x] != null && (!(elements[x] instanceof Node) || !AntNodeHook.isAntNode((Node)elements[x])) && (this.isBuildable(elements[x]) || JCompiler.isCopyable(elements[x], context.getProject()))) continue;
                leaveEarly = true;
                break;
            }
        }
        if (leaveEarly) {
            assert (LOG.trace("End of JCompilerMenuItems.menuWillShow"));
            return;
        }
        if (view instanceof CodeEditor) {
            CodeEditor codeEditor = (CodeEditor)view;
            context = codeEditor.getContext();
        }
        Element element = elements.length >= 1 ? elements[0] : null;
        boolean isElementAProject = elements.length == 1 && element instanceof Project;
        boolean bl = isElementAWorkspace = elements.length == 1 && element instanceof Workspace;
        if (!isElementAWorkspace && (action = IdeAction.find((int)(isElementAProject ? JCompiler.MAKE_PROJECT_AND_DEPENDENCIES_CMD_ID : JCompiler.MAKE_SELECTED_CMD_ID))) != null) {
            this.update(action, context);
            popup.add((Component)this.getMenuItem(popup, action), JDeveloperMenuConstants.SECTION_BUILD_CTXT_MENU);
        }
        if (!isElementAWorkspace && (action = IdeAction.find((int)(isElementAProject ? JCompiler.BUILD_PROJECT_AND_DEPENDENCIES_CMD_ID : JCompiler.BUILD_SELECTED_CMD_ID))) != null && this.getCommand(element, false, false, null) != CompileDB) {
            this.update(action, context);
            popup.add((Component)this.getMenuItem(popup, action), JDeveloperMenuConstants.SECTION_BUILD_CTXT_MENU);
        }
        if (elements.length > 1) {
            boolean addCleanSelected = true;
            for (int x = 0; x < elements.length; ++x) {
                if (elements[x] instanceof Project) continue;
                addCleanSelected = false;
                break;
            }
            if (addCleanSelected && (action = IdeAction.find((int)JCompiler.CLEANALL_CMD_ID)) != null) {
                this.update(action, context);
                popup.add((Component)this.getMenuItem(popup, action), JDeveloperMenuConstants.SECTION_BUILD_CTXT_MENU);
            }
        }
        assert (LOG.trace("End of JCompilerMenuItems.menuWillShow"));
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private void createBuildMenu() {
        Menubar menubar = Ide.getMenubar();
        JMenu buildMenu = menubar.createMenu(CompArb.getString(0), JDeveloperMenuConstants.WEIGHT_BUILD_MENU, JDeveloperMenuConstants.SECTION_BUILD_TOOLS);
        MenuManager.putJMenu((String)"Build", (JMenu)buildMenu);
        menubar.add((Component)buildMenu);
    }

    private void initializeMenuItems() {
        Menubar menuMgr = Ide.getMenubar();
        AddinManager addMgr = AddinManager.getAddinManager();
        JMenu buildMenu = MenuManager.getJMenu((String)"Build");
        String cmd = addMgr.getCommand(JCompiler.MAKE_WORKSPACE_CMD_ID, "oracle.jdeveloper.compiler.MakeWorkspaceCommand");
        IdeAction action = IdeAction.get((int)JCompiler.MAKE_WORKSPACE_CMD_ID, (String)cmd, (String)CompArb.getString(24), (String)buildMenu.getText(), (Integer)CompArb.getInteger(25), (ArrayResourceBundle)CompArb.getInstance(), (int)26, null, (boolean)false);
        action.putValue("NoCtxName", (Object)CompArb.getString(24));
        action.addController((Controller)this);
        this.makeWorkspace = menuMgr.createMenuItem((ToggleAction)action, JDeveloperMenuConstants.WEIGHT_RUN_MAKE_WORKSPACE);
        menuMgr.add((Component)this.makeWorkspace, buildMenu, JDeveloperMenuConstants.SECTION_BUILD_OTHER);
        cmd = addMgr.getCommand(JCompiler.MAKE_PROJECT_CMD_ID, "oracle.jdeveloper.compiler.MakeProjectCommand");
        action = IdeAction.get((int)JCompiler.MAKE_PROJECT_CMD_ID, (String)cmd, (String)CompArb.getString(18), (String)buildMenu.getText(), (Integer)CompArb.getInteger(19), (ArrayResourceBundle)CompArb.getInstance(), (int)108, null, (boolean)false);
        action.putValue("NoCtxName", (Object)CompArb.getString(18));
        action.addController((Controller)this);
        this.makeProject = menuMgr.createMenuItem((ToggleAction)action, JDeveloperMenuConstants.WEIGHT_RUN_MAKE_PROJECT);
        menuMgr.add((Component)this.makeProject, buildMenu, JDeveloperMenuConstants.SECTION_BUILD_MAKE);
        cmd = addMgr.getCommand(JCompiler.MAKE_PROJECT_AND_DEPENDENCIES_CMD_ID, "oracle.jdeveloper.compiler.MakeProjectAndDependenciesCommand");
        action = IdeAction.get((int)JCompiler.MAKE_PROJECT_AND_DEPENDENCIES_CMD_ID, (String)cmd, (String)CompArb.getString(97), (String)buildMenu.getText(), (Integer)CompArb.getInteger(98), (ArrayResourceBundle)CompArb.getInstance(), (int)20, null, (boolean)false);
        action.putValue("NoCtxName", (Object)CompArb.getString(97));
        action.addController((Controller)this);
        this.makeProjectAndDependencies = menuMgr.createMenuItem((ToggleAction)action, JDeveloperMenuConstants.WEIGHT_RUN_MAKE_PROJECT_AND_DEPENDENCIES);
        menuMgr.add((Component)this.makeProjectAndDependencies, buildMenu, JDeveloperMenuConstants.SECTION_BUILD_MAKE);
        cmd = addMgr.getCommand(JCompiler.MAKE_WORKINGSET_CMD_ID, "oracle.jdeveloper.compiler.MakeWorkingSetCommand");
        action = IdeAction.get((int)JCompiler.MAKE_WORKINGSET_CMD_ID, (String)cmd, (String)CompArb.getString(12), (String)buildMenu.getText(), (Integer)CompArb.getInteger(13), (ArrayResourceBundle)CompArb.getInstance(), (int)14, null, (boolean)false);
        action.putValue("NoCtxName", (Object)CompArb.getString(12));
        action.addController((Controller)this);
        this.makeWorkingSet = menuMgr.createMenuItem((ToggleAction)action, JDeveloperMenuConstants.WEIGHT_RUN_MAKE_WORKSET);
        menuMgr.add((Component)this.makeWorkingSet, buildMenu, JDeveloperMenuConstants.SECTION_BUILD_MAKE);
        cmd = addMgr.getCommand(JCompiler.BUILD_WORKINGSET_CMD_ID, "oracle.jdeveloper.compiler.BuildWorkingSetCommand");
        action = IdeAction.get((int)JCompiler.BUILD_WORKINGSET_CMD_ID, (String)cmd, (String)CompArb.getString(15), (String)buildMenu.getText(), (Integer)CompArb.getInteger(16), (ArrayResourceBundle)CompArb.getInstance(), (int)17, null, (boolean)false);
        action.putValue("NoCtxName", (Object)CompArb.getString(15));
        action.addController((Controller)this);
        this.buildWorkingSet = menuMgr.createMenuItem((ToggleAction)action, JDeveloperMenuConstants.WEIGHT_RUN_REBUILD_WORKSET);
        menuMgr.add((Component)this.buildWorkingSet, buildMenu, JDeveloperMenuConstants.SECTION_BUILD_REBUILD);
        cmd = addMgr.getCommand(JCompiler.MAKE_FOLDER_CMD_ID, "oracle.jdeveloper.compiler.MakeFolderCommand");
        action = IdeAction.get((int)JCompiler.MAKE_FOLDER_CMD_ID, (String)cmd, (String)CompArb.getString(3), (String)buildMenu.getText(), (Integer)CompArb.getInteger(19), (ArrayResourceBundle)CompArb.getInstance(), (int)26, null, (boolean)false);
        action.putValue("NoCtxName", (Object)CompArb.getString(3));
        action.addController((Controller)this);
        cmd = addMgr.getCommand(JCompiler.BUILD_WORKSPACE_CMD_ID, "oracle.jdeveloper.compiler.BuildWorkspaceCommand");
        action = IdeAction.get((int)JCompiler.BUILD_WORKSPACE_CMD_ID, (String)cmd, (String)CompArb.getString(27), (String)buildMenu.getText(), (Integer)CompArb.getInteger(28), (ArrayResourceBundle)CompArb.getInstance(), (int)29, null, (boolean)false);
        action.putValue("NoCtxName", (Object)CompArb.getString(27));
        action.addController((Controller)this);
        cmd = addMgr.getCommand(JCompiler.BUILD_PROJECT_CMD_ID, "oracle.jdeveloper.compiler.BuildProjectCommand");
        action = IdeAction.get((int)JCompiler.BUILD_PROJECT_CMD_ID, (String)cmd, (String)CompArb.getString(21), (String)buildMenu.getText(), (Integer)CompArb.getInteger(22), (ArrayResourceBundle)CompArb.getInstance(), (int)108, null, (boolean)false);
        action.putValue("NoCtxName", (Object)CompArb.getString(21));
        action.addController((Controller)this);
        this.buildProject = menuMgr.createMenuItem((ToggleAction)action, JDeveloperMenuConstants.WEIGHT_RUN_REBUILD_PROJECT);
        menuMgr.add((Component)this.buildProject, buildMenu, JDeveloperMenuConstants.SECTION_BUILD_REBUILD);
        cmd = addMgr.getCommand(JCompiler.BUILD_PROJECT_AND_DEPENDENCIES_CMD_ID, "oracle.jdeveloper.compiler.BuildProjectAndDependenciesCommand");
        action = IdeAction.get((int)JCompiler.BUILD_PROJECT_AND_DEPENDENCIES_CMD_ID, (String)cmd, (String)CompArb.getString(99), (String)buildMenu.getText(), (Integer)CompArb.getInteger(100), (ArrayResourceBundle)CompArb.getInstance(), (int)23, null, (boolean)false);
        action.putValue("NoCtxName", (Object)CompArb.getString(99));
        action.addController((Controller)this);
        this.buildProjectAndDependencies = menuMgr.createMenuItem((ToggleAction)action, JDeveloperMenuConstants.WEIGHT_RUN_REBUILD_PROJECT_AND_DEPENDENCIES);
        menuMgr.add((Component)this.buildProjectAndDependencies, buildMenu, JDeveloperMenuConstants.SECTION_BUILD_REBUILD);
        cmd = addMgr.getCommand(JCompiler.MAKE_SELECTED_CMD_ID, "oracle.jdeveloper.compiler.MakeSelectedCommand");
        action = IdeAction.get((int)JCompiler.MAKE_SELECTED_CMD_ID, (String)cmd, (String)CompileS, (String)buildMenu.getText(), (Integer)CompArb.getInteger(6), (ArrayResourceBundle)CompArb.getInstance(), (int)7, null, (boolean)false);
        action.putValue("NoCtxName", (Object)CompArb.getString(4));
        action.addController((Controller)this);
        this.compileSelected = menuMgr.createMenuItem((ToggleAction)action, JDeveloperMenuConstants.WEIGHT_RUN_MAKE_FILE);
        cmd = addMgr.getCommand(JCompiler.BUILD_SELECTED_CMD_ID, "oracle.jdeveloper.compiler.BuildSelectedCommand");
        action = IdeAction.get((int)JCompiler.BUILD_SELECTED_CMD_ID, (String)cmd, (String)RebuildS, (String)buildMenu.getText(), (Integer)CompArb.getInteger(10), (ArrayResourceBundle)CompArb.getInstance(), (int)11, null, (boolean)false);
        action.putValue("NoCtxName", (Object)CompArb.getString(8));
        action.addController((Controller)this);
        this.rebuildSelected = menuMgr.createMenuItem((ToggleAction)action, JDeveloperMenuConstants.WEIGHT_RUN_REBUILD_FILE);
        cmd = addMgr.getCommand(JCompiler.CANCEL_BUILD_CMD_ID, "oracle.jdeveloper.compiler.CancelBuildCommand");
        action = IdeAction.get((int)JCompiler.CANCEL_BUILD_CMD_ID, (String)cmd, (String)CompArb.getString(30), (String)buildMenu.getText(), (Integer)CompArb.getInteger(31), (ArrayResourceBundle)CompArb.getInstance(), (int)32, null, (boolean)false);
        action.putValue("ShortDescription", (Object)CompArb.getString(30));
        action.putValue("NoCtxName", (Object)CompArb.getString(30));
        action.addController((Controller)this);
        this.cancelBuild = menuMgr.createMenuItem((ToggleAction)action, JDeveloperMenuConstants.WEIGHT_RUN_CANCEL_BUILD);
        menuMgr.add((Component)this.cancelBuild, buildMenu, JDeveloperMenuConstants.SECTION_BUILD_CONTROL);
        cmd = addMgr.getCommand(JCompiler.CLEAN_WORKSPACE_CMD_ID, "oracle.jdeveloper.compiler.CleanWorkspaceCommand");
        action = IdeAction.get((int)JCompiler.CLEAN_WORKSPACE_CMD_ID, (String)cmd, (String)CompArb.getString(104), (String)buildMenu.getText(), (Integer)CompArb.getInteger(105), (ArrayResourceBundle)CompArb.getInstance(), (int)35, null, (boolean)false);
        action.putValue("ShortDescription", (Object)CompArb.getString(104));
        action.putValue("NoCtxName", (Object)CompArb.getString(104));
        action.addController((Controller)this);
        this.cleanWorkspace = menuMgr.createMenuItem((ToggleAction)action, JDeveloperMenuConstants.WEIGHT_RUN_CLEAN_WORKSPACE);
        menuMgr.add((Component)this.cleanWorkspace, buildMenu, JDeveloperMenuConstants.SECTION_BUILD_OTHER);
        cmd = addMgr.getCommand(JCompiler.CLEAN_PROJECT_CMD_ID, "oracle.jdeveloper.compiler.CleanProjectCommand");
        action = IdeAction.get((int)JCompiler.CLEAN_PROJECT_CMD_ID, (String)cmd, (String)CompArb.getString(106), (String)buildMenu.getText(), (Integer)CompArb.getInteger(107), (ArrayResourceBundle)CompArb.getInstance(), (int)35, null, (boolean)false);
        action.putValue("ShortDescription", (Object)CompArb.getString(106));
        action.putValue("NoCtxName", (Object)CompArb.getString(106));
        action.addController((Controller)this);
        this.cleanProject = menuMgr.createMenuItem((ToggleAction)action, JDeveloperMenuConstants.WEIGHT_RUN_CLEAN_PROJECT);
        menuMgr.add((Component)this.cleanProject, buildMenu, JDeveloperMenuConstants.SECTION_BUILD_OTHER);
        cmd = addMgr.getCommand(JCompiler.CLEANALL_CMD_ID, "oracle.jdeveloper.compiler.CleanAllCommand");
        action = IdeAction.get((int)JCompiler.CLEANALL_CMD_ID, (String)cmd, (String)CleanS, (String)buildMenu.getText(), (Integer)CompArb.getInteger(34), (ArrayResourceBundle)CompArb.getInstance(), (int)35, null, (boolean)false);
        action.putValue("ShortDescription", (Object)CleanS);
        action.addController((Controller)this);
        this.cleanAll = menuMgr.createMenuItem((ToggleAction)action, JDeveloperMenuConstants.WEIGHT_RUN_CLEANALL);
    }

    private JMenuItem getMenuItem(ContextMenu popup, IdeAction action) {
        JMenuItem menuItem;
        if (this.popupCachedMenuItems == null) {
            this.popupCachedMenuItems = new HashMap();
        }
        if ((menuItem = (JMenuItem)this.popupCachedMenuItems.get(action)) == null) {
            menuItem = popup.createMenuItem((ToggleAction)action, JDeveloperMenuConstants.WEIGHT_RUN_RUN_FILE);
            this.popupCachedMenuItems.put(action, menuItem);
        }
        return menuItem;
    }

    private boolean setMenuItem(IdeAction action, boolean enabled, JMenuItem m) {
        action.setEnabled(enabled);
        m.setEnabled(enabled);
        m.setVisible(true);
        return true;
    }

    private boolean setWPActionAndMenuItem(Context context, Element node, JMenuItem menu, IdeAction action, boolean rebuild, boolean clean) {
        String name = "";
        Element[] elements = this.getElementsFromContext(context, true);
        if (elements != null && elements.length > 1 && elements[0] != null && (node == null || elements[0].getClass() == node.getClass())) {
            if (this.inPopup(context)) {
                name = this.getCommand(elements[0], rebuild, clean, SelectedS);
            }
        } else if (node != null) {
            String label = this.inPopup(context) ? this.getWPMenuLabel(action, node, true) : (node instanceof Workspace || node instanceof Workspaces ? CompArb.getString(109) : this.getWPMenuLabel(action, node, false));
            name = this.getCommand(node, rebuild, clean, label);
        }
        if (name.length() > 0) {
            boolean isBusy = this.jcompiler.isBusy(null);
            if (menu != null) {
                menu.setText(name);
                menu.setEnabled(!isBusy);
            }
            action.setEnabled(!isBusy);
            action.putValue("Name", (Object)name);
        } else {
            Object independentName = action.getValue("NoCtxName");
            name = independentName != null ? independentName.toString() : this.getCommand(null, rebuild, clean, null);
            action.putValue("Name", (Object)name);
            action.setEnabled(false);
        }
        return true;
    }

    private String getWPMenuLabel(IdeAction action, Element node, boolean inPopup) {
        String label = action.getCommandId() == JCompiler.MAKE_PROJECT_CMD_ID || action.getCommandId() == JCompiler.BUILD_PROJECT_CMD_ID ? CompArb.format(101, node.getShortLabel()) : (action.getCommandId() == JCompiler.MAKE_PROJECT_AND_DEPENDENCIES_CMD_ID || action.getCommandId() == JCompiler.BUILD_PROJECT_AND_DEPENDENCIES_CMD_ID ? CompArb.format(102, node.getShortLabel()) : (inPopup ? "" : node.getShortLabel()));
        return label;
    }

    private boolean setWSMenuItem(IdeAction action, boolean enabled, JMenuItem m, WorkingSet workingSet) {
        if (workingSet != null) {
            action.setEnabled(enabled);
            m.setEnabled(enabled);
            m.setVisible(true);
            String prefix = CompArb.getString(action.getCommandId() == JCompiler.MAKE_WORKINGSET_CMD_ID ? 12 : 15);
            m.setText(prefix);
        } else if (Ide.getActiveWorkspace() == null) {
            action.setEnabled(false);
        }
        return true;
    }

    private WorkingSet getWorkingSet(Workspace workspace) {
        if (workspace == null) {
            return null;
        }
        WorkingSets workingSets = WorkingSets.getInstance((Workspace)workspace);
        WorkingSet curWorkingSet = workingSets.getCurrentWorkingSet();
        if (curWorkingSet == null) {
            curWorkingSet = workingSets.getWorkingSet(WorkingSets.ALL_FILES_WORKING_SET_LABEL);
        }
        return curWorkingSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setMenuItem(Context context, JMenuItem menuItem, IdeAction action, boolean rebuild, boolean clean) {
        boolean allowMultipleSelections;
        Element element;
        Element[] elements;
        block15: {
            block16: {
                block14: {
                    String label;
                    boolean bl;
                    elements = this.getElementsFromContext(context, true);
                    element = null;
                    allowMultipleSelections = true;
                    try {
                        if (elements != null && elements.length != 0 && elements[0] != null) break block14;
                        action.setEnabled(false);
                        bl = true;
                        label = element == null ? null : (element instanceof Workspace || element instanceof Workspaces ? CompArb.getString(109) : element.getShortLabel());
                    }
                    catch (Throwable throwable) {
                        String label2 = element == null ? null : (element instanceof Workspace || element instanceof Workspaces ? CompArb.getString(109) : element.getShortLabel());
                        String target = elements != null && elements.length > 1 && allowMultipleSelections ? SelectedS : (this.inPopup(context) ? null : label2);
                        String command = this.getCommand(element, rebuild, clean, target);
                        if (menuItem != null) {
                            menuItem.setText(command);
                        }
                        action.putValue("Name", (Object)command);
                        throw throwable;
                    }
                    String target = elements != null && elements.length > 1 && allowMultipleSelections ? SelectedS : (this.inPopup(context) ? null : label);
                    String command = this.getCommand(element, rebuild, clean, target);
                    if (menuItem != null) {
                        menuItem.setText(command);
                    }
                    action.putValue("Name", (Object)command);
                    return bl;
                }
                element = elements[0];
                if (!clean) break block15;
                if (!(element instanceof Workspace) && !(element instanceof Workspaces)) break block16;
                action.setEnabled(true);
                boolean bl = true;
                String label = element == null ? null : (element instanceof Workspace || element instanceof Workspaces ? CompArb.getString(109) : element.getShortLabel());
                String target = elements != null && elements.length > 1 && allowMultipleSelections ? SelectedS : (this.inPopup(context) ? null : label);
                String command = this.getCommand(element, rebuild, clean, target);
                if (menuItem != null) {
                    menuItem.setText(command);
                }
                action.putValue("Name", (Object)command);
                return bl;
            }
            if (element instanceof Project) break block15;
            allowMultipleSelections = false;
            element = context.getProject();
            if (element == null) {
                element = Ide.getActiveProject();
            }
            if (element != null) break block15;
            action.setEnabled(false);
            boolean bl = true;
            String label = element == null ? null : (element instanceof Workspace || element instanceof Workspaces ? CompArb.getString(109) : element.getShortLabel());
            String target = elements != null && elements.length > 1 && allowMultipleSelections ? SelectedS : (this.inPopup(context) ? null : label);
            String command = this.getCommand(element, rebuild, clean, target);
            if (menuItem != null) {
                menuItem.setText(command);
            }
            action.putValue("Name", (Object)command);
            return bl;
        }
        if (menuItem != null) {
            menuItem.setVisible(true);
        }
        if ((element instanceof Locatable || element != null && element.mayHaveChildren()) && (!(element instanceof Node) || !AntNodeHook.isAntNode((Node)element)) && (this.isBuildable(element) || JCompiler.isCopyable(element, context.getProject())) || element instanceof Workspaces) {
            action.setEnabled(!this.jcompiler.isBusy(null));
        } else {
            action.setEnabled(false);
        }
        String label = element == null ? null : (element instanceof Workspace || element instanceof Workspaces ? CompArb.getString(109) : element.getShortLabel());
        String target = elements != null && elements.length > 1 && allowMultipleSelections ? SelectedS : (this.inPopup(context) ? null : label);
        String command = this.getCommand(element, rebuild, clean, target);
        if (menuItem != null) {
            menuItem.setText(command);
        }
        action.putValue("Name", (Object)command);
        return true;
    }

    private String getCommand(Element elem, boolean rebuild, boolean clean, String target) {
        if (elem instanceof Locatable && CmJavaUtil.isCMUrl(((Locatable)elem).getURL())) {
            if (target == null) {
                return CompileDB;
            }
            return CompArb.format(114, target);
        }
        if (rebuild) {
            if (target == null) {
                return RebuildS;
            }
            return CompArb.format(115, target);
        }
        if (clean) {
            if (target == null) {
                return CleanS;
            }
            return CompArb.format(116, target);
        }
        if (target == null) {
            return CompileS;
        }
        return CompArb.format(113, target);
    }

    private boolean inPopup(Context context) {
        if (context.getNode() instanceof Workspace) {
            return false;
        }
        EventObject o = context.getEvent();
        return o == null || o instanceof MouseEvent;
    }

    private Element[] getElementsFromContext(Context context, boolean checkNode) {
        Element[] elements = context.getSelection();
        if (!(elements != null && elements.length != 0 && (elements[0] == null || this.isBuildable(elements[0])) || checkNode && context.getNode() == null)) {
            elements = new Element[]{context.getNode()};
        }
        return elements;
    }

    void enableCancelBuild(final boolean enable) {
        if (Ide.getIdeArgs().getCreateUI()) {
            JCompiler.invokeAsap(new Runnable(){

                @Override
                public void run() {
                    JCompilerMenuItems.this.setMenuItem(IdeAction.find((int)JCompiler.CANCEL_BUILD_CMD_ID), enable, JCompilerMenuItems.this.cancelBuild);
                    JCompilerMenuItems.this.setMenuItem(IdeAction.find((int)JCompiler.MAKE_PROJECT_AND_DEPENDENCIES_CMD_ID), !enable, JCompilerMenuItems.this.makeProjectAndDependencies);
                    JCompilerMenuItems.this.setMenuItem(IdeAction.find((int)JCompiler.BUILD_PROJECT_AND_DEPENDENCIES_CMD_ID), !enable, JCompilerMenuItems.this.buildProjectAndDependencies);
                    JCompilerMenuItems.this.setMenuItem(IdeAction.find((int)JCompiler.MAKE_WORKINGSET_CMD_ID), !enable, JCompilerMenuItems.this.makeWorkingSet);
                    JCompilerMenuItems.this.setMenuItem(IdeAction.find((int)JCompiler.BUILD_WORKINGSET_CMD_ID), !enable, JCompilerMenuItems.this.buildWorkingSet);
                    JCompilerMenuItems.this.setMenuItem(IdeAction.find((int)JCompiler.CLEAN_PROJECT_CMD_ID), !enable, JCompilerMenuItems.this.cleanProject);
                    JCompilerMenuItems.this.setMenuItem(IdeAction.find((int)JCompiler.CLEAN_WORKSPACE_CMD_ID), !enable, JCompilerMenuItems.this.cleanWorkspace);
                }
            });
        }
    }

    private boolean isBuildable(Element element) {
        if (element == null) {
            return false;
        }
        Attributes attrs = element.getAttributes();
        if (attrs == null) {
            return false;
        }
        return attrs.isSet(ElementAttributes.BUILDABLE);
    }
}

