/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeArgs;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.SaveAllCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.compiler.BuildSystemListener;
import oracle.ide.compiler.BuildSystemVetoException;
import oracle.ide.compiler.CompileArguments;
import oracle.ide.compiler.Compiler;
import oracle.ide.compiler.CopyListener;
import oracle.ide.compiler.PostBuilder;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.panels.ProjectPropertiesDialog;
import oracle.ide.panels.Navigable;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.util.IdeUtil;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.compiler.BuildSystemConfiguration;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.CompilerPage;
import oracle.jdeveloper.compiler.IdeLog;
import oracle.jdeveloper.compiler.IdeStorage;
import oracle.jdeveloper.compiler.OjcConfiguration;
import oracle.jdeveloper.compiler.OjcConfigurationPanel;
import oracle.jdeveloper.compiler.OutputStreamLogPage;
import oracle.jdeveloper.compiler.ProblemsPage;
import oracle.jdeveloper.compiler.Translator;
import oracle.jdeveloper.compiler.UnifiedBuildSystem;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.compiler.CompilerOptionPanel;
import oracle.jdevimpl.config.JProjectPaths;
import oracle.jdevimpl.resource.CompilerArb;
import oracle.ojc.interfaces.Storage;

public final class JCompiler
extends Compiler
implements Addin,
ShutdownHook {
    private static final String pkgName = "oracle.jdeveloper.compiler.";
    public static final String DISABLE_FILE_NOT_IN_PROJECT_WARNING = "disableFileNotInProjectWarning";
    static final String DO_NOT_COMPILE_DEPENDENT_PROJECTS = "buildsystem.dont.compile.dependent.projects";
    public static final int MAKE_SELECTED_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.MAKE_SELECTED_CMD_ID");
    public static final String MAKE_SELECTED_CMD = "oracle.jdeveloper.compiler.MakeSelectedCommand";
    public static final int BUILD_SELECTED_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.BUILD_SELECTED_CMD_ID");
    public static final String BUILD_SELECTED_CMD = "oracle.jdeveloper.compiler.BuildSelectedCommand";
    public static final int MAKE_WORKINGSET_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.MAKE_WORKINGSET_CMD_ID");
    public static final String MAKE_WORKINGSET_CMD = "oracle.jdeveloper.compiler.MakeWorkingSetCommand";
    public static final int BUILD_WORKINGSET_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.BUILD_WORKINGSET_CMD_ID");
    public static final String BUILD_WORKINGSET_CMD = "oracle.jdeveloper.compiler.BuildWorkingSetCommand";
    public static final int MAKE_PROJECT_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.MAKE_PROJECT_CMD_ID");
    public static final String MAKE_PROJECT_CMD = "oracle.jdeveloper.compiler.MakeProjectCommand";
    public static final int MAKE_PROJECT_AND_DEPENDENCIES_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.MAKE_PROJECT_AND_DEPENDENCIES_CMD_ID");
    public static final String MAKE_PROJECT_AND_DEPENDENCIES_CMD = "oracle.jdeveloper.compiler.MakeProjectAndDependenciesCommand";
    public static final int BUILD_PROJECT_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.BUILD_PROJECT_CMD_ID");
    public static final String BUILD_PROJECT_CMD = "oracle.jdeveloper.compiler.BuildProjectCommand";
    public static final int BUILD_PROJECT_AND_DEPENDENCIES_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.BUILD_PROJECT_AND_DEPENDENCIES_CMD_ID");
    public static final String BUILD_PROJECT_AND_DEPENDENCIES_CMD = "oracle.jdeveloper.compiler.BuildProjectAndDependenciesCommand";
    public static final int MAKE_WORKSPACE_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.MAKE_WORKSPACE_CMD_ID");
    public static final String MAKE_WORKSPACE_CMD = "oracle.jdeveloper.compiler.MakeWorkspaceCommand";
    public static final int BUILD_WORKSPACE_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.BUILD_WORKSPACE_CMD_ID");
    public static final String BUILD_WORKSPACE_CMD = "oracle.jdeveloper.compiler.BuildWorkspaceCommand";
    public static final int MAKE_FOLDER_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.MAKE_FOLDER_CMD_ID");
    public static final String MAKE_FOLDER_CMD = "oracle.jdeveloper.compiler.MakeFolderCommand";
    public static final int CANCEL_BUILD_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.CANCEL_BUILD_CMD_ID");
    public static final String CANCEL_BUILD_CMD = "oracle.jdeveloper.compiler.CancelBuildCommand";
    public static final int CLEANALL_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.CLEANALL_CMD_ID");
    public static final String CLEANALL_CMD = "oracle.jdeveloper.compiler.CleanAllCommand";
    public static final int CLEAN_PROJECT_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.CLEAN_PROJECT_CMD_ID");
    public static final String CLEAN_PROJECT_CMD = "oracle.jdeveloper.compiler.CleanProjectCommand";
    public static final int CLEAN_WORKSPACE_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.CLEAN_WORKSPACE_CMD_ID");
    public static final String CLEAN_WORKSPACE_CMD = "oracle.jdeveloper.compiler.CleanWorkspaceCommand";
    private static final String msgStart = CompArb.getString(43);
    private static final String cleanCompleted = CompArb.getString(36);
    private static final String cleanCancelled = CompArb.getString(37);
    private static final String msgSuccess = CompArb.getString(44);
    private static final String msgNothingToBuild = CompArb.getString(45);
    private static JCompiler instance;
    private LogPage outputLog;
    private LogPage errorLog;
    private LogPage userDefinedOutputLog;
    private LogPage userDefinedErrorLog;
    private LogPage ideOutputLog;
    private LogPage ideErrorLog;
    private Navigable compilerNavigable;
    private ArrayList buildListeners = new ArrayList();
    private HashMap cachedProjects = new HashMap();
    private NodeListener cachedProjectsNL = new NodeListener(){

        public void nodeClosed(NodeEvent ee) {
            JCompiler.this.removeProjectFromCache((Project)ee.getNode());
        }
    };
    ArrayList copyListeners = new ArrayList();
    private boolean disableProjectUpdates = false;
    private Boolean busy = false;
    private final ProjectChangeListener projectChangeListener = new ProjectChangeListener(){

        public void projectPropertiesChanged(ProjectChangeEvent e) {
            JCompiler.this.projectPropertiesChangedImpl(e);
        }
    };
    private static boolean caseSensitiveFileSystem;

    public static JCompiler getInstance() {
        if (instance == null) {
            instance = new JCompiler();
        }
        return instance;
    }

    JCompiler() {
        instance = this;
    }

    static void invokeAsap(Runnable runnable) {
        if (!Ide.getIdeArgs().getCreateUI() || SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void projectPropertiesChangedImpl(ProjectChangeEvent e) {
        ChangeInfo[] changes = e.getChangeDetails();
        if (changes != null) {
            for (int i = 0; i < changes.length; ++i) {
                if (changes[i].getChangeType() != 0 && changes[i].getChangeType() != 1) continue;
                Project prj = e.getProject();
                if (prj == null || this.disableProjectUpdates) break;
                if (prj.isDirty()) {
                    if (this.cachedProjects.isEmpty()) {
                        Project.addNodeListenerForType(Project.class, (NodeListener)this.cachedProjectsNL);
                    }
                    this.cachedProjects.put(prj, Boolean.TRUE);
                    break;
                }
                this.removeProjectFromCache(prj);
                break;
            }
        }
    }

    private void removeProjectFromCache(Project prj) {
        this.cachedProjects.remove(prj);
        if (this.cachedProjects.isEmpty()) {
            Project.removeNodeListenerForType(Project.class, (NodeListener)this.cachedProjectsNL);
        }
    }

    public boolean forceRebuildOnProject(Project prj) {
        if ((Boolean)this.cachedProjects.get(prj) == null) {
            return false;
        }
        this.removeProjectFromCache(prj);
        return true;
    }

    public void initialize() {
        Compiler.setCompiler((Compiler)this);
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(((Object)((Object)this)).getClass().getClassLoader(), "oracle/jdeveloper/compiler/accelerators.xml");
        this.compilerNavigable = new Navigable(CompArb.getString(40), OjcConfigurationPanel.class);
        ProjectPropertiesDialog.addPanel((Navigable)this.compilerNavigable);
        String compilerOptionPanelName = CompilerArb.getString((int)0);
        this.registerNavigable(new Navigable(compilerOptionPanelName, CompilerOptionPanel.class));
        Project.addProjectChangeListener((String)OjcConfiguration.DATA_KEY, (ProjectChangeListener)this.projectChangeListener);
        Project.addProjectChangeListener((String)"oracle.jdevimpl.config.JProjectLibraries", (ProjectChangeListener)this.projectChangeListener);
        Project.addProjectChangeListener((String)JProjectPaths.DATA_KEY, (ProjectChangeListener)this.projectChangeListener);
        Project.addProjectChangeListener((String)PathsConfiguration.DATA_KEY, (ProjectChangeListener)this.projectChangeListener);
        ExitCommand.addShutdownHook((ShutdownHook)this);
    }

    public void shutdown() {
    }

    public boolean canShutdown() {
        if (!this.isBusy(null)) {
            return true;
        }
        int answer = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), CompArb.getString(81), CompArb.getString(80), 0, 3);
        if (answer == 0) {
            this.stopBuild(null);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBusy(Context context) {
        Boolean bl = this.busy;
        synchronized (bl) {
            return this.busy != false || UnifiedBuildSystem.getInstance().isAlive() || UnifiedBuildSystem.getInstance().isLocked(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setBusy(Context context) {
        Boolean bl = this.busy;
        synchronized (bl) {
            if (this.isBusy(context)) {
                return false;
            }
            this.busy = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNotBusy() {
        Boolean bl = this.busy;
        synchronized (bl) {
            this.busy = false;
        }
    }

    public void stopBuild(Context context) {
        UnifiedBuildSystem.getInstance().stopBuildSystem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanAll(Context context) {
        if (this.setBusy(context)) {
            try {
                UnifiedBuildSystem.getInstance().initCleanAll(context);
            }
            finally {
                this.setNotBusy();
            }
        }
    }

    private void saveAll(boolean saveRequested) {
        if (saveRequested && Ide.getEnvironOptions().getSaveBeforeCompile()) {
            IdeUtil.runNow((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean oldValue = JCompiler.this.disableProjectUpdates;
                    JCompiler.this.disableProjectUpdates = true;
                    try {
                        SaveAllCommand.saveAll();
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        JCompiler.this.disableProjectUpdates = oldValue;
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compile(final CompileArguments compileArguments) {
        if (compileArguments == null) {
            throw new IllegalArgumentException("Need a valid context for compilations");
        }
        if (!this.setBusy(compileArguments.getContext())) {
            return false;
        }
        boolean releaseResources = true;
        boolean executePostBuilder = true;
        final UnifiedBuildSystem ubs = UnifiedBuildSystem.getInstance();
        boolean result = false;
        try {
            if (!compileArguments.isCompileDependentProjects()) {
                compileArguments.getContext().setProperty(DO_NOT_COMPILE_DEPENDENT_PROJECTS, (Object)Boolean.TRUE);
            }
            if (this.outputLog != this.ideOutputLog) {
                this.outputLog = null;
            }
            if (this.errorLog != this.ideErrorLog) {
                this.errorLog = null;
            }
            this.userDefinedOutputLog = compileArguments.getOutputStream() != null ? new OutputStreamLogPage(compileArguments.getOutputStream()) : null;
            this.userDefinedErrorLog = compileArguments.getDiagnosticsStream() != null ? new OutputStreamLogPage(compileArguments.getDiagnosticsStream()) : null;
            if (Ide.getIdeArgs().getCreateUI()) {
                this.saveAll(compileArguments.isSaveBeforeCompiling());
            }
            result = compileArguments.isWaitForTermination() && SwingUtilities.isEventDispatchThread() ? ubs.buildOnUIThread(compileArguments.getContext(), compileArguments.isRebuildAllSources()) : ubs.init(compileArguments.getContext(), compileArguments.isRebuildAllSources());
            if (!compileArguments.isWaitForTermination() && result) {
                releaseResources = false;
                executePostBuilder = false;
                Thread thread = new Thread(){
                    private boolean result;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            ubs.join(0L);
                            this.result = ubs.getLastErrorCount() == 0;
                        }
                        catch (InterruptedException iex) {
                            this.result = false;
                        }
                        finally {
                            JCompiler.this.userDefinedOutputLog = null;
                            JCompiler.this.userDefinedErrorLog = null;
                            JCompiler.this.setNotBusy();
                        }
                        if (compileArguments.getPostBuilder() != null) {
                            compileArguments.getPostBuilder().postBuild(this.result);
                        }
                    }
                };
                thread.start();
            } else if (compileArguments.isWaitForTermination() && result) {
                ubs.join(0L);
                result = ubs.getLastErrorCount() == 0;
            }
        }
        catch (InterruptedException t) {
            result = false;
        }
        finally {
            if (releaseResources) {
                this.userDefinedOutputLog = null;
                this.userDefinedErrorLog = null;
                this.setNotBusy();
            }
        }
        if (executePostBuilder && compileArguments.getPostBuilder() != null) {
            compileArguments.getPostBuilder().postBuild(result);
        }
        return result;
    }

    @Deprecated
    public boolean compile(Context context, boolean rebuild, boolean wait) {
        CompileArguments compileArguments = new CompileArguments(context);
        compileArguments.setRebuildAllSources(rebuild);
        compileArguments.setSaveBeforeCompiling(false);
        compileArguments.setWaitForTermination(wait);
        return this.compile(compileArguments);
    }

    @Deprecated
    public boolean compile(Context context, boolean rebuild, boolean wait, boolean save) {
        CompileArguments compileArguments = new CompileArguments(context);
        compileArguments.setRebuildAllSources(rebuild);
        compileArguments.setSaveBeforeCompiling(save);
        compileArguments.setWaitForTermination(wait);
        return this.compile(compileArguments);
    }

    @Deprecated
    public void compile(Context context, boolean rebuild, PostBuilder postBuild, boolean save) {
        CompileArguments compileArguments = new CompileArguments(context);
        compileArguments.setRebuildAllSources(rebuild);
        compileArguments.setSaveBeforeCompiling(save);
        compileArguments.setWaitForTermination(false);
        compileArguments.setPostBuilder(postBuild);
        this.compile(compileArguments);
    }

    @Deprecated
    public boolean compile(Context context, boolean rebuild, boolean wait, OutputStream outStream, OutputStream errStream) {
        CompileArguments compileArguments = new CompileArguments(context);
        compileArguments.setRebuildAllSources(rebuild);
        compileArguments.setSaveBeforeCompiling(false);
        compileArguments.setWaitForTermination(wait);
        compileArguments.setOutputStream(outStream);
        compileArguments.setDiagnosticsStream(errStream);
        return this.compile(compileArguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clean(Context context, boolean throwOnFailedDelete, OutputStream outStream, OutputStream errStream) throws IOException {
        if (!this.setBusy(context)) {
            return false;
        }
        try {
            IOException failedDeleteException;
            if (this.outputLog != this.ideOutputLog) {
                this.outputLog = null;
            }
            if (this.errorLog != this.ideErrorLog) {
                this.errorLog = null;
            }
            this.userDefinedOutputLog = outStream != null ? new OutputStreamLogPage(outStream) : null;
            this.userDefinedErrorLog = errStream != null ? new OutputStreamLogPage(errStream) : null;
            UnifiedBuildSystem ubs = UnifiedBuildSystem.getInstance();
            if (!ubs.initCleanAll(context, true, throwOnFailedDelete)) {
                boolean bl = false;
                return bl;
            }
            ubs.join(0L);
            if (throwOnFailedDelete && (failedDeleteException = ubs.getFailedDeleteException()) != null) {
                throw failedDeleteException;
            }
            boolean bl = true;
            return bl;
        }
        catch (InterruptedException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.userDefinedOutputLog = null;
            this.userDefinedErrorLog = null;
            this.setNotBusy();
        }
    }

    public boolean internalJavaCompile(Context context, final ArrayList messages) throws Exception {
        final boolean[] areThereErrors = new boolean[]{false};
        if (!this.setBusy(context)) {
            throw new IllegalStateException();
        }
        boolean savedValue = UnifiedBuildSystem.showCompileProgress;
        try {
            UnifiedBuildSystem.showCompileProgress = false;
            Element[] files = context.getSelection();
            ArrayList<IdeStorage> sources = new ArrayList<IdeStorage>();
            for (Element file : files) {
                if (!file.getLongLabel().endsWith(".java")) {
                    throw new IllegalArgumentException();
                }
                sources.add(new IdeStorage((Node)file));
            }
            Translator javaTranslator = UnifiedBuildSystem.getInstance().getJavaTranslator();
            if (javaTranslator == null) {
                throw new ClassNotFoundException();
            }
            Translator.Log log = new Translator.Log(){
                int errCnt = 0;
                int warningCnt = 0;

                @Override
                public void error(Storage source, int line, int col, int errNumber, String errMsg) {
                    areThereErrors[0] = true;
                    messages.add(source.getPath() + '(' + line + ',' + col + "):" + errNumber + ':' + errMsg);
                    ++this.errCnt;
                }

                @Override
                public void warning(Storage source, int line, int col, int errNumber, String errMsg) {
                    messages.add(source.getPath() + '(' + line + ',' + col + "):" + errNumber + ':' + errMsg);
                    ++this.warningCnt;
                }

                @Override
                public void clear(Storage source) {
                }

                @Override
                public int nerrors() {
                    return this.errCnt;
                }

                @Override
                public int nwarnings() {
                    return this.warningCnt;
                }
            };
            Project prj = context.getProject();
            if (prj == null) {
                prj = Ide.getActiveProject();
            }
            javaTranslator.setLog(log);
            javaTranslator.translate(prj, true, sources, new ArrayList());
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        finally {
            UnifiedBuildSystem.showCompileProgress = savedValue;
            this.setNotBusy();
        }
        return !areThereErrors[0];
    }

    public int compileInThread(Thread thread, Project prj, ArrayList files, boolean rebuild) {
        UnifiedBuildSystem ubs = UnifiedBuildSystem.getInstance();
        return ubs.compileInThread(thread, prj, files, rebuild);
    }

    private static BuildSystemConfiguration getBuildSysConfig(Project prj) {
        return BuildSystemConfiguration.getInstance((PropertyStorage)prj);
    }

    static boolean getReverseCopyRes(Project prj) {
        BuildSystemConfiguration bsc = JCompiler.getBuildSysConfig(prj);
        if (bsc != null) {
            return bsc.getReverseCopyRes();
        }
        return false;
    }

    static String[] getCopyRes(Project prj) {
        BuildSystemConfiguration bsc = JCompiler.getBuildSysConfig(prj);
        if (bsc != null) {
            return bsc.getCopyRes();
        }
        return null;
    }

    static boolean isCopyable(String name, String[] copyResSpec, boolean reverseCopy) {
        block4: {
            if (name == null || copyResSpec == null) break block4;
            if (!caseSensitiveFileSystem) {
                name = name.toLowerCase();
                for (int i = 0; i < copyResSpec.length; ++i) {
                    if (!name.endsWith(copyResSpec[i].toLowerCase())) continue;
                    return !reverseCopy;
                }
            } else {
                for (int i = 0; i < copyResSpec.length; ++i) {
                    if (!name.endsWith(copyResSpec[i])) continue;
                    return !reverseCopy;
                }
            }
        }
        return reverseCopy;
    }

    static boolean isCopyable(Element element, String[] copyResSpec, boolean reverseCopy) {
        if (element != null) {
            URL url;
            String name = element instanceof Node ? ((url = ((Node)element).getURL()) != null ? url.getPath() : element.getShortLabel()) : element.getShortLabel();
            return JCompiler.isCopyable(name, copyResSpec, reverseCopy);
        }
        return false;
    }

    static boolean isCopyable(Element element, Project prj) {
        return JCompiler.isCopyable(element, JCompiler.getCopyRes(prj), JCompiler.getReverseCopyRes(prj));
    }

    public synchronized boolean addCopyListener(CopyListener cl) {
        for (int i = 0; i < this.copyListeners.size(); ++i) {
            if ((CopyListener)this.copyListeners.get(i) != cl) continue;
            return false;
        }
        this.copyListeners.add(cl);
        return true;
    }

    public synchronized boolean removeCopyListener(CopyListener cl) {
        for (int i = 0; i < this.copyListeners.size(); ++i) {
            if ((CopyListener)this.copyListeners.get(i) != cl) continue;
            this.copyListeners.remove(i);
            return true;
        }
        return false;
    }

    public synchronized boolean addBuildSystemListener(BuildSystemListener bsl) {
        for (int i = 0; i < this.buildListeners.size(); ++i) {
            if ((BuildSystemListener)this.buildListeners.get(i) != bsl) continue;
            return false;
        }
        this.buildListeners.add(bsl);
        return true;
    }

    public synchronized boolean removeBuildSystemListener(BuildSystemListener bsl) {
        for (int i = 0; i < this.buildListeners.size(); ++i) {
            if ((BuildSystemListener)this.buildListeners.get(i) != bsl) continue;
            this.buildListeners.remove(i);
            return true;
        }
        return false;
    }

    void invokeListenersBuildBegin(Context context, IdeLog ideLog) throws BuildSystemVetoException {
        BuildSystemListener[] listeners = this.getBuildSystemListenersArray();
        if (listeners == null) {
            return;
        }
        for (int i = 0; i < listeners.length; ++i) {
            try {
                long startTime = System.nanoTime();
                listeners[i].buildWillStart(context);
                long endTime = System.nanoTime();
                PerformanceLogger.get().log("BuildSystemListener.buildWillStart()", listeners[i].getClass().getName(), endTime - startTime);
                continue;
            }
            catch (BuildSystemVetoException ex) {
                ideLog.error(null, 0, 0, 0, ex.getMessage());
                for (int j = 0; j < i; ++j) {
                    this.invokeOneListenerBuildFinish(listeners[j], ideLog);
                }
                throw ex;
            }
        }
    }

    void invokeListenersBuildFinish(IdeLog ideLog) {
        BuildSystemListener[] listeners = this.getBuildSystemListenersArray();
        if (listeners == null) {
            return;
        }
        for (int i = 0; i < listeners.length; ++i) {
            this.invokeOneListenerBuildFinish(listeners[i], ideLog);
        }
    }

    private void invokeOneListenerBuildFinish(BuildSystemListener listener, IdeLog ideLog) {
        try {
            long startTime = System.nanoTime();
            listener.buildFinished(ideLog.nerrors(), ideLog.nwarnings(), 0);
            long endTime = System.nanoTime();
            PerformanceLogger.get().log("BuildSystemListener.buildFinished", listener.getClass().getName(), endTime - startTime);
        }
        catch (BuildSystemVetoException ex) {
            ideLog.error(null, 0, 0, 0, ex.getMessage());
        }
    }

    void invokeListenersCleanBegin(Context context, IdeLog ideLog) throws BuildSystemVetoException {
        BuildSystemListener[] listeners = this.getBuildSystemListenersArray();
        if (listeners == null) {
            return;
        }
        for (int i = 0; i < listeners.length; ++i) {
            try {
                long startTime = System.nanoTime();
                listeners[i].cleanWillStart(context);
                long endTime = System.nanoTime();
                PerformanceLogger.get().log("BuildSystemListener.cleanWillStart", listeners[i].getClass().getName(), endTime - startTime);
                continue;
            }
            catch (AbstractMethodError e) {
                continue;
            }
            catch (BuildSystemVetoException bsvex) {
                ideLog.error(null, 0, 0, 0, bsvex.getMessage());
                for (int j = 0; j < i; ++j) {
                    this.invokeOneListenerCleanFinish(listeners[j], context, ideLog);
                }
                throw bsvex;
            }
        }
    }

    void invokeListenersCleanFinish(Context context, IdeLog ideLog) {
        BuildSystemListener[] listeners = this.getBuildSystemListenersArray();
        if (listeners == null) {
            return;
        }
        for (int i = 0; i < listeners.length; ++i) {
            this.invokeOneListenerCleanFinish(listeners[i], context, ideLog);
        }
    }

    private void invokeOneListenerCleanFinish(BuildSystemListener listener, Context context, IdeLog ideLog) {
        try {
            long startTime = System.nanoTime();
            listener.cleanFinished(context);
            long endTime = System.nanoTime();
            PerformanceLogger.get().log("BuildSystemListener.cleanFinished", listener.getClass().getName(), endTime - startTime);
        }
        catch (AbstractMethodError e) {
        }
        catch (BuildSystemVetoException bsvex) {
            ideLog.error(null, 0, 0, 0, bsvex.getMessage());
        }
    }

    private synchronized BuildSystemListener[] getBuildSystemListenersArray() {
        if (this.buildListeners == null || this.buildListeners.size() == 0) {
            return null;
        }
        BuildSystemListener[] listeners = new BuildSystemListener[this.buildListeners.size()];
        int i = 0;
        Iterator iter = this.buildListeners.iterator();
        while (iter.hasNext()) {
            listeners[i++] = (BuildSystemListener)iter.next();
        }
        return listeners;
    }

    public boolean lock(Context context, boolean wait) {
        if (this.isBusy(context)) {
            if (!wait) {
                return false;
            }
            try {
                UnifiedBuildSystem.getInstance().join(0L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return UnifiedBuildSystem.getInstance().lock(context);
    }

    public boolean unlock(Context context) {
        return UnifiedBuildSystem.getInstance().unlock();
    }

    public LogPage getOutputLog() {
        if (this.userDefinedOutputLog != null) {
            return this.userDefinedOutputLog;
        }
        if (this.outputLog == null) {
            IdeArgs args = Ide.getIdeArgs();
            if (!args.getCreateUI() || args.hasArg("-make") || args.hasArg("-rebuild")) {
                this.outputLog = new OutputStreamLogPage(System.out);
            } else {
                this.ideOutputLog = this.outputLog = LogManager.getLogManager().getMsgPage();
            }
        }
        return this.outputLog;
    }

    public void logOutMsg(final String msg) {
        try {
            JCompiler.invokeAsap(new Runnable(){

                @Override
                public void run() {
                    JCompiler.this.getOutputLog().log((Object)msg);
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void logOutStartBuild() {
        JCompiler.invokeAsap(new Runnable(){

            @Override
            public void run() {
                if (UnifiedBuildSystem.showCompileProgress) {
                    JCompiler.this.logOutMsg(msgStart + "\n");
                }
                JCompiler.this.setStatusBarText(msgStart);
                LogPage log = JCompiler.this.getErrorLog();
                UnifiedBuildSystem.ideLog.registerAsynchronousLogPage(log);
                if (Ide.getEnvironOptions().getClearCompilerLogBeforeCompile() && (System.getProperty("compiler.log") == null || !System.getProperty("compiler.log").equals("tablestyle"))) {
                    log.clearAll();
                }
            }
        });
    }

    private void _logOutEndBuild(int filesBuilt, int cleanAll) {
        IdeLog ideLog = UnifiedBuildSystem.ideLog;
        if (ideLog == null) {
            return;
        }
        DateFormat timeFormatter = DateFormat.getTimeInstance(2);
        String timeMsg = "[" + timeFormatter.format(new Date()) + "] ";
        if (cleanAll > 0) {
            String msg = timeMsg + (cleanAll == 1 ? cleanCompleted : cleanCancelled);
            if (UnifiedBuildSystem.showCompileProgress) {
                this.logOutMsg(msg + "\n");
            }
            this.setStatusBarText(msg);
        } else if (ideLog.nerrors() + ideLog.nwarnings() > 0) {
            String msgFailure = timeMsg + CompArb.format(62, Integer.toString(ideLog.nerrors()), Integer.toString(ideLog.nwarnings()));
            if (UnifiedBuildSystem.showCompileProgress) {
                this.logOutMsg(msgFailure + "\n");
            }
            this.setStatusBarText(msgFailure);
            ideLog.unregisterAsynchronousLogPage(this.getErrorLog());
        } else {
            String msg = timeMsg + (filesBuilt == 0 ? msgNothingToBuild : msgSuccess);
            if (UnifiedBuildSystem.showCompileProgress) {
                this.logOutMsg(msg + "\n");
            }
            this.setStatusBarText(msg);
            ideLog.unregisterAsynchronousLogPage(this.getErrorLog());
        }
    }

    private void setStatusBarText(String message) {
        Ide.getStatusBar().setText(message);
    }

    void logOutEndBuild(final int filesBuilt, final int cleanAll) {
        JCompiler.invokeAsap(new Runnable(){

            @Override
            public void run() {
                JCompiler.this._logOutEndBuild(filesBuilt, cleanAll);
            }
        });
    }

    public static Logger getLogger() {
        return Logger.getLogger(JCompiler.class.getName());
    }

    public LogPage getErrorLog() {
        if (this.userDefinedErrorLog != null) {
            return this.userDefinedErrorLog;
        }
        if (this.errorLog == null) {
            IdeArgs args = Ide.getIdeArgs();
            if (!Ide.getIdeArgs().getCreateUI()) {
                this.errorLog = new OutputStreamLogPage(System.err);
            } else if (args.hasArg("-make") || args.hasArg("-rebuild")) {
                this.errorLog = new OutputStreamLogPage(System.err);
            } else {
                this.errorLog = System.getProperty("compiler.log") != null && System.getProperty("compiler.log").equals("tablestyle") ? new ProblemsPage() : new CompilerPage();
                this.ideErrorLog = this.errorLog;
            }
        }
        return this.errorLog;
    }

    public void registerTranslator(Translator translator) {
        UnifiedBuildSystem.getInstance().registerTranslator(translator);
    }

    public void unregisterTranslator(Translator translator) {
        UnifiedBuildSystem.getInstance().unregisterTranslator(translator);
    }

    public void registerNavigable(Navigable navigable) {
        if (this.compilerNavigable != null) {
            this.compilerNavigable.addChildNavigable(navigable);
        }
    }

    static {
        caseSensitiveFileSystem = !new File("A").equals(new File("a"));
    }
}

