/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.logging.Level;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.QueryCriteria;
import oracle.ide.index.task.BackgroundTask;
import oracle.ide.model.Project;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.JCompiler;
import oracle.jdeveloper.compiler.JarStorage;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.DirectoryStorage;
import oracle.ojc.storage.FileStorage;

public class Helpers {
    public static Storage createFileStorage(String pathName) {
        return new FileStorage(new File(pathName));
    }

    public static Storage createFileStorage(File file) {
        return new FileStorage(file);
    }

    public static boolean isFileStorage(Storage stor) {
        return stor instanceof FileStorage;
    }

    static String arrayToString(String[] a, String separator) {
        if (a == null) {
            return null;
        }
        int len = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == null) continue;
            len += a[i].length();
        }
        StringBuffer sb = new StringBuffer(len += a.length == 0 ? 0 : a.length * separator.length());
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != null) {
                sb.append(a[i]);
            }
            if (i + 1 >= a.length) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    static String[] stringToArray(String s, String separator) {
        if (s == null) {
            return null;
        }
        int l = s.length();
        int i = 0;
        int n = 0;
        while (i < l) {
            int j = s.indexOf(separator, i);
            if (j < 0) {
                j = l;
            }
            if (i < j) {
                ++n;
            }
            i = j + 1;
        }
        String[] path = new String[n];
        i = 0;
        n = 0;
        while (i < l) {
            int j = s.indexOf(separator, i);
            if (j < 0) {
                j = l;
            }
            if (i < j) {
                path[n++] = s.substring(i, j);
            }
            i = j + 1;
        }
        return path;
    }

    static Storage[] stringToStorageArray(String s) {
        String[] sa = Helpers.stringToArray(s, File.pathSeparator);
        if (sa == null) {
            return null;
        }
        Storage[] path = new Storage[sa.length];
        for (int i = 0; i < sa.length; ++i) {
            path[i] = sa[i].endsWith(".jar") || sa[i].endsWith(".zip") ? new oracle.ojc.storage.JarStorage(new File(sa[i])) : new FileStorage(new File(sa[i]));
        }
        return path;
    }

    static ArrayList listOfUniqueClassPathElement(ArrayList storageList) {
        ArrayList<URL> uniqueElements = null;
        HashMap<URL, URL> map = null;
        if (storageList != null) {
            for (int i = 0; i < storageList.size(); ++i) {
                Storage st = (Storage)storageList.get(i);
                ArrayList l = (ArrayList)st.getProperty("dependantClassPathURLList");
                if (l == null) continue;
                if (map == null) {
                    map = new HashMap<URL, URL>();
                }
                for (int j = 0; j < l.size(); ++j) {
                    URL cp = (URL)l.get(j);
                    if (map.get(cp) != null) continue;
                    map.put(cp, cp);
                    if (uniqueElements == null) {
                        uniqueElements = new ArrayList<URL>();
                    }
                    uniqueElements.add(cp);
                }
            }
        }
        return uniqueElements;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void addStoragePath(HashSet seenURLs, ArrayList storagePath, URL url, boolean isFromManifestFile) {
        String urlPath;
        if (seenURLs.contains(url)) {
            return;
        }
        seenURLs.add(url);
        URL jarFileUrl = null;
        if (JarUtil.isJarURL((URL)url)) {
            jarFileUrl = JarUtil.getJarFileURL((URL)url);
        } else if ("file".equals(url.getProtocol()) && (urlPath = url.getPath()) != null && (urlPath.endsWith(".jar") || urlPath.endsWith(".zip"))) {
            jarFileUrl = URLFactory.newJarURL((URL)url, null);
        }
        if (jarFileUrl != null) {
            if (!URLFileSystem.exists((URL)jarFileUrl) && !new File(jarFileUrl.getPath()).exists()) return;
            JarStorage jarStorage = new JarStorage(url);
            if (isFromManifestFile) {
                jarStorage.setProperty("isFromManifestFile", Boolean.TRUE);
            }
            storagePath.add(jarStorage);
            try {
                String classPathAttr = JarUtil.getClassPath((URL)jarFileUrl);
                if (classPathAttr == null) return;
                URL dirUrl = URLFileSystem.getParent((URL)jarFileUrl);
                StringTokenizer st = new StringTokenizer(classPathAttr);
                while (st.hasMoreTokens()) {
                    String classPathItemStr = st.nextToken();
                    boolean isJar = false;
                    URL classPathItemURL = URLFactory.newURL((URL)dirUrl, (String)classPathItemStr);
                    if (JarUtil.isArchive((String)classPathItemStr)) {
                        isJar = true;
                        classPathItemURL = URLFactory.newJarURL((URL)classPathItemURL, null);
                    }
                    Helpers.addStoragePath(seenURLs, storagePath, classPathItemURL, true);
                }
                return;
            }
            catch (IOException e) {
                return;
            }
        } else {
            File file = new File(url.getPath());
            if (file.isDirectory()) {
                storagePath.add(new DirectoryStorage(file));
                return;
            } else {
                if (!file.exists()) return;
                storagePath.add(new FileStorage(file));
            }
        }
    }

    static Storage[] urlPathAndDependantPathToStorageArray(URLPath urlPath, ArrayList storageList) {
        int i;
        int n;
        ArrayList cpElements = Helpers.listOfUniqueClassPathElement(storageList);
        int cpElementCnt = cpElements == null ? 0 : cpElements.size();
        URL[] urls = urlPath == null ? null : urlPath.getEntries();
        int n2 = n = urls == null ? 0 : urls.length;
        if (n + cpElementCnt == 0) {
            return null;
        }
        HashSet seenURLs = new HashSet();
        ArrayList storagePathList = new ArrayList(n + cpElementCnt);
        for (i = 0; i < n; ++i) {
            Helpers.addStoragePath(seenURLs, storagePathList, urls[i], false);
        }
        for (i = 0; i < cpElementCnt; ++i) {
            Helpers.addStoragePath(seenURLs, storagePathList, (URL)cpElements.get(i), false);
        }
        return storagePathList.toArray(new Storage[storagePathList.size()]);
    }

    static Storage[] urlPathToStorageArray(URLPath urlPath) {
        return Helpers.urlPathAndDependantPathToStorageArray(urlPath, null);
    }

    private static void addStringPath(StringBuffer path, URL url, String separator) {
        File urlFile;
        if (JarUtil.isJarURL((URL)url)) {
            url = JarUtil.getJarFileURL((URL)url);
        }
        if ((urlFile = new File(url.getPath())).exists()) {
            path.append(urlFile.getPath());
            path.append(separator);
        }
    }

    static String urlPathAndDependantPathToString(URLPath urlPath, ArrayList storageList, String separator) {
        int i;
        ArrayList cpElements = Helpers.listOfUniqueClassPathElement(storageList);
        URL[] urls = urlPath == null ? null : urlPath.getEntries();
        StringBuffer path = new StringBuffer(30);
        if (urls != null) {
            for (i = 0; i < urls.length; ++i) {
                Helpers.addStringPath(path, urls[i], separator);
            }
        }
        if (cpElements != null) {
            for (i = 0; i < cpElements.size(); ++i) {
                Helpers.addStringPath(path, (URL)cpElements.get(i), separator);
            }
        }
        if (path.length() > 0) {
            path.deleteCharAt(path.length() - 1);
        }
        return path.toString();
    }

    static String urlPathToString(URLPath urlPath, String separator) {
        return Helpers.urlPathAndDependantPathToString(urlPath, null, separator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static URL[] getUrlsThroughIndexer(Project prj, QueryCriteria queryCriteria) {
        IndexManager manager = IndexManager.getIndexManager();
        Index index = manager.getIndex(prj);
        BackgroundTask query = index.query(queryCriteria);
        try {
            URL[] uRLArray = (URL[])query.get();
            return uRLArray;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(CompArb.getString(76));
        }
        catch (Exception e) {
            JCompiler.getLogger().log(Level.SEVERE, "Unable to retrieve project content", e);
        }
        finally {
            index.release();
        }
        return new URL[0];
    }
}

