/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.util.ArrayList;
import oracle.jdeveloper.compiler.BuildGraph;
import oracle.jdeveloper.compiler.Translator;

class BuildNode {
    int marker = 0;
    ArrayList parents;
    ArrayList children;
    String name;
    ArrayList preProcessors;
    Translator translator;

    BuildNode(String name, Translator translator) {
        this.name = name;
        this.translator = translator;
        this.preProcessors = null;
        this.parents = new ArrayList(1);
        this.children = new ArrayList(1);
    }

    BuildNode(String name, ArrayList translators) {
        this.name = name;
        this.parents = new ArrayList(1);
        this.children = new ArrayList(1);
        int cnt = translators != null ? translators.size() : 0;
        this.preProcessors = cnt > 1 ? new ArrayList(cnt - 1) : null;
        this.translator = null;
        for (int i = 0; i < cnt; ++i) {
            Translator t = (Translator)translators.get(i);
            if (this.translator == null && !BuildGraph.isPreprocessor(t)) {
                this.translator = t;
                continue;
            }
            if (i == cnt - 1 && this.translator == null) {
                this.translator = t;
                continue;
            }
            this.preProcessors.add(t);
        }
    }

    boolean containsTranslator(Translator translator) {
        return translator == this.translator || this.preProcessors != null && this.preProcessors.contains(translator);
    }

    void addTranslator(Translator translator) {
        if (this.preProcessors == null) {
            this.preProcessors = new ArrayList(1);
        }
        if (BuildGraph.isPreprocessor(translator)) {
            this.preProcessors.add(translator);
        } else {
            assert (BuildGraph.isPreprocessor(this.translator));
            this.preProcessors.add(this.translator);
            this.translator = translator;
        }
    }
}

