/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.file;

import java.awt.Image;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.GalleryArb;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.builder.AbstractBuilderModel;
import oracle.jdeveloper.builder.file.FileBuilder;
import oracle.jdeveloper.builder.file.FileBuilderModel;
import oracle.jdeveloper.builder.resource.BuilderArb;

public class EmptyFileBuilder
extends FileBuilder {
    @Override
    public String getShortLabel() {
        return GalleryArb.getString((int)29);
    }

    public String getLongLabel() {
        return GalleryArb.getString((int)30);
    }

    @Override
    public Icon getIcon() {
        return OracleIcons.getIcon((String)"file.png");
    }

    @Override
    protected String _getTitleString() {
        return this.getShortLabel();
    }

    @Override
    protected String getHelpID() {
        return "f1_newfilegeneric_html";
    }

    @Override
    protected AbstractBuilderModel _buildModel(Context context) {
        return new EmptyFileBuilderModel(context);
    }

    @Override
    protected Image getHeaderImage() {
        return OracleIcons.toImage((Icon)OracleIcons.getIcon((String)"header/simpleFile.png"));
    }

    private static class EmptyFileBuilderModel
    extends FileBuilderModel {
        public EmptyFileBuilderModel(Context context) {
            super(context);
        }

        @Override
        public String getFileType() {
            return GalleryArb.getString((int)29);
        }

        @Override
        public String getBuilderType() {
            return "File";
        }

        @Override
        protected boolean buildFile(Node node) {
            if (super.buildFile(node)) {
                URL url;
                if (node != null && !URLFileSystem.exists((URL)(url = node.getURL()))) {
                    try {
                        URLFileSystem.openOutputStream((URL)url).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        protected String getBaseName() {
            return BuilderArb.getString(147);
        }

        @Override
        protected String getDefaultRelativeDirectory(Project project) {
            return "";
        }

        @Override
        protected void initializeSourceDir(Context ctx) {
            Context context = new Context(ctx);
            if (ctx != null && ctx.getElement() == null) {
                if (ctx.getNode() != null) {
                    context.setElement((Element)ctx.getNode());
                } else if (ctx.getProject() != null) {
                    context.setElement((Element)ctx.getProject());
                }
            }
            super.initializeSourceDir(context);
        }
    }
}

