/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder;

import java.net.URL;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import oracle.ide.Context;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.Subject;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.resource.IdeArb;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.builder.SourceModel;
import oracle.jdeveloper.builder.resource.BuilderArb;
import oracle.jdeveloper.model.PackagedSource;
import oracle.jdeveloper.wizard.common.BaliWizardState;

public abstract class AbstractBuilderModel
implements BaliWizardState {
    private SourceModel _src;
    private boolean _clearExistingFiles = true;
    private boolean _raiseEditor = true;

    public abstract String getBuilderType();

    protected abstract String getBaseName();

    protected void initializeFromContext(Context ctx) {
        Project proj = ctx.getProject();
        this.setProject(proj);
        this.initializeSourceDir(ctx);
        this.getSourceModel().generateDefaultFileName(this.getBaseName());
    }

    protected void initializeSourceDir(Context ctx) {
        TreeNode parent;
        TNode tnode;
        SourceModel src = this.getSourceModel();
        Element elem = ctx.getElement();
        if ((elem == null || !elem.mayHaveChildren()) && (tnode = ExplorerContext.getFirstTNode((Context)ctx)) != null && (parent = tnode.getParent()) instanceof TNode) {
            tnode = (TNode)parent;
            elem = tnode.getData();
        }
        if (elem instanceof RelativeDirectoryContextFolder) {
            URLPath dirs;
            RelativeDirectoryContextFolder folder = (RelativeDirectoryContextFolder)elem;
            String path = folder.getRelativePath();
            if (path == null) {
                path = src.getRelativeDirectory();
            }
            if ((dirs = folder.getRootDirectories()) != null && dirs.size() == 1) {
                URL dir = URLFactory.newDirURL((URL)dirs.getFirstEntry(), (String)path);
                src.setDirectory(dir);
                if (!ModelUtil.hasLength((String)src.getDirectoryString())) {
                    src.setRelativeDirectory(this.getDefaultRelativeDirectory(this.getProject()));
                }
            } else if (ModelUtil.hasLength((String)path)) {
                src.setRelativeDirectory(path);
            } else {
                src.setRelativeDirectory(this.getDefaultRelativeDirectory(this.getProject()));
            }
        } else {
            URL dir = null;
            String relPath = null;
            if (elem instanceof Locatable) {
                Project proj;
                PackagedSource pkgSrc;
                URL url = ((Locatable)elem).getURL();
                if (url != null) {
                    URL uRL = dir = URLFileSystem.isDirectory((URL)url) ? url : URLFileSystem.getParent((URL)url);
                }
                if (elem instanceof PackagedSource && (relPath = (pkgSrc = (PackagedSource)elem).getPackage(proj = ctx.getProject())) != null) {
                    relPath = relPath.replace('.', '/');
                }
            }
            if (src.isInSourcePath(dir)) {
                src.setDirectory(dir);
                if (relPath != null) {
                    src.setRelativeDirectory(relPath);
                }
            } else {
                src.setRelativeDirectory(this.getDefaultRelativeDirectory(this.getProject()));
            }
        }
    }

    protected String getDefaultRelativeDirectory(Project project) {
        return "";
    }

    protected final void setClearExistingFiles(boolean clearExistingFiles) {
        this._clearExistingFiles = clearExistingFiles;
    }

    public boolean isRaiseEditor() {
        return this._raiseEditor;
    }

    public void setRaiseEditor(boolean raise) {
        this._raiseEditor = raise;
    }

    public final void setProject(Project project) {
        this.getSourceModel().setProject(project);
    }

    public final Project getProject() {
        return this.getSourceModel().getProject();
    }

    public final void setFileName(String newName) {
        this.getSourceModel().setFileName(newName);
    }

    public final String getFileName() {
        return this.getSourceModel().getFileName();
    }

    public final void setDirectory(URL url) {
        this.getSourceModel().setDirectory(url);
    }

    public final URL getDirectory() {
        return this.getSourceModel().getDirectory();
    }

    public final void setRelativeDirectory(String newDir) {
        this.getSourceModel().setRelativeDirectory(newDir);
    }

    public final String getRelativeDirectory() {
        return this.getSourceModel().getRelativeDirectory();
    }

    public final URL getURL() {
        return this.getSourceModel().getURL();
    }

    public final void setURL(URL url) {
        this.getSourceModel().setURL(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void commitWizardState() {
        Node node = this.getSourceModel().createNode();
        if (node != null) {
            if (!node.isReadOnly()) {
                TextBuffer buffer = null;
                try {
                    if (node instanceof TextNode) {
                        buffer = ((TextNode)node).acquireTextBuffer();
                    }
                    if (!this.fileBuiltSynchronously(node) || !this.shouldAddToProjectContent()) return;
                    this.addFileToProject(node);
                    return;
                }
                finally {
                    if (buffer != null) {
                        ((TextNode)node).releaseTextBuffer();
                    }
                }
            } else {
                this.reportError(BuilderArb.getString(37), BuilderArb.format(38, URLFileSystem.getPlatformPathName((URL)this.getURL())), null);
            }
            return;
        } else {
            this.reportError(BuilderArb.getString(24), BuilderArb.format(25, this.getURL()), null);
        }
    }

    private boolean fileBuiltSynchronously(final Node node) {
        if (this.getProject().isOpen()) {
            return this.buildFile(node);
        }
        if (!this.getProject().ensureOpen()) {
            return false;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AbstractBuilderModel.this.buildFile(node)) {
                    AbstractBuilderModel.this.addFileToProject(node);
                }
            }
        });
        return false;
    }

    protected void addFileToProject(Node node) {
        this.getProject().add(node, this.getSourceModel().getContentSetKey());
        this.postProcess(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean buildFile(Node node) {
        if (node instanceof TextNode && this._clearExistingFiles) {
            TextNode txtNode = (TextNode)node;
            TextBuffer textBuffer = null;
            try {
                textBuffer = txtNode.acquireTextBuffer();
                int textBufferLength = textBuffer.getLength();
                if (textBufferLength > 0) {
                    textBuffer.remove(0, textBufferLength);
                    UpdateMessage.fireStructureChanged((Subject)txtNode);
                }
            }
            finally {
                if (textBuffer != null) {
                    txtNode.releaseTextBuffer();
                }
            }
        }
        return true;
    }

    protected void postProcess(final Node node) {
        if (node != null) {
            try {
                node.save();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Context context = Context.newIdeContext((Node)node);
                    EditorManager editorManager = EditorManager.getEditorManager();
                    OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
                    if (!AbstractBuilderModel.this.isRaiseEditor()) {
                        openEditorOptions.setFlags(2);
                    }
                    openEditorOptions.setFlags(8, true);
                    editorManager.openEditor(openEditorOptions);
                }
            });
        }
    }

    protected SourceModel createSourceModel() {
        return new SourceModel();
    }

    public final void reportError(String msg) {
        this.reportError(IdeArb.getString((int)2), msg, null);
    }

    public void reportError(String title, String msg, String helpID) {
    }

    protected final SourceModel getSourceModel() {
        if (this._src == null) {
            this._src = this.createSourceModel();
        }
        return this._src;
    }

    protected boolean shouldAddToProjectContent() {
        return true;
    }
}

