/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dependency;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dependency.Declaration;
import oracle.ide.dependency.DependencyManager;
import oracle.ide.dependency.IdDeclaration;
import oracle.ide.dependency.IdDeclarationProvider;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.handler.classpath.ClasspathHandlerFacade;

public class URLDeclarationProvider
implements IdDeclarationProvider {
    private static final String PREFIX = "url:";

    public static String getDeclarationId(URL url) {
        return url == null ? null : PREFIX + url.toString();
    }

    public static URL getURL(String id) {
        if (URLDeclarationProvider.isURLDeclaration(id)) {
            try {
                return new URL(id.substring(PREFIX.length()));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isURLDeclaration(String id) {
        return id != null && id.startsWith(PREFIX);
    }

    @Override
    public boolean canGetDeclaration(Context context, String id) {
        return URLDeclarationProvider.isURLDeclaration(id);
    }

    @Override
    public IdDeclaration getDeclaration(Context context, String id) throws InterruptedException {
        URL url = URLDeclarationProvider.getURL(id);
        if (url != null) {
            Workspace workspace = context.getWorkspace();
            Project project = URLDeclarationProvider.getProject(context, url);
            if (project != null && "classpath".equals(url.getProtocol())) {
                url = ClasspathHandlerFacade.resolveClasspathURL((Project)project, (URL)url);
            }
            return new URLDeclaration(workspace, project, url, id);
        }
        return null;
    }

    @Override
    public boolean canGetDeclaration(Context context) {
        return false;
    }

    @Override
    public Declaration getDeclaration(Context context) {
        return null;
    }

    @Override
    public boolean canGetDeclarations(Context context, Node node) {
        return true;
    }

    @Override
    public Collection<? extends Declaration> getDeclarations(Context context, Node node) {
        URL url = node.getURL();
        Workspace workspace = context.getWorkspace();
        Project project = URLDeclarationProvider.getProject(context, url);
        return Collections.singleton(new URLDeclaration(workspace, project, url));
    }

    @Override
    public Collection<? extends Declaration> getTopLevelDeclarations(Context context, Node node) {
        return this.getDeclarations(context, node);
    }

    private static Project getProject(Context context, URL url) {
        Project project = context.getProject();
        if (project == null) {
            project = Ide.getActiveProject();
        }
        return project;
    }

    private static final class URLDeclaration
    extends IdDeclaration {
        private Workspace workspace;
        private Project project;
        private URL url;

        public URLDeclaration(Workspace workspace, Project project, URL url) {
            this(workspace, project, url, URLDeclarationProvider.getDeclarationId(url));
        }

        public URLDeclaration(Workspace workspace, Project project, String id) {
            this(workspace, project, URLDeclarationProvider.getURL(id), id);
        }

        public URLDeclaration(Workspace workspace, Project project, URL url, String id) {
            super(id);
            this.workspace = workspace;
            this.project = project;
            this.url = url;
        }

        @Override
        public URL getURL() {
            return this.url;
        }

        @Override
        public void show() {
            try {
                Node node = NodeFactory.findOrCreate((URL)this.url);
                Context context = Context.newIdeContext((Node)node);
                context.setWorkspace(this.workspace);
                context.setProject(this.project);
                EditorManager editorManager = EditorManager.getEditorManager();
                editorManager.openEditor(new OpenEditorOptions(context));
            }
            catch (Exception e) {
                DependencyManager.getDependencyManager().getLogger().log(Level.SEVERE, "Unable to show " + URLFileSystem.getPlatformPathName((URL)this.url), e);
            }
        }
    }
}

