/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.themes;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import oracle.javatools.ui.themes.Painter;

public final class LinearGradientPainter
implements Painter {
    private final Color _startColor;
    private final Color _endColor;
    private final int _direction;
    private BufferedImage _cache;

    public LinearGradientPainter(Color startColor, Color endColor, int direction) {
        this._startColor = startColor;
        this._endColor = endColor;
        this._direction = direction;
    }

    @Override
    public void paint(Graphics g, int x, int y, int w, int h) {
        boolean vertical;
        boolean bl = vertical = this._direction == 1;
        if (this._cache == null || (vertical ? this._cache.getHeight() != h : this._cache.getWidth() != w)) {
            this._cache = new BufferedImage(vertical ? 2 : w, vertical ? h : 2, 2);
            GradientPaint paint = new GradientPaint(0.0f, 0.0f, this._startColor, vertical ? 0.0f : (float)w, vertical ? (float)h : 0.0f, this._endColor, true);
            Graphics2D g2d = this._cache.createGraphics();
            g2d.setPaint(paint);
            g2d.fillRect(0, 0, vertical ? 2 : w, vertical ? h : 2);
            g2d.dispose();
        }
        g.drawImage(this._cache, x, y, w, h, null);
    }
}

