/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.table;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.javatools.ui.table.RolloverColumnHeaderListener;
import oracle.javatools.ui.table.RolloverColumnHeaderRenderer;
import oracle.javatools.ui.table.RolloverListener;
import oracle.javatools.ui.table.RolloverTableListener;
import oracle.javatools.ui.table.RolloverTableRenderer;
import oracle.javatools.ui.table.RowHeader;
import oracle.javatools.ui.table.TableUIManager;

class RolloverTableHandler {
    static final String ROLLOVER_ROW = "ROLLOVER_ROW";
    static final String ROLLOVER_COLUMN = "ROLLOVER_COLUMN";
    static final int ROLLOVER_ALL_ROWS = -2;
    static final int ROLLOVER_ALL_COLUMNS = -2;
    private Listener _listener;
    private RolloverListener _rolloverListener;
    private RolloverColumnHeaderListener _colheaderListener;
    private RowHeader _rowHeader;
    private JTableHeader _colHeader;
    private JTable _table;

    public RolloverTableHandler(JTable table) {
        this._table = table;
        this._listener = new Listener();
    }

    public static Color getTableCellRolloverHighlight() {
        return TableUIManager.CELL_ROLLOVER_HIGHLIGHT;
    }

    public static Color getHeaderRolloverHighlight() {
        return TableUIManager.HEADER_ROLLOVER_HIGHLIGHT;
    }

    public static void setRolloverHighlightingEnabled(JTable table, boolean enable) {
        if (enable != RolloverTableHandler.isRolloverHighlightingEnabled(table)) {
            if (enable) {
                RolloverTableHandler rc = new RolloverTableHandler(table);
                rc.configureTable();
            } else {
                RolloverTableHandler handler = (RolloverTableHandler)table.getClientProperty(RolloverTableHandler.class);
                handler.unconfigureTable();
            }
        }
    }

    public static boolean isRolloverHighlightingEnabled(JTable table) {
        return table.getClientProperty(RolloverTableHandler.class) instanceof RolloverTableHandler;
    }

    public void configureTable() {
        this._table.putClientProperty(RolloverTableHandler.class, this);
        this._rolloverListener = new RolloverTableListener(this._table);
        this._table.addMouseMotionListener(this._rolloverListener);
        this._table.addMouseListener(this._rolloverListener);
        this._table.addPropertyChangeListener(ROLLOVER_ROW, this._listener);
        this._table.addPropertyChangeListener(ROLLOVER_COLUMN, this._listener);
        int colCount = this._table.getColumnCount();
        for (int i = 0; i < colCount; ++i) {
            this._installColumnRenderer(i);
        }
        this._table.getColumnModel().addColumnModelListener(this._listener);
        this.setColumnHeader(this._table.getTableHeader());
        this.setRowHeader((RowHeader)this._table.getClientProperty("tableRowHeader"));
        this._table.addPropertyChangeListener("tableRowHeader", this._listener);
        this._table.addPropertyChangeListener("tableHeader", this._listener);
        this._table.putClientProperty(ROLLOVER_COLUMN, -1);
        this._table.putClientProperty(ROLLOVER_ROW, -1);
    }

    public void unconfigureTable() {
        this._table.removeMouseMotionListener(this._rolloverListener);
        this._table.removeMouseListener(this._rolloverListener);
        this._rolloverListener = null;
        this._table.putClientProperty(ROLLOVER_COLUMN, null);
        this._table.putClientProperty(ROLLOVER_ROW, null);
        this._table.removePropertyChangeListener(ROLLOVER_ROW, this._listener);
        this._table.removePropertyChangeListener(ROLLOVER_COLUMN, this._listener);
        this._table.getColumnModel().removeColumnModelListener(this._listener);
        int colCount = this._table.getColumnCount();
        for (int i = 0; i < colCount; ++i) {
            this._uninstallColumnRenderer(i);
        }
        this.setColumnHeader(null);
        this.setRowHeader(null);
        this._table.removePropertyChangeListener("tableRowHeader", this._listener);
        this._table.removePropertyChangeListener("tableHeader", this._listener);
        this._table.putClientProperty(RolloverTableHandler.class, null);
    }

    public void setRowHeader(RowHeader rowHeader) {
        if (this._rowHeader != null) {
            this._rowHeader.removePropertyChangeListener(ROLLOVER_ROW, this._listener);
            this._rowHeader.setRolloverHighlightingEnabled(false);
        }
        this._rowHeader = rowHeader;
        if (this._rowHeader != null) {
            this._rowHeader.addPropertyChangeListener(ROLLOVER_ROW, this._listener);
            this._rowHeader.setRolloverHighlightingEnabled(true);
        }
    }

    public RowHeader getRowHeader() {
        return this._rowHeader;
    }

    public void setColumnHeader(JTableHeader colHeader) {
        if (this._colHeader != null) {
            this._colHeader.removePropertyChangeListener(ROLLOVER_COLUMN, this._listener);
            this._colHeader.removeMouseListener(this._colheaderListener);
            this._colHeader.removeMouseMotionListener(this._colheaderListener);
            this._colheaderListener = null;
            TableCellRenderer colRenderer = this._colHeader.getDefaultRenderer();
            if (colRenderer instanceof RolloverColumnHeaderRenderer) {
                this._colHeader.setDefaultRenderer(((RolloverColumnHeaderRenderer)colRenderer).getBaseRenderer());
            }
        }
        this._colHeader = colHeader;
        if (this._colHeader != null) {
            this._colheaderListener = new RolloverColumnHeaderListener(colHeader);
            this._colHeader.addMouseListener(this._colheaderListener);
            this._colHeader.addMouseMotionListener(this._colheaderListener);
            this._colHeader.setDefaultRenderer(new RolloverColumnHeaderRenderer(colHeader.getDefaultRenderer()));
            this._colHeader.addPropertyChangeListener(ROLLOVER_COLUMN, this._listener);
        }
    }

    public JTableHeader getColumnHeader() {
        return this._colHeader;
    }

    private void _installColumnRenderer(int index) {
        TableColumn tableColum = this._table.getColumnModel().getColumn(index);
        TableCellRenderer renderer = tableColum.getCellRenderer();
        if (!(renderer instanceof RolloverTableRenderer)) {
            tableColum.setCellRenderer(new RolloverTableRenderer(renderer));
        }
        tableColum.addPropertyChangeListener(this._listener);
    }

    private void _uninstallColumnRenderer(int index) {
        TableColumn tableColum = this._table.getColumnModel().getColumn(index);
        tableColum.removePropertyChangeListener(this._listener);
        TableCellRenderer renderer = tableColum.getCellRenderer();
        if (renderer instanceof RolloverTableRenderer) {
            tableColum.setCellRenderer(((RolloverTableRenderer)renderer).getBaseRenderer());
        }
    }

    private class Listener
    implements PropertyChangeListener,
    TableColumnModelListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            TableCellRenderer renderer;
            Object src = e.getSource();
            String name = e.getPropertyName();
            if (src == RolloverTableHandler.this._rowHeader) {
                RolloverTableHandler.this._table.putClientProperty(RolloverTableHandler.ROLLOVER_ROW, e.getNewValue());
                RolloverTableHandler.this._table.putClientProperty(RolloverTableHandler.ROLLOVER_COLUMN, -2);
                RolloverTableHandler.this._table.repaint();
            } else if (src == RolloverTableHandler.this._colHeader) {
                RolloverTableHandler.this._table.putClientProperty(RolloverTableHandler.ROLLOVER_ROW, -2);
                RolloverTableHandler.this._table.putClientProperty(RolloverTableHandler.ROLLOVER_COLUMN, e.getNewValue());
                RolloverTableHandler.this._table.repaint();
            } else if (src == RolloverTableHandler.this._table) {
                if (RolloverTableHandler.ROLLOVER_ROW.equals(name)) {
                    if (RolloverTableHandler.this._table.getRowSelectionAllowed() && !RolloverTableHandler.this._table.getCellSelectionEnabled() && RolloverTableHandler.this._rowHeader != null) {
                        RolloverTableHandler.this._rowHeader.putClientProperty(RolloverTableHandler.ROLLOVER_ROW, e.getNewValue());
                        RolloverTableHandler.this._rowHeader.repaint();
                    }
                } else if (RolloverTableHandler.ROLLOVER_COLUMN.equals(name)) {
                    if (RolloverTableHandler.this._table.getColumnSelectionAllowed() && !RolloverTableHandler.this._table.getCellSelectionEnabled() && RolloverTableHandler.this._colHeader != null) {
                        RolloverTableHandler.this._colHeader.putClientProperty(RolloverTableHandler.ROLLOVER_COLUMN, e.getNewValue());
                        RolloverTableHandler.this._colHeader.repaint();
                    }
                } else if ("tableRowHeader".equals(name)) {
                    RolloverTableHandler.this.setRowHeader((RowHeader)e.getNewValue());
                } else if ("tableHeader".equals(name)) {
                    RolloverTableHandler.this.setColumnHeader((JTableHeader)e.getNewValue());
                }
            } else if (src instanceof TableColumn && "cellRenderer".equals(name) && (renderer = (TableCellRenderer)e.getOldValue()) instanceof RolloverTableRenderer) {
                ((RolloverTableRenderer)renderer).setBaseRenderer((TableCellRenderer)e.getNewValue());
            }
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
            RolloverTableHandler.this._installColumnRenderer(e.getToIndex());
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }
}

