/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.table;

import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.table.GenericTableModel;
import oracle.javatools.ui.table.TableHelper;
import oracle.javatools.ui.table.TableUIManager;

public class GenericTableHeaderRenderer
extends DefaultTableCellRenderer {
    private final DefaultTableCellRenderer _defaultRenderer = (DefaultTableCellRenderer)new JTable().getTableHeader().getDefaultRenderer();

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        isSelected = this._isColumnSelected(table, column);
        this._defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (table != null) {
            List<RowSorter.SortKey> sortKeys;
            JTableHeader header = table.getTableHeader();
            if (header != null) {
                this._defaultRenderer.setBackground(header.getBackground());
                this._defaultRenderer.setFont(header.getFont());
                if (table.isEnabled()) {
                    this._defaultRenderer.setForeground(header.getForeground());
                } else {
                    this._defaultRenderer.setForeground(UIManager.getColor("textInactiveText"));
                }
                TableModel model = table.getModel();
                if (model instanceof GenericTableModel) {
                    this._defaultRenderer.setHorizontalAlignment(((GenericTableModel)((Object)model)).getColumnAlignment(table.convertColumnIndexToModel(column)));
                }
            }
            Icon sortIcon = null;
            RowSorter<? extends TableModel> rowSorter = table.getRowSorter();
            if (rowSorter != null && (sortKeys = rowSorter.getSortKeys()).size() > 0 && sortKeys.get(0).getColumn() == table.convertColumnIndexToModel(column)) {
                switch (sortKeys.get(0).getSortOrder()) {
                    case ASCENDING: {
                        sortIcon = TableHelper.getSortIconUp();
                        break;
                    }
                    case DESCENDING: {
                        sortIcon = TableHelper.getSortIconDown();
                    }
                }
            }
            this._defaultRenderer.setIcon(sortIcon);
            if (isSelected) {
                this._defaultRenderer.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, Colors.FLAT_EDITOR_BORDER), BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 3, 0, TableUIManager.HEADER_SEL), BorderFactory.createEmptyBorder(2, 6, 0, 6))));
            } else {
                this._defaultRenderer.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, Colors.FLAT_EDITOR_BORDER), BorderFactory.createEmptyBorder(2, 6, 2, 6)));
            }
        }
        return this._defaultRenderer;
    }

    private boolean _isColumnSelected(JTable table, int column) {
        if (table.getColumnSelectionAllowed()) {
            if (table.getCellSelectionEnabled()) {
                if (table.isColumnSelected(column)) {
                    int min = table.getSelectionModel().getMinSelectionIndex();
                    int max = table.getSelectionModel().getMaxSelectionIndex();
                    return min == 0 && max == table.getRowCount() - 1;
                }
            } else {
                return table.isColumnSelected(column);
            }
        }
        return false;
    }
}

