/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.search;

public abstract class SearchMatcher {
    public abstract boolean matches(CharSequence var1);

    public CharSequence searchString() {
        return "";
    }

    public static SearchMatcher getSubstringMatcher(CharSequence searchString, boolean ignoreCase) {
        return new SubstringSearchHelper(searchString, ignoreCase);
    }

    public static SearchMatcher getPrefixMatcher(CharSequence searchString, boolean ignoreCase, boolean exclusive) {
        return new PrefixSearchHelper(searchString, ignoreCase, exclusive);
    }

    private static int indexOf(CharSequence source, CharSequence target, boolean ignoreCase) {
        int fromIndex = 0;
        int sourceCount = source.length();
        int sourceOffset = 0;
        int targetOffset = 0;
        int targetCount = target.length();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = target.charAt(targetOffset);
        int max = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset + fromIndex; i <= max; ++i) {
            if (!SearchMatcher.charsAreEqual(source.charAt(i), first, ignoreCase)) {
                while (++i <= max && !SearchMatcher.charsAreEqual(source.charAt(i), first, ignoreCase)) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end && SearchMatcher.charsAreEqual(source.charAt(j), target.charAt(k), ignoreCase)) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    private static boolean charsAreEqual(char a, char b, boolean ignoreCase) {
        return ignoreCase ? Character.toUpperCase(a) == Character.toUpperCase(b) : a == b;
    }

    private static boolean isWordSeparator(char c) {
        return Character.isWhitespace(c) || c == '.';
    }

    private static class Words {
        private int[] _wordPointers = new int[5];
        private int _wordCount = 0;
        private int _pos = 0;

        Words(CharSequence str) {
            boolean inWhitespace = true;
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                boolean whitespace = SearchMatcher.isWordSeparator(c);
                if (whitespace) {
                    inWhitespace = true;
                    continue;
                }
                if (!inWhitespace) continue;
                inWhitespace = false;
                this._wordPointers[this._wordCount] = i;
                ++this._wordCount;
                if (this._wordCount < this._wordPointers.length) continue;
                int[] tmp = new int[2 * this._wordPointers.length];
                System.arraycopy(this._wordPointers, 0, tmp, 0, this._wordPointers.length);
                this._wordPointers = tmp;
            }
        }

        boolean hasMoreWords() {
            return this._pos < this._wordCount;
        }

        int nextWordPos() {
            return this._wordPointers[this._pos++];
        }

        void reset() {
            this._pos = 0;
        }
    }

    private static final class SubstringSearchHelper
    extends SearchMatcher {
        private final boolean _ignoreCase;
        private final CharSequence _searchString;

        SubstringSearchHelper(CharSequence searchString, boolean ignoreCase) {
            this._ignoreCase = ignoreCase;
            this._searchString = searchString;
        }

        @Override
        public boolean matches(CharSequence textToSearch) {
            if (textToSearch == null) {
                throw new NullPointerException("textToSearch is null");
            }
            return SearchMatcher.indexOf(textToSearch, this._searchString, this._ignoreCase) != -1;
        }

        public String toString() {
            return String.format("%s [ignoreCase=%s, searchString=%s]", this.getClass().getSimpleName(), this._ignoreCase, this._searchString);
        }

        @Override
        public CharSequence searchString() {
            return this._searchString;
        }
    }

    private static final class PrefixSearchHelper
    extends SearchMatcher {
        private final boolean _ignoreCase;
        private final boolean _exclusive;
        private final CharSequence _searchString;
        private final Words _searchStringWords;

        PrefixSearchHelper(CharSequence searchString, boolean ignoreCase, boolean exclusive) {
            this._ignoreCase = ignoreCase;
            this._exclusive = exclusive;
            this._searchString = ((Object)searchString).toString();
            this._searchStringWords = new Words(searchString);
        }

        @Override
        public boolean matches(CharSequence textToSearch) {
            if (textToSearch == null) {
                throw new NullPointerException("textToSearch is null");
            }
            this._searchStringWords.reset();
            if (!this._searchStringWords.hasMoreWords()) {
                return false;
            }
            Words textWords = new Words(textToSearch);
            block0: while (this._searchStringWords.hasMoreWords()) {
                int sStart = this._searchStringWords.nextWordPos();
                boolean foundMatchingWord = false;
                textWords.reset();
                block1: while (textWords.hasMoreWords()) {
                    int tStart = textWords.nextWordPos();
                    int sPos = sStart;
                    for (int tPos = tStart; tPos < textToSearch.length() && sPos < this._searchString.length(); ++tPos, ++sPos) {
                        char tChar = textToSearch.charAt(tPos);
                        char sChar = this._searchString.charAt(sPos);
                        if (SearchMatcher.isWordSeparator(sChar)) {
                            if (this._exclusive) {
                                return true;
                            }
                            foundMatchingWord = true;
                            continue block0;
                        }
                        if (SearchMatcher.isWordSeparator(tChar) || !SearchMatcher.charsAreEqual(tChar, sChar, this._ignoreCase)) continue block1;
                    }
                    if (sPos != this._searchString.length()) continue block0;
                    if (this._exclusive) {
                        return true;
                    }
                    foundMatchingWord = true;
                }
                if (foundMatchingWord || this._exclusive) continue;
                return false;
            }
            return !this._exclusive;
        }

        public String toString() {
            return String.format("%s [ignoreCase=%s, exclusive=%, searchString=%s]", this.getClass().getSimpleName(), this._ignoreCase, this._exclusive, this._searchString);
        }

        @Override
        public CharSequence searchString() {
            return this._searchString;
        }
    }
}

