/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.plaf.theme;

import com.jgoodies.looks.plastic.PlasticMenuUI;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import oracle.javatools.ui.themes.Theme;
import oracle.javatools.ui.themes.Themes;

public class ThemedMenuUI
extends PlasticMenuUI {
    private final Handler _handler = new Handler();

    public static ComponentUI createUI(JComponent m) {
        return new ThemedMenuUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (Themes.isThemed()) {
            c.addMouseListener(this._handler);
            c.addPropertyChangeListener(this._handler);
        }
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        if (Themes.isThemed()) {
            c.removeMouseListener(this._handler);
            c.removePropertyChangeListener(this._handler);
        }
    }

    private void setMenuStyle(JMenu menu, boolean mouseOver) {
        String state = mouseOver ? "mouseover" : "normal";
        Theme theme = Themes.getActiveTheme();
        if (menu.getFont() instanceof UIResource) {
            Font defaultFont = UIManager.getFont("Menu.font");
            menu.setFont(theme.getStateProperties("menubar", state).getFont(defaultFont, "label"));
        }
        if (menu.getForeground() instanceof UIResource) {
            menu.setForeground(theme.getStateProperties("menubar", state).getColor("label.foreground"));
        }
        if (menu.isShowing()) {
            menu.repaint();
        }
    }

    private class Handler
    implements MouseListener,
    PropertyChangeListener {
        private Handler() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JMenu menu = (JMenu)e.getSource();
            if (menu.isTopLevelMenu()) {
                ThemedMenuUI.this.setMenuStyle(menu, true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JMenu menu = (JMenu)e.getSource();
            if (menu.isTopLevelMenu()) {
                ThemedMenuUI.this.setMenuStyle(menu, false);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            JMenu menu;
            if ("ancestor".equals(e.getPropertyName()) && (menu = (JMenu)e.getSource()).isTopLevelMenu()) {
                ThemedMenuUI.this.setMenuStyle(menu, false);
            }
        }
    }
}

