/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.internal;

import java.awt.Component;
import java.lang.reflect.Method;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;

final class ReflectiveCellRenderer
extends DefaultListCellRenderer {
    private Method _method;
    private Object[] _parameters;

    public ReflectiveCellRenderer(Class objectClass, String methodName) {
        try {
            this._method = objectClass.getMethod(methodName, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ReflectiveCellRenderer(Class objectClass, String methodName, Class[] paramClasses, Object[] params) {
        try {
            this._method = objectClass.getMethod(methodName, paramClasses);
            this._parameters = params;
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        try {
            Object ret;
            if (this._method != null && (ret = this._method.invoke(value, this._parameters)) != null) {
                label.setText(ret.toString());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return label;
    }
}

