/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.ghost;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.UIManager;
import oracle.javatools.ui.ColorUtils2;

public final class UIConstants {
    public static String VETO_CONVERSION = "VETO_CONVERSION";
    public static String VETO_HIERARCHY_CONVERSION = "VETO_HIERARCHY_CONVERSION";
    public static String GHOST_LOOK = "GHOST_LOOK";
    public static String INSTRUCTION_LABEL = "INSTRUCTION_LABEL";
    public static String ICON_BUTTON = "ICON_BUTTON";
    public static final int SHADOW_OFFSET = 6;
    public static final float ALPHA_NORMAL = 0.93f;
    public static final float ALPHA_ALMOST_CLEAR = 0.12f;
    public static final String TITLE_FOREGROUND = "ghost.title.foreground";
    public static final String TITLE_BACKGROUND = "ghost.title.background";
    public static final String TITLE_FONT = "ghost.title.font";
    public static final String PANEL_BACKGROUND = "ghost.panel.background";
    public static final String PANEL_HIGHLIGHT = "ghost.panel.highlight";
    public static final String PANEL_SHADOW = "ghost.panel.shadow";
    public static final String PANEL_BORDER = "ghost.panel.border";
    public static final String SELECTION_BACKGROUND = "ghost.selection.background";
    public static final String SELECTION_FOREGROUND = "ghost.selection.text";
    public static final String TRANSPARENT_COLOR = "ghost.transparent";
    public static final String TEXT_FOREGROUND = "ghost.text.foreground";
    public static final String CARET_FOREGROUND = "ghost.caret.foreground";
    public static final String INSTRUCTION_TEXT_FOREGROUND = "ghost.instruction.foreground";
    public static final String SCROLLBAR_THUMB_SHADOW = "ghost.scrollbar.thumb.shadow";
    public static final String SCROLLBAR_THUMB = "ghost.scrollbar.thumb";
    public static final String SCROLLBAR_TRACK = "ghost.scrollbar.track";
    public static final String SCROLLBAR_TRACK_HIGHLIGHT = "ghost.scrollbar.track.highlight";
    public static final String SCROLLBAR_BUTTON = "ghost.scrollbar.button";
    public static final String SCROLLBAR_MIN_THUMB_SIZE = "ghost.scrollbar.thumb.min";
    public static final String BUTTON_BORDER = "ghost.button.border";
    public static final String BUTTON_DISABLED_BORDER = "ghost.button.disabled.border";
    public static final String BUTTON_BACKGROUND = "ghost.button.background";
    public static final String BUTTON_DOWN_BACKGROUND = "ghost.button.down.background";

    public static Color getColor(String key, Look look) {
        Color c = UIManager.getColor(look.name() + key);
        if (c == null) {
            c = UIManager.getColor(key);
        }
        return c;
    }

    public static Font getFont(String key, Look look) {
        Font f = UIManager.getFont(look.name() + key);
        if (f == null) {
            f = UIManager.getFont(key);
        }
        return f;
    }

    public static Dimension getDimension(String key, Look look) {
        Dimension d = UIManager.getDimension(look.name() + key);
        if (d == null) {
            d = UIManager.getDimension(key);
        }
        return d;
    }

    static {
        UIManager.put(TITLE_FOREGROUND, Color.WHITE);
        UIManager.put(TITLE_BACKGROUND, new Color(255, 255, 255));
        UIManager.put(TITLE_FONT, UIManager.getFont("Label.font").deriveFont(1));
        UIManager.put(PANEL_BACKGROUND, new Color(204, 204, 204));
        UIManager.put(PANEL_SHADOW, new Color(153, 153, 153));
        UIManager.put(PANEL_BORDER, new Color(153, 153, 153));
        UIManager.put(PANEL_HIGHLIGHT, new Color(255, 255, 255));
        UIManager.put(SELECTION_BACKGROUND, new Color(255, 255, 255, 220));
        UIManager.put(SELECTION_FOREGROUND, new Color(0, 0, 0));
        UIManager.put(TRANSPARENT_COLOR, new Color(0, 0, 0, 0));
        UIManager.put(TEXT_FOREGROUND, new Color(255, 255, 255));
        UIManager.put(CARET_FOREGROUND, new Color(255, 255, 255));
        UIManager.put(INSTRUCTION_TEXT_FOREGROUND, new Color(102, 102, 102));
        UIManager.put(SCROLLBAR_TRACK_HIGHLIGHT, new Color(255, 255, 255, 64));
        UIManager.put(SCROLLBAR_THUMB_SHADOW, new Color(255, 255, 255, 96));
        UIManager.put(SCROLLBAR_THUMB, new Color(255, 255, 255, 128));
        UIManager.put(SCROLLBAR_TRACK, new Color(255, 255, 255, 32));
        UIManager.put(SCROLLBAR_BUTTON, new Color(255, 255, 255, 128));
        UIManager.put(SCROLLBAR_MIN_THUMB_SIZE, new Dimension(20, 20));
        UIManager.put(BUTTON_BORDER, new Color(102, 102, 102));
        UIManager.put(BUTTON_DISABLED_BORDER, new Color(153, 153, 153));
        UIManager.put(BUTTON_BACKGROUND, new Color(255, 255, 255, 102));
        UIManager.put(BUTTON_DOWN_BACKGROUND, new Color(0, 0, 0, 68));
        UIManager.put(Look.LIGHT.name() + TITLE_FOREGROUND, UIManager.getColor("Label.foreground"));
        UIManager.put(Look.LIGHT.name() + PANEL_BACKGROUND, ColorUtils2.shadeColor((Color)UIManager.getColor("Panel.background"), (int)-33));
        UIManager.put(Look.LIGHT.name() + SELECTION_BACKGROUND, ColorUtils2.alphaColor(UIManager.getColor("TextArea.selectionBackground"), 220));
        UIManager.put(Look.LIGHT.name() + SELECTION_FOREGROUND, UIManager.getColor("TextArea.selectionForeground"));
        UIManager.put(Look.LIGHT.name() + TEXT_FOREGROUND, UIManager.getColor("Label.foreground"));
        UIManager.put(Look.LIGHT.name() + CARET_FOREGROUND, UIManager.getColor("Label.foreground"));
        Color scrollBase = UIManager.getColor("Label.foreground");
        UIManager.put(Look.LIGHT.name() + SCROLLBAR_TRACK_HIGHLIGHT, ColorUtils2.alphaColor(scrollBase, 64));
        UIManager.put(Look.LIGHT.name() + SCROLLBAR_THUMB_SHADOW, ColorUtils2.alphaColor(scrollBase, 96));
        UIManager.put(Look.LIGHT.name() + SCROLLBAR_THUMB, ColorUtils2.alphaColor(scrollBase, 128));
        UIManager.put(Look.LIGHT.name() + SCROLLBAR_TRACK, ColorUtils2.alphaColor(scrollBase, 16));
        UIManager.put(Look.LIGHT.name() + SCROLLBAR_BUTTON, ColorUtils2.alphaColor(scrollBase, 128));
        Color baseColor = UIManager.getColor("TextArea.selectionBackground");
        if (ColorUtils2.getApproximateLuminance((Color)baseColor) < 128) {
            baseColor = ColorUtils2.saturateColor(baseColor, 45.0);
            baseColor = ColorUtils2.shadeColor((Color)baseColor, (int)-40);
        } else {
            baseColor = ColorUtils2.shadeColor((Color)baseColor, (int)-40);
        }
        UIManager.put(Look.DARK.name() + TITLE_FOREGROUND, Color.WHITE);
        UIManager.put(Look.DARK.name() + PANEL_BACKGROUND, baseColor);
        UIManager.put(Look.DARK.name() + PANEL_BORDER, ColorUtils2.shadeColor((Color)baseColor, (int)40));
        UIManager.put(Look.DARK.name() + PANEL_HIGHLIGHT, ColorUtils2.shadeColor((Color)baseColor, (int)80));
        UIManager.put(Look.DARK.name() + SELECTION_BACKGROUND, ColorUtils2.alphaColor(UIManager.getColor("TextArea.selectionForeground"), 180));
        Color bgSel = ColorUtils2.getApproximateLuminance((Color)UIManager.getColor("TextArea.selectionForeground")) < 128 ? Color.WHITE : Color.BLACK;
        UIManager.put(Look.DARK.name() + SELECTION_FOREGROUND, bgSel);
        UIManager.put(Look.DARK.name() + TEXT_FOREGROUND, UIManager.getColor("TextArea.selectionForeground"));
        UIManager.put(Look.DARK.name() + CARET_FOREGROUND, UIManager.getColor("TextArea.selectionForeground"));
    }

    public static enum Look {
        DARK,
        LIGHT;

    }
}

