/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.ghost;

import javax.accessibility.AccessibleContext;
import javax.swing.JLabel;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.ghost.UIConstants;

final class GhostTitle
extends JLabel {
    public GhostTitle(UIConstants.Look look) {
        this.setOpaque(false);
        this.setLayout(null);
        this.setForeground(UIConstants.getColor("ghost.title.foreground", look));
        this.setFont(UIConstants.getFont("ghost.title.font", look));
        this.setLocation(0, 0);
        if (GhostTitle.isAssistiveTechnologySet()) {
            this.setFocusable(true);
        }
    }

    static boolean isAssistiveTechnologySet() {
        return System.getProperty("javax.accessibility.assistive_technologies") != null;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleGhostTitle();
        }
        return this.accessibleContext;
    }

    private class AccessibleGhostTitle
    extends JLabel.AccessibleJLabel {
        private AccessibleGhostTitle() {
            super(GhostTitle.this);
        }

        @Override
        public String getAccessibleName() {
            return UIBundle.get("GHOST_WINDOW_TITLE") + " : " + GhostTitle.this.getText();
        }
    }
}

