/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.ghost;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;
import oracle.javatools.ui.ghost.UIConstants;

final class GhostButtonUI
extends BasicButtonUI {
    private static final GhostButtonUI buttonUI = new GhostButtonUI();
    private static final int ROUNDEDNESS = 6;
    private static final Insets insets = new Insets(0, 0, 1, 1);

    GhostButtonUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return buttonUI;
    }

    @Override
    public void paint(Graphics g, JComponent comp) {
        boolean isIconButton;
        AbstractButton b = (AbstractButton)comp;
        boolean bl = isIconButton = b.getClientProperty(UIConstants.ICON_BUTTON) == Boolean.TRUE;
        if (!b.getModel().isPressed() && comp.isEnabled() && !isIconButton) {
            UIConstants.Look look = (UIConstants.Look)((Object)comp.getClientProperty(UIConstants.GHOST_LOOK));
            Color c = UIConstants.getColor("ghost.button.background", look);
            this.fillBackground(g, b, c);
        }
        super.paint(g, comp);
        if (!isIconButton || b.getModel().isRollover()) {
            this.paintBorder(g, comp);
        }
    }

    @Override
    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        UIConstants.Look look = (UIConstants.Look)((Object)b.getClientProperty(UIConstants.GHOST_LOOK));
        b.setForeground(b.isEnabled() ? UIConstants.getColor("ghost.title.foreground", look) : UIConstants.getColor("ghost.button.background", look));
        this.paintText(g, (JComponent)b, textRect, text);
    }

    protected void paintBorder(Graphics g, JComponent c) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(0.75f));
        g.setClip(0, 0, c.getWidth(), c.getHeight());
        UIConstants.Look look = (UIConstants.Look)((Object)c.getClientProperty(UIConstants.GHOST_LOOK));
        Color color = c.isEnabled() ? UIConstants.getColor("ghost.button.border", look) : UIConstants.getColor("ghost.button.disabled.border", look);
        g2.setColor(color);
        g2.drawRoundRect(GhostButtonUI.insets.left, GhostButtonUI.insets.top, c.getWidth() - GhostButtonUI.insets.left - GhostButtonUI.insets.right, c.getHeight() - GhostButtonUI.insets.top - GhostButtonUI.insets.bottom, 6, 6);
        g2.dispose();
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        UIConstants.Look look = (UIConstants.Look)((Object)b.getClientProperty(UIConstants.GHOST_LOOK));
        Color c = UIConstants.getColor("ghost.button.down.background", look);
        this.fillBackground(g, b, c);
    }

    private void fillBackground(Graphics g, AbstractButton b, Color c) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setColor(c);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(1.0f));
        g.setClip(0, 0, b.getWidth(), b.getHeight());
        g2.fillRoundRect(GhostButtonUI.insets.left, GhostButtonUI.insets.top, b.getWidth() - GhostButtonUI.insets.left - GhostButtonUI.insets.right, b.getHeight() - GhostButtonUI.insets.top - GhostButtonUI.insets.bottom, 6, 6);
        g2.dispose();
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        g.setColor(UIManager.getColor("Button.focus"));
        g.drawRect(textRect.x - 2, textRect.y + 1, textRect.width + 2, textRect.height - 2);
    }
}

