/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.ghost;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.lang.ref.SoftReference;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import oracle.javatools.ui.ghost.GhostPalette;
import oracle.javatools.ui.ghost.UIConstants;

final class GhostBorder
extends AbstractBorder {
    private static final int TITLE_HEIGHT = 18;
    private static int INSET = 2;
    private static int THICKNESS = 3;
    private static int ROUNDEDNESS = 10;
    private SoftReference<BufferedImage> shadowImageRef = new SoftReference<Object>(null);
    private SoftReference<BufferedImage> backgroundImageRef = new SoftReference<Object>(null);

    GhostBorder() {
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        GhostPalette gp = (GhostPalette)c;
        RoundRectangle2D.Float shape = new RoundRectangle2D.Float(0 + INSET, 0 + INSET, width - 2 * INSET - 6, height - 2 * INSET - 6, ROUNDEDNESS, ROUNDEDNESS);
        BufferedImage backgroundImage = this.getCachedImage(this.backgroundImageRef, width + 6, height + 6);
        Graphics2D g2 = backgroundImage.createGraphics();
        this.paintShadow(gp, g2, shape);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setComposite(AlphaComposite.getInstance(3, 0.93f));
        this.paintBackground(width, height, gp, shape, g2);
        this.paintBoundary(width, height, gp.getLook(), shape, g2);
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        this.paintClearComponents(c, gp, g2);
        g2.dispose();
        g.drawImage(backgroundImage, 0, 0, null);
    }

    private void paintClearComponents(Component c, GhostPalette gp, Graphics2D g2) {
        g2.setComposite(AlphaComposite.Clear);
        for (JComponent comp : gp.getTransparentComponents()) {
            Rectangle thatR = comp.getBounds();
            Rectangle thisR = SwingUtilities.convertRectangle(comp.getParent(), thatR, gp);
            g2.fill(thisR);
        }
    }

    private void paintBoundary(int width, int height, UIConstants.Look look, Shape shape, Graphics2D g2) {
        g2.setClip(0, 0, width, height);
        g2.setColor(UIConstants.getColor("ghost.panel.border", look));
        g2.setStroke(new BasicStroke(1.0f));
        g2.draw(shape);
    }

    private void paintBackground(int width, int height, GhostPalette gp, Shape shape, Graphics2D g2) {
        g2.setColor(UIConstants.getColor("ghost.panel.background", gp.getLook()));
        int SOLID_FILL_HEIGHT = 0;
        int y0 = SOLID_FILL_HEIGHT + 18;
        g2.setComposite(AlphaComposite.getInstance(3, 0.6975f));
        g2.setClip(0, y0, width, height - y0);
        g2.fill(shape);
        GradientPaint gradP = new GradientPaint(0.0f, SOLID_FILL_HEIGHT, UIConstants.getColor("ghost.panel.highlight", gp.getLook()), 0.0f, y0, UIConstants.getColor("ghost.panel.background", gp.getLook()));
        g2.setPaint(gradP);
        g2.setClip(0, 0, width, y0);
        g2.fill(shape);
    }

    private void paintShadow(GhostPalette panel, Graphics2D g2, Shape shape) {
        Rectangle shadowR = shape.getBounds();
        BufferedImage shadowImage = this.getCachedImage(this.shadowImageRef, shadowR.width + 12, shadowR.height + 12);
        Graphics2D shadowG = shadowImage.createGraphics();
        shadowG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        shadowG.setColor(new Color(0, 0, 0));
        shadowG.translate(-shadowR.x + 6, -shadowR.y + 6);
        shadowG.fill(shape);
        shadowG.translate(shadowR.x - 6, shadowR.y - 6);
        float i = 0.04f;
        float[] elements = new float[]{i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i};
        Kernel myKernel = new Kernel(5, 5, elements);
        ConvolveOp simpleBlur = new ConvolveOp(myKernel);
        g2.setComposite(AlphaComposite.getInstance(3, 0.93f * panel.getFadeAmount() * 0.2f));
        g2.drawImage(shadowImage, simpleBlur, shadowR.x, shadowR.y);
        shadowG.dispose();
        g2.setComposite(AlphaComposite.Clear);
        g2.fill(shape);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        int edge = (int)((double)(INSET + ROUNDEDNESS) / Math.PI) + THICKNESS;
        int top = c instanceof GhostPalette && ((GhostPalette)c).getTitle() != null ? 18 + edge : edge;
        return new Insets(top + INSET + THICKNESS, edge, edge + 6, edge + 6);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        return this.getBorderInsets(c);
    }

    public static Rectangle getInteriorRectangle(Component c, Border b, int x, int y, int width, int height) {
        Insets insets = b != null ? b.getBorderInsets(c) : new Insets(0, 0, 0, 0);
        return new Rectangle(x + insets.left, y + insets.top, width - insets.right - insets.left, height - insets.top - insets.bottom);
    }

    private BufferedImage getCachedImage(SoftReference<BufferedImage> imageRef, int width, int height) {
        BufferedImage image = imageRef.get();
        if (image != null && (image.getWidth() != width || image.getHeight() != height)) {
            image = null;
        }
        if (image == null) {
            image = new BufferedImage(width, height, 2);
            imageRef = new SoftReference<BufferedImage>(image);
        }
        return image;
    }
}

