/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.combo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.javatools.ui.combo.CheckComboModel;
import oracle.javatools.ui.combo.JCustomComboBox;

public class JCheckCombo
extends JCustomComboBox {
    private TableCombo table;
    private ListSelectionModel selList;
    private JScrollPane sp;
    private int visibleRowCount = 8;

    public JCheckCombo() {
        this.init();
    }

    public JCheckCombo(ListModel listModel, ListSelectionModel selModel) {
        this.init();
        this.setModel(listModel, selModel);
    }

    public JCheckCombo(ListModel listModel) {
        this.init();
        this.setModel(listModel);
    }

    public void setModel(ListModel listModel, ListSelectionModel selModel) {
        CheckComboModel model = new CheckComboModel(listModel, selModel);
        this.setModel(model);
    }

    public void setModel(ListModel listModel) {
        CheckComboModel model = new CheckComboModel(listModel);
        this.setModel(model);
    }

    public void setModel(CheckComboModel model) {
        this.selList = model.getSelectionModel();
        super.setModel(model);
        this.table.setModel(model);
        int colWidth = UIManager.getIcon("CheckBox.icon").getIconWidth();
        this.table.getColumnModel().getColumn(0).setMaxWidth(colWidth);
    }

    public void setPoppedRenderer(TableCellRenderer aRenderer) {
        this.table.setCellRenderer(aRenderer);
    }

    private void init() {
        JPanel panel = new JPanel(new BorderLayout());
        this.table = new TableCombo();
        this.table.setRowSelectionAllowed(true);
        this.table.setTableHeader(null);
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        this.table.setShowGrid(false);
        this.table.setFocusable(false);
        this.table.setSelectionMode(0);
        this.sp = new JScrollPane(this.table, 20, 30);
        this.sp.setBorder(BorderFactory.createEmptyBorder());
        panel.add((Component)this.sp, "North");
        this.setPopupComponent(panel);
        this.table.addMouseMotionListener(new ListMouseListener());
        this.table.addMouseListener(new TableClickListener());
        this.addKeyListener(new CheckComboKeyListener());
        this.setRenderer(new UnpoppedRenderer());
        this.setPoppedRenderer(new DefaultTableCellRenderer());
    }

    protected void updatePopupPreferredSize() {
        int prefW = this.table.getPreferredSize().width;
        Dimension newD = new Dimension(prefW += this.table.getRowCount() > this.visibleRowCount ? this.sp.getVerticalScrollBar().getPreferredSize().width : 6, this.table.getRowHeight() * Math.min(this.visibleRowCount, this.table.getRowCount()));
        if (prefW < this.getWidth()) {
            newD.width = Math.max(newD.width, this.getWidth() - 2);
            if (this.table.getRowCount() > this.visibleRowCount) {
                newD.width = Math.max(prefW, newD.width - this.sp.getVerticalScrollBar().getPreferredSize().width);
            }
        }
        this.sp.getViewport().setPreferredSize(newD);
    }

    @Override
    public void firePopupMenuWillBecomeVisible() {
        this.updatePopupPreferredSize();
        Object selObj = this.getSelectedItem();
        ((CheckComboModel)this.getModel()).setSelectedItem(selObj);
        super.firePopupMenuWillBecomeVisible();
    }

    @Override
    public void firePopupMenuWillBecomeInvisible() {
        super.firePopupMenuWillBecomeInvisible();
    }

    private void toggleSelection(int index) {
        if (this.selList.isSelectedIndex(index)) {
            this.selList.removeSelectionInterval(index, index);
        } else {
            this.selList.addSelectionInterval(index, index);
        }
        this.table.repaint();
        this.repaint();
    }

    public void setVisibleRowCount(int visibleRowCount) {
        this.visibleRowCount = visibleRowCount;
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    public ListSelectionModel getSelectionModel() {
        return this.selList;
    }

    public CheckComboModel getCheckModel() {
        return (CheckComboModel)this.table.getModel();
    }

    public ComboBoxModel getModel() {
        if (this.table == null) {
            return super.getModel();
        }
        return this.getCheckModel();
    }

    public class UnpoppedRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            String s = "";
            for (int i = 0; i < JCheckCombo.this.table.getRowCount(); ++i) {
                if (!JCheckCombo.this.selList.isSelectedIndex(i)) continue;
                if (s.length() != 0) {
                    s = s + ", ";
                }
                s = s + JCheckCombo.this.table.getValueAt(i, 1);
            }
            if (s.length() == 0) {
                s = " ";
                this.setToolTipText(null);
            } else {
                JCheckCombo.this.setToolTipText(s);
            }
            label.setText(s);
            return label;
        }
    }

    private class CheckBoxCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public CheckBoxCellRenderer() {
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 0));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Boolean) {
                this.setSelected((Boolean)value);
            }
            return this;
        }
    }

    private class TableCombo
    extends JTable {
        private TableCellRenderer _renderer;

        private TableCombo() {
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            if (column == 0) {
                return new DefaultCellEditor(new JCheckBox());
            }
            return super.getCellEditor(row, column);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            if (column == 0) {
                return new CheckBoxCellRenderer();
            }
            if (this._renderer != null) {
                return this._renderer;
            }
            return super.getCellRenderer(row, column);
        }

        public void setCellRenderer(TableCellRenderer renderer) {
            this._renderer = renderer;
        }
    }

    private class CheckComboKeyListener
    extends KeyAdapter {
        private CheckComboKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 40) {
                int newSel = JCheckCombo.this.table.getSelectedRow() + 1;
                if (newSel < JCheckCombo.this.table.getRowCount()) {
                    JCheckCombo.this.table.getSelectionModel().setSelectionInterval(newSel, newSel);
                    JCheckCombo.this.table.scrollRectToVisible(JCheckCombo.this.table.getCellRect(newSel, 2, true));
                }
            } else if (e.getKeyCode() == 38) {
                int newSel = JCheckCombo.this.table.getSelectedRow() - 1;
                if (newSel >= 0) {
                    JCheckCombo.this.table.getSelectionModel().setSelectionInterval(newSel, newSel);
                    JCheckCombo.this.table.scrollRectToVisible(JCheckCombo.this.table.getCellRect(newSel, 2, true));
                }
            } else if (e.getKeyCode() == 32) {
                int sel = JCheckCombo.this.table.getSelectedRow();
                JCheckCombo.this.toggleSelection(sel);
                e.consume();
            }
        }
    }

    private class TableClickListener
    extends MouseAdapter {
        private TableClickListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int index = JCheckCombo.this.table.rowAtPoint(e.getPoint());
            JCheckCombo.this.toggleSelection(index);
            e.consume();
        }
    }

    private class ListMouseListener
    extends MouseMotionAdapter {
        private ListMouseListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int index = JCheckCombo.this.table.rowAtPoint(e.getPoint());
            JCheckCombo.this.table.getSelectionModel().setSelectionInterval(index, index);
        }
    }
}

