/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.checklist.test;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.olaf2.OracleLookAndFeel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.util.WindowUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.checklist.Checklist;
import oracle.javatools.ui.checklist.ChecklistModel;
import oracle.javatools.ui.checklist.ContentActionEvent;
import oracle.javatools.ui.checklist.ContentActionListener;
import oracle.javatools.ui.checklist.ContentElement;
import oracle.javatools.ui.checklist.DefaultChecklistModel;
import oracle.javatools.ui.checklist.Step;
import oracle.javatools.ui.checklist.TaskContent;
import oracle.javatools.ui.checklist.TaskContentProvider;
import oracle.javatools.ui.checklist.xml.XMLChecklist;

class UICChecklistDemoPanel
extends JPanel {
    public UICChecklistDemoPanel() {
        this.setBackground(Color.white);
        JTabbedPane pane = new JTabbedPane();
        pane.setOpaque(false);
        pane.setBackground(Color.white);
        JPanel p = new JPanel(new BorderLayout());
        Checklist c1 = this._createChecklist();
        p.add((Component)c1, "Center");
        p.setBorder(BorderFactory.createMatteBorder(8, 8, 8, 8, Color.white));
        pane.add("Basic Checklist", p);
        p = new JPanel(new BorderLayout());
        XMLChecklist c2 = this._createXMLChecklist();
        p.add((Component)c2, "Center");
        p.setBorder(BorderFactory.createMatteBorder(8, 8, 8, 8, Color.white));
        pane.add("XMLChecklist", p);
        this.setLayout(new BorderLayout());
        this.add(pane);
        JButton b = new JButton("Hide");
        this.add((Component)b, "South");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
            }
        });
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new OracleLookAndFeel());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JFrame frame = new JFrame("Checklist Demo");
        frame.add(new UICChecklistDemoPanel());
        frame.setDefaultCloseOperation(3);
        frame.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        frame.setVisible(true);
    }

    private Checklist _createChecklist() {
        ChecklistModel model = this._createChecklistModel();
        Checklist list = new Checklist(model);
        list.setChecklistModel(model);
        this.setLayout(new BorderLayout());
        this.add(list);
        list.setHeaderText("Fusion Web Application Quick start Checklist");
        list.setHeaderDescription("Create the application by following step-by-step instructions describing how to build Fusion Web Applicationsaccording to Oracle best practice recommendations.");
        list.setHeaderIcon(new ImageIcon(ImageUtils.getImageResource(UICChecklistDemoPanel.class, (String)"header.png")));
        list.addContentActionListener(new LinkAdapter());
        return list;
    }

    private ChecklistModel _createChecklistModel() {
        DefaultChecklistModel model = new DefaultChecklistModel();
        Step step1 = new Step();
        step1.setIcon(new ImageIcon(ImageUtils.getImageResource(UICChecklistDemoPanel.class, (String)"stepicon.png")));
        step1.setTitle("Plan Your Application");
        step1.setContent(this._getStepContent(step1));
        model.addStep(step1);
        Step step2 = new Step();
        step2.setIcon(new ImageIcon(ImageUtils.getImageResource(UICChecklistDemoPanel.class, (String)"stepicon.png")));
        step2.setTitle("Connect to a Database");
        step2.setContent(this._getStepContent(step2));
        model.addStep(step2);
        Step step3 = new Step();
        step3.setIcon(new ImageIcon(ImageUtils.getImageResource(UICChecklistDemoPanel.class, (String)"stepicon.png")));
        step3.setTitle("Build Business Services");
        step3.setContent(this._getStepContent(step3));
        model.addStep(step3);
        Step step4 = new Step();
        step4.setIcon(new ImageIcon(ImageUtils.getImageResource(UICChecklistDemoPanel.class, (String)"stepicon.png")));
        step4.setTitle("Design Page Flow");
        step4.setContent(this._getStepContent(step4));
        model.addStep(step4);
        Step step5 = new Step();
        step5.setIcon(new ImageIcon(ImageUtils.getImageResource(UICChecklistDemoPanel.class, (String)"stepicon.png")));
        step5.setTitle("Design Pages");
        step5.setContent(this._getStepContent(step5));
        model.addStep(step5);
        Step step6 = new Step();
        step6.setIcon(new ImageIcon(ImageUtils.getImageResource(UICChecklistDemoPanel.class, (String)"stepicon.png")));
        step6.setTitle("Add Common Components - With SubSteps");
        this._setSubStepsForStep6(step6);
        step6.setContent(this._getStepContent(step6));
        model.addStep(step6);
        Step step7 = new Step();
        step7.setIcon(new ImageIcon(ImageUtils.getImageResource(UICChecklistDemoPanel.class, (String)"stepicon.png")));
        step7.setTitle("Implement Business Logic");
        step7.setContent(this._getStepContent(step7));
        model.addStep(step7);
        Step step8 = new Step();
        step8.setIcon(new ImageIcon(ImageUtils.getImageResource(UICChecklistDemoPanel.class, (String)"stepicon.png")));
        step8.setTitle("Secure Your Application");
        step8.setContent(this._getStepContent(step8));
        model.addStep(step8);
        Step step9 = new Step();
        step9.setIcon(new ImageIcon(ImageUtils.getImageResource(UICChecklistDemoPanel.class, (String)"stepicon.png")));
        step9.setTitle("Debug and Test Your application");
        step9.setContent(this._getStepContent(step9));
        model.addStep(step9);
        Step step10 = new Step();
        step10.setIcon(new ImageIcon(ImageUtils.getImageResource(UICChecklistDemoPanel.class, (String)"stepicon.png")));
        step10.setTitle("Package and Deploy Your Application - Step Disabled");
        step10.setContent(this._getStepContent(step10));
        model.addStep(step10);
        step10.setEnabled(false);
        return model;
    }

    private TaskContent _getStepContent(Step step) {
        TaskContentProvider provider = new TaskContentProvider();
        provider.setImage(ImageUtils.getImageResource(UICChecklistDemoPanel.class, (String)"cimage.png"));
        provider.setDescription("A brief description. ief description. A brief description.A brief description. ief description. A brief description. A brief description. ie iff description. A brief description. A brief description. ie ff description.description. A brief description. ie iff description. A brief description. A brief description. ie iff description. A brief description. A brief description. ie iff description. A brief description. A brief description. ie iff description. A brief ");
        ArrayList<String> v = new ArrayList<String>();
        v.add("This is a <a href=\"http:helpId\">possible </a>prerequisite");
        v.add("This is another possible prerequisite");
        v.add("This is even yet another possible prerequisite that you should do sajkdsakjd adasjkd klasdjasdj ashd k");
        provider.setRequirements("Prerequisites and KeyAssumptions", v);
        ArrayList<String> v1 = new ArrayList<String>();
        v1.add("This is a possible next step");
        v1.add("This is another possible option");
        v1.add("This is even yet another possible thing that you might do This is even yet another possible prerequisite that you should do sajkdsakjd adasjkd klasdjasdj ashd k. This is even yet another possible thing that you might do This is even yet another possible prerequisite that you should do sajkdsakjd adasjkd klasdjasdj ashd k");
        provider.setSummary("Possible Next Steps", v1);
        provider.addContentElement(new ContentElement("step_by_step", ContentElement.Type.HYPERLINK, "Step-by-Step Instructions", OracleIcons.getIcon((String)"database.png"), "http://Step"));
        provider.addContentElement(new ContentElement("describe_what_i_see", ContentElement.Type.HYPERLINK, "Describe What I See in the IDE", OracleIcons.getIcon((String)"action.png"), "http://Step", "More about what happens when you create entity objectsMore about what happens when you create entity objects."));
        provider.addContentElement(new ContentElement("dev_guide", ContentElement.Type.HYPERLINK, "Developer\u2019s Guide", OracleIcons.getIcon((String)"chooseDate.png"), "http://Step"));
        provider.addContentElement(new ContentElement("dev_guide", ContentElement.Type.ACTIONBUTTON, "Create Entity Object", OracleIcons.getIcon((String)"entityObject.png"), "http://Step", "File,New"));
        provider.addContentElement(new ContentElement("dev_guide", ContentElement.Type.ACTIONBUTTON, "Create Business Components from Table", OracleIcons.getIcon((String)"viewObject.png"), "http://Step", "File,New"));
        provider.addContentElement(new ContentElement("dev_guide", ContentElement.Type.ACTIONBUTTON, "Create View Objects", OracleIcons.getIcon((String)"viewObject.png"), "http://Step", "File , New"));
        TaskContent content = new TaskContent(step, provider);
        content.addContentActionListener(new ContentActionListener(){

            @Override
            public void contentActionPerformed(ContentActionEvent le) {
                System.out.println("Listener attached to TaskContent's " + le.getContentElement());
            }
        });
        return content;
    }

    private void _setSubStepsForStep6(Step step) {
        Step[] substeps = new Step[3];
        substeps[0] = new Step();
        substeps[0].setTitle("Create a Lookup");
        substeps[0].setContent(this._getStepContent(substeps[0]));
        step.addSubstep(substeps[0]);
        substeps[1] = new Step();
        substeps[1].setTitle("Create a Search Form");
        substeps[1].setContent(this._getStepContent(substeps[1]));
        step.addSubstep(substeps[1]);
        substeps[2] = new Step();
        substeps[2].setTitle("Create a Menu");
        substeps[2].setContent(this._getStepContent(substeps[2]));
        step.addSubstep(substeps[2]);
    }

    private XMLChecklist _createXMLChecklist() {
        String fileName = "fusionchecklistsample.xml";
        InputStreamReader stream = new InputStreamReader(UICChecklistDemoPanel.class.getResourceAsStream(fileName));
        XMLChecklist list = new XMLChecklist(stream);
        list.addContentActionListener(new LinkAdapter());
        return list;
    }

    private class LinkAdapter
    implements ContentActionListener {
        private LinkAdapter() {
        }

        @Override
        public void contentActionPerformed(ContentActionEvent le) {
            JEWTDialog d = new JEWTDialog(WindowUtils.parentFrame((Component)((Checklist)le.getSource())));
            d.setTitle("Testing Links and Buttons");
            JPanel p = new JPanel(new BorderLayout(15, 15));
            MultiLineLabel label = new MultiLineLabel();
            label.setText("Testing Links and Buttons. In Real application, this will take to a help doc or external link or a wizard");
            p.add((Component)label, "North");
            MultiLineLabel blabel = new MultiLineLabel(){

                public Font getFont() {
                    Font f = super.getFont();
                    if (f != null) {
                        f = f.deriveFont(1);
                    }
                    return f;
                }
            };
            StringBuffer text = new StringBuffer("Current Checklist : " + ((Checklist)le.getSource()).getHeaderText());
            text.append("\n");
            text.append("Current Step : " + ((Checklist)le.getSource()).getSelectedStep().getTitle());
            text.append("\n");
            text.append("LinkId: " + le.getContentElement().getId());
            text.append("\n");
            text.append("LinkLabel: " + le.getContentElement().getLabel());
            text.append("\n");
            text.append("LinkTarget: " + le.getContentElement().getTarget());
            text.append("\n");
            text.append("LinkDescription: " + le.getContentElement().getHint());
            text.append("\n");
            blabel.setText(text.toString());
            p.add((Component)blabel);
            d.setContent((Component)p);
            d.runDialog();
        }
    }
}

