/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.checklist;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.painter.ColorChange;
import oracle.bali.ewt.painter.FilledRectPainter;
import oracle.bali.ewt.painter.IconPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.PainterComponent;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.checklist.StatusButton;
import oracle.javatools.ui.checklist.Step;

public final class StepHeader
extends LWComponent
implements Accessible {
    private static final Painter _BG_PAINTER = new BgPainter();
    private static final String _STATUS_KEY = "_Status_Key";
    private static final Dimension _ICON_SIZE = new Dimension(10, 10);
    private static int _sStatusLabelPrefWidth = -1;
    private static Icon _sCollapsedIcon;
    private static Icon _sExpandedIcon;
    private Step _step;
    private boolean _complexHeader;
    private boolean _showStatus;
    private boolean _mouseOver;
    private boolean _expandable;
    private JLabel _indexLabel;
    private JSeparator _separator;
    private IconComponent _expandLabel;
    private JLabel _stepIcon;
    private JLabel _stepTitle;
    private StatusButton _statusLabel;
    private JComboBox _statusBox;
    private HeaderBand _band;
    private Listener _listener;

    public StepHeader(Step step) {
        this._step = step;
        this._showStatus = true;
        this._createUI();
        this.setFill(_BG_PAINTER);
    }

    public Step getStep() {
        return this._step;
    }

    public void setShowStatus(boolean show) {
        if (show != this.getShowStatus()) {
            this._showStatus = show;
            this._layoutStatus();
        }
    }

    public boolean getShowStatus() {
        return this._showStatus;
    }

    public int getPaintState() {
        int state = super.getPaintState();
        if (this._step.getAllowsSubsteps() && this._step.isSelected() || this.isComplexHeader()) {
            state |= 0x20;
        }
        if (this._mouseOver) {
            state |= 0x10;
        }
        return state;
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.height = this._step.getAllowsSubsteps() ? 45 : 27;
        return size;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void paintOverChildren(Graphics g) {
        Color oldColor = g.getColor();
        if (this.getStep().isSelected()) {
            g.setColor(new Color(49, 106, 196));
            g.drawLine(0, 0, this.getWidth() - 1, 0);
        }
        if (this.getStep().isExpanded()) {
            g.setColor(new Color(204, 204, 204));
            g.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
        }
        g.setColor(oldColor);
    }

    public void setLayout(LayoutManager lm) {
        throw new IllegalArgumentException("Client should not call setLayout");
    }

    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this._indexLabel.setEnabled(enable);
        this._stepIcon.setEnabled(enable);
        this._stepTitle.setEnabled(enable);
        this._statusLabel.setEnabled(enable);
        this._statusBox.setEnabled(enable);
    }

    public Color getBackground() {
        if (this._band != null) {
            return this._band.getBackground(this._step.getIndex());
        }
        return super.getBackground();
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        _sStatusLabelPrefWidth = -1;
        this._updateStatus();
    }

    public void updateUI() {
        super.updateUI();
        _sStatusLabelPrefWidth = -1;
        this._updateStatus();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleHeader();
        }
        return this.accessibleContext;
    }

    void setComplexHeader(boolean complex) {
        this._complexHeader = complex;
        this._stepTitle.setFocusable(!this.isComplexHeader());
        this._layoutComponents();
    }

    boolean isComplexHeader() {
        return this._complexHeader;
    }

    void setHeaderBanding(HeaderBand band) {
        this._band = band;
        this.repaint();
    }

    private int _sGetStatusLabelPreferredWidth() {
        if (_sStatusLabelPrefWidth == -1) {
            StatusButton statusButton = new StatusButton();
            statusButton.setMenuActions(new Action[]{null});
            statusButton.setText(this._getStatusText(Step.StepStatus.NOT_STARTED));
            statusButton.setIcon(this._getStatusIcon(Step.StepStatus.NOT_STARTED));
            _sStatusLabelPrefWidth = statusButton.getPreferredSize().width;
            statusButton.setText(this._getStatusText(Step.StepStatus.IN_PROCESS));
            statusButton.setIcon(this._getStatusIcon(Step.StepStatus.IN_PROCESS));
            _sStatusLabelPrefWidth = Math.max(_sStatusLabelPrefWidth, statusButton.getPreferredSize().width);
            statusButton.setText(this._getStatusText(Step.StepStatus.DONE));
            statusButton.setIcon(this._getStatusIcon(Step.StepStatus.DONE));
            _sStatusLabelPrefWidth = Math.max(_sStatusLabelPrefWidth, statusButton.getPreferredSize().width);
            statusButton.setText(this._getStatusText(Step.StepStatus.WILL_NOT_DO));
            statusButton.setIcon(this._getStatusIcon(Step.StepStatus.WILL_NOT_DO));
            _sStatusLabelPrefWidth = Math.max(_sStatusLabelPrefWidth, statusButton.getPreferredSize().width);
        }
        return _sStatusLabelPrefWidth;
    }

    private static Icon _sGetCollapsedIcon() {
        if (_sCollapsedIcon == null) {
            _sCollapsedIcon = new CollapsedIcon();
        }
        return _sCollapsedIcon;
    }

    private static Icon _sGetExpandedIcon() {
        if (_sExpandedIcon == null) {
            _sExpandedIcon = new ExpandedIcon();
        }
        return _sExpandedIcon;
    }

    private void _createUI() {
        this._listener = new Listener();
        this._createIndexLabel();
        this._createSeparator();
        this._createExpandLabel();
        this._createStepIconLabel();
        this._createStepTitleLabel();
        this._createStatusLabel();
        this._createStatusBox();
        GridBagLayout layout = new GridBagLayout();
        super.setLayout((LayoutManager)layout);
        this._updateStatus();
        this.setEnabled(this._step.isEnabled());
        this._setExpandable(!this.isComplexHeader());
        this._statusLabel.setStepSelected(this._step.isSelected() && !this._step.getAllowsSubsteps());
        this.addMouseListener(this._listener);
        this.addMouseMotionListener(this._listener);
        this._step.addPropertyChangeListener(this._listener);
        this._layoutComponents();
    }

    private void _createIndexLabel() {
        this._indexLabel = new IndexLabel();
    }

    private void _createSeparator() {
        this._separator = new JSeparator(1);
        this._separator.setPreferredSize(new Dimension(2, 38));
        this._separator.setForeground(new Color(204, 204, 204));
        this._separator.setBackground(Color.white);
    }

    private void _createExpandLabel() {
        this._expandLabel = new IconComponent();
        this._expandLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
        this._expandLabel.setOpaque(false);
    }

    private void _createStepIconLabel() {
        this._stepIcon = new JLabel();
        this._stepIcon.setIcon(this._step.getIcon());
        this._stepIcon.setOpaque(false);
    }

    private void _createStepTitleLabel() {
        this._stepTitle = new StepTitleLabel();
        this._stepTitle.setOpaque(false);
        this._stepTitle.setText(this._step.getTitle());
        this._stepTitle.setFocusable(!this.isComplexHeader());
        this._stepTitle.addFocusListener(this._listener);
    }

    private void _createStatusLabel() {
        this._statusLabel = new StatusButton();
        this._statusLabel.setMenuActions(new Action[]{this._createStatusMenuAction(Step.StepStatus.NOT_STARTED), this._createStatusMenuAction(Step.StepStatus.IN_PROCESS), this._createStatusMenuAction(Step.StepStatus.DONE), null, this._createStatusMenuAction(Step.StepStatus.WILL_NOT_DO)});
        this._statusLabel.addMouseListener(this._listener);
        this._statusLabel.addMouseMotionListener(this._listener);
        this._statusLabel.addFocusListener(this._listener);
    }

    private void _createStatusBox() {
        Component[] comps;
        this._statusBox = new AccessibleComboBox();
        StatusBoxModel model = new StatusBoxModel(new Object[]{Step.StepStatus.NOT_STARTED, Step.StepStatus.IN_PROCESS, Step.StepStatus.DONE, null, Step.StepStatus.WILL_NOT_DO});
        this._statusBox.setModel(model);
        this._statusBox.setRenderer(new StatusComboRenderer());
        this._statusBox.setOpaque(false);
        this._statusBox.addActionListener(new StatusChangeAction());
        for (Component comp : comps = this._statusBox.getComponents()) {
            comp.addMouseListener(this._listener);
            comp.addMouseMotionListener(this._listener);
        }
        this._statusBox.addFocusListener(this._listener);
    }

    private Action _createStatusMenuAction(Step.StepStatus status) {
        StatusChangeAction item = new StatusChangeAction();
        item.putValue("Name", this._getStatusText(status));
        item.putValue("SmallIcon", this._getStatusIcon(status));
        item.putValue(_STATUS_KEY, (Object)status);
        return item;
    }

    private void _layoutComponents() {
        this._layoutIndexLabel();
        this._layoutSeparator();
        this._layoutDrillIcon();
        this._layoutStepIcon();
        this._layoutStepTitle();
        this._layoutStatus();
        this.revalidate();
    }

    private void _layoutIndexLabel() {
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0);
        if (!this._step.getAllowsSubsteps()) {
            gbc.gridx = 1;
        }
        this.add(this._indexLabel, gbc);
    }

    private void _layoutSeparator() {
        GridBagConstraints gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0);
        if (this.isComplexHeader()) {
            gbc.insets.right = 6;
        }
        if (this._step.getAllowsSubsteps()) {
            this.add(this._separator, gbc);
        } else {
            this.remove(this._separator);
        }
    }

    private void _layoutDrillIcon() {
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0);
        if (this._step.getAllowsSubsteps()) {
            gbc.gridx = 2;
        }
        if (this.isComplexHeader()) {
            this.remove((Component)((Object)this._expandLabel));
        } else {
            this.add((Component)((Object)this._expandLabel), gbc);
        }
    }

    private void _layoutStepIcon() {
        GridBagConstraints gbc = new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0);
        if (this._step.getAllowsSubsteps()) {
            this.add(this._stepIcon, gbc);
        } else {
            this.remove(this._stepIcon);
        }
    }

    private void _layoutStepTitle() {
        this.add(this._stepTitle, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
    }

    private void _layoutStatus() {
        if (this.getShowStatus() && !this.isComplexHeader()) {
            if (this._step.isExpanded()) {
                this.remove(this._statusLabel);
                if (this._statusBox.getParent() != this) {
                    this._layoutStatusComponent(this._statusBox);
                }
            } else {
                this.remove(this._statusBox);
                if (this._statusLabel.getParent() != this) {
                    this._layoutStatusComponent(this._statusLabel);
                }
            }
        } else {
            this.remove(this._statusLabel);
            this.remove(this._statusBox);
        }
        this.revalidate();
    }

    private void _layoutStatusComponent(Component comp) {
        if (this.isComplexHeader()) {
            this.remove(comp);
        } else {
            this.add(comp, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 16), 0, 0));
        }
    }

    private void _setExpandable(boolean expandable) {
        if (expandable != this._isExpandable()) {
            this._expandable = expandable;
        }
    }

    private boolean _isExpandable() {
        return this._expandable;
    }

    private void _toggleHeader() {
        if (this._isExpandable()) {
            this._step.setExpanded(!this._step.isExpanded());
        }
    }

    private void _updateStatus() {
        this._statusLabel.setText(this._getStatusText(this._step.getStatus()));
        this._statusLabel.setIcon(this._getStatusIcon(this._step.getStatus()));
        this._statusBox.setSelectedItem((Object)this._step.getStatus());
        this._statusLabel.setPreferredSize(new Dimension(this._sGetStatusLabelPreferredWidth(), this._statusLabel.getPreferredSize().height));
        this.revalidate();
    }

    private String _getStatusText(Step.StepStatus status) {
        switch (status) {
            case DONE: {
                return UIBundle.get("CHECKLIST_STATUS_DONE");
            }
            case IN_PROCESS: {
                return UIBundle.get("CHECKLIST_STATUS_IN_PROCESS");
            }
            case WILL_NOT_DO: {
                return UIBundle.get("CHECKLIST_STATUS_WILL_NOT_DO");
            }
            case NOT_STARTED: {
                return UIBundle.get("CHECKLIST_STATUS_NOT_STARTED");
            }
        }
        return "";
    }

    private Icon _getStatusIcon(Step.StepStatus status) {
        switch (status) {
            case DONE: {
                return OracleIcons.getIcon((String)"check.png");
            }
            case IN_PROCESS: {
                return OracleIcons.getIcon((String)"incompletestatus.png");
            }
            case WILL_NOT_DO: {
                return OracleIcons.getIcon((String)"noaccess.png");
            }
            case NOT_STARTED: {
                return OracleIcons.getIcon((String)"notstarted.png");
            }
        }
        return null;
    }

    private class Listener
    extends MouseAdapter
    implements PropertyChangeListener,
    FocusListener {
        private Listener() {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            StepHeader.this._mouseOver = true;
            if (me.getComponent() == StepHeader.this) {
                StepHeader.this._toggleHeader();
                StepHeader.this._step.setSelected(true);
                if (StepHeader.this._step.isEnabled()) {
                    StepHeader.this._stepTitle.requestFocus();
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent me) {
            StepHeader.this._mouseOver = true;
            StepHeader.this.revalidate();
            StepHeader.this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent me) {
            StepHeader.this._mouseOver = false;
            StepHeader.this.revalidate();
            StepHeader.this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            StepHeader.this._mouseOver = true;
            StepHeader.this.revalidate();
            StepHeader.this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            if (!me.getComponent().contains(me.getPoint())) {
                StepHeader.this._mouseOver = false;
                StepHeader.this.revalidate();
                StepHeader.this.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            if (!me.getComponent().contains(me.getPoint())) {
                StepHeader.this._mouseOver = false;
                StepHeader.this.revalidate();
                StepHeader.this.repaint();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent pe) {
            String name = pe.getPropertyName();
            if ("selected".equals(name)) {
                StepHeader.this.revalidate();
                StepHeader.this.repaint();
                StepHeader.this._statusLabel.setStepSelected(StepHeader.this._step.isSelected() && StepHeader.this._step.getAllowsSubsteps());
            } else if ("status".equals(name)) {
                StepHeader.this._updateStatus();
            } else if ("expanded".equals(name)) {
                StepHeader.this._layoutStatus();
            } else if ("parent".equals(name)) {
                StepHeader.this._layoutComponents();
            } else if ("enabled".equals(name)) {
                StepHeader.this.setEnabled(Boolean.TRUE.equals(pe.getNewValue()));
            } else if ("title".equals(name)) {
                StepHeader.this._stepTitle.setText((String)pe.getNewValue());
            } else if ("icon".equals(name)) {
                StepHeader.this._stepIcon.setIcon((Icon)pe.getNewValue());
            }
        }

        @Override
        public void focusGained(FocusEvent fe) {
            StepHeader.this.scrollRectToVisible(StepHeader.this.getBounds());
        }

        @Override
        public void focusLost(FocusEvent fe) {
        }
    }

    private class StatusChangeAction
    extends AbstractAction {
        private StatusChangeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (ae.getSource() == StepHeader.this._statusBox) {
                StepHeader.this._step.setStatus((Step.StepStatus)((Object)StepHeader.this._statusBox.getSelectedItem()));
            } else if (this.getValue(StepHeader._STATUS_KEY) != null) {
                StepHeader.this._step.setStatus((Step.StepStatus)((Object)this.getValue(StepHeader._STATUS_KEY)));
            }
        }
    }

    private class StatusComboRenderer
    extends DefaultListCellRenderer {
        private StatusComboRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                JSeparator sep = new JSeparator(0);
                sep.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 3));
                return sep;
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            this.setText(StepHeader.this._getStatusText((Step.StepStatus)((Object)value)));
            Icon icon = StepHeader.this._getStatusIcon((Step.StepStatus)((Object)value));
            if (!StepHeader.this._statusBox.isEnabled()) {
                icon = UIManager.getLookAndFeel().getDisabledIcon(StepHeader.this._statusBox, icon);
            }
            this.setIcon(icon);
            if (index == 0) {
                this.setBorder(BorderFactory.createEmptyBorder(4, 4, 2, 3));
            } else if (index == StepHeader.this._statusBox.getItemCount() - 1) {
                this.setBorder(BorderFactory.createEmptyBorder(2, 4, 4, 3));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 3));
            }
            return this;
        }
    }

    private class StatusBoxModel
    extends DefaultComboBoxModel {
        public StatusBoxModel(Object[] items) {
            super(items);
        }

        @Override
        public void setSelectedItem(Object o) {
            if (o != null) {
                super.setSelectedItem(o);
            } else {
                int newIndex = this.getIndexOf(o);
                int oldIndex = this.getIndexOf(this.getSelectedItem());
                int index = -1;
                if (newIndex < oldIndex) {
                    if (newIndex - 1 >= 0) {
                        index = newIndex - 1;
                    }
                } else if (newIndex > oldIndex && newIndex + 1 < this.getSize()) {
                    index = newIndex + 1;
                }
                if (index != -1) {
                    this.setSelectedItem(this.getElementAt(index));
                }
            }
        }
    }

    private class AccessibleComboBox
    extends JComboBox {
        private AccessibleComboBox() {
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new CustomAccessibleJComboBox();
            }
            return this.accessibleContext;
        }

        protected class CustomAccessibleJComboBox
        extends JComboBox.AccessibleJComboBox {
            protected CustomAccessibleJComboBox() {
                super(AccessibleComboBox.this);
            }

            @Override
            public String getAccessibleName() {
                return StepHeader.this._getStatusText((Step.StepStatus)((Object)StepHeader.this._statusBox.getSelectedItem()));
            }
        }
    }

    private class IconComponent
    extends PainterComponent {
        public IconComponent() {
            this.setPainter((Painter)new IconPainter());
        }

        public Object getPaintData(Object key) {
            if (PaintContext.ICON_KEY.equals(key)) {
                if (StepHeader.this._step.isExpanded()) {
                    return StepHeader._sGetExpandedIcon();
                }
                return StepHeader._sGetCollapsedIcon();
            }
            return super.getPaintData(key);
        }

        public Color getForeground() {
            if ((StepHeader.this.getPaintState() & 0x20) != 0) {
                return Color.white;
            }
            return new Color(49, 106, 196);
        }
    }

    private class StepTitleLabel
    extends JLabel {
        public StepTitleLabel() {
            this._createActionListener();
            this.setBorder(new FocusLineBorder());
            this.enableEvents(4L);
        }

        @Override
        public Color getForeground() {
            if (StepHeader.this._step.getAllowsSubsteps() && (StepHeader.this.getPaintState() & 0x20) != 0) {
                return Color.white;
            }
            return super.getForeground();
        }

        @Override
        public Font getFont() {
            Font f = super.getFont();
            if (f != null && ((StepHeader.this.getPaintState() & 0x20) != 0 || (StepHeader.this.getPaintState() & 0x10) != 0)) {
                f = f.deriveFont(1);
            }
            return f;
        }

        @Override
        protected void processFocusEvent(FocusEvent fe) {
            super.processFocusEvent(fe);
            this.repaint();
        }

        private void _createActionListener() {
            AbstractAction expandAction = new AbstractAction("toggle"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StepHeader.this._step.setSelected(true);
                    StepHeader.this._toggleHeader();
                }
            };
            this.getActionMap().put("toggle", expandAction);
            this.getInputMap(0).put(KeyStroke.getKeyStroke(32, 0), "toggle");
            this.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "toggle");
        }
    }

    private class AccessibleHeader
    extends JComponent.AccessibleJComponent {
        private AccessibleHeader() {
            super((JComponent)((Object)StepHeader.this));
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }

    private class IndexLabel
    extends JLabel {
        public IndexLabel() {
            this.setHorizontalAlignment(0);
            this.setOpaque(false);
        }

        @Override
        public String getText() {
            String index = Integer.toString(StepHeader.this._step.getIndex() + 1);
            if (!StepHeader.this._step.getAllowsSubsteps()) {
                index = StepHeader.this._step.getParent().getIndex() + 1 + "." + index;
            }
            return index;
        }

        @Override
        public void paintComponent(Graphics g) {
            if (g instanceof Graphics2D && StepHeader.this._step.getAllowsSubsteps() && (StepHeader.this.getPaintState() & 0x20) == 0 && (StepHeader.this.getPaintState() & 0x10) == 0) {
                Color top = Color.white;
                Color bottom = new Color(232, 232, 232);
                GradientPaint grad = new GradientPaint(0.0f, 0.0f, top, 0.0f, this.getHeight(), bottom);
                ((Graphics2D)g).setPaint(grad);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            super.paintComponent(g);
        }

        @Override
        public Font getFont() {
            Font f = super.getFont();
            if (f != null && ((StepHeader.this.getPaintState() & 0x20) != 0 || (StepHeader.this.getPaintState() & 0x10) != 0)) {
                f = f.deriveFont(1);
            }
            return f;
        }

        @Override
        public Color getForeground() {
            if (StepHeader.this._step.getAllowsSubsteps() && (StepHeader.this.getPaintState() & 0x20) != 0) {
                return Color.white;
            }
            return super.getForeground();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            if (StepHeader.this._step.getAllowsSubsteps()) {
                size.width = 22;
            }
            return size;
        }
    }

    public static class FocusLineBorder
    extends AbstractBorder {
        private static final Insets _INSET = new Insets(1, 1, 1, 1);

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (c.hasFocus()) {
                g.setColor(UIManager.getColor("Button.focus"));
                g.drawRect(x, y, width - 1, height - 1);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return _INSET;
        }
    }

    private static class CollapsedIcon
    implements Icon {
        private CollapsedIcon() {
        }

        @Override
        public int getIconHeight() {
            return _ICON_SIZE.height;
        }

        @Override
        public int getIconWidth() {
            return _ICON_SIZE.width;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.drawLine(x + 3, y + 1, x + 3, y + 9);
            g.drawLine(x + 4, y + 2, x + 4, y + 8);
            g.drawLine(x + 5, y + 3, x + 5, y + 7);
            g.drawLine(x + 6, y + 4, x + 6, y + 6);
            g.drawLine(x + 7, y + 5, x + 7, y + 5);
        }
    }

    private static class ExpandedIcon
    implements Icon {
        private ExpandedIcon() {
        }

        @Override
        public int getIconHeight() {
            return _ICON_SIZE.height;
        }

        @Override
        public int getIconWidth() {
            return _ICON_SIZE.width;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.drawLine(x + 1, y + 3, x + 9, y + 3);
            g.drawLine(x + 2, y + 4, x + 8, y + 4);
            g.drawLine(x + 3, y + 5, x + 7, y + 5);
            g.drawLine(x + 4, y + 6, x + 6, y + 6);
            g.drawLine(x + 5, y + 7, x + 5, y + 7);
        }
    }

    private static class BgPainter
    extends ColorChange {
        public BgPainter() {
            super(FilledRectPainter.getPainter());
        }

        protected Color getColor(PaintContext context) {
            if ((context.getPaintState() & 0x20) != 0) {
                return new Color(49, 106, 196);
            }
            if ((context.getPaintState() & 0x10) != 0) {
                return new Color(216, 236, 253);
            }
            return context.getComponent().getBackground();
        }
    }

    static interface HeaderBand {
        public Color getBackground(int var1);
    }
}

