/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.checklist;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.UIBundle;

public final class ContentElement {
    private static Icon _sClosedBookIcon;
    private static Icon _sHelpTopicIcon;
    private static Icon _sStepIcon;
    private String _id;
    private Type _type;
    private Icon _icon;
    private String _label;
    private String _target;
    private String _hint;

    public ContentElement(String id, Type type, String target) {
        this(id, type, null, null, target);
    }

    public ContentElement(String id, Type type, String label, String target) {
        this(id, type, label, null, target);
    }

    public ContentElement(String id, Type type, String label, Icon icon, String target) {
        this(id, type, label, icon, target, null);
    }

    public ContentElement(String id, Type type, String label, Icon icon, String target, String hint) {
        this._type = type;
        this._id = id;
        this._target = target;
        this._hint = hint;
        this._label = label;
        if (this._label == null || "".equals(this._label)) {
            this._label = ContentElement._sGetDefaultLabel(this._type);
        }
        this._icon = icon;
        if (this._icon == null) {
            this._icon = ContentElement._sGetDefaultIcon(this._type);
        }
    }

    public String getId() {
        return this._id;
    }

    public Type getType() {
        return this._type;
    }

    public String getLabel() {
        return this._label;
    }

    public String getTarget() {
        return this._target;
    }

    public Icon getIcon() {
        return this._icon;
    }

    public String getHint() {
        return this._hint;
    }

    private static String _sGetDefaultLabel(Type type) {
        switch (type) {
            case HELPLINK_DEVGUIDE: {
                return UIBundle.get("CHECKLIST_HELPLINK_DEVGUIDE");
            }
            case HELPLINK_STEPBYSTEP: {
                return UIBundle.get("CHECKLIST_HELPLINK_STEPBYSTEP");
            }
            case HELPLINK_HELPTOPIC: {
                return UIBundle.get("CHECKLIST_HELPLINK_HELPTOPIC");
            }
            case HELPLINK_WHATISEE: {
                return UIBundle.get("CHECKLIST_HELPLINK_WHATISEE");
            }
            case HELPLINK_CUECARD: {
                return "Cue Card";
            }
        }
        return "";
    }

    private static Icon _sGetDefaultIcon(Type type) {
        switch (type) {
            case HELPLINK_DEVGUIDE: {
                if (_sClosedBookIcon == null) {
                    _sClosedBookIcon = new ImageIcon(ImageUtils.getImageResource(ContentElement.class, (String)"icons/closedbook.png"));
                }
                return _sClosedBookIcon;
            }
            case HELPLINK_STEPBYSTEP: {
                if (_sStepIcon == null) {
                    _sStepIcon = new ImageIcon(ImageUtils.getImageResource(ContentElement.class, (String)"icons/worklist_qualifier.png"));
                }
                return _sStepIcon;
            }
            case HELPLINK_HELPTOPIC: 
            case HELPLINK_WHATISEE: {
                if (_sHelpTopicIcon == null) {
                    _sHelpTopicIcon = new ImageIcon(ImageUtils.getImageResource(ContentElement.class, (String)"icons/kd_coach.png"));
                }
                return _sHelpTopicIcon;
            }
            case HELPLINK_CUECARD: {
                return OracleIcons.getIcon((String)"cuecard.png");
            }
        }
        return null;
    }

    public static enum Type {
        ACTIONBUTTON,
        HYPERLINK,
        HELPLINK_DEVGUIDE,
        HELPLINK_STEPBYSTEP,
        HELPLINK_HELPTOPIC,
        HELPLINK_WHATISEE,
        HELPLINK_CUECARD,
        HELPLINK_CUSTOMHELP;

    }
}

