/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.checklist;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.javatools.ui.RichHintLabel;

final class ChecklistHelper {
    private static StyleSheet _sDefaultLinkSheet;

    ChecklistHelper() {
    }

    public static RichHintLabel createLinkLabel(String text, String actionId, Action action) {
        RichHintLabel label = ChecklistHelper.createLinkLabel();
        ChecklistHelper._updateCaret(label);
        label.setHtmlText(text);
        label.registerAction(actionId, action);
        label.setDisabledTextColor(new Color(204, 204, 204));
        return label;
    }

    public static RichHintLabel createLinkLabel() {
        return ChecklistHelper.createLinkLabel(null);
    }

    public static RichHintLabel createLinkLabel(Color bgColor) {
        RichHintLabel label = new RichHintLabel();
        ChecklistHelper._updateCaret(label);
        HTMLDocument document = (HTMLDocument)label.getDocument();
        StyleSheet styles = document.getStyleSheet();
        if (bgColor != null) {
            StyleSheet bgColorStyle = new StyleSheet();
            bgColorStyle.addRule("body {color: " + ColorUtils.colorToHTML((Color)bgColor) + " ; }");
            styles.addStyleSheet(bgColorStyle);
        } else {
            styles.addStyleSheet(ChecklistHelper._sGetLinkStleSheet());
        }
        return label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StyleSheet _sGetLinkStleSheet() {
        if (_sDefaultLinkSheet == null) {
            _sDefaultLinkSheet = new StyleSheet();
            Font font = new JLabel().getFont();
            StringBuilder rule = new StringBuilder();
            if (font != null) {
                rule.append("body {");
                rule.append(" font-family: ");
                rule.append(font.getFamily());
                rule.append(" ; ");
                rule.append(" font-size: ");
                rule.append(font.getSize());
                rule.append("pt ;");
            }
            rule.append(" color: #666666; ");
            rule.append(" }");
            rule.append("a {");
            rule.append("color:#316AC4;");
            rule.append("text-decoration:none");
            rule.append("}");
            rule.append("a.bold {");
            rule.append(" font-weight: 700 ; ");
            rule.append("}");
            rule.append("ul {");
            rule.append("text-indent: 1px;");
            rule.append("margin-left: 12px;");
            rule.append("margin-top: 8px;");
            rule.append("margin-bottom: 0px;");
            rule.append("margin-right: 0px;");
            URL url = ChecklistHelper.class.getResource("icons/bullet.png");
            rule.append("list-style-image:" + url.toString());
            rule.append("}");
            StringReader r = null;
            try {
                r = new StringReader(rule.toString());
                _sDefaultLinkSheet.loadRules(r, null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (r != null) {
                    r.close();
                }
            }
        }
        return _sDefaultLinkSheet;
    }

    private static void _updateCaret(RichHintLabel label) {
        Caret caret = label.getCaret();
        if (caret instanceof DefaultCaret) {
            ((DefaultCaret)caret).setUpdatePolicy(1);
        }
    }
}

