/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.calendar;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.beans.PropertyVetoException;
import java.text.DateFormatSymbols;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.AppearanceManager;
import oracle.bali.ewt.grid.ComplexAppearanceManager;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridKeyHandler;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.grid.StandardGridKeyHandler;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.FormatPainter;
import oracle.bali.ewt.painter.NullPainter;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.CellRange;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.util.ImmInsets;
import oracle.javatools.ui.calendar.CalendarDateProvider;
import oracle.javatools.ui.calendar.Day;

final class DayComponent
extends JPanel {
    private boolean _isSelectionAdjusting = false;
    private SpreadTable _dayTable;
    private ArrayTwoDModel _tableModel = new ArrayTwoDModel(7, 6);
    private ArrayOneDModel _headerModel = new ArrayOneDModel(7);
    private static final int _DAYS_IN_WEEK = 7;
    private static final int _WEEKS_IN_MONTH = 6;
    private DateFormatSymbols _dfSymbols;
    private Calendar _cal;
    private boolean _isMultiSelect;
    private SimpleDateFormat _dayFormat = new SimpleDateFormat("d");
    private CalendarDateProvider _dateProvider;
    private Font _boldFont;
    private ImmInsets _cellInsets = new ImmInsets(0, 0, 0, 0);
    private TreeSet<Day> _selectedDays;
    private Day _minDay;
    private Day _maxDay;

    public DayComponent(Calendar cal, boolean isMultiSelect, TreeSet<Day> selectedDays, Locale locale) {
        this._cal = cal;
        this._isMultiSelect = isMultiSelect;
        this._selectedDays = selectedDays;
        this._minDay = null;
        this._dfSymbols = new DateFormatSymbols(locale);
        this._buildTableModel();
        this._buildColHeaderModel();
        this._dayTable = new CustomSpreadTable((TwoDModel)this._tableModel, (OneDModel)this._headerModel, null);
        this._customizeDayTable();
        this.setLayout(new BoxLayout(this, 1));
        this.add((Component)this._dayTable);
    }

    public void rebuild() {
        this._buildTableModel();
        this._dayTable.setModels((TwoDModel)this._tableModel, (OneDModel)this._headerModel, null);
        this._updateSelection();
        this._updateAppearance();
    }

    private void _updateSelection() {
        this._isSelectionAdjusting = true;
        TwoDSelection newSelection = new TwoDSelection();
        for (int week = 0; week <= 5; ++week) {
            for (int day = 0; day <= 6; ++day) {
                Date date = this.getDateAt(day, week);
                if (date == null || !this.isInCurrentMonth(date) || !this._dateInRange(date) || !this._selectedDays.contains(new Day(date)) || this._dateProvider != null && !this._dateProvider.isDateValid(date)) continue;
                TwoDSelection cellSelection = new TwoDSelection(day, week);
                newSelection = newSelection.add(cellSelection);
            }
        }
        try {
            this._dayTable.getGrid().setSelection(newSelection);
            this._dayTable.getGrid().repaint();
        }
        catch (PropertyVetoException veto) {
            System.out.println("ui.calendar.DayPanel._updateSelection: VetoExeception");
        }
        this._isSelectionAdjusting = false;
    }

    private void _updateAppearance() {
        ComplexAppearanceManager appMan = (ComplexAppearanceManager)this._dayTable.getGrid().getAppearanceManager();
        for (int week = 0; week < 6; ++week) {
            for (int day = 0; day < 7; ++day) {
                Appearance app = appMan.getCellAppearance(day, week);
                Date date = this.getDateAt(day, week);
                if (date == null || !this.isInCurrentMonth(date)) {
                    app.setBackground(UIManager.getColor("TextArea.background"));
                    app.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
                    app.setFont(this._boldFont);
                    app.setInsets(this._cellInsets);
                } else if (this._dateProvider != null && !this._dateProvider.isDateValid(date)) {
                    app.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
                    app.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
                } else if (!this._dateInRange(date)) {
                    app.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
                    app.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
                    app.setFont(this._boldFont);
                    app.setInsets(this._cellInsets);
                } else {
                    app.setBackground(UIManager.getColor("Table.background"));
                    app.setForeground(UIManager.getColor("TextArea.foreground"));
                    app.setFont(this._boldFont);
                    app.setInsets(this._cellInsets);
                }
                appMan.setCellAppearance(day, week, app);
            }
        }
    }

    public SpreadTable getTable() {
        return this._dayTable;
    }

    public Date getDateAt(int day, int week) {
        Object object = this._tableModel.getData(day, week);
        return object == null ? null : (Date)object;
    }

    public boolean isInCurrentMonth(Date date) {
        boolean bRet = false;
        int month = this._cal.get(2);
        Date origDate = this._cal.getTime();
        this._cal.setTime(date);
        bRet = this._cal.get(2) == month;
        this._cal.setTime(origDate);
        return bRet;
    }

    public void setMinimumDate(Date minimumDate) {
        this._minDay = minimumDate == null ? null : new Day(minimumDate);
        this._refreshSelectedDates();
        this.rebuild();
    }

    public Date getMinimumDate() {
        return this._minDay.getDate();
    }

    public void setMaximumDate(Date maximumDate) {
        this._maxDay = maximumDate == null ? null : new Day(maximumDate);
        this._refreshSelectedDates();
        this.rebuild();
    }

    public Date getMaximumDate() {
        return this._maxDay.getDate();
    }

    public void setDateProvider(CalendarDateProvider calDateProvider) {
        this._dateProvider = calDateProvider;
        this._refreshSelectedDates();
        this.rebuild();
    }

    public CalendarDateProvider getDateProvider() {
        return this._dateProvider;
    }

    private boolean _dateInRange(Date date) {
        if (this._minDay == null && this._maxDay == null) {
            return true;
        }
        if (date == null) {
            return false;
        }
        Day dateDay = new Day(date);
        if (this._minDay != null && dateDay.compareTo(this._minDay) < 0) {
            return false;
        }
        return this._maxDay == null || dateDay.compareTo(this._maxDay) <= 0;
    }

    private void _refreshSelectedDates() {
        for (Day day : this._selectedDays.toArray(new Day[0])) {
            if (!this._dateInRange(day.getDate())) {
                this._selectedDays.remove(day);
            }
            if (this._dateProvider == null || this._dateProvider.isDateValid(day.getDate())) continue;
            this._selectedDays.remove(day);
        }
    }

    private void _buildTableModel() {
        Date date = this._cal.getTime();
        int firstDayOfWeek = this._cal.getFirstDayOfWeek() - 1;
        this._cal.set(5, 1);
        this._cal.add(5, 1 - this._cal.get(7) + firstDayOfWeek);
        int firstDay = this._cal.get(5);
        if (firstDay > 1 && firstDay < 10) {
            this._cal.add(5, -7);
        }
        for (int w = 0; w < 6; ++w) {
            for (int day = 0; day < 7; ++day) {
                this._tableModel.setData(day, w, (Object)this._cal.getTime());
                this._cal.add(5, 1);
            }
        }
        this._cal.setTime(date);
    }

    private void _buildColHeaderModel() {
        int firstDay;
        int i;
        this._headerModel = new ArrayOneDModel(7);
        for (i = firstDay = this._cal.getFirstDayOfWeek(); i <= 7; ++i) {
            this._headerModel.setData(i - firstDay, (Object)this._dfSymbols.getShortWeekdays()[i]);
        }
        for (i = 1; i < firstDay; ++i) {
            this._headerModel.setData(7 - firstDay + i, (Object)this._dfSymbols.getShortWeekdays()[i]);
        }
    }

    private void _customizeDayTable() {
        Font baseFont = UIManager.getFont("Label.font");
        this._boldFont = baseFont.deriveFont(1).deriveFont((float)baseFont.getSize() - 1.0f);
        Appearance appearance = this._dayTable.getColumnHeader().getAppearance();
        appearance.setHorizontalJustify(3);
        appearance.setForeground(UIManager.getColor("TitledBorder.titleColor"));
        appearance.setInsets(this._cellInsets);
        Font smallerFont = baseFont.deriveFont((float)baseFont.getSize() - 1.0f);
        appearance.setFont(smallerFont);
        this._dayTable.getColumnHeader().setAppearance(appearance);
        this._dayTable.setColumnHeaderHeight(16);
        this._dayTable.setFont(this._boldFont);
        NullPainter np = new NullPainter();
        this._dayTable.getColumnHeader().setFirstItemBorderPainter((BorderPainter)np);
        this._dayTable.getColumnHeader().setLastItemBorderPainter((BorderPainter)np);
        this._dayTable.getColumnHeader().setHeaderItemBorderPainter((BorderPainter)np);
        this._dayTable.getColumnHeader().setFont(this._boldFont);
        ComplexAppearanceManager appMan = new ComplexAppearanceManager();
        this._dayTable.getGrid().setAppearanceManager((AppearanceManager)appMan);
        appearance = appMan.getAppearance();
        appearance.setHorizontalJustify(3);
        appearance.setVerticalJustify(1);
        appMan.setAppearance(appearance);
        if (this._isMultiSelect) {
            this._dayTable.getGrid().setGridSelectionManager((GridSelectionManager)new DayGridSelectionManager(0, 0, 2));
        } else {
            this._dayTable.getGrid().setGridSelectionManager((GridSelectionManager)new DayGridSelectionManager(0, 0, 1));
        }
        this._dayTable.setHorizontalSeparatorsVisible(false);
        this._dayTable.setVerticalSeparatorsVisible(false);
        this._dayTable.getColumnHeader().setCanResizeItems(false);
        FormatPainter datePainter = new FormatPainter((Format)this._dayFormat);
        this._dayTable.getGrid().setColumnPainter(0, (Painter)datePainter);
        this._dayTable.getGrid().setColumnPainter(1, (Painter)datePainter);
        this._dayTable.getGrid().setColumnPainter(2, (Painter)datePainter);
        this._dayTable.getGrid().setColumnPainter(3, (Painter)datePainter);
        this._dayTable.getGrid().setColumnPainter(4, (Painter)datePainter);
        this._dayTable.getGrid().setColumnPainter(5, (Painter)datePainter);
        this._dayTable.getGrid().setColumnPainter(6, (Painter)datePainter);
        this._autoSetWidth();
    }

    private void _autoSetWidth() {
        int colWidth = this._getMinColSize();
        this._dayTable.getGrid().setColumnWidth(0, colWidth);
        this._dayTable.getGrid().setColumnWidth(1, colWidth);
        this._dayTable.getGrid().setColumnWidth(2, colWidth);
        this._dayTable.getGrid().setColumnWidth(3, colWidth);
        this._dayTable.getGrid().setColumnWidth(4, colWidth);
        this._dayTable.getGrid().setColumnWidth(5, colWidth);
        this._dayTable.getGrid().setColumnWidth(6, colWidth);
        this._dayTable.getColumnHeader().setPreferredHeaderSize(colWidth * 7);
    }

    private int _getMinColSize() {
        int minSize = 0;
        FontMetrics fmetrics = this.getFontMetrics(this._boldFont);
        for (String name : this._dfSymbols.getShortWeekdays()) {
            int width = SwingUtilities.computeStringWidth(fmetrics, name);
            minSize = Math.max(minSize, width += this._cellInsets.left + this._cellInsets.right);
        }
        for (int i = 1; i <= 31; ++i) {
            int width = SwingUtilities.computeStringWidth(fmetrics, new Integer(i).toString());
            minSize = Math.max(minSize, width);
        }
        int sepSize = this._dayTable.getColumnGeometryManager().getSeparatorSize();
        return minSize += sepSize;
    }

    public void setMultiSelect(boolean isMultiSelect) {
        this._isMultiSelect = isMultiSelect;
        if (this._isMultiSelect) {
            this._dayTable.getGrid().setGridSelectionManager((GridSelectionManager)new DayGridSelectionManager(0, 0, 2));
        } else {
            this._dayTable.getGrid().setGridSelectionManager((GridSelectionManager)new DayGridSelectionManager(0, 0, 1));
        }
    }

    public boolean isMultiSelect() {
        return this._isMultiSelect;
    }

    public void cleanUp() {
        this._dayTable = null;
        this._tableModel = null;
        this._headerModel = null;
        this._cal = null;
        if (this._selectedDays != null) {
            this._selectedDays.clear();
        }
        this._selectedDays = null;
        this._dateProvider = null;
    }

    private class DayGridSelectionManager
    extends GeneralGridSelectionManager {
        public DayGridSelectionManager(int columnConstraint, int rowConstraint, int cellConstraint) {
            super(columnConstraint, rowConstraint, cellConstraint);
        }

        public TwoDSelection modifySelection(TwoDSelection oldSelection, TwoDSelection newSelection, int how) {
            if (!DayComponent.this._isSelectionAdjusting) {
                switch (how) {
                    case 0: {
                        DayComponent.this._selectedDays.clear();
                    }
                    case 2: {
                        newSelection = !DayComponent.this._isMultiSelect ? this._addSingleSelection(newSelection) : this._addMultiSelection(newSelection);
                        break;
                    }
                    case 1: {
                        this._removeSelection(newSelection);
                    }
                }
            }
            if (newSelection == null) {
                DayComponent.this._updateSelection();
                newSelection = this.getSelection();
                how = 0;
            }
            return super.modifySelection(oldSelection, newSelection, how);
        }

        private boolean _isDateInCurrentMonth(Date date) {
            Date origTime = DayComponent.this._cal.getTime();
            int thisMonth = DayComponent.this._cal.get(2);
            DayComponent.this._cal.setTime(date);
            int givenMonth = DayComponent.this._cal.get(2);
            DayComponent.this._cal.setTime(origTime);
            return thisMonth == givenMonth;
        }

        private TwoDSelection _addSingleSelection(TwoDSelection newValue) {
            DayComponent.this._selectedDays.clear();
            CellRange[] cellRanges = newValue.getCellRanges();
            if (cellRanges != null) {
                Date newDate = DayComponent.this.getDateAt(newValue.getSingleCell().column, newValue.getSingleCell().row);
                if (newDate != null && this._isDateInCurrentMonth(newDate) && (DayComponent.this._dateProvider == null || DayComponent.this._dateProvider.isDateValid(newDate)) && DayComponent.this._dateInRange(newDate)) {
                    DayComponent.this._selectedDays.add(new Day(newDate));
                } else {
                    newValue = newValue.subtract(newValue);
                }
            }
            return newValue;
        }

        private TwoDSelection _addMultiSelection(TwoDSelection newValue) {
            CellRange[] cellRanges = newValue.getCellRanges();
            if (cellRanges != null) {
                for (int rangeIndex = 0; rangeIndex < cellRanges.length; ++rangeIndex) {
                    CellRange range = cellRanges[rangeIndex];
                    for (int x = range.getLowerLimit().column; x <= range.getUpperLimit().column; ++x) {
                        for (int y = range.getLowerLimit().row; y <= range.getUpperLimit().row; ++y) {
                            Date newDate = DayComponent.this.getDateAt(x, y);
                            if (newDate != null && this._isDateInCurrentMonth(newDate) && (DayComponent.this._dateProvider == null || DayComponent.this._dateProvider.isDateValid(newDate)) && DayComponent.this._dateInRange(newDate)) {
                                DayComponent.this._selectedDays.add(new Day(newDate));
                                continue;
                            }
                            TwoDSelection removeCell = new TwoDSelection(new Cell(x, y));
                            newValue = newValue.subtract(removeCell);
                        }
                    }
                }
            }
            return newValue;
        }

        private void _removeSelection(TwoDSelection newValue) {
            CellRange[] cellRanges = newValue.getCellRanges();
            if (cellRanges != null) {
                for (int rangeIndex = 0; rangeIndex < cellRanges.length; ++rangeIndex) {
                    CellRange range = cellRanges[rangeIndex];
                    for (int x = range.getLowerLimit().column; x <= range.getUpperLimit().column; ++x) {
                        for (int y = range.getLowerLimit().row; y <= range.getUpperLimit().row; ++y) {
                            Date newDate = DayComponent.this.getDateAt(x, y);
                            if (newDate == null || !this._isDateInCurrentMonth(newDate)) continue;
                            DayComponent.this._selectedDays.remove(new Day(newDate));
                        }
                    }
                }
            }
        }
    }

    private class CustomSpreadTable
    extends SpreadTable {
        public CustomSpreadTable(TwoDModel gridModel, OneDModel columnHeaderModel, OneDModel rowHeaderModel) {
            super(gridModel, columnHeaderModel, rowHeaderModel);
            this.setBorder(null);
        }

        protected Grid createGrid(TwoDModel ds) {
            return new CustomGrid(ds);
        }

        protected Header createColumnHeader(OneDModel ds) {
            return new CustomColumnHeader(ds);
        }

        private class CustomKeyHandler
        extends StandardGridKeyHandler {
            private CustomKeyHandler() {
            }

            protected Cell enter(Grid grid, Cell focusCell, KeyEvent e, boolean shiftDown) {
                return focusCell;
            }
        }

        private class CustomColumnHeader
        extends Header {
            public CustomColumnHeader(OneDModel ds) {
                super(ds);
            }

            public boolean isFocusable() {
                return false;
            }

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
            }

            public Header.AccessibleHeader createAccessibleHeader() {
                return new AccessibleDayHeader();
            }

            private class AccessibleDayHeader
            extends Header.AccessibleHeader {
                private AccessibleDayHeader() {
                    super((Header)CustomColumnHeader.this);
                }

                public String getAccessibleName(int index) {
                    int mod = DayComponent.this._cal.getFirstDayOfWeek();
                    int day = mod + index;
                    day = day > 7 ? day - 7 : day;
                    return DayComponent.this._dfSymbols.getWeekdays()[day];
                }
            }
        }

        private class CustomGrid
        extends Grid {
            public CustomGrid(TwoDModel ds) {
                super(ds);
                this.setGridKeyHandler((GridKeyHandler)new CustomKeyHandler());
            }
        }
    }
}

