/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.calendar;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.DefaultButtonModel;
import javax.swing.JDialog;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.calendar.CalendarPanel;

public final class CalendarPopupButton
extends JToggleButton {
    private CalendarPanel calendarPanel;
    private JDialog popup;
    public static final String PROPERTY_CALENDAR_POPUP_VISIBLE = "PROPERTY_CALENDAR_POPUP_VISIBLE";

    public CalendarPopupButton() {
        this(Locale.getDefault());
    }

    public CalendarPopupButton(Locale locale) {
        this.init(locale);
    }

    public CalendarPanel getCalendarPanel() {
        return this.calendarPanel;
    }

    public Date[] getSelectedDates() {
        return this.calendarPanel.getSelectedDates();
    }

    private void init(Locale locale) {
        this.setIcon(OracleIcons.getIcon((String)"chooseDate.png"));
        super.setModel(new CalendarButtonModel());
        this.calendarPanel = new CalendarPanel(locale);
        this.popup = new JDialog();
        this.popup.setUndecorated(true);
        this.popup.getContentPane().add(this.calendarPanel);
        this.popup.setResizable(false);
        this.popup.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        String POP = "POP";
        this.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "POP");
        this.getInputMap().put(KeyStroke.getKeyStroke(32, 0, false), "POP");
        this.getActionMap().put("POP", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (!CalendarPopupButton.this.popup.isShowing()) {
                    CalendarPopupButton.this.showPopup();
                } else {
                    CalendarPopupButton.this.hidePopup();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!CalendarPopupButton.this.popup.isShowing()) {
                    CalendarPopupButton.this.showPopup();
                } else {
                    CalendarPopupButton.this.hidePopup();
                }
            }
        });
        this.popup.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CalendarPopupButton.this.hidePopup();
                    }
                });
            }
        });
        String hideKey = "hide-popup";
        this.calendarPanel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "hide-popup");
        this.calendarPanel.getInputMap(2).put(KeyStroke.getKeyStroke(10, 0), "hide-popup");
        this.calendarPanel.getActionMap().put("hide-popup", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CalendarPopupButton.this.hidePopup();
            }
        });
        this.calendarPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand() == "DOUBLE_CLICK_COMMAND") {
                    CalendarPopupButton.this.hidePopup();
                }
            }
        });
    }

    public void showPopup() {
        if (this.isEnabled()) {
            this.setSelected(true);
            this.popup.pack();
            this.popup.setLocation(this.getPopupLocation());
            this.popup.setVisible(true);
            this.calendarPanel.getDayPanel().getTable().requestFocus();
            this.firePropertyChange(PROPERTY_CALENDAR_POPUP_VISIBLE, false, true);
        }
    }

    public void hidePopup() {
        this.setSelected(false);
        this.popup.setVisible(false);
        if (this.isEnabled()) {
            this.firePropertyChange(PROPERTY_CALENDAR_POPUP_VISIBLE, true, false);
        }
    }

    private Point getPopupLocation() {
        Point p = this.getLocationOnScreen();
        Dimension buttonD = this.getSize();
        Dimension popupD = this.popup.getSize();
        Dimension screenD = Toolkit.getDefaultToolkit().getScreenSize();
        Point loc = new Point();
        loc.y = p.y + buttonD.height + popupD.height <= screenD.height ? p.y + buttonD.height : p.y - popupD.height;
        loc.x = p.x + popupD.width <= screenD.width ? p.x : screenD.width - popupD.width;
        return loc;
    }

    private class CalendarButtonModel
    extends DefaultButtonModel {
        private CalendarButtonModel() {
        }

        @Override
        public boolean isPressed() {
            return CalendarPopupButton.this.popup.isShowing();
        }
    }
}

