/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.breadcrumbs;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;
import javax.swing.plaf.basic.BasicComboPopup;
import oracle.javatools.ui.breadcrumbs.Breadcrumb;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsListener;
import oracle.javatools.ui.breadcrumbs.JBreadcrumbs;
import oracle.javatools.ui.breadcrumbs.PopupItem;
import oracle.javatools.ui.breadcrumbs.PopupProvider;
import oracle.javatools.ui.breadcrumbs.PopupRenderer;

public class PopupHandler {
    private JBreadcrumbs breadcrumbs;
    private BreadcrumbsL breadcrumbsL = new BreadcrumbsL();
    private ActionListener itemActionL = new ItemActionL();
    private PopupProvider provider;
    private JComboBox popupCombo = new JComboBox();
    private BasicComboPopup popup = new BasicComboPopup(this.popupCombo){

        @Override
        public boolean isFocusTraversable() {
            return true;
        }

        @Override
        protected void installKeyboardActions() {
            AbstractAction action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (list.getModel().getSize() > 0) {
                        if (comboBox.getSelectedIndex() != list.getSelectedIndex()) {
                            comboBox.setSelectedIndex(list.getSelectedIndex());
                        } else {
                            comboBox.getEditor().setItem(list.getSelectedValue());
                        }
                    }
                }
            };
            String SELECT_ITEM = "select-item";
            this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "select-item");
            this.getActionMap().put("select-item", action);
        }
    };
    protected static final String KEY_POPUP_ITEM = "KEY_POPUP_ITEM";

    public PopupHandler() {
        this.popupCombo.setRenderer(new PopupRenderer());
        this.popupCombo.setMaximumRowCount(20);
    }

    public void attach(JBreadcrumbs breadcrumbs, PopupProvider provider) {
        this.breadcrumbs = breadcrumbs;
        this.provider = provider;
        this.breadcrumbs.addBreadcrumbsListener(this.breadcrumbsL);
        this.popupCombo.addActionListener(this.itemActionL);
    }

    public void detatch() {
        this.breadcrumbs.removeBreadcrumbsListener(this.breadcrumbsL);
        this.popupCombo.removeAllItems();
        this.popupCombo.removeActionListener(this.itemActionL);
        this.provider = null;
    }

    protected void separatorClicked(Breadcrumb crumb, Rectangle separatorBounds) {
        List<PopupItem> itemList = this.getPopupItems(crumb);
        if (itemList == null || itemList.isEmpty()) {
            return;
        }
        this.popupCombo.setModel(new DefaultComboBoxModel<Object>(itemList.toArray()));
        this.popup.getList().setVisibleRowCount(Math.min(50, itemList.size()));
        this.popup.getList().setFocusable(true);
        this.popup.setFocusable(true);
        this.popupCombo.setSelectedIndex(-1);
        this.popup.getList().setFixedCellHeight(-1);
        this.popup.show(this.breadcrumbs, separatorBounds.x, this.breadcrumbs.getHeight() - 1);
        this.popup.getList().requestFocus();
    }

    protected List<PopupItem> getPopupItems(Breadcrumb breadcrumb) {
        if (this.provider == null) {
            throw new IllegalStateException("PopupHandler has null PopupProvider");
        }
        return this.provider.getPopupItems(breadcrumb);
    }

    private class ItemActionL
    implements ActionListener {
        private ItemActionL() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PopupHandler.this.popup.setVisible(false);
            PopupItem pItem = (PopupItem)PopupHandler.this.popupCombo.getSelectedItem();
            if (pItem == null) {
                return;
            }
            PopupHandler.this.provider.itemSelected(pItem);
        }
    }

    private class BreadcrumbsL
    implements BreadcrumbsListener {
        private BreadcrumbsL() {
        }

        @Override
        public void breadcrumbClicked(Breadcrumb crumb) {
        }

        @Override
        public void breadcrumbContextClicked(Breadcrumb crumb, Point p) {
        }

        @Override
        public void showBreadcrumbPeek(Breadcrumb crumb, Rectangle peekLocation) {
        }

        @Override
        public void hideBreadcrumbPeek() {
        }

        @Override
        public void separatorClicked(Breadcrumb crumb, Rectangle separatorBounds) {
            PopupHandler.this.separatorClicked(crumb, separatorBounds);
        }
    }
}

