/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.balloon;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PanelUI;
import oracle.javatools.ui.balloon.Balloon;

public final class BalloonUI
extends PanelUI {
    protected static final BalloonUI BALLOON_UI = new BalloonUI();
    private Rectangle _scratch = new Rectangle();
    private final MouseAdapter _listener = new MouseAdapter(){

        @Override
        public void mouseReleased(MouseEvent me) {
            Balloon balloon;
            if (me.getButton() == 1 && (balloon = this.getBalloon(me)) != null) {
                MouseEvent balloonEvent = SwingUtilities.convertMouseEvent(me.getComponent(), me, balloon);
                Rectangle cRect = SwingUtilities.calculateInnerArea(balloon, null);
                if (cRect.contains(balloonEvent.getPoint())) {
                    balloon.fireActionPerformed();
                }
            }
        }

        private Balloon getBalloon(MouseEvent me) {
            for (Component c = me.getComponent(); c != null; c = c.getParent()) {
                if (!(c instanceof Balloon)) continue;
                return (Balloon)c;
            }
            return null;
        }
    };

    @Override
    public void paint(Graphics g, JComponent c) {
        g.setColor(c.getBackground());
        ((Graphics2D)g).fill(SwingUtilities.calculateInnerArea(c, this._scratch));
    }

    @Override
    public void installUI(JComponent c) {
        Balloon balloon = (Balloon)c;
        this.installDefaults(balloon);
        this.installListeners(balloon);
    }

    @Override
    public void uninstallUI(JComponent c) {
        Balloon balloon = (Balloon)c;
        this.uninstallDefaults(balloon);
        this.uninstallListeners(balloon);
    }

    protected void installDefaults(Balloon b) {
        b.setOpaque(false);
        LookAndFeel.installColorsAndFont(b, "Balloon.background", "Balloon.foreground", "Balloon.font");
        LookAndFeel.installBorder(b, "Balloon.border");
    }

    protected void uninstallDefaults(Balloon b) {
    }

    public static ComponentUI createUI(JComponent c) {
        return BALLOON_UI;
    }

    private void installListeners(Balloon balloon) {
        balloon.addMouseListener(this._listener);
    }

    private void uninstallListeners(Balloon balloon) {
        balloon.removeMouseListener(this._listener);
    }
}

