/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.actiontip;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.javatools.ui.ViewportChangeNotifier;
import oracle.javatools.ui.actiontip.ActionTip;
import oracle.javatools.ui.actiontip.ActionTipTask;
import oracle.javatools.ui.actiontip.RectangleComponent;

public final class ActionTipManager {
    private static final int FEEDBACK_DURATION = 300;
    private static int tipDisplayDuration = 5000;
    private static ActionTipManager INSTANCE = new ActionTipManager();
    private static ActionTip actionTip;
    private static RectangleComponent boundingRect;
    private List<ActionTipTask> tipQueue = new LinkedList<ActionTipTask>();
    private ActionTipTask currentTask = null;
    private JLayeredPane currentLayeredPane;
    private AWTEventL awtEventL = new AWTEventL();
    private HierarchyL hierarchyL = new HierarchyL();
    private ViewportChangeNotifier viewportChangeNotifier;
    private Timer timer = new Timer(tipDisplayDuration, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ActionTipManager.this.currentTask == null) {
                return;
            }
            ActionTipManager.this.taskComplete(TaskResult.ACCEPTED);
        }
    });
    private boolean isCompleting = false;

    private ActionTipManager() {
        this.timer.setRepeats(false);
        actionTip = new ActionTip();
        actionTip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand() == "ACTION_COMMAND_CANCEL") {
                    ActionTipManager.this.taskComplete(TaskResult.REJECTED);
                }
            }
        });
    }

    public static ActionTipManager getActionTipManager() {
        return INSTANCE;
    }

    public void submitTipTask(ActionTipTask task) {
        assert (SwingUtilities.isEventDispatchThread());
        if (!this.tipQueue.contains(task)) {
            this.tipQueue.add(task);
        }
        this.nextInQueue();
    }

    public void cancelTipTask(ActionTipTask task) {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.currentTask.equals(task)) {
            this.taskComplete(TaskResult.REJECTED);
        } else {
            this.tipQueue.remove(task);
            task.actionTipResult(TaskResult.REJECTED);
        }
    }

    public void acceptTipTask(ActionTipTask task) {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.currentTask.equals(task)) {
            this.taskComplete(TaskResult.ACCEPTED);
        } else {
            this.tipQueue.remove(task);
            task.actionTipResult(TaskResult.ACCEPTED);
        }
    }

    private void nextInQueue() {
        if (this.currentTask != null || this.tipQueue.isEmpty()) {
            return;
        }
        try {
            this.currentTask = this.tipQueue.remove(0);
            JComponent component = this.currentTask.getActionTipContent();
            if (component == null) {
                this.nextInQueue();
                return;
            }
            this.showTip(component);
        }
        catch (RuntimeException e) {
            this.taskComplete(TaskResult.ERROR);
            throw e;
        }
    }

    private void showTip(JComponent component) {
        this.currentLayeredPane = null;
        Window w = SwingUtilities.windowForComponent(this.currentTask.getParentComponent());
        if (this.checkTaskWindowHidden()) {
            this.taskComplete(TaskResult.HIDDEN);
            return;
        }
        if (w instanceof JFrame) {
            this.currentLayeredPane = ((JFrame)w).getLayeredPane();
        } else if (w instanceof JWindow) {
            this.currentLayeredPane = ((JWindow)w).getLayeredPane();
        }
        if (this.currentLayeredPane == null) {
            throw new IllegalStateException("Attempting to show a ActionTip on a component which is not part of a JFrame or JWindow");
        }
        this.currentLayeredPane.add((Component)actionTip, new Integer(JLayeredPane.POPUP_LAYER - 3));
        this.currentLayeredPane.add((Component)boundingRect, new Integer(JLayeredPane.POPUP_LAYER - 4));
        actionTip.setContentComponent(component);
        actionTip.setSize(actionTip.getPreferredSize());
        if (!this.positionTip()) {
            this.taskComplete(TaskResult.HIDDEN);
            return;
        }
        this.currentTask.getParentComponent().addHierarchyListener(this.hierarchyL);
        Toolkit.getDefaultToolkit().addAWTEventListener(this.awtEventL, 8L);
        this.viewportChangeNotifier = new ViewportChangeNotifier(this.currentTask.getParentComponent());
        this.viewportChangeNotifier.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!ActionTipManager.this.positionTip()) {
                    ActionTipManager.this.taskComplete(TaskResult.HIDDEN);
                }
            }
        });
        this.timer.start();
    }

    private void hideTip() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.awtEventL);
        if (this.viewportChangeNotifier != null) {
            this.viewportChangeNotifier.dispose();
        }
        this.viewportChangeNotifier = null;
        if (actionTip != null) {
            if (this.currentTask != null && this.currentTask.getParentComponent() != null) {
                this.currentTask.getParentComponent().removeHierarchyListener(this.hierarchyL);
            }
            Rectangle bounds = actionTip.getBounds();
            if (this.currentLayeredPane != null) {
                this.currentLayeredPane.remove(actionTip);
                this.currentLayeredPane.repaint(bounds);
            }
        }
    }

    private boolean positionTip() {
        JComponent parentComponent = this.currentTask.getParentComponent();
        Rectangle location = this.currentTask.getLocation();
        if (location == null || !parentComponent.getVisibleRect().contains(location)) {
            return false;
        }
        Rectangle r = SwingUtilities.convertRectangle(parentComponent, location, this.currentLayeredPane);
        actionTip.validate();
        int extraBounds = 3;
        boundingRect.setForeground(UIManager.getColor("controlShadow"));
        boundingRect.setSize(r.width + extraBounds + extraBounds, r.height + extraBounds + extraBounds);
        boundingRect.setLocation(r.x - extraBounds, r.y - extraBounds);
        boundingRect.validate();
        r.translate(-actionTip.getWidth() / 2, -actionTip.getHeight());
        Point p = new Point(r.getLocation().x + r.width / 2, r.y);
        actionTip.setLocation(p);
        return true;
    }

    private void taskComplete(TaskResult result) {
        if (this.isCompleting) {
            return;
        }
        this.isCompleting = true;
        this.timer.stop();
        if (this.checkTaskWindowHidden()) {
            result = TaskResult.HIDDEN;
        }
        switch (result) {
            case ACCEPTED: {
                boundingRect.setForeground(new Color(150, 250, 150));
                boundingRect.repaint();
                this.pauseForFeedback(result);
                break;
            }
            case REJECTED: {
                boundingRect.setForeground(new Color(250, 150, 150));
                boundingRect.repaint();
                this.pauseForFeedback(result);
                break;
            }
            default: {
                this.taskReallyComplete(result);
            }
        }
    }

    private void pauseForFeedback(final TaskResult result) {
        Timer t = new Timer(300, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionTipManager.this.taskReallyComplete(result);
            }
        });
        t.setRepeats(false);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void taskReallyComplete(TaskResult result) {
        try {
            if (this.checkTaskWindowHidden()) {
                result = TaskResult.HIDDEN;
            }
            this.hideTip();
            if (this.currentTask != null) {
                this.currentTask.actionTipResult(result);
            }
            this.currentTask = null;
            this.removeBoundingRect();
            this.nextInQueue();
        }
        finally {
            this.isCompleting = false;
        }
    }

    private boolean checkTaskWindowHidden() {
        if (this.currentTask == null) {
            return false;
        }
        Window w = SwingUtilities.windowForComponent(this.currentTask.getParentComponent());
        return w == null || !w.isActive();
    }

    private void removeBoundingRect() {
        if (this.currentLayeredPane != null) {
            Rectangle rect = boundingRect.getBounds();
            this.currentLayeredPane.remove(boundingRect);
            this.currentLayeredPane.repaint(rect);
        }
    }

    public static void setTipDisplayDuration(int tipDisplayDuration) {
        ActionTipManager.tipDisplayDuration = tipDisplayDuration;
        ActionTipManager.getActionTipManager().timer.setInitialDelay(tipDisplayDuration);
    }

    public static int getTipDisplayDuration() {
        return tipDisplayDuration;
    }

    static {
        boundingRect = new RectangleComponent();
    }

    private class HierarchyL
    implements HierarchyListener {
        private HierarchyL() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            JComponent c = (JComponent)e.getSource();
            if (!c.isShowing()) {
                ActionTipManager.this.taskComplete(TaskResult.HIDDEN);
            }
        }
    }

    private class AWTEventL
    implements AWTEventListener {
        private AWTEventL() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (((KeyEvent)event).getKeyCode() == 27) {
                ActionTipManager.this.taskComplete(TaskResult.REJECTED);
            } else if (((KeyEvent)event).getKeyCode() == 10 && ((KeyEvent)event).isAltDown()) {
                ActionTipManager.this.taskComplete(TaskResult.ACCEPTED);
            }
        }
    }

    public static enum TaskResult {
        ACCEPTED,
        REJECTED,
        HIDDEN,
        ERROR;

    }
}

