/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.actiontip;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.lang.ref.SoftReference;
import javax.swing.border.AbstractBorder;

final class ActionTipBorder
extends AbstractBorder {
    public static final int BORDER_POINT_HEIGHT = 8;
    public static final int BORDER_POINT_WIDTH = 8;
    public static final int SHADOW_WIDTH = 4;
    public static final Insets INTERNAL_INDENT = new Insets(0, 3, 0, 0);
    public static final Insets OUTER_INDENT = new Insets(1, 1, 2, 7);
    private static final Insets insets = new Insets(ActionTipBorder.OUTER_INDENT.top + ActionTipBorder.INTERNAL_INDENT.top, ActionTipBorder.OUTER_INDENT.left + ActionTipBorder.INTERNAL_INDENT.left, ActionTipBorder.OUTER_INDENT.bottom + 8 + ActionTipBorder.INTERNAL_INDENT.bottom, ActionTipBorder.OUTER_INDENT.right + ActionTipBorder.INTERNAL_INDENT.right);
    public static final Color edgeColor = Color.DARK_GRAY;
    private SoftReference<BufferedImage> shadowImageRef = new SoftReference<Object>(null);

    @Override
    public Insets getBorderInsets(Component c) {
        return insets;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        return insets;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Shape shadow = this.getShape(x, y, width, height, true);
        Shape s = this.getShape(x, y, width, height, false);
        this.paintShadow(g2, shadow, s);
        g2.setColor(c.getBackground());
        g2.fill(s);
        g2.setColor(Color.DARK_GRAY);
        g2.setStroke(new BasicStroke(1.0f));
        g2.draw(s);
    }

    private void paintShadow(Graphics2D g2, Shape shadowShape, Shape componentShape) {
        Rectangle shadowR = shadowShape.getBounds();
        BufferedImage shadowImage = this.getShadowImage(shadowR.width + 8, shadowR.height + 8);
        Graphics2D shadowG = shadowImage.createGraphics();
        shadowG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        shadowG.setColor(new Color(0, 0, 0));
        shadowG.fill(shadowShape);
        shadowG.dispose();
        float i = 0.04f;
        float[] elements = new float[]{i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i};
        Kernel myKernel = new Kernel(5, 5, elements);
        ConvolveOp simpleBlur = new ConvolveOp(myKernel);
        Graphics2D imageG = (Graphics2D)g2.create();
        imageG.setComposite(AlphaComposite.getInstance(3, 0.558f));
        imageG.drawImage(shadowImage, simpleBlur, 0, 0);
        imageG.dispose();
        Graphics2D clearG = (Graphics2D)g2.create();
        clearG.setComposite(AlphaComposite.Clear);
        clearG.fill(componentShape);
        clearG.dispose();
    }

    private Shape getShape(int x, int y, int width, int height, boolean isShadow) {
        GeneralPath gp = new GeneralPath();
        int SHADOW_MODIFIER = isShadow ? 4 : 0;
        gp.moveTo(x + ActionTipBorder.OUTER_INDENT.left + SHADOW_MODIFIER, y + ActionTipBorder.OUTER_INDENT.top + SHADOW_MODIFIER);
        gp.lineTo(x + width - ActionTipBorder.OUTER_INDENT.right + SHADOW_MODIFIER, y + ActionTipBorder.OUTER_INDENT.top + SHADOW_MODIFIER);
        gp.lineTo(x + width - ActionTipBorder.OUTER_INDENT.right + SHADOW_MODIFIER, y + height - 8 - ActionTipBorder.OUTER_INDENT.bottom + SHADOW_MODIFIER);
        gp.lineTo(x + ActionTipBorder.OUTER_INDENT.left + width / 2 + 4 + SHADOW_MODIFIER, y + height - 8 - ActionTipBorder.OUTER_INDENT.bottom + SHADOW_MODIFIER);
        gp.lineTo(x + ActionTipBorder.OUTER_INDENT.left + width / 2, y + height - ActionTipBorder.OUTER_INDENT.bottom);
        gp.lineTo(x + ActionTipBorder.OUTER_INDENT.left + width / 2 - 4 + SHADOW_MODIFIER, y + height - 8 - ActionTipBorder.OUTER_INDENT.bottom + SHADOW_MODIFIER);
        gp.lineTo(x + ActionTipBorder.OUTER_INDENT.left + SHADOW_MODIFIER, y + height - 8 - ActionTipBorder.OUTER_INDENT.bottom + SHADOW_MODIFIER);
        gp.closePath();
        return gp;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    private BufferedImage getShadowImage(int width, int height) {
        BufferedImage shadowImage = this.shadowImageRef.get();
        if (shadowImage != null && (shadowImage.getWidth() != width || shadowImage.getHeight() != height)) {
            shadowImage = null;
        }
        if (shadowImage == null) {
            shadowImage = new BufferedImage(width, height, 2);
            this.shadowImageRef = new SoftReference<BufferedImage>(shadowImage);
        }
        return shadowImage;
    }
}

