/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.actiontip;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.actiontip.ActionTipBorder;
import oracle.javatools.ui.actiontip.CancelIcon;

final class ActionTip
extends JComponent {
    public static final String ACTION_COMMAND_CANCEL = "ACTION_COMMAND_CANCEL";
    public static final String ACTION_COMMAND_ACCEPT = "ACTION_COMMAND_ACCEPT";
    private boolean isCancelable = true;
    private JComponent contentComponent;
    private JButton cancelButton = new JButton(CancelIcon.INSTANCE);
    private transient ArrayList actionListeners;

    public ActionTip() {
        this.cancelButton.setBorder(BorderFactory.createEmptyBorder());
        this.cancelButton.setOpaque(false);
        this.cancelButton.setMargin(new Insets(0, 2, 2, 2));
        this.cancelButton.setVerticalAlignment(0);
        this.cancelButton.setHorizontalAlignment(0);
        this.cancelButton.setRolloverEnabled(true);
        this.cancelButton.setRolloverIcon(CancelIcon.INSTANCE_ROLLOVER);
        this.cancelButton.setPressedIcon(CancelIcon.INSTANCE_PRESSED);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionTip.this.fireActionPerformed(new ActionEvent(ActionTip.this, 1001, ActionTip.ACTION_COMMAND_CANCEL));
            }
        });
        this.cancelButton.setToolTipText(UIBundle.get("ACTION_TIP_REJECT"));
        this.actionListeners = new ArrayList(2);
        this.setLayout(new BorderLayout(0, 0));
        this.setCancelable(true);
        this.setBorder(new ActionTipBorder());
    }

    public void setCancelable(boolean isCancelable) {
        this.isCancelable = isCancelable;
        if (isCancelable) {
            this.add((Component)this.cancelButton, "East");
        } else {
            this.remove(this.cancelButton);
        }
    }

    public boolean isCancelable() {
        return this.isCancelable;
    }

    public void setContentComponent(JComponent contentComponent) {
        if (this.contentComponent != null) {
            this.remove(this.contentComponent);
        }
        this.contentComponent = contentComponent;
        this.setBackground(contentComponent.getBackground());
        if (this.contentComponent != null) {
            this.add((Component)this.contentComponent, "Center");
        }
    }

    public JComponent getContentComponent() {
        return this.contentComponent;
    }

    public synchronized void addActionListener(ActionListener listener) {
        if (this.actionListeners == null) {
            this.actionListeners = new ArrayList(2);
        }
        this.actionListeners.add(listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        if (this.actionListeners != null) {
            this.actionListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActionPerformed(ActionEvent actionEvent) {
        List list;
        ActionTip actionTip = this;
        synchronized (actionTip) {
            if (this.actionListeners == null) {
                return;
            }
            list = (List)this.actionListeners.clone();
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            ((ActionListener)list.get(i)).actionPerformed(actionEvent);
        }
    }
}

