/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicSeparatorUI;
import oracle.javatools.ui.Colors;

public class TitledSeparator
extends JPanel {
    private static Stroke dottedStroke = new BasicStroke(1.0f, 2, 2, 10.0f, new float[]{0.0f, 4.0f}, 0.0f);
    private static Stroke lineStroke = new BasicStroke(1.0f, 2, 2);
    private JLabel label = new JLabel();
    private JSeparator leadingSep = new JSeparator();
    private JSeparator trailingSep = new JSeparator();
    private STYLE style = STYLE.LINE;

    public TitledSeparator(String title) {
        this.init();
        this.setTitle(title);
    }

    public TitledSeparator(String title, STYLE style) {
        this.style = style;
        this.init();
        this.setTitle(title);
    }

    public void setTitle(String text) {
        this.label.setText(text);
    }

    public String getTitle() {
        return this.label.getText();
    }

    public void setSeparatorColor(Color color) {
        this.leadingSep.setForeground(color);
        this.trailingSep.setForeground(color);
    }

    public Color getSeparatorColor() {
        return this.leadingSep.getForeground();
    }

    private void init() {
        this.setOpaque(false);
        this.label.setForeground(UIManager.getColor("TitledBorder.titleColor"));
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.setLayout(new BorderLayout());
        JPanel labelPanel = new JPanel(new BorderLayout());
        labelPanel.setOpaque(false);
        Color sepColor = Colors.isFusionBlueLAF() ? new Color(204, 204, 204) : UIManager.getColor("Label.disabledForeground");
        this.leadingSep.setUI(new DottedSeparatorUI());
        this.leadingSep.setForeground(sepColor);
        this.leadingSep.setPreferredSize(new Dimension(10, 2));
        this.trailingSep.setUI(new DottedSeparatorUI());
        this.trailingSep.setForeground(sepColor);
        labelPanel.add((Component)this.leadingSep, "Before");
        labelPanel.add((Component)this.label, "After");
        this.add((Component)labelPanel, "Before");
        this.add((Component)this.trailingSep, "Center");
    }

    private class DottedSeparatorUI
    extends BasicSeparatorUI {
        private DottedSeparatorUI() {
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            Dimension s = c.getSize();
            int y = 1 + s.height / 2;
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setColor(c.getForeground());
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setStroke(TitledSeparator.this.style.getStroke());
            g2.drawLine(0, y, s.width, y);
            g2.dispose();
        }
    }

    public static enum STYLE {
        LINE,
        DOTTED;


        public Stroke getStroke() {
            switch (this) {
                case LINE: {
                    return lineStroke;
                }
                case DOTTED: {
                    return dottedStroke;
                }
            }
            return new BasicStroke();
        }
    }
}

