/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class SectionView
extends JPanel {
    protected int viewStart = -1;
    protected int viewEnd = -1;
    private JComponent wrappedComponent;

    public SectionView() {
        this.setLayout(null);
        this.setOpaque(false);
    }

    public SectionView(JComponent componentToViewRestrict) {
        this();
        this.setWrappedComponent(componentToViewRestrict);
    }

    public boolean isRestricted() {
        return this.viewStart != -1 && this.viewEnd > this.viewStart;
    }

    @Override
    public Color getBackground() {
        if (this.wrappedComponent == null) {
            return super.getBackground();
        }
        return this.wrappedComponent.getBackground();
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paintComponent(g);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension parentD = this.getParent().getSize();
        if (this.getWrappedComponent() == null) {
            return parentD;
        }
        Dimension d = this.wrappedComponent.getPreferredSize();
        if (this.isRestricted()) {
            d.height = Math.min(d.height, this.viewEnd - this.viewStart);
        }
        d.width = Math.max(d.width, parentD.width);
        d.height = Math.max(parentD.height, d.height);
        return d;
    }

    public void setWrappedComponent(JComponent wrappedComponent) {
        if (this.wrappedComponent != null) {
            this.remove(this.wrappedComponent);
        }
        this.wrappedComponent = wrappedComponent;
        if (this.wrappedComponent != null) {
            this.add(wrappedComponent);
        }
    }

    public JComponent getWrappedComponent() {
        return this.wrappedComponent;
    }

    public void setViewBounds(int viewStart, int viewEnd) {
        if (this.viewStart == viewStart && this.viewEnd == viewEnd) {
            return;
        }
        this.viewStart = viewStart;
        this.viewEnd = viewEnd;
        this.setBounds(this.getBounds());
        this.doLayout();
    }

    @Override
    public void doLayout() {
        if (this.wrappedComponent == null) {
            return;
        }
        if (this.isRestricted()) {
            this.wrappedComponent.setLocation(0, -this.viewStart);
            this.wrappedComponent.setSize(this.getWidth(), this.viewEnd);
        } else {
            this.wrappedComponent.setLocation(0, 0);
            this.wrappedComponent.setSize(this.getWidth(), this.getHeight());
        }
    }

    public int getViewStart() {
        return this.viewStart;
    }

    public int getViewEnd() {
        return this.viewStart;
    }
}

