/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.javatools.ui.ResizeScrollPaneLayout;

public class ResizeComponent
extends JPanel {
    private static Dimension resizeD = new Dimension(16, 16);
    private ResizeGrip resizeGrip = new ResizeGrip();
    private JComponent componentToResize;
    private final MouseL ml = new MouseL();

    public ResizeComponent(JComponent componentToResize) {
        JScrollPane sp;
        this.componentToResize = componentToResize;
        this.setLayout(null);
        this.add(componentToResize);
        this.setOpaque(false);
        this.resizeGrip.setSize(resizeD);
        if (componentToResize instanceof JScrollPane && !((sp = (JScrollPane)componentToResize).getLayout() instanceof ResizeScrollPaneLayout)) {
            sp.setLayout(new ResizeScrollPaneLayout());
        }
        this.add((Component)this.resizeGrip, 0);
    }

    @Override
    public void doLayout() {
        Insets insets = this.getInsets();
        this.componentToResize.setLocation(insets.left, insets.top);
        this.componentToResize.setSize(this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
        this.resizeGrip.setLocation(this.getWidth() - insets.right - ResizeComponent.resizeD.width - 1, this.getHeight() - insets.bottom - ResizeComponent.resizeD.height - 1);
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        Dimension size = this.componentToResize.getPreferredSize();
        size.width += insets.left + insets.right;
        size.height += insets.top + insets.bottom;
        return size;
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        Insets insets = this.getInsets();
        preferredSize.width -= insets.left + insets.right;
        preferredSize.height -= insets.top + insets.bottom;
        this.componentToResize.setPreferredSize(preferredSize);
    }

    @Override
    public Dimension getMinimumSize() {
        Insets insets = this.getInsets();
        Dimension size = this.componentToResize.getMinimumSize();
        size.width += insets.left + insets.right;
        size.height += insets.top + insets.bottom;
        return size;
    }

    @Override
    public void setMaximumSize(Dimension preferredSize) {
        Insets insets = this.getInsets();
        preferredSize.width -= insets.left + insets.right;
        preferredSize.height -= insets.top + insets.bottom;
        this.componentToResize.setMaximumSize(preferredSize);
    }

    private class ResizeGrip
    extends JComponent {
        private Stroke wideStroke = new BasicStroke(1.0f);
        private Stroke thinStoke = new BasicStroke(0.5f);
        private Color lightColor = UIManager.getColor("controlDkShadow");
        private Color darkColor = UIManager.getColor("controlDkShadow").darker();

        private ResizeGrip() {
        }

        @Override
        public Cursor getCursor() {
            PointerInfo info = MouseInfo.getPointerInfo();
            if (info != null && info.getLocation() != null) {
                Point p = info.getLocation();
                SwingUtilities.convertPointFromScreen(p, this);
                if (p.x + p.y > this.getHeight()) {
                    if (!Arrays.asList(this.getMouseListeners()).contains(ResizeComponent.this.ml)) {
                        this.addMouseListener(ResizeComponent.this.ml);
                    }
                    if (!Arrays.asList(this.getMouseMotionListeners()).contains(ResizeComponent.this.ml)) {
                        this.addMouseMotionListener(ResizeComponent.this.ml);
                    }
                    return Cursor.getPredefinedCursor(5);
                }
            }
            if (Arrays.asList(this.getMouseListeners()).contains(ResizeComponent.this.ml)) {
                this.removeMouseListener(ResizeComponent.this.ml);
            }
            if (Arrays.asList(this.getMouseMotionListeners()).contains(ResizeComponent.this.ml)) {
                this.removeMouseMotionListener(ResizeComponent.this.ml);
            }
            return super.getCursor();
        }

        @Override
        public Dimension getPreferredSize() {
            return resizeD;
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int noLines = 3;
            int lineSpacing = 4;
            Color bgColor = ResizeComponent.this.componentToResize.getBackground();
            if (ResizeComponent.this.componentToResize instanceof JScrollPane) {
                bgColor = ((JScrollPane)ResizeComponent.this.componentToResize).getViewport().getView().getBackground();
            }
            g2.setColor(bgColor);
            GeneralPath cornerPath = new GeneralPath();
            cornerPath.moveTo(this.getWidth() - 12 - 1, this.getHeight());
            cornerPath.lineTo(this.getWidth(), this.getHeight() - 12 - 1);
            cornerPath.lineTo(this.getWidth(), this.getHeight());
            cornerPath.closePath();
            g2.fill(cornerPath);
            for (int i = 1; i <= 3; ++i) {
                g2.setColor(this.lightColor);
                g2.setStroke(this.wideStroke);
                g2.drawLine(this.getWidth() - i * 4, this.getHeight() - 2, this.getWidth() - 2, this.getHeight() - i * 4);
                g2.setColor(this.darkColor);
                g2.setStroke(this.thinStoke);
                g2.drawLine(this.getWidth() - i * 4, this.getHeight() - 2, this.getWidth() - 2, this.getHeight() - i * 4);
            }
            g2.dispose();
        }
    }

    private class MouseL
    extends MouseAdapter
    implements AWTEventListener {
        private Dimension d = null;

        private MouseL() {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 48L);
            if (me.getX() + me.getY() > ResizeComponent.this.resizeGrip.getHeight()) {
                this.d = new Dimension(ResizeComponent.this.resizeGrip.getWidth() - me.getX(), ResizeComponent.this.resizeGrip.getHeight() - me.getY());
            }
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (event instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)event;
                if (me.getID() == 506) {
                    if (this.d != null) {
                        Point p = me.getLocationOnScreen();
                        SwingUtilities.convertPointFromScreen(p, ResizeComponent.this.componentToResize);
                        Dimension minSize = ResizeComponent.this.getMinimumSize();
                        Dimension maxSize = ResizeComponent.this.getMaximumSize();
                        Dimension newD = new Dimension(Math.max(p.x + this.d.width, (int)minSize.getWidth()), Math.max(p.y + this.d.height, (int)minSize.getHeight()));
                        newD = new Dimension(Math.min(newD.width, (int)maxSize.getWidth()), Math.min(newD.height, (int)maxSize.getHeight()));
                        ResizeComponent.this.componentToResize.setPreferredSize(newD);
                        ResizeComponent.this.revalidate();
                    }
                } else if (me.getID() == 502) {
                    this.d = null;
                    Toolkit.getDefaultToolkit().removeAWTEventListener(this);
                }
            }
        }
    }
}

