/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.Color;
import oracle.bali.ewt.graphics.ColorUtils;

public class ColorUtils2
extends ColorUtils {
    public static Color getCompliment(Color c) {
        double[] hsb = ColorUtils2.colorToHSB((Color)c);
        hsb[0] = hsb[0] + 180.0;
        if (hsb[0] >= 360.0) {
            hsb[0] = hsb[0] - 360.0;
        }
        return ColorUtils2.hsbToColor((double)hsb[0], (double)hsb[1], (double)hsb[2]);
    }

    public static Color getTriad(Color c, int index) {
        if (index < 0 || index > 2) {
            throw new IllegalArgumentException("index out of range. Must be between 0 and 2 inclusive : " + index);
        }
        double[] hsb = ColorUtils2.colorToHSB((Color)c);
        hsb[0] = hsb[0] + (double)(120 * index);
        if (hsb[0] >= 360.0) {
            hsb[0] = hsb[0] - 360.0;
        }
        return ColorUtils2.hsbToColor((double)hsb[0], (double)hsb[1], (double)hsb[2]);
    }

    public static Color getAnalogous(Color c, int index) {
        if (index < -1 || index > 1) {
            throw new IllegalArgumentException("index out of range. Must be between -1 and 1 inclusive : " + index);
        }
        double[] hsb = ColorUtils2.colorToHSB((Color)c);
        hsb[0] = hsb[0] + (double)(30 * index);
        if (hsb[0] >= 360.0) {
            hsb[0] = hsb[0] - 360.0;
        }
        if (hsb[0] < 0.0) {
            hsb[0] = hsb[0] + 360.0;
        }
        return ColorUtils2.hsbToColor((double)hsb[0], (double)hsb[1], (double)hsb[2]);
    }

    public static Color getTetrad(Color c, int index) {
        if (index < 0 || index > 3) {
            throw new IllegalArgumentException("index out of range. Must be between 0 and 3 inclusive : " + index);
        }
        double[] hsb = ColorUtils2.colorToHSB((Color)c);
        hsb[0] = hsb[0] + (double)(90 * index);
        if (hsb[0] >= 360.0) {
            hsb[0] = hsb[0] - 360.0;
        }
        if (hsb[0] < 0.0) {
            hsb[0] = hsb[0] + 360.0;
        }
        return ColorUtils2.hsbToColor((double)hsb[0], (double)hsb[1], (double)hsb[2]);
    }

    public static Color shadeColorPercent(Color c, double percent) {
        return ColorUtils2.shadeColor((Color)c, (int)((int)(percent / 100.0 * 255.0)));
    }

    public static Color saturateColor(Color c, double percent) {
        double[] hsl = ColorUtils2.colorToHSL((Color)c);
        double s = hsl[1] / 100.0 * percent;
        s = Math.max(0.0, s);
        s = Math.min(100.0, s);
        Color newC = ColorUtils2.hslToColor((double)hsl[0], (double)s, (double)hsl[2]);
        return newC;
    }

    public static Color alphaColor(Color c, int alpha) {
        Color newC = new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
        return newC;
    }
}

