/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.Ide;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.SelectFilesPanel;
import oracle.ide.model.Displayable;
import oracle.ide.model.Node;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.SearchProgress;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibraryList;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.ListWrapper;
import oracle.jdevimpl.library.LeafNode;
import oracle.jdevimpl.library.LibraryArb;
import oracle.jdevimpl.library.LibraryListNode;
import oracle.jdevimpl.library.LibraryNode;
import oracle.jdevimpl.library.LibraryPanel;
import oracle.jdevimpl.library.LibrarySearchQueryFactory;
import oracle.jdevimpl.library.LibrarySearchQueryFilter;
import oracle.jdevimpl.library.ListNode;

public abstract class TreePanel
extends LibraryPanel {
    private static final String NEW_CMD = "New";
    private static final String ADD_CMD = "Add";
    private static final String REMOVE_CMD = "Remove";
    private static URL defDir = URLFactory.newDirURL((String)Ide.getUserSettingsDirectory());
    private CardLayout cardLayout1 = new CardLayout();
    private JSplitPane splitPane = new JSplitPane();
    private JScrollPane libsTreeScroller = new JScrollPane();
    private JPanel masterPanel = new JPanel();
    private JComponent detailPanel;
    private JLabel libsLabel = new JLabel();
    private JTree libsTree = new JTree();
    private JPanel buttonPanel = new JPanel();
    private GridLayout buttonLayout = new GridLayout();
    private JButton newButton = new JButton();
    private JButton addButton = new JButton();
    private JButton removeButton = new JButton();
    private SearchField searchField = null;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private DefaultTreeModel libsModel;
    private DefaultTreeCellRenderer libsTreeRenderer = new Renderer();
    private SelectionManager selMgr = new SelectionManager();
    private boolean isSplit = true;
    private SearchHelper m_searchHelper = null;
    private LibrarySearchQueryFilter m_queryFilter;
    private static SearchCategory MRU_SEARCH_CATEGORY = LibrarySearchQueryFactory.CLASS_CATEGORY;

    public TreePanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.cardLayout1);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.addTreeSelectionListener(this.selMgr);
        this.setFocusable(false);
        this.masterPanel.setBorder(BorderFactory.createEmptyBorder());
        this.masterPanel.setLayout(this.gridBagLayout1);
        this.libsTree.getSelectionModel().setSelectionMode(1);
        this.libsTree.setRootVisible(false);
        this.libsTree.setShowsRootHandles(true);
        this.libsTree.setCellRenderer(this.libsTreeRenderer);
        this.libsTree.addKeyListener(this.selMgr);
        this.libsTree.setFocusable(true);
        ToolTipManager.sharedInstance().registerComponent(this.libsTree);
        this.buttonPanel.setLayout(this.buttonLayout);
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder());
        this.buttonLayout.setHgap(2);
        ResourceUtils.resLabel((JLabel)this.libsLabel, (Component)this.libsTree, (String)LibraryArb.getString(88));
        this.newButton.setActionCommand(NEW_CMD);
        this.newButton.setEnabled(false);
        this.newButton.addActionListener(this.selMgr);
        this.addButton.setActionCommand(ADD_CMD);
        this.addButton.setEnabled(true);
        this.addButton.addActionListener(this.selMgr);
        this.removeButton.setActionCommand(REMOVE_CMD);
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(this.selMgr);
        this.splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.libsTreeScroller.setViewportView(this.libsTree);
        ResourceUtils.resButton((AbstractButton)this.newButton, (String)LibraryArb.getString(5));
        ResourceUtils.resButton((AbstractButton)this.addButton, (String)LibraryArb.getString(6));
        ResourceUtils.resButton((AbstractButton)this.removeButton, (String)LibraryArb.getString(7));
        this.buttonPanel.add((Component)this.newButton, null);
        this.buttonPanel.add((Component)this.addButton, null);
        this.buttonPanel.add((Component)this.removeButton, null);
        this.searchField = new SearchField();
        this.setupSearchField(this.searchField);
        this.masterPanel.add((Component)this.searchField, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 0, 5, 0), 0, 0));
        this.masterPanel.add((Component)this.libsLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(11, 0, 6, 0), 0, 0));
        this.masterPanel.add((Component)this.libsTreeScroller, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.masterPanel.add((Component)this.buttonPanel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.splitPane.add((Component)this.masterPanel, "left");
        this.add((Component)this.splitPane, "jSplitPane1");
        this.m_searchHelper = new SearchHelper();
    }

    private void setupSearchField(final SearchField searchField) {
        int currentHeight = (int)searchField.getPreferredSize().getHeight();
        searchField.setMinimumSize(new Dimension(200, currentHeight));
        searchField.setStyle(SearchField.Style.SEARCH);
        for (SearchCategory searchCategory : LibrarySearchQueryFactory.SEARCH_CATEGORIES) {
            searchField.addCategory(searchCategory);
        }
        searchField.setSelectedCategory(MRU_SEARCH_CATEGORY);
        searchField.getTextField().addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                String queryText = searchField.getText();
                if ((queryText == null || queryText.length() == 0) && TreePanel.this.m_searchHelper.m_defaultModel != null) {
                    TreePanel.this.libsTree.setModel(TreePanel.this.m_searchHelper.m_defaultModel);
                    TreePanel.this.expandAll(TreePanel.this.libsTree, true);
                }
            }
        });
        searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent e) {
                String searchText;
                MRU_SEARCH_CATEGORY = e.getSearchCategory();
                String string = searchText = e.isFromClear() ? "" : e.getSearchText().trim();
                if (!"".equals(searchText)) {
                    TreePanel.this.m_searchHelper.startSearch(searchText, e.getSearchProgress());
                }
            }

            public void searchCategoryChanged(SearchEvent e) {
            }
        });
        searchField.getTextField().putClientProperty((Object)"PromptedTextField.showPromptOnEmptyWithFocus", (Object)true);
    }

    public final boolean isSplit() {
        return this.isSplit;
    }

    public void setSplit(boolean split) {
        if (this.isSplit == split) {
            return;
        }
        this.isSplit = split;
        if (this.isSplit) {
            this.remove(this.masterPanel);
            this.splitPane.add((Component)this.masterPanel, "left");
            this.splitPane.add((Component)this.detailPanel, "right");
            this.add((Component)this.splitPane, "jSplitPane1");
            this.libsTree.getSelectionModel().setSelectionMode(1);
        } else {
            this.remove(this.splitPane);
            this.add((Component)this.masterPanel, "masterPanel");
            this.libsTree.getSelectionModel().setSelectionMode(4);
        }
    }

    public void setSelectionMode(int mode) {
        switch (mode) {
            case 1: 
            case 2: 
            case 4: {
                this.libsTree.getSelectionModel().setSelectionMode(mode);
            }
        }
    }

    public final void initPanel(ListWrapper[] lists, Object selection) {
        TreePath path;
        this.initPanel(lists);
        TreeNode node = this.findNode(null, selection);
        if (node != null && (path = new TreePath(this.libsModel.getPathToRoot(node))) != null) {
            this.libsTree.setSelectionPath(path);
            this.libsTree.scrollPathToVisible(path);
            this.libsTree.requestFocus();
        }
    }

    @Override
    public void initPanel(ListWrapper[] lists) {
        this.libsModel = this.createTreeModel(lists);
        this.libsTree.setModel(this.libsModel);
        this.m_searchHelper.setDefaultTreeModel(this.libsModel);
        for (int i = lists.length - 1; i >= 0; --i) {
            this.libsTree.expandRow(i);
        }
        TreeNode root = (TreeNode)this.libsModel.getRoot();
        int count = root.getChildCount();
        for (int i = 0; i < count; ++i) {
            TreeNode node = root.getChildAt(i);
            if (node.getChildCount() <= 0) continue;
            TreePath path = new TreePath(((DefaultMutableTreeNode)node.getChildAt(0)).getPath());
            this.libsTree.setSelectionPath(path);
            this.libsTree.requestFocus();
            return;
        }
        if (count > 0) {
            this.libsTree.setSelectionRow(0);
        }
        this.libsTree.requestFocus();
    }

    @Override
    public final ListWrapper[] getLibraryLists() {
        TreeNode root = (TreeNode)this.libsModel.getRoot();
        ListWrapper[] result = new ListWrapper[root.getChildCount()];
        for (int i = 0; i < result.length; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)root.getChildAt(i);
            result[i] = (ListWrapper)child.getUserObject();
        }
        return result;
    }

    public final void addTreeSelectionListener(TreeSelectionListener l) {
        this.libsTree.addTreeSelectionListener(l);
    }

    public final void addMouseListenerToTree(MouseListener l) {
        this.libsTree.addMouseListener(l);
    }

    protected abstract DefaultTreeModel createTreeModel(ListWrapper[] var1);

    protected final DefaultTreeModel getTreeModel() {
        return this.libsModel;
    }

    @Override
    public boolean commitChanges() {
        return true;
    }

    public Library[] getSelection() {
        return this.selMgr._getElements(this.selMgr.selPaths);
    }

    protected final void setLeafIcon(Icon icon) {
        this.libsTreeRenderer.setLeafIcon(icon);
    }

    protected final void setDetailPanel(JComponent detail, String newTitle) {
        this.detailPanel = detail;
        this.splitPane.add((Component)this.detailPanel, "right");
    }

    protected void selectNode(DefaultMutableTreeNode node) {
        final TreePath path = new TreePath(node.getPath());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreePanel.this.libsTree.setSelectionPath(path);
                TreePanel.this.libsTree.scrollPathToVisible(path);
            }
        });
    }

    protected TreeNode findNode(TreeNode root, Object userObject) {
        if (root == null) {
            root = (TreeNode)this.libsModel.getRoot();
        }
        return TreePanel._findMatch(root, userObject);
    }

    protected static TreeNode _findMatch(TreeNode node, Object userObject) {
        TreeNode result = null;
        Object candidate = ((DefaultMutableTreeNode)node).getUserObject();
        if (candidate != null && userObject != null && candidate.equals(userObject)) {
            result = node;
        } else if (node.getAllowsChildren()) {
            int count = node.getChildCount();
            for (int i = 0; i < count && (result = TreePanel._findMatch(node.getChildAt(i), userObject)) == null; ++i) {
            }
        }
        return result;
    }

    private void _updateButtons(DefaultMutableTreeNode[] sel) {
        boolean allowNew = true;
        boolean canRemove = true;
        if (sel != null && sel.length > 0) {
            int leaves = 0;
            int lists = 0;
            boolean areSiblings = true;
            ListNode listNode = null;
            for (int i = 0; i < sel.length; ++i) {
                if (sel[i] instanceof LeafNode) {
                    ++leaves;
                    if (listNode == null) {
                        listNode = (ListNode)sel[i].getParent();
                    } else if (listNode != sel[i].getParent()) {
                        areSiblings = false;
                        listNode = (ListNode)sel[i].getParent();
                    }
                    canRemove = canRemove && lists == 0 && this._canListChange(listNode);
                    continue;
                }
                if (sel[i] instanceof ListNode) {
                    listNode = (ListNode)sel[i];
                    ++lists;
                    canRemove = canRemove && leaves == 0 && listNode.getList().getWrappedList() != JLibraryManager.getUserLibraries() && listNode.getList().getWrappedList() instanceof JLibraryList;
                    continue;
                }
                canRemove = false;
            }
        } else {
            canRemove = false;
        }
        this.newButton.setEnabled(allowNew);
        this.removeButton.setEnabled(canRemove);
    }

    public void setTree1SelectionRow(int row) {
        this.libsTree.setSelectionRow(row);
    }

    public void expandAll(JTree tree, boolean expand) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        this.expandAll(tree, new TreePath(root), expand);
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    private boolean _canListChange(ListNode node) {
        ListWrapper list = node.getList();
        return !list.isTransient();
    }

    protected abstract boolean updateSelection(Library var1);

    protected abstract Library createNewElement(ListWrapper[] var1);

    protected abstract ListNode addLibraryList(ListWrapper var1);

    protected abstract void nodeDeleted(LeafNode var1);

    protected abstract LibraryListNode createLibraryListNode(ListWrapper var1, Iterator var2);

    private static final class Renderer
    extends DefaultTreeCellRenderer {
        public Renderer() {
            this.setOpenIcon(IdeArb.getIcon((int)54));
            this.setClosedIcon(OracleIcons.getIcon((String)"folder.png"));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean set, boolean expanded, boolean leaf, int row, boolean focus) {
            JLabel c = (JLabel)super.getTreeCellRendererComponent(tree, value, set, expanded, leaf, row, focus);
            Object obj = ((DefaultMutableTreeNode)value).getUserObject();
            if (obj instanceof Displayable) {
                Displayable displayable = (Displayable)obj;
                if (obj instanceof Node && !((Node)obj).isOpen()) {
                    try {
                        ((Node)obj).open();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
                this.setText(displayable.getShortLabel());
                this.setToolTipText(displayable.getToolTipText());
                if (obj instanceof Library) {
                    this.setIcon(this.getIcon((Library)obj));
                } else if (expanded) {
                    this.setIcon(this.getOpenIcon());
                } else {
                    this.setIcon(this.getClosedIcon());
                }
            } else if (obj != null) {
                this.setToolTipText(obj.toString());
                if (leaf) {
                    this.setIcon(this.getLeafIcon());
                } else if (expanded) {
                    this.setIcon(this.getOpenIcon());
                } else {
                    this.setIcon(this.getClosedIcon());
                }
            }
            return c;
        }

        private Icon getIcon(Library lib) {
            URLPath path = lib.getClassPath();
            if (!(path != null && path.size() != 0 || (path = lib.getSourcePath()) != null && path.size() != 0 || (path = lib.getDocPath()) != null && path.size() != 0)) {
                this.setForeground(Color.red);
                return OracleIcons.getIcon((String)"warning.png");
            }
            return lib.getIcon();
        }
    }

    private final class SelectionManager
    extends KeyAdapter
    implements ActionListener,
    TreeSelectionListener {
        private TreePath[] selPaths;

        private SelectionManager() {
        }

        private Library[] _getElements(TreePath[] paths) {
            if (paths == null || paths.length == 0) {
                return null;
            }
            ArrayList<Library> list = new ArrayList<Library>();
            for (int i = 0; i < paths.length; ++i) {
                DefaultMutableTreeNode node;
                DefaultMutableTreeNode defaultMutableTreeNode = node = paths[i] != null ? (DefaultMutableTreeNode)paths[i].getLastPathComponent() : null;
                if (node.getUserObject() instanceof Library) {
                    list.add((Library)node.getUserObject());
                    continue;
                }
                if (node.getParent() == null || !(((DefaultMutableTreeNode)node.getParent()).getUserObject() instanceof Library)) continue;
                list.add((Library)((DefaultMutableTreeNode)node.getParent()).getUserObject());
            }
            if (list.size() > 0) {
                return list.toArray(new Library[list.size()]);
            }
            return null;
        }

        @Override
        public final void actionPerformed(ActionEvent ae) {
            String cmd = ae.getActionCommand();
            if (TreePanel.NEW_CMD.equals(cmd)) {
                this.createLibrary();
            } else if (TreePanel.ADD_CMD.equals(cmd)) {
                this.addDirectory();
            } else if (TreePanel.REMOVE_CMD.equals(cmd)) {
                this.deleteSelection();
            }
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            Library[] sel = null;
            TreePath[] paths = TreePanel.this.libsTree.getSelectionPaths();
            DefaultMutableTreeNode[] nodes = null;
            if (paths != null) {
                nodes = new DefaultMutableTreeNode[paths.length];
                for (int i = 0; i < paths.length; ++i) {
                    nodes[i] = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
                }
                sel = this._getElements(paths);
            }
            TreePanel.this._updateButtons(nodes);
            if (!TreePanel.this.updateSelection(sel != null && sel.length > 0 ? sel[0] : null)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (SelectionManager.this.selPaths != null && SelectionManager.this.selPaths.length > 0) {
                            TreePanel.this.libsTree.setSelectionPaths(SelectionManager.this.selPaths);
                        }
                    }
                });
            } else {
                this.selPaths = paths;
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() == '\u007f') {
                if (TreePanel.this.removeButton.isEnabled()) {
                    this.deleteSelection();
                }
                e.consume();
            }
        }

        private void createLibrary() {
            ListWrapper[] selectedWrapper;
            Library elem;
            boolean commited;
            TreePath[] paths = TreePanel.this.libsTree.getSelectionPaths();
            Object o = paths != null && paths.length > 0 ? paths[0].getLastPathComponent() : null;
            ListNode listNode = null;
            if (o instanceof ListNode) {
                listNode = (ListNode)o;
            } else if (o instanceof LeafNode) {
                listNode = (ListNode)((LeafNode)o).getParent();
            }
            boolean bl = commited = TreePanel.this.isSplit ? TreePanel.this.commitChanges() : true;
            if (commited && (elem = TreePanel.this.createNewElement(selectedWrapper = new ListWrapper[]{listNode != null ? listNode.getList() : null})) != null) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)TreePanel.this.findNode(null, elem);
                if (child != null) {
                    child.setUserObject(elem);
                    TreePanel.this.libsModel.nodeChanged(child);
                } else {
                    ListNode temp = (ListNode)TreePanel.this.findNode(null, selectedWrapper[0]);
                    if (temp != null) {
                        listNode = temp;
                    }
                    child = (DefaultMutableTreeNode)listNode.add(elem);
                    TreePanel.this.libsModel.nodesWereInserted(listNode, new int[]{listNode.getIndex(child)});
                }
                TreePanel.this.selectNode(child);
            }
        }

        private void addDirectory() {
            URL url;
            URLChooser chooser = DialogUtil.newURLChooser((URL)defDir);
            chooser.setSelectionMode(0);
            chooser.setSelectionScope(1);
            chooser.setShowJarsAsDirs(false);
            int result = chooser.showOpenDialog((Component)TreePanel.this, LibraryArb.getString(81));
            if (result == 0 && (url = chooser.getSelectedURL()) != null) {
                JLibraryList list = JLibraryManager.addLibraryList(url);
                ListWrapper[] lists = TreePanel.this.getLibraryLists();
                boolean found = false;
                if (lists != null) {
                    for (int i = 0; i < lists.length; ++i) {
                        if (list != lists[i]) continue;
                        found = true;
                    }
                }
                if (!found) {
                    ListWrapper wrapper = new ListWrapper(list);
                    ListNode listNode = TreePanel.this.addLibraryList(wrapper);
                    TreePath path = new TreePath(listNode.getPath());
                    defDir = URLFileSystem.getParent((URL)url);
                    TreePanel.this.libsTree.expandPath(path);
                    TreePanel.this.selectNode(listNode);
                }
            }
        }

        private void deleteSelection() {
            TreePath[] paths = TreePanel.this.libsTree.getSelectionPaths();
            if (paths == null) {
                return;
            }
            HashMap<ListWrapper, ArrayList<Library>> listMap = new HashMap<ListWrapper, ArrayList<Library>>();
            for (int i = 0; i < paths.length; ++i) {
                Object o = paths[i].getLastPathComponent();
                if (o instanceof ListNode) {
                    ListNode node = (ListNode)o;
                    ListWrapper list = node.getList();
                    JLibraryManager.removeLibraryList(list.getWrappedList());
                    TreePanel.this.libsModel.removeNodeFromParent(node);
                    continue;
                }
                if (!(o instanceof LeafNode)) continue;
                LeafNode leaf = (LeafNode)o;
                ListNode parent = (ListNode)leaf.getParent();
                Library library = (Library)leaf.getUserObject();
                ListWrapper wrapper = parent.getList();
                ArrayList<Library> deletions = (ArrayList<Library>)listMap.get(wrapper);
                if (deletions == null) {
                    deletions = new ArrayList<Library>();
                    listMap.put(wrapper, deletions);
                }
                deletions.add(library);
            }
            if (!listMap.isEmpty()) {
                CheckBoxListModel listModel = new CheckBoxListModel();
                Iterator i = listMap.keySet().iterator();
                ArrayList<Library> confirmations = new ArrayList<Library>();
                while (i.hasNext()) {
                    Object key = i.next();
                    ArrayList list = (ArrayList)listMap.get(key);
                    for (int x = list.size() - 1; x >= 0; --x) {
                        Library lib = (Library)list.get(x);
                        Object id = lib.getID();
                        String desc = id instanceof URL ? URLFileSystem.getPlatformPathName((URL)((URL)id)) : id.toString();
                        listModel.addElement((Object)lib, lib.getIcon(), true, true, desc);
                    }
                }
                int listSize = listModel.getSize();
                if (listSize > 0) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Library lib = (Library)listModel.getUserObjectAt(0);
                    String string = LibraryArb.format(78, new String[]{lib instanceof JDK ? LibraryArb.getString(73) : LibraryArb.getString(71)});
                    if (lib instanceof JDK) {
                        Object[] objectArray3 = new String[2];
                        objectArray3[0] = LibraryArb.getString(73);
                        objectArray2 = objectArray3;
                        objectArray3[1] = listModel.findTextForElement(0);
                    } else {
                        String[] stringArray = new String[2];
                        stringArray[0] = LibraryArb.getString(71);
                        objectArray2 = stringArray;
                        stringArray[1] = listModel.findTextForElement(0);
                    }
                    String string2 = LibraryArb.format(79, objectArray2);
                    if (lib instanceof JDK) {
                        Object[] objectArray4 = new String[1];
                        objectArray = objectArray4;
                        objectArray4[0] = LibraryArb.getString(73);
                    } else {
                        String[] stringArray = new String[1];
                        objectArray = stringArray;
                        stringArray[0] = LibraryArb.getString(72);
                    }
                    if (SelectFilesPanel.showDialog((String)string, (String)string2, (String)LibraryArb.format(80, objectArray), (CheckBoxListModel)listModel, (boolean)true, (int)0, null) == 0) {
                        int x;
                        for (x = 0; x < listSize; ++x) {
                            if (!listModel.isElementSelected(x)) continue;
                            lib = (Library)listModel.getUserObjectAt(x);
                            confirmations.add(lib);
                        }
                        for (x = confirmations.size() - 1; x >= 0; --x) {
                            lib = (Library)confirmations.get(x);
                            LeafNode node = (LeafNode)TreePanel.this.findNode(null, lib);
                            ListNode parent = (ListNode)node.getParent();
                            ListWrapper wrapper = parent.getList();
                            wrapper.remove(lib);
                            TreePanel.this.libsModel.removeNodeFromParent(node);
                        }
                    }
                }
            }
        }
    }

    private final class SearchHelper {
        volatile Boolean m_searching = false;
        private Thread m_searchThread;
        private TreeModel m_defaultModel = null;
        private SearchProgress m_searchProgress;

        SearchHelper() {
        }

        void setDefaultTreeModel(TreeModel defaultTreeModel) {
            this.m_defaultModel = defaultTreeModel;
        }

        synchronized void startSearch(String searchText, SearchProgress searchProgress) {
            this.m_searchProgress = searchProgress;
            this.startSearch(searchText);
        }

        synchronized void startSearch(final String searchText) {
            if (this.m_searching.booleanValue() && this.m_searchThread != null) {
                this.m_searchThread.interrupt();
            }
            TreePanel.this.m_queryFilter = LibrarySearchQueryFactory.createFilter(TreePanel.this.searchField.getSelectedCategory(), searchText);
            this.m_searchThread = new Thread(){

                @Override
                public void run() {
                    SearchHelper.this.m_searching = true;
                    TreePanel.this.m_queryFilter.preSearch((DefaultMutableTreeNode)TreePanel.this.libsModel.getRoot());
                    SearchHelper.this.applyTreeFilter(searchText);
                    TreePanel.this.m_queryFilter.postSearch();
                    SearchHelper.this.m_searching = false;
                }
            };
            this.m_searchThread.start();
        }

        private void resetTreeModelAndExpandAllFirstLevelChildren() {
            TreePanel.this.libsTree.setModel(this.m_defaultModel);
            TreePanel.this.expandAll(TreePanel.this.libsTree, true);
        }

        private void applyTreeFilter(String filterText) {
            if ("".equals(filterText)) {
                this.resetTreeModelAndExpandAllFirstLevelChildren();
            } else {
                final DefaultMutableTreeNode root = this.cloneTree((DefaultMutableTreeNode)this.m_defaultModel.getRoot());
                if (this.queryIndexAndFilterTree(root)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TreePanel.this.libsTree.setModel(new DefaultTreeModel(root));
                            TreePanel.this.expandAll(TreePanel.this.libsTree, true);
                            if (TreePanel.this.libsTree.getRowCount() > 0) {
                                TreePanel.this.setTree1SelectionRow(0);
                            }
                        }
                    });
                }
            }
            if (this.m_searchProgress != null) {
                this.m_searchProgress.finish();
            }
        }

        private boolean queryIndexAndFilterTree(DefaultMutableTreeNode root) {
            if (TreePanel.this.m_queryFilter.queryLibraries(root, this.m_searchProgress)) {
                TreePanel.this.libsTreeRenderer.setLeafIcon(TreePanel.this.m_queryFilter.getHitChildIcon());
                TreePanel.this.m_queryFilter.filterSearchResults(root);
                return true;
            }
            return false;
        }

        private DefaultMutableTreeNode cloneTree(DefaultMutableTreeNode root) {
            DefaultMutableTreeNode newRoot = new DefaultMutableTreeNode();
            newRoot.setUserObject(root.getUserObject());
            this.cloneTreeChildren(root, newRoot);
            return newRoot;
        }

        private void cloneTreeChildren(DefaultMutableTreeNode original, DefaultMutableTreeNode copy) {
            for (int i = 0; i < original.getChildCount(); ++i) {
                DefaultMutableTreeNode childCopy;
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)original.getChildAt(i);
                if (child instanceof LibraryNode) {
                    childCopy = new DefaultMutableTreeNode();
                    childCopy.setUserObject(child.getUserObject());
                } else if (child instanceof ListNode) {
                    childCopy = TreePanel.this.createLibraryListNode((ListWrapper)child.getUserObject(), null);
                } else {
                    childCopy = new DefaultMutableTreeNode();
                    childCopy.setUserObject(child.getUserObject());
                }
                copy.add(childCopy);
                this.cloneTreeChildren(child, childCopy);
            }
        }
    }
}

