/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.library.LibraryList;
import oracle.jdeveloper.library.ListWrapper;
import oracle.jdevimpl.library.JDKPanel;
import oracle.jdevimpl.library.LibrariesPanel;
import oracle.jdevimpl.library.LibraryArb;
import oracle.jdevimpl.library.LibraryPanel;

public class LibraryManagementPanel
extends JPanel {
    private static List registeredPanels = new ArrayList();
    private GridBagLayout mainLayout = new GridBagLayout();
    private JTabbedPane tabbedPanel = new JTabbedPane();
    private List panels = new ArrayList();
    private LibraryPanel _currentPanel;

    public static void registerPanel(String name, Class panel) {
        assert (name != null);
        assert (panel != null);
        registeredPanels.add(name);
        registeredPanels.add(panel);
    }

    public static boolean runDialog(LibraryList[] lists) {
        try {
            final LibraryManagementPanel panel = new LibraryManagementPanel();
            ListWrapper[] metaLists = new ListWrapper[lists.length];
            for (int i = 0; i < lists.length; ++i) {
                metaLists[i] = new ListWrapper(lists[i]);
            }
            panel._setLists(metaLists);
            panel.setPreferredSize(new Dimension(800, 600));
            VetoableChangeListener l = new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                    String propName = evt.getPropertyName();
                    Object newValue = evt.getNewValue();
                    if (propName.equals("closed") && Boolean.TRUE.equals(newValue) && !panel.commitChanges(evt)) {
                        throw new PropertyVetoException("veto", evt);
                    }
                }
            };
            return OnePageWizardDialogFactory.runDialog((Component)panel, (Component)panel, (String)LibraryArb.getString(1), (int)7, (VetoableChangeListener)l);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public LibraryManagementPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e);
            throw new IllegalStateException();
        }
    }

    private boolean commitChanges(PropertyChangeEvent evt) throws PropertyVetoException {
        ArrayList<ListWrapper> changes = new ArrayList<ListWrapper>();
        Iterator iter = this.panels.iterator();
        if (iter != null) {
            while (iter.hasNext()) {
                LibraryPanel panel = (LibraryPanel)iter.next();
                if (!panel.commitChanges()) {
                    return false;
                }
                ListWrapper[] lists = panel.getLibraryLists();
                if (lists == null) continue;
                for (int i = 0; i < lists.length; ++i) {
                    if (changes.contains(lists[i])) continue;
                    changes.add(lists[i]);
                }
            }
        }
        if ((iter = changes.iterator()) != null) {
            while (iter.hasNext()) {
                ListWrapper list = (ListWrapper)iter.next();
                list.commit(true);
            }
        }
        return true;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.mainLayout);
        this.setFocusable(false);
        final LibraryManagementPanel ref = this;
        this.tabbedPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                LibraryPanel newPanel = (LibraryPanel)LibraryManagementPanel.this.tabbedPanel.getSelectedComponent();
                if (ModelUtil.areDifferent((Object)LibraryManagementPanel.this._currentPanel, (Object)newPanel)) {
                    if (LibraryManagementPanel.this._currentPanel != null && !LibraryManagementPanel.this._currentPanel.commitChanges()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                LibraryManagementPanel.this.tabbedPanel.setSelectedComponent(LibraryManagementPanel.this._currentPanel);
                            }
                        });
                        return;
                    }
                    LibraryManagementPanel.this._currentPanel = newPanel;
                    HelpSystem.getHelpSystem().registerTopic(ref, LibraryManagementPanel.this._currentPanel.getHelpId());
                }
            }
        });
        int size = registeredPanels.size();
        for (int i = 0; i < size; i += 2) {
            String name = (String)registeredPanels.get(i);
            Class c = (Class)registeredPanels.get(i + 1);
            LibraryPanel panel = (LibraryPanel)c.newInstance();
            this.panels.add(panel);
            this.tabbedPanel.addTab(name, panel);
        }
        this.add((Component)this.tabbedPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void _setLists(ListWrapper[] lists) {
        Iterator iter = this.panels.iterator();
        while (iter.hasNext()) {
            ((LibraryPanel)iter.next()).initPanel(lists);
        }
    }

    static {
        LibraryManagementPanel.registerPanel(LibraryArb.getString(3), LibrariesPanel.class);
        LibraryManagementPanel.registerPanel(LibraryArb.getString(2), JDKPanel.class);
    }
}

