/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.ide.model.Project;
import oracle.jdeveloper.library.ProjectLibraryChangeEvent;
import oracle.jdeveloper.library.ProjectLibraryChangeListener;

class LibraryChangeListenerHandler {
    private final CopyOnWriteArrayList<ProjectLibraryChangeListener> projectLibraryChangeListeners = new CopyOnWriteArrayList();

    LibraryChangeListenerHandler() {
    }

    void addListener(ProjectLibraryChangeListener libraryListener) {
        this.projectLibraryChangeListeners.addIfAbsent(libraryListener);
    }

    void removeListener(ProjectLibraryChangeListener libraryListener) {
        this.projectLibraryChangeListeners.remove(libraryListener);
    }

    void fireLibraryChangeEvent(ProjectLibraryChangeEvent libraryChangeEvent) {
        Project project = libraryChangeEvent.getProject();
        if (this.anyClientNeedsNotification(this.projectLibraryChangeListeners, project)) {
            for (ProjectLibraryChangeListener listener : this.projectLibraryChangeListeners) {
                listener.projectClasspathChanged(libraryChangeEvent);
            }
        }
    }

    private boolean anyClientNeedsNotification(List<ProjectLibraryChangeListener> clientList, Project project) {
        for (ProjectLibraryChangeListener client : clientList) {
            if (!client.needClasspathNotification(project)) continue;
            return true;
        }
        return false;
    }

    void fireProjectClosed(Project project) {
        for (ProjectLibraryChangeListener listener : this.projectLibraryChangeListeners) {
            listener.projectClosed(project);
        }
    }

    void fireProjectOpened(Project project) {
        for (ProjectLibraryChangeListener listener : this.projectLibraryChangeListeners) {
            listener.projectOpened(project);
        }
    }
}

