/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.compiler.OjcConfiguration;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdevimpl.compiler.CompilerDescription;
import oracle.jdevimpl.compiler.CompilerOption;
import oracle.jdevimpl.compiler.JavacCompilerDescription;
import oracle.jdevimpl.compiler.OjcCompilerDescription;
import oracle.jdevimpl.resource.CompilerArb;

public class CompilerOptionManager
extends HashStructureAdapter {
    public static final String COMPILER_NAME = "compiler.name";
    public static final String DEFAULT_COMPILER_NAME = "Javac";
    public static final String COMPILER_OPTIONS_AS_STRING = "commandline.options";
    public static final String COMPILER_OPTIONS_AS_LIST = "commandline.optionlist";
    static List<String> compilerOptionPanelTreeState;
    static final String ADDITIONAL_OPTIONS = "additional.options";
    private static List<CompilerDescription> compilers;
    private String jdkVersion;

    public static CompilerOptionManager getInstance(PropertyStorage project) {
        return new CompilerOptionManager(CompilerOptionManager.findOrCreate((PropertyStorage)project, (String)OjcConfiguration.DATA_KEY), project);
    }

    protected CompilerOptionManager(HashStructure hash, PropertyStorage project) {
        super(hash);
        this.jdkVersion = this.getJdkVersion(project);
    }

    private CompilerOptionManager() {
        super(HashStructure.newInstance());
    }

    public void setToDefaultOptions() {
        for (CompilerDescription compiler : compilers) {
            this.rebuildStorageOfOptions(compiler.getCompilerName(), true);
        }
    }

    public void reSetToDefaultOptions() {
        for (CompilerDescription compiler : compilers) {
            String[] optionKeys;
            for (String optionKey : optionKeys = compiler.getQualifiedOptionNames()) {
                this._hash.remove(optionKey);
            }
            this.rebuildStorageOfOptions(compiler.getCompilerName(), true);
        }
    }

    public String[] getCompilerOptionsAsArray(String compilerName) {
        return this.getCompilerOptionsAsArray(compilerName, false);
    }

    private String[] getCompilerOptionsAsArray(String compilerName, boolean useDefaultOptions) {
        if (compilerName == null) {
            compilerName = this.getCurrentCompiler();
        }
        Collection<CompilerOption> compilerOptions = useDefaultOptions ? this.getDefaultCompilerOptions(compilerName) : this.getCompilerOptions(compilerName);
        String additionalOptions = null;
        ArrayList<String> optionStrings = new ArrayList<String>();
        for (CompilerOption option : compilerOptions) {
            if (!option.isTurnedOn()) continue;
            if (option.getName().equals(ADDITIONAL_OPTIONS)) {
                if (option.getArgument() == null || option.getArgument().trim().length() <= 0) continue;
                additionalOptions = option.getArgument().trim();
                continue;
            }
            if (option.getArgument() != null && option.getArgument().trim().length() == 0) continue;
            String trimmedOptionName = option.getName().trim();
            if (trimmedOptionName.endsWith(":")) {
                if (option.getArgument() != null) {
                    optionStrings.add(trimmedOptionName + option.getArgument().trim());
                    continue;
                }
                optionStrings.add(trimmedOptionName);
                continue;
            }
            optionStrings.add(trimmedOptionName);
            if (option.getArgument() == null) continue;
            optionStrings.add(option.getArgument().trim());
        }
        if (additionalOptions != null) {
            StringTokenizer tokenizer = new StringTokenizer(additionalOptions, " ");
            while (tokenizer.hasMoreTokens()) {
                optionStrings.add(tokenizer.nextToken().trim());
            }
        }
        return optionStrings.toArray(new String[optionStrings.size()]);
    }

    public String getCompilerOptionsAsString(String compilerName) {
        return this.getCompilerOptionsAsString(compilerName, false);
    }

    private String getCompilerOptionsAsString(String compilerName, boolean useDefaultOptions) {
        String[] options = this.getCompilerOptionsAsArray(compilerName, useDefaultOptions);
        StringBuffer buf = new StringBuffer();
        for (String option : options) {
            buf.append(option);
            buf.append(' ');
        }
        return buf.toString();
    }

    static String[] getOptionKeys() {
        ArrayList<String> keyList = new ArrayList<String>();
        for (CompilerDescription provider : compilers) {
            keyList.addAll(Arrays.asList(provider.getQualifiedOptionNames()));
        }
        return keyList.toArray(new String[keyList.size()]);
    }

    Collection<CompilerOption> getOptionsOfAllCompilers() {
        return this.getCompilerOptions(null);
    }

    private Collection<CompilerOption> getCompilerOptions(String compilerName) {
        ArrayList<CompilerOption> optionList = new ArrayList<CompilerOption>();
        for (CompilerDescription provider : compilers) {
            if (compilerName != null && !compilerName.equalsIgnoreCase(provider.getCompilerName())) continue;
            String[] qualifiedOptionNames = provider.getQualifiedOptionNames();
            for (int x = 0; x < qualifiedOptionNames.length; ++x) {
                optionList.add(this.getCompilerOption(qualifiedOptionNames[x]));
            }
        }
        return this.filterCompilerOptions(compilerName, optionList);
    }

    public List<String> getCompilers() {
        ArrayList<String> compilerList = new ArrayList<String>();
        for (CompilerDescription provider : compilers) {
            compilerList.add(provider.getCompilerName());
        }
        return compilerList;
    }

    public String getCurrentCompiler() {
        boolean useJavac;
        if (this._hash.containsKey("useJavac") && (useJavac = this._hash.getBoolean("useJavac"))) {
            return DEFAULT_COMPILER_NAME;
        }
        String compilerName = this._hash.getString(COMPILER_NAME);
        if (compilerName == null) {
            return DEFAULT_COMPILER_NAME;
        }
        if (System.getProperty("oracle.allow.ojc.compiler") != null && compilerName.equalsIgnoreCase("ojc1")) {
            return "Ojc";
        }
        return DEFAULT_COMPILER_NAME;
    }

    public void setCurrentCompiler(String compilerName) {
        this._hash.remove("useJavac");
        this._hash.remove(COMPILER_NAME);
        for (CompilerDescription provider : compilers) {
            if (!provider.getCompilerName().equalsIgnoreCase(compilerName)) continue;
            if ("ojc".equalsIgnoreCase(compilerName)) {
                this._hash.putString(COMPILER_NAME, "ojc1");
                break;
            }
            this._hash.putString(COMPILER_NAME, compilerName);
            break;
        }
    }

    private CompilerOption getCompilerOption(String compilerName, String optionName) {
        StringBuffer buf = new StringBuffer();
        buf.append(compilerName);
        buf.append('.');
        buf.append(optionName);
        return this.getCompilerOption(buf.toString());
    }

    CompilerOption getCompilerOption(String fullyQualifiedOptionName) {
        CompilerOption option = this.getOldStyleOption(fullyQualifiedOptionName, "-g", "debugInformation", false);
        if (option != null) {
            return option;
        }
        option = this.getOldStyleOption(fullyQualifiedOptionName, "-forcecodegen", "alwaysGenClasses", false);
        if (option != null) {
            return option;
        }
        option = this.getOldStyleOption(fullyQualifiedOptionName, "-warn", "showWarnings", false);
        if (option != null) {
            return option;
        }
        option = this.getOldStyleOption(fullyQualifiedOptionName, "-warn:320", "showObjectDotStaticWarnings", false);
        if (option != null) {
            return option;
        }
        option = this.getOldStyleOption(fullyQualifiedOptionName, "-nowarn:320", "showObjectDotStaticWarnings", true);
        if (option != null) {
            return option;
        }
        option = this.getOldStyleOption(fullyQualifiedOptionName, "-deprecation", "showDeprecations", false);
        if (option != null) {
            return option;
        }
        option = this.getOldStyleOption(fullyQualifiedOptionName, "-deprecation:self", "showSelfDeprecations", false);
        if (option != null) {
            return option;
        }
        option = this.getOldStyleOption(fullyQualifiedOptionName, "-warn:486", "showUnusedImportWarnings", false);
        if (option != null) {
            return option;
        }
        option = this.getOldStyleOption(fullyQualifiedOptionName, "-nowarn:486", "showUnusedImportWarnings", true);
        if (option != null) {
            return option;
        }
        option = this.getOldStyleOption(fullyQualifiedOptionName, "-warn:487", "showPartialImportWarnings", false);
        if (option != null) {
            return option;
        }
        option = this.getOldStyleOption(fullyQualifiedOptionName, "-nowarn:487", "showPartialImportWarnings", true);
        if (option != null) {
            return option;
        }
        if (fullyQualifiedOptionName.endsWith("-exclude") && (option = this.getOldStyleExclude(fullyQualifiedOptionName)) != null) {
            return option;
        }
        String optionString = this._hash.getString(fullyQualifiedOptionName);
        CompilerOption defaultOption = this.getDefaultCompilerOption(fullyQualifiedOptionName);
        if (optionString == null) {
            return defaultOption;
        }
        return CompilerOption.createCompilerOption(defaultOption, fullyQualifiedOptionName, optionString);
    }

    private CompilerOption getOldStyleOption(String optionName, String name, String key, boolean reverseOption) {
        if (optionName.endsWith(name) && this._hash.containsKey(key)) {
            boolean optionOn = this._hash.getBoolean(key);
            if (reverseOption) {
                optionOn = !optionOn;
            }
            CompilerOption option = this.getDefaultCompilerOption(optionName);
            option.setTurnedOn(optionOn);
            return option;
        }
        return null;
    }

    private CompilerOption getOldStyleExclude(String optionName) {
        ListStructure list;
        if (this._hash.containsKey("excludedClasses") && (list = this._hash.getListStructure("excludedClasses")) != null) {
            CompilerOption option = this.getDefaultCompilerOption(optionName);
            option.setTurnedOn(true);
            String[] strArray = (String[])list.toArray((Object[])new String[list.size()]);
            option.setArgument(this.stringArrayToString(strArray));
            return option;
        }
        return null;
    }

    void setCompilerOption(CompilerOption option) {
        String qualifiedName = option.getQualifiedName();
        CompilerOption currentOption = this.getCompilerOption(option.getQualifiedName());
        if (currentOption.equals(option)) {
            return;
        }
        this.setOldStyleOption(qualifiedName, "-g", "debugInformation");
        this.setOldStyleOption(qualifiedName, "-forcecodegen", "alwaysGenClasses");
        this.setOldStyleOption(qualifiedName, "-warn", "showWarnings");
        this.setOldStyleOption(qualifiedName, "-nowarn", "showWarnings");
        this.setOldStyleOption(qualifiedName, "-warn:320", "showObjectDotStaticWarnings");
        this.setOldStyleOption(qualifiedName, "-nowarn:320", "showObjectDotStaticWarnings");
        this.setOldStyleOption(qualifiedName, "-deprecation", "showDeprecations");
        this.setOldStyleOption(qualifiedName, "-deprecation:self", "showSelfDeprecations");
        this.setOldStyleOption(qualifiedName, "-warn:368", "showDeprecations");
        this.setOldStyleOption(qualifiedName, "-nowarn:368", "showDeprecations");
        this.setOldStyleOption(qualifiedName, "-warn:486", "showUnusedImportWarnings");
        this.setOldStyleOption(qualifiedName, "-nowarn:486", "showUnusedImportWarnings");
        this.setOldStyleOption(qualifiedName, "-warn:487", "showPartialImportWarnings");
        this.setOldStyleOption(qualifiedName, "-nowarn:487", "showPartialImportWarnings");
        this.setOldStyleOption(qualifiedName, "-exclude", "excludedClasses");
        this._hash.remove(qualifiedName);
        CompilerOption defaultOption = this.getDefaultCompilerOption(qualifiedName);
        if (!defaultOption.equals(option)) {
            String optionString;
            String string = optionString = option.isTurnedOn() ? "true" : "false";
            if (option.getArgument() != null) {
                optionString = optionString + option.getArgument();
            }
            this._hash.putString(qualifiedName, optionString);
        }
        this.rebuildStorageOfOptions(option.getCompilerName(), false);
    }

    private void rebuildStorageOfOptions(String compilerName, boolean useDefaultOptions) {
        this._hash.remove(compilerName + "." + COMPILER_OPTIONS_AS_STRING);
        String[] options = this.getCompilerOptionsAsArray(compilerName, useDefaultOptions);
        ListStructure listStruct = ListStructure.newInstance();
        for (int x = 0; x < options.length; ++x) {
            listStruct.add((Object)options[x]);
        }
        this._hash.putListStructure(compilerName + "." + COMPILER_OPTIONS_AS_LIST, listStruct);
    }

    private void setOldStyleOption(String optionName, String name, String key) {
        if (optionName.endsWith(name)) {
            this._hash.remove(key);
        }
    }

    private CompilerOption getDefaultCompilerOption(String name) {
        for (CompilerDescription compiler : compilers) {
            CompilerOption option = compiler.getDefaultCompilerOption(name);
            if (option == null) continue;
            return new CompilerOption(option.getCompilerName(), option.getCategory(), option.isTurnedOn(), option.getName(), option.getArgument(), option.getDescription());
        }
        int dotIndex = name.indexOf(46);
        String compilerName = this.getCurrentCompiler();
        if (dotIndex > 0) {
            compilerName = name.substring(0, dotIndex);
            name = name.substring(dotIndex + 1);
        }
        return new CompilerOption(compilerName, CompilerArb.getString(71), false, name, null, "fake option");
    }

    private Collection<CompilerOption> getDefaultCompilerOptions(String compilerName) {
        for (CompilerDescription provider : compilers) {
            if (!provider.getCompilerName().equalsIgnoreCase(compilerName)) continue;
            return this.filterCompilerOptions(compilerName, provider.getDefaultCompilerOptions());
        }
        return null;
    }

    private Collection<CompilerOption> filterCompilerOptions(String compilerName, Collection<CompilerOption> options) {
        if (compilerName == null || compilerName.equalsIgnoreCase("javac")) {
            ArrayList<CompilerOption> filteredOptions = new ArrayList<CompilerOption>();
            for (CompilerOption option : options) {
                if (this.filterJavacOption(option, compilerName, "1.6", new String[]{"-proc", "-Xprint"}) || this.filterJavacOption(option, compilerName, "1.5", new String[]{"-X", "-cp", "-endors", "-version"}) || this.filterJavacOption(option, compilerName, "1.3", new String[]{"-g:", "-boot", "-ext"})) continue;
                filteredOptions.add(option);
            }
            return filteredOptions;
        }
        return options;
    }

    boolean filterJavacOption(CompilerOption option, String compilerName, String firstSupportedVersion, String[] filteredOptions) {
        if (this.jdkVersion.compareTo(firstSupportedVersion) < 0) {
            for (String filteredOption : filteredOptions) {
                if (!option.getName().startsWith(filteredOption) || compilerName == null && !option.getCompilerName().equalsIgnoreCase("javac")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isUseJavac() {
        return this.getCurrentCompiler().equalsIgnoreCase(DEFAULT_COMPILER_NAME);
    }

    public boolean isUseOjc() {
        if (System.getProperty("oracle.allow.ojc.compiler") != null) {
            return this.getCurrentCompiler().equalsIgnoreCase("Ojc");
        }
        return false;
    }

    @Deprecated
    public void setUseJavac(boolean useJavac) {
        if (System.getProperty("oracle.allow.ojc.compiler") != null) {
            this.setCurrentCompiler(useJavac ? DEFAULT_COMPILER_NAME : "Ojc");
        } else {
            this.setCurrentCompiler(DEFAULT_COMPILER_NAME);
        }
    }

    public boolean isForceCodeGen() {
        if ("ojc".equalsIgnoreCase(this.getCurrentCompiler())) {
            return this.getCompilerOption("Ojc", "-forcecodegen").isTurnedOn();
        }
        return false;
    }

    public void setForceCodeGen(boolean forceCodeGen) {
        if ("ojc".equalsIgnoreCase(this.getCurrentCompiler())) {
            CompilerOption option = this.getCompilerOption("Ojc", "-forcecodegen");
            option.setTurnedOn(forceCodeGen);
            this.setCompilerOption(option);
        }
    }

    public boolean isShowWarnings() {
        String currentCompiler = this.getCurrentCompiler();
        String showWarningsOption = this.getShowWarningsOption(currentCompiler);
        if (showWarningsOption != null) {
            return this.getCompilerOption(currentCompiler, showWarningsOption).isTurnedOn();
        }
        return false;
    }

    public void setShowWarnings(boolean showWarnings) {
        String currentCompiler = this.getCurrentCompiler();
        String showWarningsOption = this.getShowWarningsOption(currentCompiler);
        if (showWarningsOption != null) {
            CompilerOption option = this.getCompilerOption(currentCompiler, showWarningsOption);
            option.setTurnedOn(showWarnings);
            this.setCompilerOption(option);
        }
    }

    public boolean isShowUnusedImportWarnings() {
        return this.isShowWarnings("486");
    }

    public void setShowUnusedImportWarnings(boolean showUnusedImportWarnings) {
        if ("ojc".equalsIgnoreCase(this.getCurrentCompiler())) {
            this.setShowWarnings(showUnusedImportWarnings, "486");
        }
    }

    public boolean isShowPartialImportWarnings() {
        return this.isShowWarnings("487");
    }

    public void setShowPartialImportWarnings(boolean showPartialImportWarnings) {
        if ("ojc".equalsIgnoreCase(this.getCurrentCompiler())) {
            this.setShowWarnings(showPartialImportWarnings, "487");
        }
    }

    public boolean isShowObjectDotStaticWarnings() {
        return this.isShowWarnings("370");
    }

    public void setShowObjectDotStaticWarnings(boolean showObjectDotStaticWarnings) {
        if ("ojc".equalsIgnoreCase(this.getCurrentCompiler())) {
            this.setShowWarnings(showObjectDotStaticWarnings, "370");
        }
    }

    public boolean isShowDeprecations() {
        String currentCompiler = this.getCurrentCompiler();
        String showDeprecationWarnings = this.getShowDeprecationWarningsOption(currentCompiler);
        if (showDeprecationWarnings != null) {
            return this.getCompilerOption(currentCompiler, showDeprecationWarnings).isTurnedOn();
        }
        return false;
    }

    public void setShowDeprecations(boolean showDeprecations) {
        String currentCompiler = this.getCurrentCompiler();
        String showDeprecationWarningsOption = this.getShowDeprecationWarningsOption(currentCompiler);
        if (showDeprecationWarningsOption != null) {
            CompilerOption option = this.getCompilerOption(currentCompiler, showDeprecationWarningsOption);
            option.setTurnedOn(showDeprecations);
            this.setCompilerOption(option);
        }
    }

    public boolean isShowSelfDeprecations() {
        if ("ojc".equalsIgnoreCase(this.getCurrentCompiler())) {
            return this.getCompilerOption("Ojc", "-deprecation:self").isTurnedOn();
        }
        return false;
    }

    public void setShowSelfDeprecations(boolean showSelfDeprecations) {
        if ("ojc".equalsIgnoreCase(this.getCurrentCompiler())) {
            CompilerOption option = this.getCompilerOption("Ojc", "-deprecation:self");
            option.setTurnedOn(showSelfDeprecations);
            this.setCompilerOption(option);
        }
    }

    public boolean isDebugInformation() {
        return this.isDebugInformation(this.getCurrentCompiler());
    }

    public boolean isDebugInformation(String compilerName) {
        String debugInformationOption = this.getDebugInformationOption(compilerName);
        if (debugInformationOption != null) {
            return this.getCompilerOption(compilerName, debugInformationOption).isTurnedOn();
        }
        return false;
    }

    public void setDebugInformation(boolean debugInformation) {
        String currentCompiler = this.getCurrentCompiler();
        this.setDebugInformation(currentCompiler, debugInformation);
    }

    public void setDebugInformation(String compilerName, boolean debugInformation) {
        String debugInformationOption = this.getDebugInformationOption(compilerName);
        if (debugInformationOption != null) {
            CompilerOption option = this.getCompilerOption(compilerName, debugInformationOption);
            option.setTurnedOn(debugInformation);
            this.setCompilerOption(option);
            String noDebugInformationOption = this.getNoDebugInformationOption(compilerName);
            if (noDebugInformationOption != null) {
                option = this.getCompilerOption(compilerName, noDebugInformationOption);
                option.setTurnedOn(!debugInformation);
                this.setCompilerOption(option);
            }
        }
    }

    public String[] getExcludedClasses() {
        CompilerOption option;
        String currentCompiler = this.getCurrentCompiler();
        String excludeClassesOption = this.getExcludeClassesOption(currentCompiler);
        if (excludeClassesOption != null && (option = this.getCompilerOption(currentCompiler, excludeClassesOption)).isTurnedOn() && option.getArgument() != null && option.getArgument().trim().length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(option.getArgument(), ";");
            ArrayList<String> excludeClasses = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                excludeClasses.add(tokenizer.nextToken());
            }
            return excludeClasses.toArray(new String[excludeClasses.size()]);
        }
        return null;
    }

    public void setExcludedClasses(String[] excludedClasses) {
        String currentCompiler = this.getCurrentCompiler();
        String excludeClassesOption = this.getExcludeClassesOption(currentCompiler);
        if (excludeClassesOption != null) {
            CompilerOption option = this.getCompilerOption(currentCompiler, excludeClassesOption);
            if (excludedClasses != null && excludedClasses.length > 0) {
                option.setTurnedOn(true);
                option.setArgument(this.stringArrayToString(excludedClasses));
            } else {
                option.setTurnedOn(false);
            }
            this.setCompilerOption(option);
        }
    }

    private boolean isShowWarnings(String optionNumber) {
        if ("ojc".equalsIgnoreCase(this.getCurrentCompiler())) {
            boolean warningsOn = this.getCompilerOption("Ojc", "-warn").isTurnedOn();
            boolean thisWarningOn = this.getCompilerOption("Ojc", "-warn:" + optionNumber).isTurnedOn();
            boolean thisWarningOff = this.getCompilerOption("Ojc", "-nowarn:" + optionNumber).isTurnedOn();
            return warningsOn && !thisWarningOff || thisWarningOn;
        }
        return false;
    }

    private void setShowWarnings(boolean showWarnings, String optionNumber) {
        CompilerOption option = this.getCompilerOption("Ojc", "-nowarn:" + optionNumber);
        option.setTurnedOn(!showWarnings);
        this.setCompilerOption(option);
    }

    private String stringArrayToString(String[] strArray) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < strArray.length; ++i) {
            buffer.append(strArray[i]).append(";");
        }
        if (strArray.length > 0) {
            int lastCharIndex = buffer.length() - 1;
            buffer.deleteCharAt(lastCharIndex);
        }
        return buffer.toString().trim();
    }

    private String getJdkVersion(PropertyStorage project) {
        VersionNumber ver;
        JDK jdk;
        JProjectLibraries libs = JProjectLibraries.getInstance(project);
        if (libs != null && (jdk = libs.getJDK()) != null && (ver = jdk.getJavaVersion()) != null) {
            return ver.toString();
        }
        return "1.1";
    }

    private String getShowWarningsOption(String compilerName) {
        for (CompilerDescription compiler : compilers) {
            if (!compiler.getCompilerName().equalsIgnoreCase(compilerName)) continue;
            return compiler.getShowWarningsOption();
        }
        return null;
    }

    private String getShowDeprecationWarningsOption(String compilerName) {
        for (CompilerDescription compiler : compilers) {
            if (!compiler.getCompilerName().equalsIgnoreCase(compilerName)) continue;
            return compiler.getShowDeprecationWarningsOption();
        }
        return null;
    }

    private String getExcludeClassesOption(String compilerName) {
        for (CompilerDescription compiler : compilers) {
            if (!compiler.getCompilerName().equalsIgnoreCase(compilerName)) continue;
            return compiler.getExcludeClassesOption();
        }
        return null;
    }

    private String getDebugInformationOption(String compilerName) {
        for (CompilerDescription compiler : compilers) {
            if (!compiler.getCompilerName().equalsIgnoreCase(compilerName)) continue;
            return compiler.getDebugInformationOption();
        }
        return null;
    }

    private String getNoDebugInformationOption(String compilerName) {
        for (CompilerDescription compiler : compilers) {
            if (!compiler.getCompilerName().equalsIgnoreCase(compilerName)) continue;
            return compiler.getNoDebugInformationOption();
        }
        return null;
    }

    static {
        compilers = new ArrayList<CompilerDescription>();
        if (System.getProperty("oracle.allow.ojc.compiler") != null) {
            compilers.add(new OjcCompilerDescription());
        }
        compilers.add(new JavacCompilerDescription());
        compilerOptionPanelTreeState = null;
    }
}

