/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.View;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.library.DynamicLibraryProvider;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.ProjectLibrary;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.resource.ModelArb;
import oracle.jdevimpl.buildtools.ModuleConfiguration;
import oracle.jdevimpl.config.JProjectPaths;

public class PathsConfiguration
extends HashStructureAdapter {
    public static final String DATA_KEY = PathsConfiguration.class.getName();
    public static final String JAVA_CONTENT_SET_LOCAL_KEY = "javaContentSet";
    public static final String JAVA_CONTENT_SET_KEY = DATA_KEY + "/" + "javaContentSet";
    private static final PatternFilter[] INCLUDE_ALL_FILTER = new PatternFilter[]{PatternFilter.newInclude((String)"**")};
    private static final String HELP_ID = "f1_idechoosepackagelocation_html";
    private Project _project;
    public static final String PROJECT_SOURCEPATH = "javaContentSet/url-path";

    private PathsConfiguration(Project project, HashStructure hash) {
        super(hash);
        if (project == null) {
            throw new IllegalArgumentException("null project");
        }
        this._project = project;
    }

    public static PathsConfiguration getInstance(Project project) {
        return PathsConfiguration.getInstance(project, (PropertyStorage)project);
    }

    public static PathsConfiguration getInstance(Project project, PropertyStorage propertyData) {
        HashStructure properties = propertyData.getProperties();
        return new PathsConfiguration(project, properties.getOrCreateHashStructure(DATA_KEY));
    }

    public ContentSet getJavaContentSet() {
        return new ContentSet(this._hash.getOrCreateHashStructure(JAVA_CONTENT_SET_LOCAL_KEY));
    }

    public URLPath getProjectSourcePath() {
        ContentSet javaContentSet = this.getJavaContentSet();
        return javaContentSet.getAllRootDirs();
    }

    public boolean setProjectSourcePath(URLPath urlPath) {
        ContentSet contentSet = this.getJavaContentSet();
        contentSet.getURLPath().setEntries(null);
        contentSet.getPatternFilters().setFilters(null);
        contentSet.removeAllContentSets();
        if (urlPath == null) {
            return true;
        }
        List urls = urlPath.asList();
        if (urls.size() == 1) {
            this.persistContentSet((URL)urls.get(0), contentSet);
        } else {
            for (URL url : urls) {
                if (contentSet.getURLPath().contains(url)) continue;
                ContentSet subContentSet = new ContentSet(HashStructure.newInstance());
                contentSet.addContentSet(subContentSet);
                this.persistContentSet(url, subContentSet);
            }
        }
        return true;
    }

    private void persistContentSet(URL srcRootURL, ContentSet contentSet) {
        URLPath existingURLPath = contentSet.getURLPath();
        if (existingURLPath.size() != 1 || !URLFileSystem.equals((URL)((URL)existingURLPath.asList().get(0)), (URL)srcRootURL)) {
            URL[] entries = new URL[]{srcRootURL};
            existingURLPath.setEntries(entries);
        }
        contentSet.getPatternFilters().setFilters(INCLUDE_ALL_FILTER);
    }

    public URLPath getSourcePath() {
        URLPath sourcePath = this.getProjectSourcePath();
        Iterator deps = DependencyConfiguration.getInstance((Project)this._project).getDependencies();
        while (deps.hasNext()) {
            Dependable dep = (Dependable)deps.next();
            if (!(dep instanceof Library)) continue;
            Library lib = (Library)dep;
            sourcePath.add(lib.getSourcePath());
        }
        JProjectLibraries libs = JProjectLibraries.getInstance((PropertyStorage)this._project);
        JDK jdkDefinition = libs.getJDK();
        if (jdkDefinition != null) {
            URLPath jdkSourcePath = jdkDefinition.getSourcePath();
            sourcePath.add(jdkSourcePath);
        }
        JLibrary[] defs = libs.getLibraries();
        for (int i = 0; i < defs.length; ++i) {
            URLPath librarySourcePath = defs[i].getSourcePath();
            sourcePath.add(librarySourcePath);
        }
        return sourcePath;
    }

    public URLPath getClassPath() {
        URLPath classPath = new URLPath();
        JDK jdk = JProjectLibraries.getInstance((PropertyStorage)this._project).getJDK();
        if (jdk != null) {
            classPath.add(jdk.getClassPath());
        }
        classPath.add(this.getRunClassPath());
        return classPath;
    }

    public URLPath getRunClassPath() {
        return this.getRunClassPath(false);
    }

    public URLPath getRunClassPath(boolean onlyDeployLibs) {
        URLPath classPath = new URLPath();
        classPath.add(JavaProject.getInstance(this._project).getOutputDirectory());
        classPath.add(JProjectPaths.getInstance((PropertyStorage)this._project).getAdditionalClassPath());
        ModuleConfiguration moduleConfig = ModuleConfiguration.getInstance(this._project);
        if (moduleConfig != null) {
            classPath.add(moduleConfig.getClassPath());
        }
        Iterator deps = DependencyConfiguration.getInstance((Project)this._project).getDependencies();
        while (deps.hasNext()) {
            Dependable dep = (Dependable)deps.next();
            if (dep instanceof ProjectLibrary) {
                classPath.add(((ProjectLibrary)dep).getClassPath(onlyDeployLibs));
                continue;
            }
            if (!(dep instanceof Library)) continue;
            Library lib = (Library)dep;
            classPath.add(lib.getClassPath());
        }
        JLibrary[] defs = JProjectLibraries.getInstance((PropertyStorage)this._project).getLibraries();
        for (int i = 0; i < defs.length; ++i) {
            if (onlyDeployLibs && !defs[i].getDeployedByDefault().booleanValue()) continue;
            URLPath libraryClassPath = defs[i].getClassPath();
            classPath.add(libraryClassPath);
        }
        JLibraryManager mgr = JLibraryManager.getInstance();
        for (DynamicLibraryProvider provider : mgr.getDynamicLibraryProviders()) {
            provider.updateClassPath(this._project, classPath);
        }
        return classPath;
    }

    public URLPath getDocPath() {
        URLPath docPath = new URLPath();
        JDK jdk = JProjectLibraries.getInstance((PropertyStorage)this._project).getJDK();
        if (jdk != null) {
            docPath.add(jdk.getDocPath());
        }
        Iterator deps = DependencyConfiguration.getInstance((Project)this._project).getDependencies();
        while (deps.hasNext()) {
            Dependable dep = (Dependable)deps.next();
            if (!(dep instanceof Library)) continue;
            Library lib = (Library)dep;
            docPath.add(lib.getDocPath());
        }
        JLibrary[] defs = JProjectLibraries.getInstance((PropertyStorage)this._project).getLibraries();
        for (int i = 0; i < defs.length; ++i) {
            URLPath libraryDocPath = defs[i].getDocPath();
            docPath.add(libraryDocPath);
        }
        return docPath;
    }

    public static URL getURLForPackage(String packageName, Context context) {
        URL packageURL = null;
        boolean retrievedDependentProjects = false;
        boolean moreToSearch = true;
        Project project = context.getProject();
        ArrayList matchList = new ArrayList();
        String pkg = packageName;
        Project[] projects = null;
        View lastActiveView = Ide.getMainWindow().getLastActiveView();
        Context selContext = lastActiveView.getContext();
        Element selElement = selContext.getElement();
        if (lastActiveView instanceof NavigatorWindow) {
            RelativeDirectoryContextFolder r;
            URLPath path;
            if (selElement instanceof Project) {
                retrievedDependentProjects = true;
            } else if (selElement instanceof RelativeDirectoryContextFolder && (path = (r = (RelativeDirectoryContextFolder)selElement).getRootDirectories()).size() == 1) {
                packageURL = URLFactory.newDirURL((URL)path.getEntries()[0], (String)pkg);
                return packageURL;
            }
        }
        if (selElement instanceof JavaSourceNode) {
            JavaSourceNode javaNode = (JavaSourceNode)selElement;
            String selPackage = javaNode.getPackage();
            if ((selPackage = selPackage.replace('.', '/')).equals(packageName)) {
                return URLFileSystem.getParent((URL)javaNode.getURL());
            }
        }
        while (matchList.size() == 0 && moreToSearch) {
            int idx;
            PathsConfiguration.addMatchingURLs(matchList, project, pkg);
            if (matchList.size() == 0) {
                if (!retrievedDependentProjects) {
                    projects = PathsConfiguration.getDependentProjects(context);
                    retrievedDependentProjects = true;
                }
                if (projects != null) {
                    for (int i = 0; i < projects.length; ++i) {
                        PathsConfiguration.addMatchingURLs(matchList, projects[i], pkg);
                    }
                }
            }
            if ((idx = pkg.lastIndexOf(47)) == -1) {
                moreToSearch = false;
                continue;
            }
            pkg = pkg.substring(0, idx);
        }
        if (matchList.size() == 0) {
            PathsConfiguration.processProject(project, matchList, packageName);
        }
        if (matchList.size() == 1) {
            Project packageProject;
            ProjURLPair pair = (ProjURLPair)matchList.get(0);
            Project contextProject = context.getProject();
            if (ModelUtil.areEqual((Object)contextProject, (Object)(packageProject = pair.getProject()))) {
                packageURL = pair.getURL();
            } else {
                PathsConfiguration.processProject(project, matchList, packageName);
                packageURL = PathsConfiguration.runURLSelectionUI(matchList);
            }
        } else {
            packageURL = PathsConfiguration.runURLSelectionUI(matchList);
        }
        if (packageURL != null) {
            String urlString = packageURL.toString();
            if (urlString.endsWith("/")) {
                urlString = urlString.substring(0, urlString.length() - 1);
            }
            if (!urlString.endsWith(packageName)) {
                String pkgStr = URLFileSystem.getPath((URL)packageURL);
                pkg = packageName;
                StringBuffer removedString = new StringBuffer();
                boolean found = false;
                while (!found && pkg.length() > 0) {
                    int idx = pkg.lastIndexOf(47);
                    if (idx == -1) {
                        removedString.insert(0, pkg + "/");
                        pkg = null;
                        break;
                    }
                    removedString.insert(0, pkg.substring(idx + 1, pkg.length()) + "/");
                    if (!pkgStr.endsWith(pkg = pkg.substring(0, idx))) continue;
                    break;
                }
                packageURL = URLFactory.newDirURL((URL)packageURL, (String)removedString.toString());
            }
        }
        return packageURL;
    }

    private static void processProject(Project project, List matchList, String packageName) {
        URLPath urlPath = PathsConfiguration.getInstance(project).getProjectSourcePath();
        URL[] entries = urlPath.getEntries();
        if (entries.length > 1) {
            for (int i = 0; i < entries.length; ++i) {
                matchList.add(new ProjURLPair(project, entries[i]));
            }
        } else {
            ProjURLPair pair = new ProjURLPair(project, URLFactory.newDirURL((URL)entries[0], (String)packageName));
            matchList.add(pair);
        }
    }

    private static URL runURLSelectionUI(List matchList) {
        URL returnURL = null;
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("root");
        DefaultTreeModel model = new DefaultTreeModel(rootNode);
        int numMatches = matchList.size();
        Project project = null;
        DefaultMutableTreeNode projectNode = null;
        for (int i = 0; i < numMatches; ++i) {
            ProjURLPair pair = (ProjURLPair)matchList.get(i);
            if (project != pair.getProject()) {
                projectNode = new DefaultMutableTreeNode(pair.getProject());
                model.insertNodeInto(projectNode, rootNode, rootNode.getChildCount());
                project = pair.getProject();
            }
            DefaultMutableTreeNode urlNode = new DefaultMutableTreeNode(new URLDisplayWrapper(pair.getURL()));
            model.insertNodeInto(urlNode, projectNode, projectNode.getChildCount());
        }
        final JTree tree = new JTree(model);
        tree.setCellRenderer(new PathsNodeRenderer());
        tree.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        JScrollPane scrollPane = new JScrollPane(tree);
        HelpSystem.getHelpSystem().registerTopic((JComponent)scrollPane, HELP_ID);
        tree.setSelectionModel(new URLTreeSelectionModel());
        tree.getSelectionModel().setSelectionMode(1);
        final JEWTDialog dialog = DialogUtil.createJEWTDialogOwnedBy((Component)Ide.getMainWindow());
        if (dialog == null) {
            return null;
        }
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
                if (node == null) {
                    dialog.setOKButtonEnabled(false);
                } else {
                    dialog.setOKButtonEnabled(node.isLeaf());
                }
            }
        });
        tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                TreeNode selNode;
                TreePath path;
                if (event.getClickCount() == 2 && (path = tree.getSelectionPath()) != null && (selNode = (TreeNode)path.getLastPathComponent()).isLeaf()) {
                    dialog.closeDialog(false);
                }
            }
        });
        IdeUtil.expandAllTreeRows((JTree)tree);
        JWrappedLabel header = new JWrappedLabel(ModelArb.getString(140));
        JLabel treeLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)treeLabel, (Component)tree, (String)ModelArb.getString(139));
        JPanel content = new JPanel(new GridBagLayout());
        content.add((Component)header, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        content.add((Component)treeLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 0, 3, 0), 0, 0));
        content.add((Component)scrollPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        dialog.setContent((Component)content);
        dialog.setOKButtonEnabled(false);
        dialog.setMaximumInitialSize(new Dimension(400, 300));
        dialog.setInitialFocus((Component)tree);
        dialog.setTitle(ModelArb.getString(138));
        dialog.setButtonMask(7);
        dialog.setResizable(true);
        dialog.pack();
        boolean retval = dialog.runDialog();
        if (retval) {
            TreePath treePath = tree.getSelectionPath();
            DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            URLDisplayWrapper urlWrapper = (URLDisplayWrapper)selNode.getUserObject();
            returnURL = urlWrapper.getURL();
        }
        dialog.dispose();
        return returnURL;
    }

    private static void addMatchingURLs(List matchList, Project project, String pkg) {
        URL[] matchingURLs;
        PathsConfiguration pathConfig = PathsConfiguration.getInstance(project);
        URLPath urlPath = pathConfig.getProjectSourcePath();
        if (urlPath != null && (matchingURLs = urlPath.toQualifiedURL(pkg, false)) != null) {
            for (int i = 0; i < matchingURLs.length; ++i) {
                matchList.add(new ProjURLPair(project, matchingURLs[i]));
            }
        }
    }

    public static Project[] getDependentProjects(Context context) {
        return PathsConfiguration.getDependentProjects(context.getProject());
    }

    public static Project[] getDependentProjects(Project deepestProject) {
        HashSet<Object> bases = new HashSet<Object>();
        ArrayList<Object> dependables = new ArrayList<Object>();
        bases.add(deepestProject);
        dependables.add(deepestProject);
        while (!dependables.isEmpty()) {
            Project project = (Project)dependables.remove(0);
            Iterator dependencies = DependencyConfiguration.getInstance((Project)project).getDependencies();
            while (dependencies.hasNext()) {
                Dependable dependable = (Dependable)dependencies.next();
                Element dependableSource = dependable.getSource();
                if (!(dependableSource instanceof Project) || !bases.add(dependableSource)) continue;
                dependables.add(dependableSource);
            }
        }
        bases.remove(deepestProject);
        Project[] projects = bases.toArray(new Project[bases.size()]);
        return projects;
    }

    private static class PathsNodeRenderer
    extends DefaultTreeCellRenderer {
        private PathsNodeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            label.setIcon(OracleIcons.getIcon((String)(leaf ? "folder.png" : "project.png")));
            return label;
        }
    }

    private static class URLDisplayWrapper {
        private URL _url;

        public URLDisplayWrapper(URL url) {
            this._url = url;
        }

        public URL getURL() {
            return this._url;
        }

        public String toString() {
            return URLFileSystem.getPlatformPathName((URL)this._url);
        }
    }

    private static class URLTreeSelectionModel
    extends DefaultTreeSelectionModel {
        private URLTreeSelectionModel() {
        }

        @Override
        public void setSelectionPath(TreePath treePath) {
            DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (selNode.isLeaf()) {
                super.setSelectionPath(treePath);
            } else {
                super.clearSelection();
            }
        }
    }

    private static class ProjURLPair {
        private Project _project;
        private URL _url;

        public ProjURLPair(Project project, URL url) {
            this._project = project;
            this._url = url;
        }

        public Project getProject() {
            return this._project;
        }

        public URL getURL() {
            return this._url;
        }
    }
}

