/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTempFile;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.UnresolvedType;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaNode;

public final class JavaClassNode
extends JavaNode {
    public static final String EXT = ".class";

    protected Reader createReader(URL url) {
        String classText = this.getDecompiledClass(url);
        return classText == null ? null : new StringReader(classText);
    }

    protected void saveImpl() {
    }

    public boolean isReadOnly() {
        return true;
    }

    private String getDecompiledClass(URL url) {
        JavaManager javaManager;
        JavaFile javaFile;
        Project project;
        String cmd = System.getProperty("jcncmd");
        if (cmd != null) {
            try {
                URLTempFile tempFile = new URLTempFile(url);
                File file = tempFile.getFile();
                Process process = Runtime.getRuntime().exec(cmd + " " + file.getAbsolutePath());
                final BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
                final StringBuffer buf = new StringBuffer();
                Thread outputPump = new Thread(){

                    @Override
                    public void run() {
                        try {
                            String line;
                            while ((line = br.readLine()) != null) {
                                buf.append(line).append("\n");
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                };
                outputPump.start();
                int exitCode = process.waitFor();
                outputPump.join();
                if (exitCode == 0) {
                    return buf.toString();
                }
            }
            catch (Throwable e) {
                Logger.getAnonymousLogger().log(Level.SEVERE, "decompiling " + URLFileSystem.getPlatformPathName((URL)url) + " using \"" + cmd + "\"", e);
            }
        }
        if ((project = Ide.getActiveProject()) == null) {
            project = Ide.getDefaultProject();
        }
        if (project != null && (javaFile = (javaManager = JavaManager.getJavaManager(project)).getFile(url)) != null) {
            return JavaClassNode.emitFile(javaFile);
        }
        return null;
    }

    protected static String emitFile(JavaFile javaFile) {
        StringBuffer out = new StringBuffer(4096);
        JavaClassNode.emitComment(0, "", out);
        JavaClassNode.emitComment(0, "Oracle JDeveloper Stub Generated Source", out);
        JavaClassNode.emitComment(0, "", out);
        JavaClassNode.emitPackage(javaFile.getPackageName(), out);
        JavaClass javaClass = javaFile.getPrimaryClass();
        JavaClassNode.emitClass(javaClass, out);
        return out.toString();
    }

    private static void emitPackage(String packageName, StringBuffer out) {
        if (packageName != null && packageName.length() > 0) {
            out.append("package ");
            out.append(packageName);
            out.append(";");
            JavaClassNode.emitEOL(out);
            JavaClassNode.emitEOL(out);
        }
    }

    private static void emitClass(JavaClass javaClass, StringBuffer out) {
        Collection methods;
        boolean hasMethods;
        Collection fields;
        boolean hasFields;
        Iterator iterator;
        String superClassName;
        String modifierText;
        Collection annotations = javaClass.getAnnotations();
        if (annotations != null && !annotations.isEmpty()) {
            JavaClassNode.emitAnnotations(annotations, out);
        }
        if ((modifierText = JavaClassNode.getClassModifiers(javaClass)).length() > 0) {
            out.append(modifierText);
            JavaClassNode.emitSpaces(1, out);
        }
        boolean isInterface = false;
        boolean isAnnotation = false;
        if (javaClass.isAnnotation()) {
            out.append("@interface");
            isAnnotation = true;
        } else if (javaClass.isInterface()) {
            out.append("interface");
            isInterface = true;
        } else {
            out.append("class");
        }
        JavaClassNode.emitSpaces(1, out);
        out.append(javaClass.getName());
        JavaClassNode.emitEOL(out);
        JavaType superClass = javaClass.getSuperclass();
        if (!isAnnotation && superClass != null && !"java.lang.Object".equals(superClassName = superClass.getQualifiedName())) {
            JavaClassNode.emitIndent(1, out);
            out.append("extends ");
            out.append(superClassName);
            JavaClassNode.emitEOL(out);
        }
        Collection unresolvedInterfaces = javaClass.getUnresolvedInterfaces();
        if (!isAnnotation && !unresolvedInterfaces.isEmpty()) {
            String superTypesIndent;
            JavaClassNode.emitIndent(1, out);
            if (isInterface) {
                out.append("extends ");
                superTypesIndent = "        ";
            } else {
                out.append("implements ");
                superTypesIndent = "           ";
            }
            iterator = unresolvedInterfaces.iterator();
            out.append(((UnresolvedType)iterator.next()).getSimplifiedName());
            String comma = ",\n";
            while (iterator.hasNext()) {
                out.append(comma);
                JavaClassNode.emitIndent(1, out);
                out.append(superTypesIndent);
                out.append(((UnresolvedType)iterator.next()).getSimplifiedName());
            }
            JavaClassNode.emitEOL(out);
        }
        out.append("{");
        JavaClassNode.emitEOL(out);
        Collection constructors = javaClass.getDeclaredConstructors();
        iterator = constructors.iterator();
        boolean hasConstructors = iterator.hasNext();
        if (hasConstructors) {
            JavaClassNode.emitComment(1, "", out);
            JavaClassNode.emitComment(1, "Constructors", out);
            JavaClassNode.emitComment(1, "", out);
        }
        boolean first = true;
        while (iterator.hasNext()) {
            if (!first) {
                JavaClassNode.emitEOL(out);
            }
            first = false;
            JavaMethod constructor = (JavaMethod)iterator.next();
            JavaClassNode.emitMethod(constructor, out);
        }
        if (hasConstructors) {
            JavaClassNode.emitEOL(out);
        }
        if (hasFields = (iterator = (fields = javaClass.getDeclaredFields()).iterator()).hasNext()) {
            JavaClassNode.emitComment(1, "", out);
            JavaClassNode.emitComment(1, "Fields", out);
            JavaClassNode.emitComment(1, "", out);
        }
        first = true;
        while (iterator.hasNext()) {
            if (!first) {
                JavaClassNode.emitEOL(out);
            }
            first = false;
            JavaField field = (JavaField)iterator.next();
            JavaClassNode.emitField(field, out);
        }
        if (hasFields) {
            JavaClassNode.emitEOL(out);
        }
        if (hasMethods = (iterator = (methods = javaClass.getDeclaredMethods()).iterator()).hasNext()) {
            JavaClassNode.emitComment(1, "", out);
            JavaClassNode.emitComment(1, "Methods", out);
            JavaClassNode.emitComment(1, "", out);
        }
        first = true;
        while (iterator.hasNext()) {
            if (!first) {
                JavaClassNode.emitEOL(out);
            }
            first = false;
            JavaMethod method = (JavaMethod)iterator.next();
            JavaClassNode.emitMethod(method, out);
        }
        out.append("}");
        JavaClassNode.emitEOL(out);
    }

    private static void emitField(JavaField javaField, StringBuffer out) {
        UnresolvedType type;
        JavaClassNode.emitIndent(1, out);
        String modifierText = JavaClassNode.getFieldModifiers(javaField);
        if (modifierText.length() > 0) {
            out.append(modifierText);
            JavaClassNode.emitSpaces(1, out);
        }
        out.append((type = javaField.getUnresolvedType()) == null ? "java.lang.Object" : type.toString());
        JavaClassNode.emitSpaces(1, out);
        out.append(javaField.getName());
        out.append(";");
        JavaClassNode.emitEOL(out);
    }

    private static void emitMethod(JavaMethod javaMethod, StringBuffer out) {
        boolean isConstructor;
        String modifierText;
        JavaClassNode.emitIndent(1, out);
        Collection annotations = javaMethod.getAnnotations();
        if (annotations != null && !annotations.isEmpty()) {
            JavaClassNode.emitAnnotations(annotations, out);
        }
        String string = modifierText = (isConstructor = javaMethod.isConstructor()) ? JavaClassNode.getConstructorModifiers(javaMethod) : JavaClassNode.getMethodModifiers(javaMethod);
        if (modifierText.length() > 0) {
            out.append(modifierText);
            JavaClassNode.emitSpaces(1, out);
        }
        JavaClass javaClass = javaMethod.getOwningClass();
        if (isConstructor) {
            out.append(javaClass.getName());
        } else {
            JavaType returnType = javaMethod.getReturnType();
            if (returnType != null) {
                out.append(returnType.getQualifiedName());
                JavaClassNode.emitSpaces(1, out);
            }
            out.append(javaMethod.getName());
        }
        JavaClassNode.emitMethodParameters(javaMethod, out);
        if (javaClass.isAnnotation()) {
            Object defaultValue = javaMethod.getDefaultValue();
            if (defaultValue != null) {
                JavaClassNode.emitSpaces(1, out);
                out.append("default");
                JavaClassNode.emitSpaces(1, out);
                if ("java.lang.String".equals(javaMethod.getReturnType().getQualifiedName())) {
                    out.append("\"" + defaultValue + "\"");
                } else if ("java.lang.Class".equals(javaMethod.getReturnType().getQualifiedName())) {
                    JavaClass classObject = (JavaClass)defaultValue;
                    out.append(classObject.getName() + EXT);
                } else if (javaMethod.getReturnType().isEnum()) {
                    JavaField fieldObject = (JavaField)defaultValue;
                    out.append(fieldObject.getOwningClass().getName() + "." + fieldObject.getName());
                } else {
                    out.append(defaultValue);
                }
            }
            out.append(";");
        } else {
            JavaClassNode.emitSpaces(1, out);
            out.append("{ }");
        }
        JavaClassNode.emitEOL(out);
    }

    private static void emitMethodParameters(JavaMethod javaMethod, StringBuffer out) {
        out.append("(");
        Collection parameters = javaMethod.getParameters();
        if (parameters != null) {
            String comma = "";
            int index = 1;
            for (JavaVariable parameter : parameters) {
                out.append(comma);
                comma = ", ";
                UnresolvedType type = parameter.getUnresolvedType();
                out.append(type == null ? "java.lang.Object" : type.toString());
                JavaClassNode.emitSpaces(1, out);
                String parameterName = parameter.getName();
                if (parameterName != null && parameterName.length() > 0) {
                    out.append(parameterName);
                    continue;
                }
                out.append("p").append(index++);
            }
        }
        out.append(")");
    }

    private static String getFieldModifiers(JavaField javaField) {
        int modifiers = javaField.getModifiers();
        return Modifier.toString(modifiers);
    }

    private static String getMethodModifiers(JavaMethod javaMethod) {
        JavaClass javaClass = javaMethod.getOwningClass();
        boolean isInterfaceMethod = javaClass.isInterface();
        int modifiers = javaMethod.getModifiers();
        if (isInterfaceMethod) {
            modifiers &= 0xFFFFFBFE;
        }
        return Modifier.toString(modifiers);
    }

    private static String getConstructorModifiers(JavaMethod javaMethod) {
        StringBuffer out = new StringBuffer(30);
        int modifiers = javaMethod.getModifiers();
        if (Modifier.isPublic(modifiers)) {
            out.append("public ");
        }
        if (Modifier.isPrivate(modifiers)) {
            out.append("private ");
        }
        if (Modifier.isProtected(modifiers)) {
            out.append("protected ");
        }
        if (Modifier.isAbstract(modifiers)) {
            out.append("abstract ");
        }
        if (Modifier.isFinal(modifiers)) {
            out.append("final ");
        }
        return out.toString().trim();
    }

    private static String getClassModifiers(JavaClass javaClass) {
        StringBuffer out = new StringBuffer(30);
        int modifiers = javaClass.getModifiers();
        boolean isInterface = javaClass.isInterface();
        if (Modifier.isPublic(modifiers)) {
            out.append("public ");
        }
        if (Modifier.isPrivate(modifiers)) {
            out.append("private ");
        }
        if (Modifier.isProtected(modifiers)) {
            out.append("protected ");
        }
        if (!isInterface && Modifier.isAbstract(modifiers)) {
            out.append("abstract ");
        }
        if (Modifier.isStatic(modifiers)) {
            out.append("static ");
        }
        if (Modifier.isFinal(modifiers)) {
            out.append("final ");
        }
        if (Modifier.isNative(modifiers)) {
            out.append("native ");
        }
        return out.toString().trim();
    }

    private static void emitEOL(StringBuffer out) {
        out.append("\n");
    }

    private static void emitSpaces(int count, StringBuffer out) {
        for (int i = 0; i < count; ++i) {
            out.append(' ');
        }
    }

    private static void emitIndent(int level, StringBuffer out) {
        for (int i = 0; i < level; ++i) {
            out.append("    ");
        }
    }

    private static int findIndent(StringBuffer out) {
        int index = out.length() - 1;
        int count = 0;
        while (index >= 0) {
            if (out.charAt(index) == '\n') {
                return count;
            }
            --index;
            ++count;
        }
        return count;
    }

    private static void emitComment(int level, String comment, StringBuffer out) {
        JavaClassNode.emitIndent(level, out);
        out.append("//");
        if (comment != null && comment.length() > 0) {
            out.append(' ');
            out.append(comment);
        }
        JavaClassNode.emitEOL(out);
    }

    private static void emitAnnotations(Collection annotations, StringBuffer out) {
        for (Object element : annotations) {
            if (!(element instanceof JavaAnnotation)) continue;
            JavaAnnotation annotation = (JavaAnnotation)element;
            JavaType annotationType = annotation.getAnnotationType();
            if (annotationType != null) {
                out.append("@" + annotationType.getName());
            } else {
                out.append("@" + annotation.getUnresolvedType().getSimplifiedName());
            }
            Map components = annotation.getComponents();
            if (components != null && components.size() > 0) {
                out.append("(");
                int indent = JavaClassNode.findIndent(out);
                Iterator j = components.keySet().iterator();
                while (j.hasNext()) {
                    JavaType returnType;
                    String key = (String)j.next();
                    Collection declaredMethods = annotation.getAnnotationType().getDeclaredMethods(key);
                    if (declaredMethods == null || declaredMethods.size() != 1) continue;
                    JavaMethod attribute = (JavaMethod)declaredMethods.toArray()[0];
                    if (!key.equals("value") || components.size() != 1) {
                        out.append(key);
                        JavaClassNode.emitSpaces(1, out);
                        out.append("=");
                        JavaClassNode.emitSpaces(1, out);
                    }
                    if ((returnType = attribute.getReturnType()).isArray() && components.size() > 1) {
                        out.append('{');
                    }
                    JavaClassNode.emitAnnotationComponentValue(out, returnType, components.get(key));
                    if (returnType.isArray() && components.size() > 1) {
                        out.append('}');
                    }
                    if (!j.hasNext()) continue;
                    out.append(",");
                    JavaClassNode.emitEOL(out);
                    JavaClassNode.emitSpaces(indent, out);
                }
                out.append(")");
            }
            JavaClassNode.emitEOL(out);
        }
    }

    private static void emitAnnotationComponentValue(StringBuffer out, JavaType javaType, Object value) {
        if ("java.lang.String".equals(javaType.getQualifiedName())) {
            out.append("\"" + value.toString() + "\"");
        } else if ("java.lang.Class".equals(javaType.getQualifiedName())) {
            JavaClass classObject = (JavaClass)value;
            out.append(classObject.getName() + EXT);
        } else if (javaType.isEnum()) {
            JavaField fieldObject = (JavaField)value;
            out.append(fieldObject.getOwningClass().getName() + "." + fieldObject.getName());
        } else if (javaType.isArray()) {
            Object[] values = (Object[])value;
            for (int x = 0; x < values.length; ++x) {
                if (x > 0) {
                    out.append(", ");
                }
                JavaClassNode.emitAnnotationComponentValue(out, javaType.getBaseComponentType(), values[x]);
            }
        } else {
            out.append(value.toString());
        }
    }
}

