/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.Ide;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLPath;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.model.SourceRootHelper;
import oracle.jdeveloper.resource.JProjectArb;

public final class JProjectUtil {
    private static final String JAVA_NODE_KEY = "java-node-key";
    private static boolean canceled;

    private JProjectUtil() {
    }

    public static URL getProjectBasePath(Project project) {
        URLPath srcPath = PathsConfiguration.getInstance(project).getProjectSourcePath();
        URL result = srcPath.getFirstEntry();
        if (result == null) {
            result = URLFileSystem.getParent((URL)project.getURL());
        }
        return result;
    }

    public static void addLibraries(Project proj, Object[] libraries) {
        JProjectUtil._updateLibraries(proj, libraries, true);
    }

    public static void removeLibraries(Project proj, Object[] libraries) {
        JProjectUtil._updateLibraries(proj, libraries, false);
    }

    public static void setOutputDirectory(Project project, URL outputDirectory) {
        JavaProject.getInstance(project).setOutputDirectory(outputDirectory);
    }

    public static void execturePathChange(Project project, Runnable runnable) {
        project.applyBatchChanges(runnable);
    }

    public static String getLibraryNameFromPath(URL path) {
        String name = URLFileSystem.getFileName((URL)path);
        if (!URLFileSystem.isDirectory((URL)path) && name.lastIndexOf(46) != -1) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        if (name != null && !Character.isUpperCase(name.charAt(0))) {
            name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }
        return name;
    }

    private static void _updateLibraries(final Project project, final Object[] libraries, final boolean add) {
        if (libraries != null && libraries.length > 0) {
            project.applyBatchChanges(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < libraries.length; ++i) {
                        if (libraries[i] == null) continue;
                        if (add) {
                            JProjectLibraries.getInstance((PropertyStorage)project).addLibrary(libraries[i]);
                            continue;
                        }
                        JProjectLibraries.getInstance((PropertyStorage)project).removeLibrary(libraries[i]);
                    }
                }
            });
        }
    }

    private static void resetCancelState() {
        canceled = false;
    }

    static void notifyCanceled() {
        canceled = true;
    }

    static URL[] getSourceRoots(URL[] urls, SourceRootHelper[] helpers) {
        JProjectUtil.resetCancelState();
        ArrayList<URL> found = new ArrayList<URL>();
        for (URL url : urls) {
            if (canceled) {
                return new URL[0];
            }
            ArrayList<URL> roots = JProjectUtil.findSourceRootsFromURL(url, helpers);
            if (roots.size() > 0) {
                found.addAll(roots);
            } else {
                found.add(url);
            }
            JProjectUtil.ensureRootContentIsIncluded(url, found, helpers);
        }
        URL[] urlArray = new URL[found.size()];
        found.toArray(urlArray);
        return urlArray;
    }

    private static void ensureRootContentIsIncluded(URL rootFolderURL, List<URL> found, SourceRootHelper[] helpers) {
        URLFilter filter;
        URL[] children;
        if (found.contains(rootFolderURL)) {
            return;
        }
        boolean shouldAddURL = false;
        for (URL u : found) {
            if (!URLFileSystem.isBaseURLFor((URL)rootFolderURL, (URL)u)) continue;
            shouldAddURL = true;
            break;
        }
        if (shouldAddURL && (children = URLFileSystem.list((URL)rootFolderURL, (URLFilter)(filter = GlobalIgnoreList.getURLFilter()))) != null) {
            boolean addRoot = false;
            for (URL nextChild : children) {
                if (URLFileSystem.hasSuffix((URL)nextChild, (String)".java")) {
                    addRoot = true;
                    break;
                }
                for (SourceRootHelper nextHelper : helpers) {
                    if (!URLFileSystem.hasSuffix((URL)nextChild, (String)nextHelper.getFileExtension())) continue;
                    addRoot = true;
                    break;
                }
                if (addRoot) break;
            }
            if (addRoot) {
                found.add(0, rootFolderURL);
            }
        }
    }

    static ArrayList getSourceRootsFromFolder(URL folder, SourceRootHelper[] helpers) {
        JProjectUtil.resetCancelState();
        return JProjectUtil.findSourceRootsFromURL(folder, helpers);
    }

    /*
     * WARNING - void declaration
     */
    private static ArrayList<URL> findSourceRootsFromURL(URL folder, SourceRootHelper[] helpers) {
        ArrayList<URL> results = new ArrayList<URL>();
        URLFilter filter = GlobalIgnoreList.getURLFilter();
        URL[] children = URLFileSystem.list((URL)folder, (URLFilter)filter);
        if (children != null) {
            void var10_17;
            URL[] uRLArray;
            URL root;
            Node[] javaSourceNodes;
            Map<String, List<Node>> nodeMap = JProjectUtil.buildNodeMap(children, helpers);
            for (Node node : javaSourceNodes = JProjectUtil.getNodesForKey(nodeMap, JAVA_NODE_KEY)) {
                if (canceled) {
                    return new ArrayList<URL>(0);
                }
                JavaSourceNode javaSourceNode = (JavaSourceNode)node;
                boolean[] errorStatus = new boolean[]{false};
                root = JProjectUtil.determineSourceRoot(javaSourceNode, false, errorStatus);
                if (errorStatus[0] || results.contains(root)) continue;
                results.add(root);
                return results;
            }
            for (SourceRootHelper sourceRootHelper : helpers) {
                Node[] otherNodes;
                if (canceled) {
                    return new ArrayList<URL>(0);
                }
                String key = sourceRootHelper.getClass().getName();
                for (Node node : otherNodes = JProjectUtil.getNodesForKey(nodeMap, key)) {
                    boolean[] errorStatus = new boolean[]{false};
                    URL root2 = sourceRootHelper.determineSourceRoot(node, errorStatus);
                    if (errorStatus[0] || results.contains(root2)) continue;
                    results.add(root2);
                    return results;
                }
            }
            URL[] arr$ = uRLArray = JProjectUtil.getDirectories(children);
            int len$ = arr$.length;
            boolean bl = false;
            while (var10_17 < len$) {
                URL url = arr$[var10_17];
                if (canceled) {
                    return new ArrayList<URL>(0);
                }
                ArrayList<URL> list = JProjectUtil.findSourceRootsFromURL(url, helpers);
                if (list.size() == 1) {
                    root = (URL)list.get(0);
                    if (!results.contains(root)) {
                        results.add(root);
                    }
                    if (URLFileSystem.isBaseURLFor((URL)root, (URL)folder)) {
                        return results;
                    }
                } else if (list.size() > 0) {
                    for (URL u : list) {
                        if (results.contains(u)) continue;
                        results.add(u);
                    }
                }
                ++var10_17;
            }
        } else if (URLFileSystem.isDirectoryPath((URL)folder)) {
            results.add(folder);
        }
        if (canceled) {
            return new ArrayList<URL>(0);
        }
        return results;
    }

    static URL getSourceRootForFile(URL fileURL, boolean showError, SourceRootHelper[] helpers) {
        URL[] oneFile = new URL[]{fileURL};
        Map<String, List<Node>> map = JProjectUtil.buildNodeMap(oneFile, helpers);
        Node[] javaNodes = JProjectUtil.getNodesForKey(map, JAVA_NODE_KEY);
        if (javaNodes.length == 1) {
            boolean[] errorStatus = new boolean[]{false};
            URL root = JProjectUtil.determineSourceRoot((JavaSourceNode)javaNodes[0], showError, errorStatus);
            return root;
        }
        for (SourceRootHelper nextHelper : helpers) {
            Node[] otherNodes;
            String key = nextHelper.getClass().getName();
            for (Node node : otherNodes = JProjectUtil.getNodesForKey(map, key)) {
                boolean[] errorStatus = new boolean[]{false};
                URL root = nextHelper.determineSourceRoot(node, errorStatus);
                if (errorStatus[0]) continue;
                return root;
            }
        }
        return null;
    }

    private static Node[] getNodesForKey(Map<String, List<Node>> map, String key) {
        if (map.containsKey(key)) {
            List<Node> nodes = map.get(key);
            Node[] nodeArray = new Node[nodes.size()];
            nodes.toArray(nodeArray);
            return nodeArray;
        }
        return new Node[0];
    }

    private static Map<String, List<Node>> buildNodeMap(URL[] fileList, SourceRootHelper[] helpers) {
        HashMap<String, List<Node>> map = new HashMap<String, List<Node>>(helpers.length + 1);
        for (URL url : fileList) {
            if (URLFileSystem.hasSuffix((URL)url, (String)".java")) {
                try {
                    Node node = NodeFactory.findOrCreate((URL)url);
                    JProjectUtil.store(node, map, JAVA_NODE_KEY);
                }
                catch (Exception e) {}
                continue;
            }
            for (SourceRootHelper nextHelper : helpers) {
                if (!URLFileSystem.hasSuffix((URL)url, (String)nextHelper.getFileExtension())) continue;
                try {
                    Node node = NodeFactory.findOrCreate((Class)nextHelper.getNodeClass(), (URL)url);
                    JProjectUtil.store(node, map, nextHelper.getClass().getName());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return map;
    }

    private static void store(Node node, Map<String, List<Node>> map, String key) {
        List<Object> nodeList;
        if (map.containsKey(key)) {
            nodeList = map.get(key);
        } else {
            nodeList = new ArrayList();
            map.put(key, nodeList);
        }
        nodeList.add(node);
    }

    private static URL[] getDirectories(URL[] directoryList) {
        ArrayList<URL> dirs = new ArrayList<URL>(directoryList.length);
        for (URL dir : directoryList) {
            if (!URLFileSystem.isDirectory((URL)dir)) continue;
            dirs.add(dir);
        }
        URL[] urls = new URL[dirs.size()];
        dirs.toArray(urls);
        return urls;
    }

    static URL determineSourceRoot(JavaSourceNode node, boolean showError, boolean[] errorStatus) {
        URL nodeURL = node.getURL();
        URL parentURL = URLFileSystem.getParent((URL)nodeURL);
        String pack = node.getPackage();
        if (ModelUtil.hasLength((String)pack)) {
            pack = pack.replace('.', '/');
            pack = pack.concat("/");
        }
        URL srcPathURL = parentURL;
        if (ModelUtil.hasLength((String)pack) && (srcPathURL = URLFileSystem.getBaseParent((URL)parentURL, (String)pack)).equals(parentURL)) {
            errorStatus[0] = true;
            if (showError) {
                String msg = JProjectArb.format(109, URLFileSystem.getPlatformPathName((URL)node.getURL()));
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)msg, (String)JProjectArb.getString(108), null);
            }
        }
        return srcPathURL;
    }
}

