/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.ComponentArb;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryList;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.JProjectLibraryList;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.LibraryList;
import oracle.jdeveloper.library.ListWrapper;
import oracle.jdeveloper.library.MutableLibraryList;
import oracle.jdeveloper.model.JLibraryModel;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.JProjectUtil;
import oracle.jdeveloper.resource.ControlsArb;
import oracle.jdeveloper.resource.JProjectArb;
import oracle.jdevimpl.library.JDKPanel;
import oracle.jdevimpl.library.LibrariesPanel;
import oracle.jdevimpl.library.LibraryArb;
import oracle.jdevimpl.library.LibraryEditPanel;
import oracle.jdevimpl.library.LibraryPanel;

public class JProjectLibrariesPanel
extends ProjectSettingsTraversablePanel {
    private static final LocalChangeListener LISTENER = new LocalChangeListener();
    private static final LocalChangeListener2 LISTENER2 = new LocalChangeListener2();
    private static final String[] COLUMN_NAMES = new String[]{"  " + ControlsArb.getString(12) + "  ", ControlsArb.getString(11)};
    private static final String[] PROPERTYKEYS = new String[]{"jdkReference", "libraryReferences", "internalDefinitions", "exportedReferences"};
    private static URL DEF_DIR = URLFactory.newDirURL((String)Ide.getWorkDirectory());
    private GridBagLayout mainLayout = new GridBagLayout();
    private JLabel jdkPrompt = new JLabel();
    private JTextField jdkField = new JTextField();
    private JLabel libsPrompt = new JLabel();
    private JScrollPane libsScrollPane = new JScrollPane();
    private LibraryTableModel tableModel = new LibraryTableModel(COLUMN_NAMES, 0);
    private JTable libTable = new JTable(this.tableModel);
    private JButton editJDKButton = new JButton();
    private JButton addPathButton = new JButton();
    private JButton addLibButton = new JButton();
    private JButton editLibButton = new JButton();
    private JButton removeLibButton = new JButton();
    private JButton shareLibButton = new JButton();
    private JButton upButton = new JButton();
    private JButton downButton = new JButton();
    private LibraryList[] libLists;
    private JProjectLibraryList prjLibList;
    private JProjectLibraries projectLibraries;
    private ButtonHandler buttonHandler = new ButtonHandler();
    private ListHandler listHandler = new ListHandler();

    public JProjectLibrariesPanel() {
        try {
            TableColumnModel model = this.libTable.getColumnModel();
            JTableHeader header = this.libTable.getTableHeader();
            header.setReorderingAllowed(false);
            TableColumn column = model.getColumn(0);
            JCheckBox jCheckBox = new JCheckBox();
            jCheckBox.setHorizontalAlignment(0);
            column.setCellEditor(new DefaultCellEditor(jCheckBox));
            column.setCellRenderer(new BooleanCellRenderer());
            column.setHeaderRenderer(header.getDefaultRenderer());
            column.sizeWidthToFit();
            column = model.getColumn(1);
            column.setCellRenderer(new LibraryCellRenderer());
            this.setHelpID("f1_idecustlibclasspath_html");
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.mainLayout);
        this.jdkField.setEnabled(false);
        this.jdkField.setEditable(false);
        this.editJDKButton.addActionListener(this.buttonHandler);
        this.libTable.setColumnSelectionAllowed(false);
        this.libTable.setAutoResizeMode(3);
        this.libTable.getSelectionModel().addListSelectionListener(this.listHandler);
        this.libTable.addKeyListener(this.listHandler);
        this.addPathButton.addActionListener(this.buttonHandler);
        this.addLibButton.addActionListener(this.buttonHandler);
        this.editLibButton.addActionListener(this.buttonHandler);
        this.removeLibButton.addActionListener(this.buttonHandler);
        this.shareLibButton.addActionListener(this.buttonHandler);
        this.upButton.addActionListener(this.buttonHandler);
        this.downButton.addActionListener(this.buttonHandler);
        this.libsScrollPane.getViewport().add((Component)this.libTable, null);
        this.libsScrollPane.getViewport().setBackground(this.libTable.getBackground());
        this.add(this.jdkPrompt, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.add(this.jdkField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.libsPrompt, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 2, 0), 0, 0));
        this.add(this.libsScrollPane, new GridBagConstraints(0, 3, 1, 9, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.editJDKButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 12, 0, 0), 0, 0));
        this.add(this.addLibButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add(this.addPathButton, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add(this.removeLibButton, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 12, 10, 0), 0, 0));
        this.add(this.editLibButton, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add(this.shareLibButton, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 12, 10, 0), 0, 0));
        this.add(this.upButton, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add(this.downButton, new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 12, 0, 0), 0, 0));
        ResourceUtils.resLabel((JLabel)this.jdkPrompt, (Component)this.editJDKButton, (String)JProjectArb.getString(152));
        ResourceUtils.resButton((AbstractButton)this.editJDKButton, (String)ControlsArb.getString(10));
        ResourceUtils.resLabel((JLabel)this.libsPrompt, (Component)this.libTable, (String)ControlsArb.getString(0));
        ResourceUtils.resButton((AbstractButton)this.addPathButton, (String)ControlsArb.getString(73));
        ResourceUtils.resButton((AbstractButton)this.addLibButton, (String)ControlsArb.getString(3));
        ResourceUtils.resButton((AbstractButton)this.editLibButton, (String)ControlsArb.getString(4));
        ResourceUtils.resButton((AbstractButton)this.removeLibButton, (String)ControlsArb.getString(5));
        ResourceUtils.resButton((AbstractButton)this.shareLibButton, (String)ControlsArb.getString(6));
        ResourceUtils.resButton((AbstractButton)this.upButton, (String)ControlsArb.getString(7));
        ResourceUtils.resButton((AbstractButton)this.downButton, (String)ControlsArb.getString(8));
    }

    public String getDataKey() {
        return "oracle.jdevimpl.config.JProjectLibraries";
    }

    public String[] getPropertyKeys() {
        return PROPERTYKEYS;
    }

    public void onProjectPanelEntry(TraversableContext tc) {
        if (JProjectLibrariesPanel.isDefaultProject((Namespace)tc)) {
            this.setHelpID("f1_idedprojsetlibrariesdpp_html");
        }
        this.projectLibraries = JProjectLibrariesPanel.getJProjectLibraries(tc);
        this.reload();
        this.listHandler.valueChanged(null);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        this.projectLibraries = JProjectLibrariesPanel.getJProjectLibraries(tc);
        this.commit();
    }

    public void hideShareButton() {
        if (this.shareLibButton.getParent() != null) {
            this.remove(this.shareLibButton);
        }
    }

    private static JProjectLibraries getJProjectLibraries(TraversableContext tc) {
        if (tc.getWizardCallbacks() != null) {
            return (JProjectLibraries)((Object)tc.find("oracle.jdevimpl.config.JProjectLibraries"));
        }
        PropertyStorage propertyData = JProjectLibrariesPanel.getPropertyData((Namespace)tc);
        return JProjectLibraries.getInstance(propertyData);
    }

    protected Component getDefaultFocusComponent() {
        return this.addLibButton;
    }

    private void reload() {
        LibraryList[] builtInLists = JLibraryManager.getAllLibraryLists();
        this.prjLibList = this.projectLibraries.getProjectLibraryList();
        this.libLists = new LibraryList[builtInLists.length + 1];
        System.arraycopy(builtInLists, 0, this.libLists, 0, builtInLists.length);
        this.libLists[this.libLists.length - 1] = this.prjLibList;
        JDK jdk = this.projectLibraries.getJDK();
        if (jdk != null) {
            this.jdkField.setText(jdk.toString());
        }
        this.tableModel.setRowCount(0);
        JLibrary[] libs = this.projectLibraries.getLibraries();
        JLibrary[] exps = this.projectLibraries.getExports();
        if (libs != null) {
            block0: for (int i = 0; i < libs.length; ++i) {
                if (exps != null) {
                    for (int j = 0; j < exps.length; ++j) {
                        if (!exps[j].equals(libs[i])) continue;
                        this.tableModel.addRow(new Object[]{Boolean.TRUE, libs[i]});
                        continue block0;
                    }
                }
                this.tableModel.addRow(new Object[]{Boolean.FALSE, libs[i]});
            }
        }
    }

    private void commit() throws TraversalException {
        ArrayList<JLibrary> libs = new ArrayList<JLibrary>();
        ArrayList<JLibrary> exps = new ArrayList<JLibrary>();
        int count = this.tableModel.getRowCount();
        for (int i = 0; i < count; ++i) {
            boolean exported = (Boolean)this.tableModel.getValueAt(i, 0);
            JLibrary lib = (JLibrary)this.tableModel.getValueAt(i, 1);
            if (exported) {
                exps.add(lib);
            }
            libs.add(lib);
        }
        JLibrary[] libraries = new JLibrary[exps.size()];
        exps.toArray(libraries);
        this.projectLibraries.setExports(libraries);
        libraries = new JLibrary[libs.size()];
        libs.toArray(libraries);
        this.projectLibraries.setLibraries(libraries);
    }

    private void syncProjectLibraries(JProjectLibraryList originals) {
        int row;
        JLibrary lib;
        List libs = originals != null ? originals.getLibraryList() : null;
        Iterator i = libs != null ? libs.iterator() : null;
        JProjectLibraryList libList = this.projectLibraries.getProjectLibraryList();
        if (i != null && libList != null) {
            while (i.hasNext()) {
                lib = (JLibrary)i.next();
                if (libList.findLibrary(lib.getID()) != null || (row = this.findRow(lib)) < 0) continue;
                this.tableModel.removeRow(row);
            }
        }
        libs = libList != null ? libList.getLibraryList() : null;
        Iterator iterator = i = libs != null ? libs.iterator() : null;
        if (i != null && originals != null) {
            while (i.hasNext()) {
                lib = (JLibrary)i.next();
                if (originals.findLibrary(lib.getID()) != null || (row = this.findRow(lib)) >= 0) continue;
                this.tableModel.addRow(new Object[]{Boolean.TRUE, lib});
            }
        }
    }

    private int findRow(Library lib) {
        Object id;
        Object object = id = lib != null ? lib.getID() : null;
        if (id != null) {
            int count = this.libTable.getRowCount();
            for (int i = 0; i < count; ++i) {
                if (!((Library)this.libTable.getValueAt(i, 1)).equivalent(lib)) continue;
                return i;
            }
        }
        return -1;
    }

    private void deleteSelection() {
        int count;
        int[] rows = this.libTable.getSelectedRows();
        if (rows != null) {
            int i;
            for (i = 0; i < rows.length; ++i) {
                for (int j = i + 1; j < rows.length; ++j) {
                    if (rows[j] >= rows[i]) continue;
                    int temp = rows[i];
                    rows[i] = rows[j];
                    rows[j] = temp;
                }
            }
            for (i = rows.length - 1; i >= 0; --i) {
                this.prjLibList.remove((Library)this.libTable.getValueAt(rows[i], 1));
                this.tableModel.removeRow(rows[i]);
            }
        }
        if ((count = this.libTable.getRowCount()) != 0) {
            int lastDeletedRow = rows[rows.length - 1];
            int row = count > lastDeletedRow ? lastDeletedRow : count - 1;
            this.selectRow(row);
        }
    }

    private void selectRow(final int row) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JProjectLibrariesPanel.this.libTable.setRowSelectionInterval(row, row);
            }
        });
    }

    private void selectRows(final Library[] elems) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (elems == null) {
                    return;
                }
                JProjectLibrariesPanel.this.libTable.clearSelection();
                for (int i = 0; i < elems.length; ++i) {
                    int row = JProjectLibrariesPanel.this.findRow(elems[i]);
                    if (row < 0) continue;
                    JProjectLibrariesPanel.this.libTable.addRowSelectionInterval(row, row);
                }
                JProjectLibrariesPanel.this.libTable.requestFocus();
            }
        });
    }

    private static final class LibraryTableModel
    extends DefaultTableModel {
        private LibraryTableModel(String[] columnNames, int rows) {
            super(columnNames, rows);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0 && row >= 0 && row < this.getRowCount();
        }
    }

    private static final class LocalChangeListener2
    implements VetoableChangeListener {
        private boolean _vetoThrown;
        private LibraryEditPanel _newPanel;
        private Library _lib;
        private LibraryList _list;

        private LocalChangeListener2() {
        }

        public void initialize(LibraryEditPanel panel, Library lib, LibraryList list) {
            this._newPanel = panel;
            this._lib = lib;
            this._list = list;
        }

        public Library getLibrary() {
            return this._lib;
        }

        @Override
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            if (this._vetoThrown) {
                this._vetoThrown = false;
                return;
            }
            try {
                if (!(this._list instanceof MutableLibraryList)) {
                    return;
                }
                JLibraryModel model = new JLibraryModel((JLibrary)this._lib, (MutableLibraryList)this._list, (Component)this._newPanel);
                model.setName(this._newPanel.getLibraryName());
                model.setClassPath(this._newPanel.getClassPath());
                model.setSourcePath(this._newPanel.getSourcePath());
                model.setDocPath(this._newPanel.getDocPath());
                model.setDeployedByDefault(this._newPanel.isDeployByDefault());
                this._lib = model.commit();
                if (this._list instanceof ListWrapper) {
                    ((ListWrapper)this._list).commit(true);
                }
            }
            catch (Exception x) {
                this._vetoThrown = true;
                throw new PropertyVetoException(null, e);
            }
        }
    }

    private static final class LocalChangeListener
    implements VetoableChangeListener {
        private LibraryPanel _panel;
        private boolean _vetoThrown;

        private LocalChangeListener() {
        }

        @Override
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            if (this._vetoThrown) {
                this._vetoThrown = false;
                return;
            }
            if (!this._panel.commitChanges()) {
                this._vetoThrown = true;
                throw new PropertyVetoException(null, e);
            }
        }
    }

    private static final class BooleanCellRenderer
    extends JCheckBox
    implements TableCellRenderer,
    Serializable {
        protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        private Color unselectedForeground;
        private Color unselectedBackground;

        BooleanCellRenderer() {
            this.setOpaque(true);
            this.setBorderPainted(true);
            this.setBorder(noFocusBorder);
            this.setHorizontalAlignment(0);
        }

        @Override
        public void setForeground(Color c) {
            super.setForeground(c);
            this.unselectedForeground = c;
        }

        @Override
        public void setBackground(Color c) {
            super.setBackground(c);
            this.unselectedBackground = c;
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setForeground(null);
            this.setBackground(null);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                super.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
                super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
            }
            this.setFont(table.getFont());
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            this.setValue(value);
            return this;
        }

        @Override
        public boolean isOpaque() {
            Color back = this.getBackground();
            Container p = this.getParent();
            if (p != null) {
                p = p.getParent();
            }
            boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
            return !colorMatch && super.isOpaque();
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
        }

        @Override
        public void repaint(Rectangle r) {
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            if (propertyName == "text") {
                super.firePropertyChange(propertyName, oldValue, newValue);
            }
        }

        protected void setValue(Object value) {
            boolean selected = value instanceof Boolean ? (Boolean)value : false;
            this.setSelected(selected);
        }
    }

    private static final class LibraryCellRenderer
    extends DefaultTableCellRenderer {
        private Color unselectedForeground;
        private Color unselectedBackground;

        private LibraryCellRenderer() {
        }

        @Override
        public void setForeground(Color c) {
            super.setForeground(c);
            this.unselectedForeground = c;
        }

        @Override
        public void setBackground(Color c) {
            super.setBackground(c);
            this.unselectedBackground = c;
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setForeground(null);
            this.setBackground(null);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            if (isSelected) {
                super.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
                super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
            }
            this.setDisabledIcon(null);
            this.setIcon(this.getIcon(value));
            if (value instanceof Library) {
                String libTooltip = ((Library)value).getToolTipText();
                if (!ModelUtil.hasLength((String)libTooltip)) {
                    libTooltip = LibraryArb.getString(84);
                    this.setText(libTooltip);
                }
                this.setToolTipText(libTooltip);
                this.setText(((Library)value).getName());
            }
            return this;
        }

        @Override
        public boolean isOpaque() {
            Color back = this.getBackground();
            Container p = this.getParent();
            if (p != null) {
                p = p.getParent();
            }
            boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
            return !colorMatch && super.isOpaque();
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
        }

        @Override
        public void repaint(Rectangle r) {
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            if (propertyName == "text") {
                super.firePropertyChange(propertyName, oldValue, newValue);
            }
        }

        private Icon getIcon(Object value) {
            if (value instanceof JLibrary) {
                Library lib = (Library)value;
                URLPath path = lib.getClassPath();
                if (path.size() == 0 && (path = lib.getSourcePath()).size() == 0 && (path = lib.getDocPath()).size() == 0) {
                    super.setForeground(Color.red);
                    return LibraryArb.getIcon(65);
                }
                return lib.getIcon();
            }
            return null;
        }
    }

    private final class ListHandler
    extends KeyAdapter
    implements ListSelectionListener {
        private ListHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e != null && e.getValueIsAdjusting()) {
                return;
            }
            int[] rows = JProjectLibrariesPanel.this.libTable.getSelectedRows();
            if (rows == null || rows.length != 1) {
                JProjectLibrariesPanel.this.editLibButton.setEnabled(false);
                JProjectLibrariesPanel.this.shareLibButton.setEnabled(false);
                JProjectLibrariesPanel.this.upButton.setEnabled(false);
                JProjectLibrariesPanel.this.downButton.setEnabled(false);
                JProjectLibrariesPanel.this.removeLibButton.setEnabled(rows != null && rows.length > 0);
            } else {
                int row = JProjectLibrariesPanel.this.libTable.getSelectedRow();
                JLibrary lib = (JLibrary)JProjectLibrariesPanel.this.libTable.getValueAt(row, 1);
                if (lib != null && !lib.isLocked()) {
                    ResourceUtils.resButton((AbstractButton)JProjectLibrariesPanel.this.editLibButton, (String)ControlsArb.getString(4));
                } else {
                    ResourceUtils.resButton((AbstractButton)JProjectLibrariesPanel.this.editLibButton, (String)ControlsArb.getString(75));
                }
                JProjectLibrariesPanel.this.editLibButton.setEnabled(true);
                JProjectLibrariesPanel.this.removeLibButton.setEnabled(true);
                JProjectLibrariesPanel.this.shareLibButton.setEnabled(lib instanceof HashStructureAdapter);
                JProjectLibrariesPanel.this.upButton.setEnabled(row > 0);
                JProjectLibrariesPanel.this.downButton.setEnabled(row < JProjectLibrariesPanel.this.libTable.getRowCount() - 1);
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() == '\u007f') {
                if (JProjectLibrariesPanel.this.removeLibButton.isEnabled()) {
                    JProjectLibrariesPanel.this.deleteSelection();
                }
                e.consume();
            }
        }
    }

    private final class ButtonHandler
    implements ActionListener {
        private ButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row;
            Object source = e.getSource();
            if (source == JProjectLibrariesPanel.this.editJDKButton) {
                int i;
                JDK jdk = JProjectLibrariesPanel.this.projectLibraries.getJDK();
                JDKPanel panel = new JDKPanel();
                ListWrapper[] copies = new ListWrapper[JProjectLibrariesPanel.this.libLists.length];
                boolean jdkInList = false;
                for (i = 0; i < JProjectLibrariesPanel.this.libLists.length; ++i) {
                    copies[i] = new ListWrapper(JProjectLibrariesPanel.this.libLists[i]);
                    if (!jdkInList) {
                        boolean bl = jdkInList = copies[i].findJDK(jdk.getID()) != null;
                    }
                    if (jdkInList || !(JProjectLibrariesPanel.this.libLists[i] instanceof JProjectLibraryList)) continue;
                    copies[i].addJDK(jdk.getName(), jdk.getJavaExecutable());
                }
                panel.initPanel(copies, jdk);
                panel.setSelectionMode(1);
                LISTENER._panel = panel;
                if (OnePageWizardDialogFactory.runDialog((Component)((Object)JProjectLibrariesPanel.this), (Component)panel, null, (String)ControlsArb.getString(45), (int)7, (VetoableChangeListener)LISTENER)) {
                    copies = panel.getLibraryLists();
                    for (i = 0; i < copies.length; ++i) {
                        copies[i].commit(copies[i].getWrappedList() != JProjectLibrariesPanel.this.prjLibList);
                    }
                    Library[] sel = panel.getSelection();
                    if (sel != null && sel.length > 0) {
                        jdk = (JDK)sel[0];
                    }
                    JProjectLibrariesPanel.this.projectLibraries.setJDK(jdk);
                    try {
                        JProjectLibrariesPanel.this.commit();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    JProjectLibrariesPanel.this.reload();
                }
            } else if (source == JProjectLibrariesPanel.this.addPathButton) {
                URLChooser chooser = DialogUtil.newURLChooser((URL)DEF_DIR);
                chooser.setSelectionMode(2);
                chooser.setSelectionScope(1);
                chooser.setShowJarsAsDirs(true);
                int result = chooser.showOpenDialog((Component)((Object)JProjectLibrariesPanel.this), ControlsArb.getString(74));
                if (result == 0) {
                    URL[] paths = chooser.getSelectedURLs();
                    int n = paths.length;
                    for (int i = 0; i < n; ++i) {
                        URL url = paths[i];
                        String urlSuffix = URLFileSystem.getSuffix((URL)url);
                        if (!urlSuffix.equals(".jar") && !urlSuffix.equals(".zip") || !URLFileSystem.exists((URL)url) || URLFileSystem.isDirectory((URL)url)) continue;
                        paths[i] = URLFactory.newJarURL((URL)url, (String)"");
                    }
                    ArrayList<JLibrary> newLibs = new ArrayList<JLibrary>();
                    for (int i = 0; i < n; ++i) {
                        String name = JProjectUtil.getLibraryNameFromPath(paths[i]);
                        JLibrary lib = JProjectLibrariesPanel.this.prjLibList.addLibrary(name);
                        if (lib == null) continue;
                        lib.setClassPath(new URLPath(paths[i]));
                        lib.setDeployedByDefault(Boolean.TRUE);
                        lib.setLocked(true);
                        JProjectLibrariesPanel.this.tableModel.addRow(new Object[]{Boolean.TRUE, lib});
                        newLibs.add(lib);
                        DEF_DIR = URLFileSystem.getParent((URL)paths[i]);
                    }
                    if (newLibs.size() > 0) {
                        Library[] elems = new JLibrary[newLibs.size()];
                        newLibs.toArray(elems);
                        JProjectLibrariesPanel.this.selectRows(elems);
                    }
                }
            } else if (source == JProjectLibrariesPanel.this.addLibButton) {
                LibrariesPanel panel = new LibrariesPanel();
                panel.makeDoubleClickCloseDialog();
                ListWrapper[] copies = new ListWrapper[JProjectLibrariesPanel.this.libLists.length];
                for (int i = 0; i < copies.length; ++i) {
                    copies[i] = new ListWrapper(JProjectLibrariesPanel.this.libLists[i]);
                }
                panel.setSplit(false);
                int numExistingLibs = JProjectLibrariesPanel.this.tableModel.getRowCount();
                if (numExistingLibs > 0) {
                    ArrayList<JLibrary> exLibs = new ArrayList<JLibrary>(numExistingLibs);
                    for (int i = 0; i < numExistingLibs; ++i) {
                        JLibrary existingLib = (JLibrary)JProjectLibrariesPanel.this.tableModel.getValueAt(i, 1);
                        exLibs.add(existingLib);
                    }
                    panel.setExistingLibraries(exLibs);
                }
                panel.initPanel(copies);
                LISTENER._panel = panel;
                if (OnePageWizardDialogFactory.runDialog((Component)((Object)JProjectLibrariesPanel.this), (Component)panel, null, (String)ControlsArb.getString(14), (int)7, (VetoableChangeListener)LISTENER)) {
                    HashStructure hash = HashStructure.newInstance();
                    JProjectLibraryList originals = new JProjectLibraryList(hash);
                    JProjectLibrariesPanel.this.prjLibList.copyTo(originals);
                    copies = panel.getLibraryLists();
                    for (int i = 0; i < copies.length; ++i) {
                        copies[i].commit(copies[i].getWrappedList() != JProjectLibrariesPanel.this.prjLibList);
                    }
                    Library[] elems = panel.getSelection();
                    if (elems != null) {
                        for (int i = 0; i < elems.length; ++i) {
                            if (JProjectLibrariesPanel.this.findRow(elems[i]) >= 0) continue;
                            JProjectLibrariesPanel.this.tableModel.addRow(new Object[]{Boolean.TRUE, elems[i]});
                        }
                    }
                    JProjectLibrariesPanel.this.syncProjectLibraries(originals);
                    try {
                        JProjectLibrariesPanel.this.commit();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                    JProjectLibrariesPanel.this.reload();
                    JProjectLibrariesPanel.this.selectRows(elems);
                }
            } else if (source == JProjectLibrariesPanel.this.editLibButton) {
                JLibraryList list;
                int row2 = JProjectLibrariesPanel.this.libTable.getSelectedRow();
                JLibrary lib = row2 >= 0 ? (JLibrary)JProjectLibrariesPanel.this.libTable.getValueAt(row2, 1) : null;
                LibraryList wrapper = null;
                if (lib instanceof JProjectLibraries.UnresolvedLibrary) {
                    Object id = lib.getID();
                    list = JLibraryManager.getUserLibraries();
                    if (id instanceof URL) {
                        URL listURL = URLFileSystem.getParent((URL)((URL)id));
                        list = JLibraryManager.addLibraryList(listURL);
                        if (((String)(id = URLFileSystem.getFileName((URL)((URL)id)))).endsWith(".library")) {
                            id = ((String)id).substring(0, ((String)id).length() - ".library".length());
                        }
                    }
                    wrapper = new ListWrapper(list);
                    lib = ((ListWrapper)wrapper).addLibrary(id.toString());
                }
                LibraryEditPanel panel = new LibraryEditPanel(lib);
                list = wrapper != null ? wrapper : this.findOwningList(lib);
                panel.setListsVisible(false);
                panel.setLibraryList(list);
                LISTENER2.initialize(panel, lib, list);
                if (OnePageWizardDialogFactory.runDialog((Component)((Object)JProjectLibrariesPanel.this), (Component)panel, null, (String)ControlsArb.getString(24), (int)7, (VetoableChangeListener)LISTENER2)) {
                    JProjectLibrariesPanel.this.libTable.setValueAt(LISTENER2.getLibrary(), row2, 1);
                    try {
                        JProjectLibrariesPanel.this.commit();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                    JProjectLibrariesPanel.this.reload();
                    if (row2 >= 0) {
                        JProjectLibrariesPanel.this.selectRow(row2);
                    }
                }
            } else if (source == JProjectLibrariesPanel.this.removeLibButton) {
                JProjectLibrariesPanel.this.deleteSelection();
            } else if (source == JProjectLibrariesPanel.this.shareLibButton) {
                JLibrary lib;
                int row3 = JProjectLibrariesPanel.this.libTable.getSelectedRow();
                JLibrary jLibrary = lib = row3 >= 0 ? (JLibrary)JProjectLibrariesPanel.this.libTable.getValueAt(row3, 1) : null;
                if (lib != null) {
                    URL url;
                    URLChooser chooser = DialogUtil.newURLChooser((URL)DEF_DIR);
                    chooser.setSelectionMode(0);
                    chooser.setSelectionScope(0);
                    chooser.setShowJarsAsDirs(false);
                    chooser.clearChooseableURLFilters();
                    chooser.setURLFilter(JLibraryList.LIB_FILTER);
                    int result = chooser.showSaveDialog((Component)((Object)JProjectLibrariesPanel.this), ControlsArb.getString(17));
                    if (result == 0 && (url = chooser.getSelectedURL()) != null) {
                        JLibrary newLib;
                        JLibraryList list;
                        URL parent;
                        if (URLFileSystem.exists((URL)(url = URLFileSystem.ensureSuffix((URL)url, (String)".library")))) {
                            if (MessageDialog.confirm((Component)((Object)JProjectLibrariesPanel.this), (Object)ComponentArb.format((int)31, (Object[])new String[]{ComponentArb.getString((int)39), URLFileSystem.getPlatformPathName((URL)url)}), (String)ComponentArb.getString((int)26), null, (boolean)true)) {
                                if (URLFileSystem.isReadOnly((URL)url)) {
                                    MessageDialog.error((Component)((Object)JProjectLibrariesPanel.this), (Object)ComponentArb.format((int)30, (Object[])new String[]{URLFileSystem.getPlatformPathName((URL)url)}), (String)ComponentArb.getString((int)36), null);
                                    return;
                                }
                            } else {
                                return;
                            }
                        }
                        if ((parent = URLFileSystem.getParent((URL)url)) != null && (list = JLibraryManager.addLibraryList(parent)) != null && (newLib = list.addLibrary(null, url)) != null) {
                            newLib.setClassPath(lib.getClassPath());
                            newLib.setSourcePath(lib.getSourcePath());
                            newLib.setDocPath(lib.getDocPath());
                            newLib.setDeployedByDefault(lib.getDeployedByDefault());
                            JProjectLibrariesPanel.this.prjLibList.remove(lib);
                            JProjectLibrariesPanel.this.libTable.setValueAt(newLib, row3, 1);
                            try {
                                JProjectLibrariesPanel.this.commit();
                            }
                            catch (Exception x) {
                                // empty catch block
                            }
                            JProjectLibrariesPanel.this.reload();
                            if (lib != null && (row3 = JProjectLibrariesPanel.this.findRow(newLib)) >= 0) {
                                JProjectLibrariesPanel.this.selectRow(row3);
                            }
                        }
                    }
                }
            } else if (source == JProjectLibrariesPanel.this.upButton) {
                int row4 = JProjectLibrariesPanel.this.libTable.getSelectedRow();
                if (row4 > 0) {
                    Object exported = JProjectLibrariesPanel.this.libTable.getValueAt(row4, 0);
                    Object lib = JProjectLibrariesPanel.this.libTable.getValueAt(row4, 1);
                    JProjectLibrariesPanel.this.libTable.getSelectionModel().removeListSelectionListener(JProjectLibrariesPanel.this.listHandler);
                    JProjectLibrariesPanel.this.tableModel.removeRow(row4);
                    JProjectLibrariesPanel.this.tableModel.insertRow(--row4, new Object[]{exported, lib});
                    JProjectLibrariesPanel.this.libTable.getSelectionModel().addListSelectionListener(JProjectLibrariesPanel.this.listHandler);
                    JProjectLibrariesPanel.this.selectRow(row4);
                }
            } else if (source == JProjectLibrariesPanel.this.downButton && (row = JProjectLibrariesPanel.this.libTable.getSelectedRow()) < JProjectLibrariesPanel.this.libTable.getRowCount() - 1) {
                Object exported = JProjectLibrariesPanel.this.libTable.getValueAt(row, 0);
                Object lib = JProjectLibrariesPanel.this.libTable.getValueAt(row, 1);
                JProjectLibrariesPanel.this.libTable.getSelectionModel().removeListSelectionListener(JProjectLibrariesPanel.this.listHandler);
                JProjectLibrariesPanel.this.tableModel.removeRow(row);
                JProjectLibrariesPanel.this.tableModel.insertRow(++row, new Object[]{exported, lib});
                JProjectLibrariesPanel.this.libTable.getSelectionModel().addListSelectionListener(JProjectLibrariesPanel.this.listHandler);
                JProjectLibrariesPanel.this.selectRow(row);
            }
        }

        private LibraryList findOwningList(JLibrary lib) {
            Object id = lib.getID();
            if (JProjectLibrariesPanel.this.prjLibList.findLibrary(id) != null) {
                return JProjectLibrariesPanel.this.prjLibList;
            }
            LibraryList[] lists = JLibraryManager.getAllLibraryLists();
            for (int i = 0; i < lists.length; ++i) {
                if (lists[i].findLibrary(id) == null) continue;
                if (lists[i] instanceof JLibraryList && id instanceof URL) {
                    URL listURL = URLFileSystem.getParent((URL)((URL)id));
                    return JLibraryManager.addLibraryList(listURL);
                }
                return lists[i];
            }
            return null;
        }
    }
}

