/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.URL;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.resource.LibraryArb;

public abstract class LibraryAdapter
extends HashStructureAdapter
implements Library {
    public LibraryAdapter(HashStructure hash) {
        super(hash);
    }

    @Override
    public URLPath getClassPath() {
        ListStructure data = this._hash.getListStructure("classPath");
        return new URLPath((List)data);
    }

    @Override
    public void setClassPath(URLPath path) {
        if (path == null) {
            this._hash.remove("classPath");
        } else {
            ListStructure data = this._hash.getOrCreateListStructure("classPath");
            data.mirror(path.asList());
        }
    }

    @Override
    public URLPath getSourcePath() {
        ListStructure data = this._hash.getListStructure("sourcePath");
        return new URLPath((List)data);
    }

    @Override
    public void setSourcePath(URLPath path) {
        if (path == null) {
            this._hash.remove("sourcePath");
        } else {
            ListStructure data = this._hash.getOrCreateListStructure("sourcePath");
            data.mirror(path.asList());
        }
    }

    @Override
    public URLPath getDocPath() {
        ListStructure data = this._hash.getListStructure("docPath");
        return new URLPath((List)data);
    }

    @Override
    public void setDocPath(URLPath path) {
        if (path == null) {
            this._hash.remove("docPath");
        } else {
            ListStructure data = this._hash.getOrCreateListStructure("docPath");
            data.mirror(path.asList());
        }
    }

    @Override
    public boolean isLocked() {
        return this._hash.getBoolean("locked", false);
    }

    @Override
    public void setLocked(boolean isLocked) {
        this._hash.putBoolean("locked", isLocked);
    }

    @Override
    public boolean equivalent(Library library) {
        if (library == null) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)library.getClassPath(), (Object)this.getClassPath())) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)library.getSourcePath(), (Object)this.getSourcePath())) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)library.getDocPath(), (Object)this.getDocPath())) {
            return false;
        }
        return library.isLocked() == this.isLocked();
    }

    @Override
    public void initFromLibrary(Library library) {
        if (library != null) {
            URLPath path = library.getClassPath();
            if (ModelUtil.areDifferent((Object)path, (Object)this.getClassPath())) {
                this.setClassPath(path);
            }
            if (ModelUtil.areDifferent((Object)(path = library.getSourcePath()), (Object)this.getSourcePath())) {
                this.setSourcePath(path);
            }
            if (ModelUtil.areDifferent((Object)(path = library.getDocPath()), (Object)this.getDocPath())) {
                this.setDocPath(path);
            }
            if (library.isLocked() != this.isLocked()) {
                this.setLocked(library.isLocked());
            }
        }
    }

    public String getShortLabel() {
        return this.getName();
    }

    public String getLongLabel() {
        Object id = this.getID();
        if (id == null) {
            return "";
        }
        return id instanceof URL ? URLFileSystem.getPlatformPathName((URL)((URL)id)) : id.toString();
    }

    public Icon getIcon() {
        return LibraryArb.getIcon(4);
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }

    public String toString() {
        return this.getShortLabel();
    }

    @Override
    public String getName() {
        return this._hash.getString("description", "");
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            this._hash.remove("description");
        } else {
            this._hash.putString("description", name);
        }
    }

    @Override
    public Object getID() {
        return this._hash.getObject("id");
    }

    public void setID(Object id) {
        if (id == null) {
            this._hash.remove("id");
        } else if (id instanceof URL) {
            this._hash.putURL("id", (URL)id);
        } else {
            this._hash.putString("id", id.toString());
        }
    }

    @Override
    public URLPath getDefaultClassPath() {
        return this.getClassPath();
    }

    @Override
    public void setDefaultClassPath(URLPath path) {
        this.setClassPath(path);
    }

    @Override
    public URLPath getDefaultSourcePath() {
        return this.getSourcePath();
    }

    @Override
    public void setDefaultSourcePath(URLPath path) {
        this.setSourcePath(path);
    }

    @Override
    public URLPath getDefaultDocPath() {
        return this.getDocPath();
    }

    @Override
    public void setDefaultDocPath(URLPath path) {
        this.setDocPath(path);
    }
}

