/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.URL;
import java.util.Arrays;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.VersionNumber;
import oracle.ide.xml.XMLRecognizer;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.library.ExternalLibrary;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JDKUtil;
import oracle.jdeveloper.library.Library;

public class JDKNode
extends ExternalLibrary
implements JDK {
    public static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"jdknode");
    public static final String ROOT_TAG = "JDKNode";
    private URL _javaExe;
    private String[] _VMs;
    private VersionNumber _version;
    private URL _binDir;

    public JDKNode() {
    }

    public JDKNode(URL url) {
        super(url);
    }

    @Override
    public boolean equivalent(Library lib) {
        JDK jdk;
        JDK jDK = jdk = lib instanceof JDK ? (JDK)lib : null;
        if (!super.equivalent(jdk)) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)jdk.getJavaExecutable(), (Object)this.getJavaExecutable())) {
            return false;
        }
        if (!Arrays.equals(jdk.getInstalledVMs(), this.getInstalledVMs())) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)jdk.getJavaVersion(), (Object)this.getJavaVersion())) {
            return false;
        }
        return !ModelUtil.areDifferent((Object)jdk.getSDKBinDir(), (Object)this.getSDKBinDir());
    }

    @Override
    public void initFromLibrary(Library lib) {
        if (lib instanceof JDK) {
            super.initFromLibrary(lib);
            JDK jdk = (JDK)lib;
            URL exe = jdk.getJavaExecutable();
            Object[] vms = jdk.getInstalledVMs();
            VersionNumber version = jdk.getJavaVersion();
            URL binDir = jdk.getSDKBinDir();
            if (ModelUtil.areDifferent((Object)exe, (Object)this.getJavaExecutable())) {
                this.setJavaExecutable(exe);
            }
            if (!Arrays.equals(vms, this.getInstalledVMs())) {
                this.setInstalledVMs((String[])vms);
            }
            if (ModelUtil.areDifferent((Object)version, (Object)this.getJavaVersion())) {
                this.setJavaVersion(version);
            }
            if (ModelUtil.areDifferent((Object)binDir, (Object)this.getSDKBinDir())) {
                this.setSDKBinDir(binDir);
            }
        }
    }

    @Override
    public URL getJavaExecutable() {
        return this.ensureOpen() ? this._javaExe : null;
    }

    @Override
    public void setJavaExecutable(URL url) {
        if (this.ensureOpen() && ModelUtil.areDifferent((Object)url, (Object)this._javaExe)) {
            this._javaExe = url;
            this.markDirty(true);
        }
    }

    @Override
    public String[] getInstalledVMs() throws TransientMarker {
        URL url;
        if (this.ensureOpen() && this._VMs == null && (url = this.getSDKBinDir()) != null) {
            this._VMs = JDKUtil.getVMChoices(url, false);
        }
        return this._VMs != null ? this._VMs : new String[]{};
    }

    @Override
    public void setInstalledVMs(String[] installedVMs) {
        if (this.ensureOpen() && !Arrays.equals(installedVMs, this._VMs)) {
            this._VMs = installedVMs;
            this.markDirty(true);
        }
    }

    @Override
    public VersionNumber getJavaVersion() {
        return this.ensureOpen() ? this._version : null;
    }

    @Override
    public void setJavaVersion(VersionNumber ver) {
        if (this.ensureOpen() && ModelUtil.areDifferent((Object)ver, (Object)this._version)) {
            this._version = ver;
            this.markDirty(true);
        }
    }

    @Override
    public URL getSDKBinDir() {
        return this.ensureOpen() ? this._binDir : null;
    }

    @Override
    public void setSDKBinDir(URL url) {
        if (this.ensureOpen() && ModelUtil.areDifferent((Object)url, (Object)this._binDir)) {
            this._binDir = url;
            this.markDirty(true);
        }
    }

    @Override
    public String getSDKBinJavaExecutableNoConsole() {
        URL url = this.getSDKBinDir();
        if (url != null) {
            return JDKUtil.getJavaExecutableNoConsolePath(url);
        }
        return null;
    }

    @Override
    public String getJavaExecutableNoConsole() {
        URL url = this.getJavaExecutable();
        if (url != null && (url = URLFileSystem.getParent((URL)url)) != null) {
            return JDKUtil.getJavaExecutableNoConsolePath(url);
        }
        return null;
    }

    @Override
    protected String getExtension() {
        return ".jdk";
    }

    static {
        Object2Dom.registerNamespaceElem(JDKNode.class, (String)NAMESPACE_URI, (String)ROOT_TAG);
        XMLRecognizer.mapRootElementToClass((String)ROOT_TAG, JDKNode.class);
    }
}

