/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.URL;
import javax.swing.Icon;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.LibraryDataNode;
import oracle.jdeveloper.resource.LibraryArb;

public abstract class ExternalLibrary
extends LibraryDataNode
implements Library {
    private String _name;
    private URLPath _clsPath;
    private URLPath _srcPath;
    private URLPath _docPath;
    private boolean _isLocked;

    public ExternalLibrary() {
    }

    public ExternalLibrary(URL url) {
        super(url);
    }

    protected abstract String getExtension();

    @Override
    public URLPath getDefaultClassPath() throws TransientMarker {
        return this.getClassPath();
    }

    @Override
    public void setDefaultClassPath(URLPath clsPath) {
        this.setClassPath(clsPath);
    }

    @Override
    public URLPath getDefaultSourcePath() throws TransientMarker {
        return this.getSourcePath();
    }

    @Override
    public void setDefaultSourcePath(URLPath srcPath) {
        this.setSourcePath(srcPath);
    }

    @Override
    public URLPath getDefaultDocPath() throws TransientMarker {
        return this.getDocPath();
    }

    @Override
    public void setDefaultDocPath(URLPath docPath) {
        this.setDocPath(docPath);
    }

    @Override
    public URLPath getClassPath() {
        return this.ensureOpen() ? this._clsPath : new URLPath();
    }

    @Override
    public void setClassPath(URLPath path) {
        if (this.ensureOpen() && ModelUtil.areDifferent((Object)path, (Object)this._clsPath)) {
            this._clsPath = path;
            this.markDirty(true);
        }
    }

    @Override
    public URLPath getSourcePath() {
        return this.ensureOpen() ? this._srcPath : new URLPath();
    }

    @Override
    public void setSourcePath(URLPath path) {
        if (this.ensureOpen() && ModelUtil.areDifferent((Object)path, (Object)this._srcPath)) {
            this._srcPath = path;
            this.markDirty(true);
        }
    }

    @Override
    public URLPath getDocPath() {
        return this.ensureOpen() ? this._docPath : new URLPath();
    }

    @Override
    public void setDocPath(URLPath path) {
        if (this.ensureOpen() && ModelUtil.areDifferent((Object)path, (Object)this._docPath)) {
            this._docPath = path;
            this.markDirty(true);
        }
    }

    @Override
    public boolean isLocked() {
        return this.ensureOpen() ? this._isLocked : true;
    }

    @Override
    public void setLocked(boolean locked) {
        if (this.ensureOpen() && locked != this._isLocked) {
            this._isLocked = locked;
            this.markDirty(true);
        }
    }

    @Override
    public String getName() {
        String ext;
        if (this._name != null) {
            return this._name;
        }
        String str = URLFileSystem.getFileName((URL)this.getURL());
        if (str.endsWith(ext = this.getExtension())) {
            return str.substring(0, str.length() - ext.length());
        }
        return str;
    }

    @Override
    public void setName(String name) {
        if (this.ensureOpen() && ModelUtil.areDifferent((Object)name, (Object)this._name)) {
            this._name = name;
            this.markDirty(true);
        }
    }

    @Override
    public Object getID() {
        return this.getURL();
    }

    @Override
    public boolean equivalent(Library lib) {
        if (lib == null) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)lib.getClassPath(), (Object)this.getClassPath())) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)lib.getSourcePath(), (Object)this.getSourcePath())) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)lib.getDocPath(), (Object)this.getDocPath())) {
            return false;
        }
        return lib.isLocked() == this.isLocked();
    }

    @Override
    public void initFromLibrary(Library lib) {
        if (lib != null) {
            URLPath path = lib.getClassPath();
            if (ModelUtil.areDifferent((Object)path, (Object)this.getClassPath())) {
                this.setClassPath(path);
            }
            if (ModelUtil.areDifferent((Object)(path = lib.getSourcePath()), (Object)this.getSourcePath())) {
                this.setSourcePath(path);
            }
            if (ModelUtil.areDifferent((Object)(path = lib.getDocPath()), (Object)this.getDocPath())) {
                this.setDocPath(path);
            }
            if (lib.isLocked() != this.isLocked()) {
                this.setLocked(lib.isLocked());
            }
        }
    }

    public String getShortLabel() {
        return this.getName();
    }

    public Icon getIcon() {
        return LibraryArb.getIcon(4);
    }

    public String toString() {
        return this.getShortLabel();
    }
}

