/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.ExtensionRegistry;
import oracle.ide.net.URLPath;
import oracle.ide.util.VersionNumber;
import oracle.jdeveloper.library.AddinJDK;
import oracle.jdeveloper.library.AddinLibrary;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.LibraryList;
import oracle.jdeveloper.resource.LibraryArb;
import oracle.jdevimpl.library.LibrariesHook;

public final class AddinLibraryList
implements LibraryList {
    private final Map<String, String> aliases;
    private final Map<String, AddinLibrary> manifestLibraries;
    private final Map<String, AddinLibrary> extraLibraries = Collections.synchronizedMap(new HashMap());
    private AddinJDK jdk;

    AddinLibraryList() {
        LibrariesHook lh = (LibrariesHook)ExtensionRegistry.getExtensionRegistry().getHook(LibrariesHook.ELEMENT);
        if (lh != null) {
            this.aliases = Collections.unmodifiableMap(AddinLibraryList.loadAliases(lh));
            this.manifestLibraries = Collections.unmodifiableMap(AddinLibraryList.loadLibraries(lh));
        } else {
            this.aliases = null;
            this.manifestLibraries = null;
        }
    }

    private static Map<String, String> loadAliases(LibrariesHook lh) {
        HashMap<String, String> aliases = new HashMap<String, String>();
        for (LibrariesHook.LibraryAlias alias : lh.getAliases()) {
            aliases.put(alias.getFrom(), alias.getTo());
        }
        return aliases;
    }

    private static Map<String, AddinLibrary> loadLibraries(LibrariesHook lh) {
        HashMap<String, AddinLibrary> libraries = new HashMap<String, AddinLibrary>();
        for (LibrariesHook.LibraryInfo info : lh.getLibraries()) {
            libraries.put(info.getName(), new AddinLibrary(info.getName(), info.getClassPath(), info.getSourcePath(), info.getDocPath(), info.isDeployed()));
        }
        return libraries;
    }

    public void addAlias(String aliasName, String libName) {
    }

    private String resolveAlias(String name) {
        String realName = this.aliases.get(name);
        return realName == null ? name : realName;
    }

    public void registerLibrary(AddinLibrary library) {
        if (library == null) {
            throw new NullPointerException("library is null");
        }
        this.extraLibraries.put(library.getName(), library);
    }

    public JLibrary loadLibrary(String name, URLPath clsPath, URLPath srcPath, URLPath docPath, Boolean isDeployed) {
        AddinLibrary lib = new AddinLibrary(name, clsPath, srcPath, docPath, isDeployed);
        this.registerLibrary(lib);
        return lib;
    }

    public synchronized JDK loadJDK(String name, URLPath clsPath, URLPath srcPath, URLPath docPath, URL exeURL, VersionNumber version, URL sdkBinDir) {
        AddinJDK jdk;
        this.jdk = jdk = new AddinJDK(name, clsPath, srcPath, docPath, exeURL, version, sdkBinDir);
        return jdk;
    }

    @Override
    public synchronized JDK findJDK(Object id) {
        if (id == null) {
            return null;
        }
        if (this.jdk.getID().equals(id)) {
            return this.jdk;
        }
        return null;
    }

    @Override
    public JLibrary findLibrary(Object id) {
        if (id == null) {
            return null;
        }
        String resolvedId = this.resolveAlias(id.toString());
        AddinLibrary lib = this.manifestLibraries.get(resolvedId);
        if (lib == null) {
            lib = this.extraLibraries.get(resolvedId);
        }
        return lib;
    }

    @Override
    public synchronized List getJdkList() {
        return Collections.singletonList(this.jdk);
    }

    @Override
    public List getLibraryList() {
        ArrayList<AddinLibrary> libraries = new ArrayList<AddinLibrary>(this.manifestLibraries.values());
        libraries.addAll(this.extraLibraries.values());
        return libraries;
    }

    @Override
    public String getListName() {
        return LibraryArb.getString(3);
    }

    @Override
    public boolean isTransient() {
        return true;
    }

    public String getShortLabel() {
        return this.getListName();
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public Icon getIcon() {
        return LibraryArb.getIcon(12);
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }

    public String toString() {
        return this.getShortLabel();
    }
}

