/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.provider;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import net.jcip.annotations.GuardedBy;
import oracle.ide.Context;
import oracle.ide.compiler.BuildSystemListener;
import oracle.ide.compiler.BuildSystemVetoException;
import oracle.ide.compiler.Compiler;
import oracle.ide.model.Dependable;
import oracle.ide.model.Folder;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.compiler.BuildSystemConfiguration;
import oracle.jdeveloper.java.JavaClassLocator;
import oracle.jdeveloper.java.JavaModelFactory;
import oracle.jdeveloper.java.locator.JdevClassLocatorFactory;
import oracle.jdeveloper.java.locator.ProjectClassLocator;
import oracle.jdeveloper.java.provider.CachedFileProvider;
import oracle.jdeveloper.java.provider.ProviderContext;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.ProjectLibrary;

public class ProjectFileProvider
extends CachedFileProvider {
    private static final Object KEY = ProjectFileProvider.class;
    private Object _locatorDirtyLock = new Object();
    @GuardedBy(value="_locatorDirtyLock")
    private boolean _locatorDirty;
    private Object _locatorCreationLock = new Object();
    @GuardedBy(value="_locatorCreationLock")
    private JavaClassLocator _locator;
    private final DependencyObserver _dependencyObserver = new DependencyObserver();
    private Project _project;
    private int _j2se = 3;
    private Map _cache = null;
    protected final ProjectObserver _projectObserver = new ProjectObserver();

    public static ProjectFileProvider getInstance(Project project) {
        return ProjectFileProvider.getInstance(project, KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProjectFileProvider getInstance(Project project, Object key) {
        if (project == null) {
            return null;
        }
        Map properties = project.getTransientProperties();
        Object object = key;
        synchronized (object) {
            ProjectFileProvider provider = (ProjectFileProvider)((Object)properties.get(key));
            if (provider == null) {
                ProviderContext e = JavaModelFactory.getInstance().newContext();
                provider = new ProjectFileProvider(e, project);
                properties.put(key, provider);
            }
            return provider;
        }
    }

    private static ProjectFileProvider lookupProvider(Project project, Object key) {
        return (ProjectFileProvider)((Object)project.getTransientProperties().get(key));
    }

    public ProjectFileProvider(ProviderContext e, Project project) {
        super(e, project.getShortLabel());
        this._project = project;
        this._project.attach((Observer)this._projectObserver);
        this._project.addNodeListener((NodeListener)this._projectObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectFileProvider(ProviderContext e, Project project, Map cache) {
        this(e, project);
        this._cache = cache;
        Map map = cache;
        synchronized (map) {
            cache.put(project, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleProjectClose() {
        if (this._cache != null) {
            Map map = this._cache;
            synchronized (map) {
                this._cache.remove(this._project);
            }
        }
        this._project.detach((Observer)this._projectObserver);
        this._project.removeNodeListener((NodeListener)this._projectObserver);
        this._dependencyObserver.detach();
        this.clearAllData();
        this.clearClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleProjectLoad() {
        Object object = this._locatorDirtyLock;
        synchronized (object) {
            this.context.clearTracking();
            this.flushCache();
            this._locatorDirty = true;
            this._dependencyObserver.detach();
            this.clearClassLoader();
        }
        this.expireAllSourceFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleProjectPathsChange() {
        Object object = this._locatorDirtyLock;
        synchronized (object) {
            this.flushCache();
            this.clearCompiledInfo();
            this._locatorDirty = true;
            this._dependencyObserver.detach();
            this.clearClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleProjectContentsChange() {
        Object object = this._locatorDirtyLock;
        synchronized (object) {
            this.flushFoundCache();
        }
    }

    public JavaClassLocator getClassLocator() {
        try {
            return this.getClassLocatorImpl(false);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public JavaClassLocator getClassLocatorInterruptibly() throws InterruptedException {
        return this.getClassLocatorImpl(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private JavaClassLocator getClassLocatorImpl(boolean checkInterrupt) throws InterruptedException {
        Object object = this._locatorCreationLock;
        // MONITORENTER : object
        while (true) {
            Object object2 = this._locatorDirtyLock;
            // MONITORENTER : object2
            if (this._locatorDirty) {
                this._locator = null;
                this._locatorDirty = false;
                this._dependencyObserver.detach();
            }
            // MONITOREXIT : object2
            if (this._locator != null) {
                // MONITOREXIT : object
                return this._locator;
            }
            try {
                this.attachDependencyObserver(checkInterrupt);
                this._locator = checkInterrupt ? JdevClassLocatorFactory.getProjectLocatorInterruptibly(this._project) : JdevClassLocatorFactory.getProjectLocator(this._project);
                continue;
            }
            finally {
                if (this._locator != null) continue;
                this._dependencyObserver.detach();
                continue;
            }
            break;
        }
    }

    private void attachDependencyObserver(boolean checkInterrupt) throws InterruptedException {
        HashSet<Project> alreadySeen = new HashSet<Project>();
        LinkedList<Project> queue = new LinkedList<Project>();
        queue.add(this._project);
        while (!queue.isEmpty()) {
            if (checkInterrupt && Thread.interrupted()) {
                throw new InterruptedException();
            }
            Project current = (Project)queue.removeFirst();
            for (Object dependent : ProjectClassLocator.getDependentsFor(current)) {
                Folder owner;
                if (checkInterrupt && Thread.interrupted()) {
                    throw new InterruptedException();
                }
                if (dependent instanceof ProjectLibrary) {
                    Project dependency = ((ProjectLibrary)dependent).getProject();
                    if (alreadySeen.contains(dependency)) continue;
                    this._dependencyObserver.attach(dependency);
                    alreadySeen.add(dependency);
                    queue.add(dependency);
                    continue;
                }
                if (!(dependent instanceof Library) || !((owner = ((Dependable)dependent).getSourceOwner()) instanceof Project) || ((Library)dependent).getSourcePath() != null) continue;
                this._dependencyObserver.attach((Project)owner);
                for (Object dependent2 : ProjectClassLocator.getDependentsFor((Project)owner)) {
                    if (!(dependent2 instanceof ProjectLibrary)) continue;
                    Project dependency = ((ProjectLibrary)dependent2).getProject();
                    this._dependencyObserver.attach(dependency);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadClassLocator() {
        Object object = this._locatorDirtyLock;
        synchronized (object) {
            this._locatorDirty = true;
            this._dependencyObserver.detach();
            this.flushCache();
            this.clearCompiledInfo();
            this.clearClassLoader();
        }
        this.getClassLocator();
    }

    public SourceClass getProjectSourceClass(String fqClassName) {
        JavaClassLocator locator = this.getClassLocator();
        if (locator instanceof ProjectClassLocator) {
            ProjectClassLocator projectLocator = (ProjectClassLocator)locator;
            URL projectSourceURL = projectLocator.getProjectSourceURL(fqClassName, true);
            if (projectSourceURL != null) {
                return this.getSourceClass(fqClassName);
            }
            URL nonProjectSourceURL = projectLocator.getNonProjectSourceURL(fqClassName);
            if (nonProjectSourceURL != null) {
                return null;
            }
            SourceClass sourceClass = this.getSourceClass(fqClassName);
            SourceFile sourceFile = sourceClass.getOwningSourceFile();
            URL sourceURL = sourceFile.getURL();
            if (this.isProjectSourceURL(sourceURL)) {
                return sourceClass;
            }
        }
        return null;
    }

    protected boolean isProjectSourceURL(URL sourceURL) {
        ArrayList<Project> processList = new ArrayList<Project>();
        processList.add(this._project);
        ArrayList<Project> doneList = new ArrayList<Project>();
        while (processList.size() > 0) {
            Project checkProject = (Project)processList.remove(0);
            doneList.add(checkProject);
            URLPath path = ProjectClassLocator.getSourcePathFor(checkProject);
            if (ProjectFileProvider.pathContainsURL(path, sourceURL)) {
                return true;
            }
            Collection dependencies = ProjectClassLocator.getDependentsFor(checkProject);
            for (Object dependent : dependencies) {
                Project dependentProject;
                if (dependent == null || !(dependent instanceof ProjectLibrary) || doneList.contains(dependentProject = (Project)((ProjectLibrary)dependent).getSource())) continue;
                processList.add(dependentProject);
            }
        }
        return false;
    }

    protected static boolean pathContainsURL(URLPath path, URL url) {
        URL[] pathURLs = path.getEntries();
        int count = pathURLs != null ? pathURLs.length : 0;
        for (int i = 0; i < count; ++i) {
            if (!URLFileSystem.isBaseURLFor((URL)pathURLs[i], (URL)url)) continue;
            return true;
        }
        return false;
    }

    private void fetchTargetJdkVersion() {
        BuildSystemConfiguration buildSysConfig = BuildSystemConfiguration.getInstance((PropertyStorage)this._project);
        int j2se = buildSysConfig.isJDK15OrHigher() ? 3 : 2;
        this._j2se = j2se;
    }

    protected int getTargetJdkVersion() {
        return this._j2se;
    }

    static {
        Compiler compiler = Compiler.getCompiler();
        if (compiler != null) {
            BuildSystemListener listener = new BuildSystemListener(){
                private Context _lastContext = null;

                public void buildWillStart(Context context) throws BuildSystemVetoException {
                    this._lastContext = context;
                }

                public void buildFinished(int errorCount, int warningCount, int infoCount) throws BuildSystemVetoException {
                    if (this._lastContext != null) {
                        ProjectFileProvider provider;
                        Project project = this._lastContext.getProject();
                        if (project != null && (provider = ProjectFileProvider.lookupProvider(project, KEY)) != null) {
                            provider.handleProjectPathsChange();
                        }
                        this._lastContext = null;
                    }
                }

                public void cleanWillStart(Context context) throws BuildSystemVetoException {
                }

                public void cleanFinished(Context context) throws BuildSystemVetoException {
                }
            };
            Compiler.getCompiler().addBuildSystemListener(listener);
        }
    }

    private class DependencyObserver
    implements Observer {
        @GuardedBy(value="this")
        private Collection<Project> observing = new ArrayList<Project>();

        private DependencyObserver() {
        }

        public void update(Object observed, UpdateMessage change) {
            int id;
            if (observed instanceof Project && (id = change.getMessageID()) == UpdateMessage.PROPERTY_SET && (change.containsProperty("classPath") || change.containsProperty("sourcePath") || change.containsProperty("exportedReferences"))) {
                this.detach();
                ProjectFileProvider.this.handleProjectPathsChange();
            }
        }

        public synchronized void attach(Project project) {
            project.attach((Observer)this);
            this.observing.add(project);
        }

        public synchronized void detach() {
            for (Project project : this.observing) {
                project.detach((Observer)this);
            }
            this.observing.clear();
        }
    }

    private class ProjectObserver
    extends NodeListener
    implements Observer {
        private ProjectObserver() {
        }

        public void nodeOpened(NodeEvent e) {
            ProjectFileProvider.this.handleProjectLoad();
            ProjectFileProvider.this.fetchTargetJdkVersion();
        }

        public void nodeReverted(NodeEvent e) {
            ProjectFileProvider.this.handleProjectLoad();
            ProjectFileProvider.this.fetchTargetJdkVersion();
        }

        public void nodeClosed(NodeEvent e) {
            ProjectFileProvider.this.handleProjectClose();
        }

        public void update(Object observed, UpdateMessage change) {
            int id;
            if (observed == ProjectFileProvider.this._project && (id = change.getMessageID()) != UpdateMessage.OBJECT_OPENED && id != UpdateMessage.OBJECT_RELOADED) {
                if (id == UpdateMessage.PROPERTY_SET) {
                    if (change.containsProperty("classPath") || change.containsProperty("sourcePath")) {
                        ProjectFileProvider.this.handleProjectPathsChange();
                    }
                    ProjectFileProvider.this.fetchTargetJdkVersion();
                } else if (id == UpdateMessage.CHILD_ADDED || id == UpdateMessage.CHILD_REMOVED || id == UpdateMessage.CHILD_RENAMED) {
                    ProjectFileProvider.this.handleProjectContentsChange();
                    ProjectFileProvider.this.fetchTargetJdkVersion();
                } else {
                    if (id == UpdateMessage.OBJECT_CLOSED) {
                        return;
                    }
                    if (id == UpdateMessage.OBJECT_CLOSING) {
                        return;
                    }
                    ProjectFileProvider.this.fetchTargetJdkVersion();
                }
            }
        }
    }
}

